/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.networkaudit;

import com.sygate.scm.util.StringUtilities;

public class NetworkAuditComputerNode {
    private String strIP = "";
    private String strHostName = "";
    private String strImagePath = "hostEntriesIcon.png";

    public NetworkAuditComputerNode(String strIP, String strHostName) {
        this.strIP = strIP;
        this.strHostName = strHostName;
    }

    public NetworkAuditComputerNode(String strIP, String strHostName, String strImagePath) {
        this.strIP = strIP;
        this.strHostName = strHostName;
        if (strImagePath != null) {
            this.strImagePath = strImagePath;
        }
    }

    public String getHostName() {
        return this.strHostName;
    }

    public String getIP() {
        return this.strIP;
    }

    public String getImagePath() {
        return this.strImagePath;
    }

    public String toString() {
        return this.strHostName;
    }

    public String getDisplayString() {
        if (this.strHostName != null && (this.strIP == null || this.strIP.trim().length() == 0)) {
            return this.strHostName;
        }
        if ((this.strHostName == null || this.strHostName.trim().length() == 0) && this.strIP != null) {
            return this.strIP;
        }
        if (this.strHostName != null && !StringUtilities.isEmpty((String)this.strIP)) {
            return this.strHostName + " (" + this.strIP + ")";
        }
        return this.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof NetworkAuditComputerNode) {
            NetworkAuditComputerNode node = (NetworkAuditComputerNode)obj;
            String nodeIP = node.getIP();
            String nodeHostName = node.getHostName();
            if (StringUtilities.isEmpty((String)nodeIP) && StringUtilities.isEmpty((String)this.strIP)) {
                return nodeHostName != null && nodeHostName.equals(this.strHostName);
            }
            if (nodeIP != null && nodeIP.equals(this.strIP)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.strIP.hashCode();
    }
}

