/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.networkaudit;

import com.sygate.scm.common.configobject.rpc.NameValuePair;
import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.client.networkaudit.NetworkAuditObject;
import com.sygate.scm.console.ui.client.networkaudit.NetworkAuditSearchListener;
import com.sygate.scm.console.ui.client.networkaudit.NetworkAuditSearchParams;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.KeepAlive;
import com.sygate.scm.util.StringUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class NetworkAuditCommunicator {
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENT = "com.sygate.scm.console.ui.client.client";
    private static final String SCAN_ALL_IP_BEGIN = "1.1.1.1";
    private static final String SCAN_ALL_IP_END = "255.255.255.255";
    public static final int INITIAL = 0;
    public static final int START = 1;
    public static final int FINISHED = 2;
    public static final int CANCELED = 3;
    public static final int ACTION_RETRIEVE = 0;
    public static final int ACTION_SCAN = 1;
    private static final int ERROR_ENTRY = 500;
    private static final int DB_ERROR = 0;
    private static final int SQL_EXCEPTION = 0;
    private static final int NST_ERROR = 1;
    private static final int NST_RETURN_CODE1 = 1;
    private static final int NST_RETURN_CODE2 = 2;
    private static final int NST_RETURN_CODE3 = 3;
    private static final int NST_RETURN_CODE4 = 4;
    private static final int NST_RETURN_CODE5 = 5;
    private static final int NST_RETURN_CODE6 = 6;
    private static final int NST_RETURN_CODE7 = 7;
    private String message = null;
    private int lineCountFromResponse = 0;
    private NetworkAuditSearchParams searchParams = null;
    private NetworkAuditSearchListener listener = null;
    private int actionType;
    private int status;
    private boolean isCommunicating;
    private BufferedReader reader;
    private String strSourceModule;

    public NetworkAuditCommunicator(int actionType, NetworkAuditSearchParams searchParams, NetworkAuditSearchListener listener) {
        this(actionType, searchParams, listener, "");
    }

    public NetworkAuditCommunicator(int actionType, NetworkAuditSearchParams searchParams, NetworkAuditSearchListener listener, String strSource) {
        this.actionType = actionType;
        this.searchParams = searchParams;
        this.listener = listener;
        this.strSourceModule = strSource;
    }

    public void sendRequest() throws ConsoleException {
        block34: {
            this.isCommunicating = false;
            this.status = 1;
            this.listener.stateChanged(1);
            KeepAlive.suspend();
            try {
                String line;
                RpcData data = null;
                if (this.actionType == 1) {
                    data = this.createScanData();
                } else if (this.actionType == 0) {
                    data = this.createGetLanDeviceData();
                }
                this.isCommunicating = true;
                if (this.status == 2) {
                    this.finished();
                    return;
                }
                if (this.actionType == 0) {
                    this.reader = new BufferedReader(new InputStreamReader(GUIManager.getDetectedLanDevice(data), "UTF-8"));
                } else if (this.actionType == 1) {
                    this.reader = new BufferedReader(new InputStreamReader(GUIManager.searchUnagentedHost(data), "UTF-8"));
                }
                this.isCommunicating = false;
                if (this.status == 3 || this.status == 2) {
                    this.finished();
                    return;
                }
                if (!this.reader.ready()) break block34;
                while ((line = this.reader.readLine()) != null) {
                    block35: {
                        String msg;
                        block37: {
                            int errorCode;
                            int errorType;
                            block36: {
                                ++this.lineCountFromResponse;
                                if (this.status == 3) break block34;
                                if (this.status == 2) {
                                    break;
                                }
                                if (!this.isRealResponse(line)) continue;
                                String[] entry = line.split("\\t", -1);
                                if (Integer.parseInt(entry[0]) != 500) break block35;
                                errorType = Integer.parseInt(entry[1]);
                                errorCode = Integer.parseInt(entry[2]);
                                msg = "";
                                if (errorType != 0) break block36;
                                switch (errorCode) {
                                    case 0: {
                                        if (this.actionType == 0) {
                                            msg = MSGRES.getString(CLIENT, "NetworkAuditFrame.error.db.retrieve");
                                            break;
                                        }
                                        if (this.actionType == 1) {
                                            msg = MSGRES.getString(CLIENT, "NetworkAuditFrame.error.db.search");
                                            break;
                                        } else {
                                            break;
                                        }
                                    }
                                }
                                break block37;
                            }
                            if (errorType == 1) {
                                switch (errorCode) {
                                    case 1: {
                                        throw new ConsoleException(-251658240, 192);
                                    }
                                    case 2: {
                                        throw new ConsoleException(-234881024, 193);
                                    }
                                    case 3: {
                                        throw new ConsoleException(-218103808, 194);
                                    }
                                    case 4: {
                                        throw new ConsoleException(-201326592, 195);
                                    }
                                    case 5: {
                                        throw new ConsoleException(-150994944, 196);
                                    }
                                    case 6: {
                                        throw new ConsoleException(-184549376, 197);
                                    }
                                    case 7: {
                                        throw new ConsoleException(-167772160, 198);
                                    }
                                }
                            }
                        }
                        throw new ConsoleException(new Throwable(msg));
                    }
                    System.out.println("NetworkAuditCommunicator >> Network Node Found : " + line);
                    NetworkAuditObject obj = new NetworkAuditObject(line);
                    this.handleKnownHostErrorCode(obj);
                    this.listener.entryFound(obj);
                }
            }
            catch (ConsoleException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                throw new ConsoleException(new Throwable(MSGRES.getString(CLIENT, "NetworkAuditFrame.error.io")));
            }
            catch (Exception ex) {
                throw new ConsoleException(new Throwable(MSGRES.getString(CLIENT, "NetworkAuditFrame.error.io")));
            }
            finally {
                this.finished();
                KeepAlive.resume();
            }
        }
    }

    private void handleKnownHostErrorCode(NetworkAuditObject obj) throws ConsoleException {
        switch (obj.getCategoryType()) {
            case 10: {
                throw new ConsoleException(-167706624, 262);
            }
            case 11: {
                throw new ConsoleException(-167641088, 263, new Object[]{obj.getIpHostName()});
            }
            case 12: {
                throw new ConsoleException(-167575552, 264, new Object[]{obj.getIpHostName()});
            }
            case 13: {
                throw new ConsoleException(-167510016, 265, new Object[]{obj.getIpHostName()});
            }
        }
    }

    private RpcData createScanData() {
        String known_hosts;
        RpcData data = new RpcData();
        String strUser = this.searchParams.getUserName();
        String strPassword = this.searchParams.getPassword();
        String strDomain = this.searchParams.getDomain();
        if (this.isScanAll()) {
            data.addNameValuePair(this.createNameValuePair("BeginIp", SCAN_ALL_IP_BEGIN));
            data.addNameValuePair(this.createNameValuePair("EndIp", SCAN_ALL_IP_END));
        } else if (this.searchParams.isSearchByIpRange()) {
            data.addNameValuePair(this.createNameValuePair("BeginIp", this.searchParams.getBeginIp()));
            data.addNameValuePair(this.createNameValuePair("EndIp", this.searchParams.getEndIp()));
        } else {
            data.addNameValuePair(this.createNameValuePair("Hostname", this.searchParams.getHostName()));
        }
        data.addNameValuePair(this.createNameValuePair("PingTimeout", this.searchParams.getScanOptions().getIcmpTimeout()));
        data.addNameValuePair(this.createNameValuePair("ContinueAudit", this.searchParams.getScanOptions().getContinueAuditString()));
        if (strUser != null && strUser.trim().length() > 0) {
            data.addNameValuePair(this.createNameValuePair("Username", strUser));
        }
        if (strPassword != null) {
            data.addNameValuePair(this.createNameValuePair("Password", strPassword));
        }
        if (strDomain != null && !"".equals(strDomain)) {
            if (this.searchParams.isDomain()) {
                data.addNameValuePair(this.createNameValuePair("Domain", this.searchParams.getDomain()));
            } else {
                data.addNameValuePair(this.createNameValuePair("Workgroup", this.searchParams.getDomain()));
            }
        }
        data.addNameValuePair(this.createNameValuePair("DomainID", Manager.getCurrentDomainId()));
        if (this.strSourceModule != null && !"".equals(this.strSourceModule)) {
            data.addNameValuePair(this.createNameValuePair("SourceModule", this.strSourceModule));
        }
        if (this.searchParams.getPlatformType() != null && !"".equals(this.searchParams.getPlatformType())) {
            data.addNameValuePair(this.createNameValuePair("PlatformType", this.searchParams.getPlatformType()));
        }
        if (!StringUtilities.isEmpty((String)(known_hosts = this.searchParams.getKnownHostsFileName()))) {
            data.addNameValuePair(this.createNameValuePair("KNOWN_HOSTS", known_hosts));
        }
        return data;
    }

    private RpcData createGetLanDeviceData() {
        RpcData data = new RpcData();
        data.addNameValuePair(this.createNameValuePair("DomainID", Manager.getCurrentDomainId()));
        return data;
    }

    private boolean isRealResponse(String line) {
        return (line = line.trim()).length() != 0;
    }

    private NameValuePair createNameValuePair(String name, String value) {
        NameValuePair pair = new NameValuePair();
        pair.setName(name);
        pair.setOptValue(value);
        return pair;
    }

    public void cancel() {
        if (this.isCommunicating) {
            this.status = 3;
        } else {
            this.finished();
        }
    }

    public void finished() {
        this.status = 2;
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.listener.stateChanged(2);
    }

    private boolean isScanAll() {
        if (this.searchParams.isSearchByIpRange()) {
            return this.searchParams.getBeginIp().equals(SCAN_ALL_IP_BEGIN) && this.searchParams.getEndIp().equals(SCAN_ALL_IP_END);
        }
        return this.searchParams.getHostName().trim().length() == 0;
    }

    public int getLineCountFromResponse() {
        return this.lineCountFromResponse;
    }

    public void setLineCountFromResponse(int lineCountFromResponse) {
        this.lineCountFromResponse = lineCountFromResponse;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

