/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.AutoUpgradeContentOption;
import com.sygate.scm.common.configobject.schema.ClientInstallationFeatures;
import com.sygate.scm.common.configobject.schema.DeploymentNotification;
import com.sygate.scm.common.configobject.schema.DeploymentSchedule;
import com.sygate.scm.common.configobject.schema.DeploymentSnooze;
import com.sygate.scm.common.configobject.schema.PackageInfo;
import com.sygate.scm.common.configobject.schema.PackageSource;
import com.sygate.scm.common.configobject.schema.RebootOptions;
import com.sygate.scm.common.configobject.schema.SoftwareDeploymentEntity;
import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.SecurityFixContentInfoObject;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationSettingObject;
import com.sygate.scm.console.ui.client.dlg.DeployConfigGeneralPanel;
import com.sygate.scm.console.ui.client.dlg.DeployConfigNotificationPanel;
import com.sygate.scm.console.ui.client.dlg.DeployConfigurationDlg;
import com.sygate.scm.console.ui.client.dlg.UpdatePackageForceDeploymentReportDlg;
import com.sygate.scm.console.ui.policy.dialog.RebootOptionsPanel;
import com.sygate.scm.console.ui.policy.lu.LuUtility;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.GroupCheckBoxTree;
import com.sygate.scm.console.ui.util.MultiLineMsgBox;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.ui.util.WizardBase;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;

public class UpdatePackageWizard
extends WizardBase {
    private static final long serialVersionUID = 1L;
    private static final int V_GAP = 80;
    private static final int STAGE_COUNT = 5;
    private static final int STAGE_WELCOME = 0;
    private static final int STAGE_TARGET = 1;
    private static final int STAGE_SERVER = 2;
    private static final int STAGE_TASK = 3;
    private static final int STAGE_SUMMARY = 4;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENTDIALOG = "com.sygate.scm.console.ui.client.dlg.clientdialog";
    private static final String WELCOME_HEADING = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "UpdatePackageWizard.heading.upgradeWelcome");
    private static final String WELCOME_INSTRUCTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "UpdatePackageWizard.welcom_instruction");
    private static final String PACKAGE_DSCRIPTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "UpdatePackageWizard.package_description");
    private static final String PACKAGE_DSCRIPTION_LEGACY = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "UpdatePackageWizard.package_description_legacy");
    private static final String PACKAGE_DSCRIPTION_MAC = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "UpdatePackageWizard.package_description_mac");
    private static final String[] SUPPORTED_32BIT_SYSTEMS_1 = new String[]{MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "UpdatePackageWizard.supported32bitOSWinXP"), MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "UpdatePackageWizard.supported32bitOSWin2K3")};
    private static final String[] SUPPORTED_32BIT_SYSTEMS_2 = new String[]{MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "UpdatePackageWizard.supported32bitOSWinVista"), MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "UpdatePackageWizard.supported32bitOSWin2K8")};
    private static final String[] SUPPORTED_32BIT_SYSTEMS_3 = new String[]{MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "UpdatePackageWizard.supported32bitOSWin7"), MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "UpdatePackageWizard.supported32bitOSWin2K8R2")};
    private static final String[] SUPPORTED_64BIT_SYSTEMS_1 = new String[]{MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "UpdatePackageWizard.supported64bitOSWinXP"), MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "UpdatePackageWizard.supported64bitOSWin2K3")};
    private static final String[] SUPPORTED_64BIT_SYSTEMS_2 = new String[]{MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "UpdatePackageWizard.supported64bitOSWinVista"), MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "UpdatePackageWizard.supported64bitOSWin2K8")};
    private static final String[] SUPPORTED_64BIT_SYSTEMS_3 = new String[]{MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "UpdatePackageWizard.supported64bitOSWin7"), MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "UpdatePackageWizard.supported64bitOSWin2K8R2")};
    private static final String[] SUPPORTED_64BIT_SYSTEMS_4 = new String[]{MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "UpdatePackageWizard.supported64bitOSWin81"), MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "UpdatePackageWizard.supported64bitOSWin2K12")};
    private static final String SUPPORTED_MAC_SYSTEMS14 = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "UpdatePackageWizard.supportedMac14");
    private static final String SUPPORTED_MAC_SYSTEMS140RU1ABOVE = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "UpdatePackageWizard.supportedMac140RU1Above");
    private int currentStage = 0;
    private WizardBase.WelcomeAndFinishPanel welcomePanel = new WizardBase.WelcomeAndFinishPanel(this, 0, WELCOME_HEADING, WELCOME_INSTRUCTION);
    private TargetPanel targetPanel = null;
    private TaskPanel taskPanel = new TaskPanel();
    private ServerPanel serverPanel = null;
    private SummaryPanel summaryPanel = null;

    public UpdatePackageWizard(CurrentPackageObject cpo) {
        super(MessageResources.getInstance().getString(CLIENTDIALOG, "UpdatePackageWizard.upgradeSymantecAgentWizard"), true, WizardBase.HelpButtonState.OFF);
        this.addStage(this.welcomePanel, 0);
        this.targetPanel = new TargetPanel(cpo);
        this.addStage(this.targetPanel, 1);
        this.addStage(this.taskPanel, 3);
        this.serverPanel = new ServerPanel(cpo);
        this.addStage(this.serverPanel, 2);
        this.summaryPanel = new SummaryPanel();
        this.addStage(this.summaryPanel, 4);
        Dimension size = this.welcomePanel.getPreferredSize();
        this.welcomePanel.setPreferredSize(new Dimension(size.width * 3 / 4, size.height));
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    @Override
    protected void prepareNext(int stage) {
        this.currentStage = stage;
        if (this.currentStage == 3) {
            this.taskPanel.initializeGroupTree();
        } else if (this.currentStage == 2) {
            this.serverPanel.enableUrlField();
        } else if (this.currentStage == 4) {
            this.summaryPanel.updateSummaryText();
        }
    }

    @Override
    protected boolean validatePanel(int stage) {
        if (stage == 1) {
            return this.targetPanel.validatePanel();
        }
        if (stage == 3) {
            return this.taskPanel.validatePanel();
        }
        if (stage == 2) {
            return this.serverPanel.validatePanel();
        }
        if (stage == 4) {
            boolean isValid = this.summaryPanel.validatePanel();
            if (isValid) {
                ArrayList<String> listGroupIds = this.taskPanel.getSelection();
                SoftwarePackageObject spo = this.targetPanel.getSelectedSoftwarePackageObject();
                try {
                    ArrayList<GroupObject> selectedGroups = new ArrayList<GroupObject>();
                    for (String selectedGroupId : listGroupIds) {
                        selectedGroups.add(GroupHandler.getGroupById(selectedGroupId));
                    }
                    ArrayList<SoftwarePackage> selectedPackages = new ArrayList<SoftwarePackage>();
                    selectedPackages.add(spo.getSoftwarePackage());
                    ArrayList<GroupObject> unAvaliableGroups = LuUtility.checkHIContentAvailable(selectedGroups, selectedPackages);
                    if (null != unAvaliableGroups) {
                        MultiLineMsgBox optionPane = new MultiLineMsgBox(this, MessageResources.getInstance().getString(CLIENTDIALOG, "UpdatePackageWizard.upgradeSymantecAgentWizard"));
                        optionPane.init(MessageResources.getInstance().getString(CLIENTDIALOG, "UpdatePackageWizard.checkHIConetentFail"), 60, 0, -1);
                        optionPane.show();
                        return false;
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage(), MessageResources.getInstance().getString(CLIENTDIALOG, "UpdatePackageWizard.upgradeSymantecAgentWizard"), 0);
                    return false;
                }
                ClientInstallationFeatures cifo = this.serverPanel.getClientInstallationFeatures();
                ClientInstallationSettingObject cis = this.serverPanel.getClientInstallationSettings();
                Integer sourceServer = this.serverPanel.isInternalSource() ? PackageSource.SEM_SERVER : PackageSource.EXTERNAL_URL;
                String externalUrl = this.serverPanel.getExternalUrl().trim();
                DeploymentSchedule deploymentSchedule = this.serverPanel.getDeploymentSchedule();
                boolean forceDeployment = this.serverPanel.isForceDeployment();
                boolean autoUpgradeToEnglish = this.serverPanel.isAutoUpgradeToEnglish();
                DeploymentNotification deploymentNotification = this.serverPanel.getDeploymentNotification();
                DeploymentSnooze deploymentSnooze = this.serverPanel.getDeploymentSnooze();
                RebootOptions rebootOptions = this.serverPanel.getRebootOptions();
                if (rebootOptions != null) {
                    cis.setOptRebootOptions(rebootOptions);
                }
                this.deletePackages(this.taskPanel.groupWithDeployedSoftwarePackage, listGroupIds);
                AutoUpgradeContentOption contentOption = this.serverPanel.getAutoUpgradeContentOption();
                this.doUpgrade(listGroupIds, spo, cifo, sourceServer, externalUrl, deploymentSchedule, forceDeployment, autoUpgradeToEnglish, deploymentNotification, deploymentSnooze, cis, contentOption, this.serverPanel.getSecurityFixInfo());
            }
            return isValid;
        }
        return true;
    }

    @Override
    protected int getStageCount() {
        return 5;
    }

    @Override
    protected boolean disableBackButtonAtCompletePanel() {
        return false;
    }

    @Override
    protected boolean disableCancelButtonAtCompletePanel() {
        return false;
    }

    @Override
    protected void cancel() {
        if (JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "WizardBase.msg.exitWizard"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "WizardBase.title.exitWizard"), 0, 3) == 0) {
            this.isOk = false;
            if (this.currentStage > 1) {
                this.taskPanel.setOriginalGroupNames();
                this.taskPanel.groupTree.updateUI();
            }
            this.dispose();
        }
    }

    private void doUpgrade(ArrayList<String> listGroupIds, SoftwarePackageObject spo, ClientInstallationFeatures cifo, Integer sourceServer, String externalUrl, DeploymentSchedule deploymentSchedule, boolean forceDeployment, boolean autoUpgradeoEnglish, DeploymentNotification deploymentNotification, DeploymentSnooze deploymentSnooze, ClientInstallationSettingObject cis, AutoUpgradeContentOption contentOption, SecurityFixContentInfoObject securityFix) {
        block6: {
            try {
                if (listGroupIds == null || listGroupIds.size() < 1) {
                    ConsoleLogger.log("UpdatePackageWizard> doUpgrade>> Error. Group ID list is invalid!");
                    return;
                }
                for (int i = 0; i < listGroupIds.size(); ++i) {
                    String groupId = listGroupIds.get(i);
                    GroupObject groupObject = GroupHandler.getGroupById(groupId);
                    PackageInfo packageInfo = spo.getPackageInfo();
                    String platform = packageInfo.getOptPlatformType();
                    if (platform == null) {
                        platform = packageInfo.getDefPlatformType();
                    }
                    String language = packageInfo.getOptLanuage();
                    RebootOptions options = cis.getOptRebootOptions();
                    SoftwarePackageHandler.addSoftwareDeploymentPolicy(groupObject, spo.getId(), cifo, sourceServer, externalUrl, deploymentSchedule, forceDeployment, autoUpgradeoEnglish, platform, language, deploymentNotification, deploymentSnooze, options, cis, contentOption, securityFix);
                    ConsoleLogger.logAdminEvent(12296);
                }
            }
            catch (Exception ex) {
                ConsoleLogger.log("UpdatePackageWizard> doUpgrade>> Exception in addSoftwareDeploymentPolicy. Exception: " + ex.getMessage());
                LoggerUtilities.logException((Throwable)ex);
                if (!(ex instanceof ConsoleException)) break block6;
                JOptionPane.showMessageDialog(this, ex.getMessage(), MessageResources.getInstance().getString(CLIENTDIALOG, "UpdatePackageWizard.error"), 0);
                if (((ConsoleException)ex).needRelogin()) {
                    Manager.getFrame().showLoginPanel();
                }
                return;
            }
        }
    }

    private void deletePackages(Hashtable<GroupObject, SoftwareDeploymentEntity> groupsWithDeployedSoftwarePackage, ArrayList<String> listGroupIds) {
        if (groupsWithDeployedSoftwarePackage.isEmpty()) {
            return;
        }
        this.taskPanel.setOriginalGroupNames();
        this.taskPanel.groupTree.updateUI();
        boolean exceptionOccured = false;
        StringBuilder groupsWithOldPackage = new StringBuilder("");
        for (Map.Entry<GroupObject, SoftwareDeploymentEntity> entry : groupsWithDeployedSoftwarePackage.entrySet()) {
            GroupObject group = entry.getKey();
            ConsoleLogger.log("UpdatePackageWizard> deletePackages>> Deleting the duplicated entity with the same package type on groupId: " + group.getId() + ", group: " + group);
            if (!group.isSelected()) continue;
            try {
                SoftwarePackageHandler.deleteSoftwareDeploymentEntity(group, entry.getValue());
            }
            catch (ConsoleException ex) {
                groupsWithOldPackage.append(group.getId());
                groupsWithOldPackage.append("  ");
                groupsWithOldPackage.append(group);
                groupsWithOldPackage.append("\n");
                listGroupIds.remove(group.getId());
                exceptionOccured = true;
            }
        }
        if (exceptionOccured) {
            ConsoleLogger.log("UpdatePackageWizard> deletePackages>> Exception got while deleting old packages from following groups:  \n" + groupsWithOldPackage);
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString(CLIENTDIALOG, "UpdatePackageWizard.exceptionWhileOverwritingPackages"), MessageResources.getInstance().getString(CLIENTDIALOG, "UpdatePackageWizard.error"), 0);
        }
    }

    @Override
    protected String getDefaultContentSensitiveHelpToken() {
        return "sesm_admin_pane_install_packages_upgrade_groups_wizard";
    }

    private class SummaryPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JTextArea summaryText;
        private static final String layout = "\n";
        private static final String layout1 = "\n\t";
        private static final String layout2 = "\n\n";

        public SummaryPanel() {
            this.initialize();
            this.putClientProperty("cssClass", "updatePackageWizardTaskPanel");
        }

        private StringBuilder getSummary() {
            Integer sourceServer;
            StringBuilder summaryCollection = new StringBuilder();
            String str = MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.summaryPackageName");
            SoftwarePackageObject spo = UpdatePackageWizard.this.targetPanel.getSelectedSoftwarePackageObject();
            str = MessageFormat.format(str, spo.getName());
            summaryCollection.append(str);
            str = MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.summaryGroupNames");
            summaryCollection.append(layout2);
            summaryCollection.append(str);
            ArrayList<String> listSelGroupIds = UpdatePackageWizard.this.taskPanel.getSelection();
            for (String groupId : listSelGroupIds) {
                try {
                    GroupObject groupObject = GroupHandler.getGroupById(groupId);
                    summaryCollection.append("\t");
                    summaryCollection.append(groupObject.getName());
                    summaryCollection.append(layout);
                }
                catch (ConsoleException ex) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.consoleError"), 0);
                    if (!ex.needRelogin()) continue;
                    Manager.getFrame().showLoginPanel();
                }
            }
            str = MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.summaryUpgradeSettings");
            summaryCollection.append(layout);
            summaryCollection.append(str);
            SecurityFixContentInfoObject securityFixInfo = UpdatePackageWizard.this.serverPanel.getSecurityFixInfo();
            if (securityFixInfo != null && securityFixInfo.getSecurityFixContentInfo() != null) {
                str = MessageFormat.format(MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.summaryVersionOfPackage"), securityFixInfo.getSecurityFixContentInfo().getProductBuildNum());
                summaryCollection.append(layout1);
                summaryCollection.append(str);
            }
            str = MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.summaryInstallSettings");
            ClientInstallationSettingObject cis = UpdatePackageWizard.this.serverPanel.getClientInstallationSettings();
            str = MessageFormat.format(str, cis.getName());
            summaryCollection.append(layout1);
            summaryCollection.append(str);
            boolean forceDeployment = UpdatePackageWizard.this.serverPanel.isForceDeployment();
            if (!forceDeployment) {
                str = MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.summaryDoNotForceDeployment");
            } else {
                str = MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.summaryDoForceDeployment");
                ClientInstallationFeatures cifo = UpdatePackageWizard.this.serverPanel.getClientInstallationFeatures();
                str = MessageFormat.format(str, cifo.getName());
            }
            summaryCollection.append(layout1);
            summaryCollection.append(str);
            Integer n = sourceServer = UpdatePackageWizard.this.serverPanel.isInternalSource() ? PackageSource.SEM_SERVER : PackageSource.EXTERNAL_URL;
            if (0 == sourceServer) {
                str = MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.summaryInternalSourceServer");
            } else {
                str = MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.summaryExternalSourceServer");
                String externalUrl = UpdatePackageWizard.this.serverPanel.getExternalUrl().trim();
                str = MessageFormat.format(str, externalUrl);
            }
            summaryCollection.append(layout1);
            summaryCollection.append(str);
            DeploymentSchedule deploymentSchedule = UpdatePackageWizard.this.serverPanel.getDeploymentSchedule();
            if (deploymentSchedule.getOptEnable().booleanValue()) {
                str = MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.summaryEnabledDeploymentSchedule");
                String startHour = String.format("%1$02d", UpdatePackageWizard.this.serverPanel.panelGeneral.getHour(0));
                String startMin = String.format("%1$02d", UpdatePackageWizard.this.serverPanel.panelGeneral.getMinute(0));
                String endMin = String.format("%1$02d", UpdatePackageWizard.this.serverPanel.panelGeneral.getMinute(1));
                String endHour = String.format("%1$02d", UpdatePackageWizard.this.serverPanel.panelGeneral.getHour(1));
                int days = UpdatePackageWizard.this.serverPanel.panelGeneral.getRandomizedDays();
                str = MessageFormat.format(str, startHour, startMin, endHour, endMin, days);
            } else {
                str = MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.summaryDisabledDeploymentSchedule");
            }
            summaryCollection.append(layout1);
            summaryCollection.append(str);
            DeploymentNotification deploymentNotification = UpdatePackageWizard.this.serverPanel.getDeploymentNotification();
            str = deploymentNotification.getOptEnable() != false ? MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.summaryEnabledDeploymentNotification") : MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.summaryDisabledDeploymentNotification");
            summaryCollection.append(layout1);
            summaryCollection.append(str);
            DeploymentSnooze deploymentSnooze = UpdatePackageWizard.this.serverPanel.getDeploymentSnooze();
            if (deploymentSnooze.getOptEnable().booleanValue()) {
                str = MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.summaryEnabledDeploymentSnooze");
                String maxDay = UpdatePackageWizard.this.serverPanel.panelNotification.getSnoozeMaxTimeInString();
                String minDay = UpdatePackageWizard.this.serverPanel.panelNotification.getSnoozeMinTimeInString();
                str = MessageFormat.format(str, minDay, maxDay);
            } else {
                str = MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.summaryDisabledDeploymentSnooze");
            }
            summaryCollection.append(layout1);
            summaryCollection.append(str);
            AutoUpgradeContentOption contentOption = UpdatePackageWizard.this.serverPanel.getAutoUpgradeContentOption();
            str = contentOption.getOptIncludeContentInAutoUpgradePackage() != false ? MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.summaryIncludeContent") : MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.summaryDoNotIncludeContent");
            summaryCollection.append(layout1);
            summaryCollection.append(str);
            return summaryCollection;
        }

        private void initialize() {
            String title = MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.readyToDeployTitle");
            String content = MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.selectedSettingMsg");
            JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
            JPanel panel = new JPanel(new BorderLayout());
            this.summaryText = new JTextArea(20, 20);
            this.summaryText.setEditable(false);
            String finishMsg = MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.finishMsg");
            JLabel finishMsgLable = new JLabel(finishMsg);
            panel.setBorder(BorderFactory.createEmptyBorder(10, 80, 10, 80));
            JScrollPane scrollPane = new JScrollPane();
            UiUtilities.setupScrollPane((JScrollPane)scrollPane, (JTextArea)this.summaryText);
            this.summaryText.setLineWrap(true);
            this.summaryText.setWrapStyleWord(true);
            this.summaryText.setTabSize(2);
            scrollPane.setHorizontalScrollBarPolicy(31);
            panel.add((Component)scrollPane, "Center");
            panel.add((Component)finishMsgLable, "South");
            this.setLayout(new VerticalFlowLayout(0, 0));
            this.add(headPanel);
            this.add(panel);
        }

        private void updateSummaryText() {
            this.summaryText.setText(this.getSummary().toString());
        }

        private boolean validatePanel() {
            return true;
        }
    }

    private class ServerPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private DeployConfigGeneralPanel panelGeneral = null;
        private DeployConfigNotificationPanel panelNotification = new DeployConfigNotificationPanel();
        private RebootOptionsPanel rebootOptionsPanel = new RebootOptionsPanel(2);
        private JRadioButton jRBInternal = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "UpdatePackageWizard.downloadAgentFromPolicyManagerBtn"), true);
        private JRadioButton jRBExternal = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "UpdatePackageWizard.downloadAgentFromURLBtn"));
        private JTextField jTFUrl = new JTextField();
        private JButton jBtnAdvancedSetting = new JButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "UpdatePackageWizard.advancedSettings"));
        private DeploymentSchedule deploymentSchedule = null;
        private boolean forceDeployment;
        private boolean autoUpgradeToEnglish;
        private DeploymentNotification deploymentNotification;
        private DeploymentSnooze deploymentSnooze;
        private RebootOptions rebootOptions = null;
        private ClientInstallationFeatures cif;
        private ClientInstallationSettingObject cis;
        private AutoUpgradeContentOption contentOption = null;
        private SecurityFixContentInfoObject securityFix = null;

        public ServerPanel(CurrentPackageObject cpo) {
            this.panelGeneral = new DeployConfigGeneralPanel(true, cpo.getPlatformType());
            this.initialize();
        }

        private void initialize() {
            String title = MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.packageUpgradeSettingsTitle");
            String content = MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.specifyDownloadLocationAndMsg");
            JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.jRBInternal);
            buttonGroup.add(this.jRBExternal);
            this.jRBInternal.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ex) {
                    ServerPanel.this.radioInternal_actionPerformed(ex);
                }
            });
            this.jRBExternal.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ex) {
                    ServerPanel.this.radioExternal_actionPerformed(ex);
                }
            });
            this.jBtnAdvancedSetting.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ex) {
                    ServerPanel.this.advancedSetting_actionPerformed(ex);
                }
            });
            int row = 0;
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(10, 80, 10, 80));
            panel.add((Component)new JLabel(MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.specifyDownloadServerLabel")), new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
            panel.add((Component)this.jRBInternal, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
            panel.add((Component)this.jRBExternal, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel(MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "DeployConfigGeneralPanel.urlLabel")), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 25, 0, 0), 0, 0));
            panel.add((Component)this.jTFUrl, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.jBtnAdvancedSetting, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.setLayout(new VerticalFlowLayout(0, 0));
            this.add(headPanel);
            this.add(panel);
        }

        private boolean validateDownloadSourceURL(String packagePlatform) {
            if (this.jRBExternal.isSelected()) {
                String requiredExtension = ".exe";
                if ("Mac".equalsIgnoreCase(packagePlatform)) {
                    requiredExtension = ".zip";
                }
                if (!Utility.isValidUrl((String)this.jTFUrl.getText().trim(), (String)requiredExtension)) {
                    JOptionPane.showMessageDialog(this, MessageFormat.format(MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.enterAValidURLMsg"), requiredExtension), MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.upgradeSymantecAgentWizard"), 0);
                    return false;
                }
            }
            return true;
        }

        private boolean validatePanel() {
            if (!this.jRBInternal.isSelected() && !this.jRBExternal.isSelected()) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.selectASrouceMsg"), MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.error"), 0);
                return false;
            }
            ArrayList<String> listGroupIds = UpdatePackageWizard.this.taskPanel.getSelection();
            SoftwarePackageObject spo = UpdatePackageWizard.this.targetPanel.getSelectedSoftwarePackageObject();
            try {
                UpdatePackageForceDeploymentReportDlg dlg;
                PackageInfo packageInfo = spo.getSoftwarePackage().getPackageInfo();
                String platform = packageInfo.getOptPlatformType();
                if (platform == null) {
                    platform = packageInfo.getDefPackageName();
                }
                if (!this.validateDownloadSourceURL(platform)) {
                    return false;
                }
                String language = packageInfo.getOptLanuage();
                ArrayList<String> listGroupObjs = SoftwarePackageHandler.retrieveGroupsWithForceDeployment(listGroupIds, spo.getId(), platform, language);
                if (listGroupObjs != null && listGroupObjs.size() > 0 && !(dlg = new UpdatePackageForceDeploymentReportDlg(MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.updatePackageWarningMsg"), listGroupObjs)).isYes()) {
                    return false;
                }
                int packageType = UpdatePackageWizard.this.targetPanel.getSelectedSoftwarePackageObject().getType();
                boolean isSBEPackage = UpdatePackageWizard.this.targetPanel.isLegacySBEPackage();
                this.panelGeneral.initData(packageType, this.cif, this.deploymentSchedule, this.forceDeployment, this.autoUpgradeToEnglish, this.cis, isSBEPackage, platform, this.contentOption, UpdatePackageWizard.this.targetPanel.getSelectedSoftwarePackageObject(), this.panelGeneral.getSecurityFixContentInfoObject());
                this.panelNotification.initData(this.deploymentNotification, this.deploymentSnooze);
                if (this.rebootOptions == null) {
                    this.rebootOptions = RebootOptionsPanel.getDefaultRebootOptions();
                }
                this.rebootOptionsPanel.updateSettings(this.rebootOptions);
                if (this.deploymentSchedule == null) {
                    this.deploymentSchedule = this.panelGeneral.generateDeploymentSchedule();
                }
                if (this.cif == null) {
                    this.cif = this.panelGeneral.getClientInstallationFeatureObject();
                }
                if (this.cis == null) {
                    this.cis = this.panelGeneral.getSelectedInstallSettings();
                }
                if (this.contentOption == null) {
                    this.contentOption = this.panelGeneral.generateAutoUpgradeContentOption();
                }
                if (this.deploymentNotification == null) {
                    this.deploymentNotification = this.panelNotification.generateDeploymentNotification();
                }
                if (this.deploymentSnooze == null) {
                    this.deploymentSnooze = this.panelNotification.generateDeploymentSnooze();
                }
                if (this.securityFix == null) {
                    this.securityFix = this.panelGeneral.getSecurityFixContentInfoObject();
                }
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.consoleError"), 0);
                if (ex.needRelogin()) {
                    Manager.getFrame().showLoginPanel();
                }
            }
            catch (Throwable ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            return true;
        }

        private boolean isInternalSource() {
            return this.jRBInternal.isSelected();
        }

        private String getExternalUrl() {
            return this.jTFUrl.getText();
        }

        private DeploymentSchedule getDeploymentSchedule() {
            return this.deploymentSchedule;
        }

        private boolean isForceDeployment() {
            return this.forceDeployment;
        }

        private boolean isAutoUpgradeToEnglish() {
            return this.autoUpgradeToEnglish;
        }

        private RebootOptions getRebootOptions() {
            return this.rebootOptions;
        }

        private DeploymentNotification getDeploymentNotification() {
            return this.deploymentNotification;
        }

        private DeploymentSnooze getDeploymentSnooze() {
            return this.deploymentSnooze;
        }

        private ClientInstallationFeatures getClientInstallationFeatures() {
            return this.cif;
        }

        private ClientInstallationSettingObject getClientInstallationSettings() {
            return this.cis;
        }

        private AutoUpgradeContentOption getAutoUpgradeContentOption() {
            return this.contentOption;
        }

        private void radioInternal_actionPerformed(ActionEvent ex) {
            this.jTFUrl.setEnabled(!this.isInternalSource());
        }

        private void radioExternal_actionPerformed(ActionEvent ex) {
            this.jTFUrl.setEnabled(!this.isInternalSource());
        }

        private void advancedSetting_actionPerformed(ActionEvent ex) {
            try {
                int packageType = UpdatePackageWizard.this.targetPanel.getSelectedSoftwarePackageObject().getType();
                boolean isSBEPackage = UpdatePackageWizard.this.targetPanel.isLegacySBEPackage();
                String packagePlatform = UpdatePackageWizard.this.targetPanel.getSelectedSoftwarePackageObject().getPackageInfo().getOptPlatformType();
                DeployConfigurationDlg dlg = new DeployConfigurationDlg(packageType, this.cif, this.deploymentSchedule, this.forceDeployment, this.autoUpgradeToEnglish, this.deploymentNotification, this.deploymentSnooze, this.cis, isSBEPackage, packagePlatform, this.contentOption, UpdatePackageWizard.this.targetPanel.getSelectedSoftwarePackageObject());
                if (dlg.isOk()) {
                    this.deploymentSchedule = dlg.generateDeploymentSchedule();
                    this.forceDeployment = dlg.isForceDeployment();
                    this.autoUpgradeToEnglish = dlg.isAutoUpgradeToEnglish();
                    this.deploymentNotification = dlg.generateDeploymentNotification();
                    this.deploymentSnooze = dlg.generateDeploymentSnooze();
                    this.contentOption = dlg.generateAutoUpgradeContentOption();
                    this.securityFix = dlg.getSecurityFixContentInfoObject();
                    this.cif = dlg.getClientFeatureObject();
                    this.cis = dlg.getClientInstallSettings();
                }
            }
            catch (ConsoleException ex1) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex1.getMessage(), MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.consoleError"), 0);
                if (ex1.needRelogin()) {
                    Manager.getFrame().showLoginPanel();
                }
            }
            catch (Throwable ex2) {
                LoggerUtilities.logException((Throwable)ex2);
            }
        }

        private void enableUrlField() {
            this.jTFUrl.setEnabled(!this.isInternalSource());
        }

        public SecurityFixContentInfoObject getSecurityFixInfo() {
            return this.securityFix;
        }
    }

    public class TaskPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private GroupCheckBoxTree groupTree = new GroupCheckBoxTree();
        private ArrayList<String> selGroups = new ArrayList();
        private boolean bInitTree = false;
        private ArrayList<GroupObject> allGroupObject = new ArrayList();
        private int packageDeployedGroupCnt = 0;
        private int groupTreeNodeCnt = 0;
        private SoftwarePackageObject spoNew = null;
        private SoftwarePackageObject spo = null;
        private SecurityFixContentInfoObject securityFixInfo = null;
        private String noteMsg;
        private JLabel note = new JLabel();
        private JPanel panel = new JPanel(new BorderLayout());
        private Hashtable<GroupObject, SoftwareDeploymentEntity> groupWithDeployedSoftwarePackage = new Hashtable();
        private Hashtable<GroupObject, String> groupWithOriginalName = new Hashtable();

        public TaskPanel() {
            this.initialize();
            this.putClientProperty("cssClass", "updatePackageWizardTaskPanel");
        }

        private void initialize() {
            String title = MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.specifyGroups");
            String content = MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.selectGroupsYouWantToUpdate");
            JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
            this.groupTree.setVisibleRowCount(10);
            this.panel.setBorder(BorderFactory.createEmptyBorder(10, 80, 10, 80));
            this.panel.add((Component)new JLabel(MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.groupsLabel")), "North");
            this.panel.add((Component)new JScrollPane(this.groupTree), "Center");
            this.setLayout(new VerticalFlowLayout(0, 0));
            this.add(headPanel);
            this.add(this.panel);
        }

        private void initializeGroupTree() {
            if (!this.bInitTree) {
                try {
                    this.groupTree.init(Manager.getCurrentDomainId(), true, false);
                }
                catch (Exception ex) {
                    ConsoleLogger.log("UpdatePackageWizard>> linkActivated: Exception in AddTaskToGroupDlg...");
                    LoggerUtilities.logException((Throwable)ex);
                    if (ex instanceof ConsoleException) {
                        JOptionPane.showMessageDialog(this, ex.getMessage(), MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.error"), 0);
                        Manager.getFrame().showLoginPanel();
                        return;
                    }
                    UpdatePackageWizard.this.cancel();
                }
                this.groupTree.setPopupMenuEnabled(true);
                this.groupTree.setSelectionMode(3);
                this.groupTree.getAllTreeObject(this.allGroupObject, false);
                this.groupTreeNodeCnt = this.allGroupObject.size();
                this.spo = UpdatePackageWizard.this.targetPanel.getSelectedSoftwarePackageObject();
                this.securityFixInfo = UpdatePackageWizard.this.serverPanel.getSecurityFixInfo();
                this.packageDeployedGroupCnt = this.disableDeployedGroups(this.groupTree, this.spo, this.securityFixInfo);
                this.bInitTree = true;
            } else {
                this.spoNew = UpdatePackageWizard.this.targetPanel.getSelectedSoftwarePackageObject();
                SecurityFixContentInfoObject securityFixInfoNew = UpdatePackageWizard.this.serverPanel.getSecurityFixInfo();
                if (!this.spoNew.getId().equals(this.spo.getId()) || securityFixInfoNew != null && !securityFixInfoNew.equals(this.securityFixInfo)) {
                    this.setOriginalGroupNames();
                    this.groupTree.updateUI();
                    this.groupWithDeployedSoftwarePackage.clear();
                    this.groupWithOriginalName.clear();
                    this.note.setText("");
                    this.packageDeployedGroupCnt = this.disableDeployedGroups(this.groupTree, this.spoNew, securityFixInfoNew);
                }
                this.spo = this.spoNew;
                this.securityFixInfo = securityFixInfoNew;
            }
        }

        private boolean validatePanel() {
            this.groupTree.getSelection(this.selGroups, false, true);
            if (this.selGroups.size() < 1 && this.packageDeployedGroupCnt < 1) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.specifyAtLeastOneGroupMsg"), MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.error"), 0);
                return false;
            }
            if (this.selGroups.size() < 1 && this.packageDeployedGroupCnt >= 1 && this.packageDeployedGroupCnt != this.groupTreeNodeCnt) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.selectAdditionalGroupsMsg"), MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.error"), 0);
                return false;
            }
            if (this.packageDeployedGroupCnt == this.groupTreeNodeCnt) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.allPackageAlreadyDeployedMsg"), this.spo.getName()), MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.error"), 0);
                return false;
            }
            return true;
        }

        public ArrayList<String> getSelection() {
            return this.selGroups;
        }

        private void setOriginalGroupNames() {
            for (Map.Entry<GroupObject, String> entry : this.groupWithOriginalName.entrySet()) {
                GroupObject group = entry.getKey();
                group.setName(entry.getValue());
            }
        }

        private int disableDeployedGroups(GroupCheckBoxTree groupTree, SoftwarePackageObject spo, SecurityFixContentInfoObject securityFixInfo) {
            ArrayList<GroupObject> allGroupObjects = new ArrayList<GroupObject>();
            this.packageDeployedGroupCnt = 0;
            groupTree.getAllTreeObject(allGroupObjects, false);
            for (GroupObject group : allGroupObjects) {
                if (!this.checkIfPackageDeployed(group, spo, securityFixInfo)) {
                    group.setSelected(true);
                    group.setEnabledUI(false);
                    ++this.packageDeployedGroupCnt;
                    continue;
                }
                group.setEnabledUI(true);
                group.setSelected(false);
            }
            return this.packageDeployedGroupCnt;
        }

        private boolean checkIfPackageDeployed(GroupObject groupObject, SoftwarePackageObject spo, SecurityFixContentInfoObject securityFixInfo) {
            PackageInfo packageInfo = spo.getSoftwarePackage().getPackageInfo();
            String platform = packageInfo.getOptPlatformType();
            if (platform == null) {
                platform = packageInfo.getDefPlatformType();
            }
            String language = packageInfo.getOptLanuage();
            Hashtable<String, ConfigObject> duplicatedPackageAndEntity = null;
            try {
                duplicatedPackageAndEntity = SoftwarePackageHandler.getSoftwarePackageAndDeploymentEntityByPackageType(groupObject, spo.getType(), platform, language);
            }
            catch (ConsoleException ex) {
                return false;
            }
            if (duplicatedPackageAndEntity == null) {
                return true;
            }
            String groupName = groupObject.getName();
            ConsoleLogger.log("UpdatePackageWizard> checkIfPackageDeployed>>  Found duplicated package type deployment on group: " + groupName);
            SoftwarePackageObject spoDuplicated = new SoftwarePackageObject((SoftwarePackage)duplicatedPackageAndEntity.get("PACKAGE"));
            SoftwareDeploymentEntity entityDup = (SoftwareDeploymentEntity)duplicatedPackageAndEntity.get("ENTITY");
            if (spoDuplicated.equals(spo)) {
                if (entityDup != null && entityDup.getOptSecurityFixContentInfo() != null && securityFixInfo != null) {
                    ConsoleLogger.log("UpdatePackageWizard> checkIfPackageDeployed>> Found SecurityFixInfo from policy, " + entityDup.getOptSecurityFixContentInfo());
                    ConsoleLogger.log("UpdatePackageWizard> checkIfPackageDeployed>> SecurityFixInfo to deploy, " + securityFixInfo.getSecurityFixContentInfo());
                    if (securityFixInfo.equals(new SecurityFixContentInfoObject(entityDup.getOptSecurityFixContentInfo()))) {
                        return false;
                    }
                    ConsoleLogger.log("UpdatePackageWizard> checkIfPackageDeployed>> SecurityFixInfo does not match! Will return true!");
                } else {
                    return false;
                }
            }
            String oldName = groupObject.getDisplayName();
            String newName = oldName + " [" + spoDuplicated.getVersion() + "]*";
            groupObject.setName(newName);
            this.groupTree.updateUI();
            this.groupWithOriginalName.put(groupObject, oldName);
            this.groupWithDeployedSoftwarePackage.put(groupObject, entityDup);
            String obj = spo.getName();
            String str = MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.youHaveAnother0DeployedMsg");
            this.noteMsg = MessageFormat.format(str, obj);
            this.note.setText(this.noteMsg);
            this.panel.add((Component)this.note, "South");
            return true;
        }
    }

    public static class TargetPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JComboBox<Object> jCmbPackage;
        private ArrayList<CurrentPackageObject> curPackages = null;
        private DescriptionTextArea packageDecriptionText = null;
        private boolean isLegacySBEPackage = false;

        public TargetPanel(CurrentPackageObject curSelectedPackage) {
            this.initialize();
            this.setSelectedCurrentPackageObject(curSelectedPackage);
        }

        private void initialize() {
            block2: {
                try {
                    JPanel panel = new JPanel(new GridBagLayout());
                    panel.setBorder(BorderFactory.createEmptyBorder(10, 80, 10, 80));
                    JLabel packagesLabel = new JLabel(MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.existingPackagesAreListedLabel"));
                    panel.add((Component)packagesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
                    panel.add(this.getPackagesCombo(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
                    panel.add((Component)this.getDescriptionArea(), new GridBagConstraints(0, 2, 1, 2, 1.0, 1.0, 11, 1, new Insets(20, 0, 10, 0), 0, 0));
                    packagesLabel.setLabelFor(this.getPackagesCombo());
                    this.setLayout(new VerticalFlowLayout(0, 0));
                    String title = MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.selectAgentPackageTitle");
                    String content = MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.selectNewAgentPackage");
                    JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
                    this.add(headPanel);
                    this.add(panel);
                }
                catch (ConsoleException ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage(), MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.error"), 0);
                    if (!ex.needRelogin()) break block2;
                    Manager.getFrame().showLoginPanel();
                }
            }
        }

        public boolean validatePanel() {
            SoftwarePackageObject spo = this.getSelectedSoftwarePackageObject();
            if (spo == null) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.selectATargetPackageMsg"), MessageResources.getInstance().getString(UpdatePackageWizard.CLIENTDIALOG, "UpdatePackageWizard.error"), 0);
                return false;
            }
            return true;
        }

        private void setSelectedCurrentPackageObject(CurrentPackageObject cpo) {
            if (cpo != null) {
                try {
                    this.jCmbPackage = this.getPackagesCombo();
                    for (CurrentPackageObject oneItem : this.curPackages) {
                        if (!oneItem.getId().equals(cpo.getId())) continue;
                        this.jCmbPackage.setSelectedItem(oneItem);
                    }
                }
                catch (ConsoleException ex) {
                    ConsoleLogger.log(ex);
                }
            }
        }

        public SoftwarePackageObject getSelectedSoftwarePackageObject() {
            if (this.curPackages == null) {
                return null;
            }
            ComboBoxModel<Object> listModel = this.jCmbPackage.getModel();
            CurrentPackageObject cpo = (CurrentPackageObject)listModel.getElementAt(this.jCmbPackage.getSelectedIndex());
            if (cpo != null) {
                return cpo.getSoftwarePackageObject();
            }
            return null;
        }

        private JComboBox<Object> getPackagesCombo() throws ConsoleException {
            if (this.jCmbPackage == null) {
                this.curPackages = SoftwarePackageHandler.getAutoUpgradableCurrentSoftwarePackages();
                Vector<CurrentPackageObject> packages = new Vector<CurrentPackageObject>(this.curPackages);
                this.jCmbPackage = new JComboBox<CurrentPackageObject>(packages);
                this.jCmbPackage.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ex) {
                        this.updatePackageDescription();
                    }
                });
            }
            return this.jCmbPackage;
        }

        protected void updatePackageDescription() {
            String text;
            if (this.jCmbPackage.getSelectedIndex() < 0) {
                return;
            }
            CurrentPackageObject selectedItem = (CurrentPackageObject)this.jCmbPackage.getSelectedItem();
            if (selectedItem == null) {
                return;
            }
            String platformString = selectedItem.getSoftwarePackage().getPackageInfo().getOptPlatformType();
            int productMajorVersion = 14;
            String versionString = this.getVersionString(selectedItem.getSoftwarePackage().getPackageInfo());
            String[] splitVersion = SoftwarePackageObject.splitVersion(versionString);
            if (platformString.equalsIgnoreCase("Mac")) {
                String desplayText = this.getDisplayText(platformString, productMajorVersion, splitVersion);
                text = MessageFormat.format(PACKAGE_DSCRIPTION_MAC, desplayText);
            } else {
                int majorVersion;
                if (versionString != null && (majorVersion = SoftwarePackageObject.getMajorVersion(versionString)) != 0) {
                    productMajorVersion = majorVersion;
                }
                String desplayText = this.getDisplayText(platformString, productMajorVersion, splitVersion);
                String PackageDescription = productMajorVersion < 14 ? PACKAGE_DSCRIPTION_LEGACY : PACKAGE_DSCRIPTION;
                text = MessageFormat.format(PackageDescription, desplayText);
                if (versionString != null && Utility.compareVersion((String)versionString, (String)"12.0.0.0") >= 0 && Utility.compareVersion((String)versionString, (String)"12.1.0.0") < 0) {
                    this.setLegacySBEPackage(true);
                } else {
                    this.setLegacySBEPackage(false);
                }
            }
            this.getDescriptionArea().setText(text);
        }

        protected String getVersionString(PackageInfo packageInfo) {
            String versionString = packageInfo.getOptProductBuildNum();
            if (StringUtils.isEmpty(versionString)) {
                versionString = packageInfo.getVersion();
            }
            return versionString;
        }

        private DescriptionTextArea getDescriptionArea() {
            if (this.packageDecriptionText == null) {
                this.packageDecriptionText = new DescriptionTextArea("TESTING TESTING", false);
            }
            return this.packageDecriptionText;
        }

        public String getDisplayText(String platformString, int productMajorVersion, String[] splitVersion) {
            String value = "";
            if (platformString == null || platformString.isEmpty() || productMajorVersion <= 0 || splitVersion == null || splitVersion.length == 0) {
                return value;
            }
            int minorVersion = 0;
            int ru = 0;
            if (splitVersion.length >= 4) {
                minorVersion = Integer.parseInt(splitVersion[1]);
                ru = Integer.parseInt(splitVersion[3]);
            }
            if (platformString.equalsIgnoreCase("WIN64BIT")) {
                value = this.convertOSString("WIN64BIT", productMajorVersion, minorVersion, ru);
            } else if (platformString.equalsIgnoreCase("WIN32BIT")) {
                value = this.convertOSString("WIN32BIT", productMajorVersion, minorVersion, ru);
            } else if (platformString.equalsIgnoreCase("Mac") && productMajorVersion >= 14) {
                value = minorVersion > 0 || minorVersion == 0 && ru >= 1000 ? SUPPORTED_MAC_SYSTEMS140RU1ABOVE : SUPPORTED_MAC_SYSTEMS14;
            }
            return value;
        }

        boolean isOsSupportGroup1(int major) {
            return major < 14;
        }

        boolean isOsSupportGroup2(int major, int minor, int ru) {
            if (major == 14) {
                return minor == 0 || minor == 2 && ru < 1000;
            }
            return false;
        }

        boolean isOsSupportGroup3(int major, int minor, int ru) {
            if (major == 14) {
                return minor == 2 && ru >= 1000 || minor == 3 && ru <= 7000;
            }
            return false;
        }

        public String convertOSString(String bitString, int productMajorVersion, int minorVersion, int ru) {
            StringBuilder retValue = new StringBuilder();
            String[] osString = new String[]{};
            if (bitString.equalsIgnoreCase("WIN64BIT")) {
                osString = this.isOsSupportGroup1(productMajorVersion) ? SUPPORTED_64BIT_SYSTEMS_1 : (this.isOsSupportGroup2(productMajorVersion, minorVersion, ru) ? SUPPORTED_64BIT_SYSTEMS_2 : (this.isOsSupportGroup3(productMajorVersion, minorVersion, ru) ? SUPPORTED_64BIT_SYSTEMS_3 : SUPPORTED_64BIT_SYSTEMS_4));
            } else if (bitString.equalsIgnoreCase("WIN32BIT")) {
                osString = this.isOsSupportGroup1(productMajorVersion) ? SUPPORTED_32BIT_SYSTEMS_1 : (this.isOsSupportGroup2(productMajorVersion, minorVersion, ru) ? SUPPORTED_32BIT_SYSTEMS_2 : SUPPORTED_32BIT_SYSTEMS_3);
            }
            for (int i = 0; i < osString.length; ++i) {
                if (i == 0) {
                    retValue.append("\t");
                    retValue.append(osString[i]);
                    continue;
                }
                retValue.append("\n");
                retValue.append("\t");
                retValue.append(osString[i]);
            }
            return retValue.toString();
        }

        public void setLegacySBEPackage(boolean isLegacySBEPackage) {
            this.isLegacySBEPackage = isLegacySBEPackage;
        }

        public boolean isLegacySBEPackage() {
            return this.isLegacySBEPackage;
        }
    }
}

