/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.configobject.schema.CommunicationOption;
import com.sygate.scm.common.configobject.schema.InstallationOption;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.RebootOptions;
import com.sygate.scm.common.configobject.schema.SemServerList;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.ui.policy.dialog.RebootOptionsPanel;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.HTMLEditorPane;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.ServerListComboBox;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.PackageUtil;
import com.sygate.scm.util.ServerVersion;
import com.sygate.scm.util.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class SoftwarePackagePropsInstallSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.console.ui.client.dlg.clientdialog");
    private static final int MAX_LEN_INSTALL_DIR = 126;
    private static final int MAX_LEN_INSTALL_LOG_FILENAME = 239;
    private RebootOptions rebootOptObject;
    private final JCheckBox jCbxEnable = new JCheckBox(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.EnableCustomizedInstallationSettingsCkbox"));
    private final JPanel jSettingPanel = new JPanel(new GridBagLayout());
    private final JLabel jLSetting1 = new JLabel(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.selectInstallationTypeLabel"));
    private JCheckBox jCbxMrClean = new JCheckBox(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.chkboxMrCleanOptions"));
    private static final String[] TYPE_NAMES = new String[]{MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.installationTypeNormal"), MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.installationTypeUnattended"), MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.installationTypeSilent")};
    private static final int TYPE_NORMAL = 0;
    private static final int TYPE_UNATTENDED = 1;
    private static final int TYPE_SILENT = 2;
    private int instType = 0;
    private final JComboBox<String> installTypeCombo = new JComboBox<String>(TYPE_NAMES);
    private final JRadioButton defaultInstallDirRB = new JRadioButton(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.defaultInstallDirectoryRButton"));
    private final JRadioButton customInstallDirRB = new JRadioButton(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.customInstallDirectoryRButton"));
    private final JRadioButton defaultInstallSizeRB = new JRadioButton(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.defaultInstallSizeRButton"));
    private final JRadioButton embeddedInstallSizeRB = new JRadioButton(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.embeddedInstallSizeRButton"));
    private final JRadioButton darkNetworkInstallSizeRB = new JRadioButton(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.darkNetworkInstallSizeRButton"));
    private final JTextField jTFInstallDir = new JTextField("", 20);
    private final JRadioButton noUninstallRB = new JRadioButton(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.noUninstallRButton"));
    private final JRadioButton uninstallThirdPartyRB = new JRadioButton(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.competitiveUninstallRButton"));
    private final JCheckBox jCbxInstallLog = new JCheckBox(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.enableInstallationLogCkbox"));
    private final JTextField jTFInstallLogFileName = new JTextField("", 20);
    private final JCheckBox jCbxStartAgentAfterInstall = new JCheckBox(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.startAgentAfterInstallationCkbox"));
    private final JTextArea jLInfoAgentStart = new DescriptionTextArea(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.noteTxt"), 1, 20);
    private final JCheckBox jCbxAddProgramIntoStartMenu = new JCheckBox(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.addProgramIntoStartMenuCkbox"));
    private final JLabel jLSetting2 = new JLabel(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.upgradeSettingsLabel"));
    private final JRadioButton jRBKeep = new JRadioButton(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.maintainAllCommunicationSettingsBtn"), true);
    private final JRadioButton jRBRemove = new JRadioButton(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.removeAllPreviousAndResetPolicyManagerBtn"));
    private final ServerListComboBox cbServer = new ServerListComboBox();
    private RebootOptionsPanel rebootOptionsPanel;
    private static final String installTabString = MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.installTab");
    private static final String rebootTabString = MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.rebootTab");
    private boolean readOnly;
    private JTabbedPane tabPane;

    public SoftwarePackagePropsInstallSettingsPanel(boolean _readOnly) {
        this.readOnly = _readOnly;
        this.initialize();
        this.setReadOnly(this.readOnly);
    }

    public InstallationOption generateInstallationOption() {
        return SoftwarePackageObject.newInstallationOption(this.jCbxEnable.isSelected(), this.jRBKeep.isSelected(), this.getUserInterfaceLevel(), this.isInstallDirEnabled(), this.getInstallDir(), this.isUnInstallEnabled(), false, this.isInstallLogEnabled(), this.getInstallLogFile(), this.isStartAgentEnabled(), this.isStartMenuEnabled(), this.isMrCleanOptionEnabled(), this.isEmbeddedSizeInstallOptionSpecified(), this.isDarkNetworkOptionSpecified());
    }

    public CommunicationOption generateCommunicationOption() {
        return SoftwarePackageObject.newCommunicationOption(this.getServerListId());
    }

    public RebootOptions generateRebootOptions() {
        return this.getRebootOptions();
    }

    public void setData(InstallationOption installationOption, CommunicationOption com, RebootOptions ro) {
        this.jCbxEnable.setSelected(true);
        int level = -1;
        if (installationOption != null) {
            level = installationOption.getUserInterfaceLevel();
        }
        switch (level) {
            case 0: {
                this.installTypeCombo.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.installTypeCombo.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.installTypeCombo.setSelectedIndex(2);
                break;
            }
            default: {
                this.installTypeCombo.setSelectedIndex(0);
            }
        }
        this.rebootOptObject = ro;
        if (this.rebootOptObject == null) {
            this.rebootOptObject = new RebootOptions(false);
            int restart = PackageUtil.getRestartSetting((InstallationOption)installationOption);
            if (restart == InstallationOption.SILENT_RESTART) {
                this.rebootOptObject.setOptPromptUser(Boolean.valueOf(false));
            }
        }
        this.rebootOptionsPanel.updateSettings(this.rebootOptObject);
        if (PackageUtil.isInstallDirEnabled((InstallationOption)installationOption)) {
            this.customInstallDirRB.setSelected(true);
            this.jTFInstallDir.setText(PackageUtil.getInstallDir((InstallationOption)installationOption));
        } else {
            this.defaultInstallDirRB.setSelected(true);
        }
        if (PackageUtil.isReducedInstallSizeSpecified((InstallationOption)installationOption)) {
            this.embeddedInstallSizeRB.setSelected(true);
        } else if (PackageUtil.isDarkNetwork((InstallationOption)installationOption)) {
            this.darkNetworkInstallSizeRB.setSelected(true);
        } else {
            this.defaultInstallSizeRB.setSelected(true);
        }
        this.uninstallThirdPartyRB.setSelected(PackageUtil.isUnInstallEnabled((InstallationOption)installationOption));
        this.noUninstallRB.setSelected(!PackageUtil.isUnInstallEnabled((InstallationOption)installationOption));
        this.jCbxInstallLog.setSelected(PackageUtil.isInstallLogEnabled((InstallationOption)installationOption));
        if (this.jCbxInstallLog.isSelected()) {
            String logFileName = PackageUtil.getInstallLogFile((InstallationOption)installationOption);
            if (logFileName.equals("")) {
                logFileName = MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.defaultLogPath");
            }
            this.jTFInstallLogFileName.setText(logFileName);
        } else {
            this.jTFInstallLogFileName.setText(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.defaultLogPath"));
        }
        this.jCbxStartAgentAfterInstall.setSelected(PackageUtil.isStartAgentEnabled((InstallationOption)installationOption));
        this.jCbxMrClean.setSelected(PackageUtil.isMrCleanOptionEnabled((InstallationOption)installationOption));
        this.jCbxAddProgramIntoStartMenu.setSelected(PackageUtil.isStartMenuEnabled((InstallationOption)installationOption));
        boolean keep = PackageUtil.isKeepAllDataOnUpgrade((InstallationOption)installationOption);
        this.jRBKeep.setSelected(keep);
        this.jRBRemove.setSelected(!keep);
        ArrayList<SemServerList> listServerList = null;
        try {
            listServerList = SoftwarePackageHandler.getServerList(true);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        this.cbServer.init(listServerList, true);
        ObjReference ref = com.getOptObjReference();
        if (ref != null) {
            this.cbServer.setSelectedServerListId(ref.getTargetId());
        }
        this.enableSettingPanel();
    }

    private void initialize() {
        this.jCbxEnable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoftwarePackagePropsInstallSettingsPanel.this.enableSettingPanel();
            }
        });
        this.rebootOptionsPanel = new RebootOptionsPanel(2);
        if (this.rebootOptObject == null) {
            this.rebootOptObject = new RebootOptions(false);
        }
        this.rebootOptionsPanel.updateSettings(this.rebootOptObject);
        this.tabPane = new JTabbedPane();
        JPanel temp = new JPanel();
        temp.add(this.rebootOptionsPanel);
        JPanel p = this.getSettingPanel();
        this.tabPane.add(installTabString, p);
        this.tabPane.add(rebootTabString, temp);
        this.add((Component)this.tabPane, "Center");
    }

    public void setTabPaneEnabled(boolean enabled) {
        this.tabPane.setEnabled(enabled);
    }

    private void updateInstallType() {
        int index = this.installTypeCombo.getSelectedIndex();
        switch (index) {
            case 0: {
                this.instType = 0;
                break;
            }
            case 1: {
                this.instType = 1;
                break;
            }
            case 2: {
                this.instType = 2;
                break;
            }
            default: {
                this.instType = 0;
            }
        }
    }

    public int getInstallType() {
        return this.instType;
    }

    private JPanel getInstallationTypePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.jLSetting1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add(this.installTypeCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.installTypeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SoftwarePackagePropsInstallSettingsPanel.this.updateInstallType();
            }
        });
        return panel;
    }

    private JPanel getSettingPanel() {
        this.defaultInstallDirRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoftwarePackagePropsInstallSettingsPanel.this.enableInstallDir();
            }
        });
        this.customInstallDirRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoftwarePackagePropsInstallSettingsPanel.this.enableInstallDir();
            }
        });
        this.jCbxInstallLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoftwarePackagePropsInstallSettingsPanel.this.enableInstallLog();
            }
        });
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.jRBKeep);
        group2.add(this.jRBRemove);
        ButtonGroup installGroup = new ButtonGroup();
        installGroup.add(this.defaultInstallDirRB);
        installGroup.add(this.customInstallDirRB);
        ButtonGroup installSizeGroup = new ButtonGroup();
        installSizeGroup.add(this.defaultInstallSizeRB);
        installSizeGroup.add(this.embeddedInstallSizeRB);
        installSizeGroup.add(this.darkNetworkInstallSizeRB);
        ButtonGroup uninstallExistingSoftwareGroup = new ButtonGroup();
        uninstallExistingSoftwareGroup.add(this.noUninstallRB);
        uninstallExistingSoftwareGroup.add(this.uninstallThirdPartyRB);
        this.jCbxEnable.setFont(this.jCbxEnable.getFont().deriveFont(1));
        RestrictedPlainDocument doc = new RestrictedPlainDocument(126);
        doc.setValidator("\"/*?<>|", false);
        this.jTFInstallDir.setDocument(doc);
        this.jTFInstallDir.putClientProperty("cssStyle", "z-index:1000");
        doc = new RestrictedPlainDocument(239);
        doc.setValidator("\"/*?<>|", false);
        this.jTFInstallLogFileName.setDocument(doc);
        this.jTFInstallLogFileName.putClientProperty("cssStyle", "z-index:1000");
        int row = 0;
        String title = MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.Installation_Setting");
        this.jSettingPanel.setBorder(new TitledBorder(BorderFactory.createTitledBorder(title)));
        this.jSettingPanel.add((Component)this.jLSetting1, new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.jSettingPanel.add((Component)this.getInstallationTypePanel(), new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jSettingPanel.add((Component)new JSeparator(), new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.jSettingPanel.add((Component)this.defaultInstallDirRB, new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.jSettingPanel.add((Component)this.customInstallDirRB, new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.jSettingPanel.add((Component)new JLabel(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.installationDirectoryLabel")), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 27, 0, 5), 0, 0));
        this.jSettingPanel.add((Component)this.jTFInstallDir, new GridBagConstraints(1, row++, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        if (!LicenseObject.getInstance().isSNACOnlyProduct()) {
            this.jSettingPanel.add((Component)new JSeparator(), new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.jSettingPanel.add((Component)this.defaultInstallSizeRB, new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.jSettingPanel.add((Component)this.embeddedInstallSizeRB, new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            String clientTypeHelpText = MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.clientTypeHelp");
            HtmlEnabledJLabel clientTypeInstallHelp = new HtmlEnabledJLabel(clientTypeHelpText, true);
            clientTypeInstallHelp.setIcon((Icon)ConsoleMain.whatsThisIcon);
            clientTypeInstallHelp.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    HelpUtil.showHelpOrErrDlg("sesm_admin_install_packages_whatis_choosetype");
                }
            });
            this.jSettingPanel.add((Component)clientTypeInstallHelp, new GridBagConstraints(3, row - 1, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 0, 5, 0), 0, 0));
            this.jSettingPanel.add((Component)this.darkNetworkInstallSizeRB, new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.jSettingPanel.add((Component)new JSeparator(), new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.jSettingPanel.add((Component)this.noUninstallRB, new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.noUninstallRB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SoftwarePackagePropsInstallSettingsPanel.this.installTypeCombo.setEnabled(true);
                }
            });
            this.jSettingPanel.add((Component)this.uninstallThirdPartyRB, new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.uninstallThirdPartyRB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SoftwarePackagePropsInstallSettingsPanel.this.showUninstallThirdPartyOptionWarning(SoftwarePackagePropsInstallSettingsPanel.this.uninstallThirdPartyRB.isSelected());
                    SoftwarePackagePropsInstallSettingsPanel.this.installTypeCombo.setEnabled(true);
                }
            });
            if (!ScmProperties.isUninstallThirdPartyAVEnabled()) {
                this.uninstallThirdPartyRB.setVisible(false);
            }
        }
        this.jSettingPanel.add((Component)new JSeparator(), new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.jSettingPanel.add((Component)this.jCbxInstallLog, new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.jSettingPanel.add((Component)new JLabel(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.installationLogFullPathNameLabel")), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 27, 0, 5), 0, 0));
        this.jSettingPanel.add((Component)this.jTFInstallLogFileName, new GridBagConstraints(1, row++, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.jSettingPanel.add((Component)new JLabel(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.installationLogFullPathWarningLabel")), new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 27, 5, 0), 0, 0));
        this.jSettingPanel.add((Component)new JSeparator(), new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.jSettingPanel.add((Component)this.jCbxMrClean, new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.jSettingPanel.add((Component)new JSeparator(), new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.jSettingPanel.add((Component)this.jCbxAddProgramIntoStartMenu, new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.jSettingPanel.add((Component)new JSeparator(), new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.jSettingPanel.add((Component)this.jLSetting2, new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
        this.jSettingPanel.add((Component)this.jRBKeep, new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.jSettingPanel.add((Component)this.jRBRemove, new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        return this.jSettingPanel;
    }

    private void showUninstallThirdPartyOptionWarning(boolean selected) {
        if (selected) {
            Object[] obj = new Object[]{ServerVersion.CURRENT_CED_VERSION, Utility.getLanguage()};
            String urlLink = MessageFormat.format(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.competitiveUninstallRButtonWarning_url"), obj);
            String prefix = MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.competitiveUninstallRButtonWarning_Prefix");
            String urlText = MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.competitiveUninstallRButtonWarning_urlText");
            String suffix = MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.competitiveUninstallRButtonWarning_suffix");
            HTMLEditorPane pane = new HTMLEditorPane();
            pane.setText("<html><body style='width:200px'>" + prefix + "<a href=\"" + urlLink + "\">" + urlText + "</a>" + suffix);
            JOptionPane.showMessageDialog(Manager.frame, pane, MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.warning"), 2);
        }
    }

    private Integer getUserInterfaceLevel() {
        int index = this.installTypeCombo.getSelectedIndex();
        if (index == 0) {
            return InstallationOption.NORMAL;
        }
        if (index == 1) {
            return InstallationOption.UNATTENDED;
        }
        if (index == 2) {
            return InstallationOption.SILENT;
        }
        return -1;
    }

    private void enableSettingPanel() {
        boolean isEnabled = this.jCbxEnable.isSelected();
        if (isEnabled) {
            this.enableInstallDir();
            this.enableInstallLog();
        }
    }

    private void enableInstallDir() {
        this.jTFInstallDir.setEnabled(this.customInstallDirRB.isSelected());
    }

    private void enableInstallLog() {
        this.jTFInstallLogFileName.setEnabled(this.jCbxInstallLog.isSelected());
    }

    private String getServerListId() {
        SemServerList serverList = this.cbServer.getSelectedSemServerList();
        if (serverList == null) {
            return null;
        }
        return serverList.getId();
    }

    private RebootOptions getRebootOptions() {
        return this.rebootOptionsPanel.saveSettings(this.rebootOptObject);
    }

    private boolean isInstallDirEnabled() {
        return this.customInstallDirRB.isSelected();
    }

    private String getInstallDir() {
        return this.jTFInstallDir.getText().trim();
    }

    boolean isUnInstallEnabled() {
        return this.uninstallThirdPartyRB.isSelected();
    }

    private boolean isInstallLogEnabled() {
        return this.jCbxInstallLog.isSelected();
    }

    private String getInstallLogFile() {
        return this.jTFInstallLogFileName.getText().trim();
    }

    private boolean isStartAgentEnabled() {
        return this.jCbxStartAgentAfterInstall.isSelected();
    }

    private boolean isStartMenuEnabled() {
        return this.jCbxAddProgramIntoStartMenu.isSelected();
    }

    private boolean isMrCleanOptionEnabled() {
        return this.jCbxMrClean.isSelected();
    }

    private boolean isEmbeddedSizeInstallOptionSpecified() {
        return this.embeddedInstallSizeRB.isSelected();
    }

    private boolean isDarkNetworkOptionSpecified() {
        return this.darkNetworkInstallSizeRB.isSelected();
    }

    public boolean isValidate() {
        if (this.isInstallDirEnabled() && !this.isValidFolder(this.getInstallDir(), MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.installFolder"))) {
            this.jTFInstallDir.requestFocus();
            return false;
        }
        if (this.isInstallLogEnabled() && !this.isValidFile(this.getInstallLogFile(), MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.installLogFile"))) {
            this.jTFInstallLogFileName.requestFocus();
            return false;
        }
        if (!this.isValidRebootOptions()) {
            this.tabPane.setSelectedIndex(1);
            this.rebootOptionsPanel.requestFocus();
            return false;
        }
        return true;
    }

    private boolean isValidFolder(String folder, String type) {
        boolean notValidPath = false;
        Object[] args = new Object[]{type};
        if (folder == null || folder.length() == 0) {
            UIUtilities.showErrorDialog(MessageFormat.format(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.emptyError"), args));
            return false;
        }
        if (!folder.startsWith("%")) {
            if (folder.length() >= 4) {
                if ((folder.charAt(0) < 'a' || folder.charAt(0) > 'z') && (folder.charAt(0) < 'A' || folder.charAt(0) > 'Z') || folder.charAt(1) != ':' || folder.charAt(2) != '\\' || folder.charAt(3) == '\\') {
                    notValidPath = true;
                }
            } else {
                notValidPath = true;
            }
        } else if (folder.toLowerCase().contains("%programfiles%") || folder.toLowerCase().contains("%commonprogramfiles%")) {
            notValidPath = true;
        }
        if (folder.indexOf(";") > 0 || folder.indexOf("&") > 0 || folder.indexOf("\\ ") > 0) {
            notValidPath = true;
        }
        if (notValidPath) {
            UIUtilities.showErrorDialog(MessageFormat.format(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.invalidPath"), args));
            return false;
        }
        if (!Utility.isValidEnvVariableOrRegValueInput((String)folder, (boolean)false)) {
            UIUtilities.showErrorDialog(MessageFormat.format(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.envError"), args));
            return false;
        }
        return true;
    }

    private boolean isValidFile(String file, String type) {
        if (!this.isValidFolder(file, type)) {
            return false;
        }
        if (!Utility.isValidEnvVariableOrRegValueInput((String)file, (boolean)false)) {
            UIUtilities.showErrorDialog(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.envError"));
            return false;
        }
        if (file.endsWith("\\")) {
            UIUtilities.showErrorDialog(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.fileError"));
            return false;
        }
        return true;
    }

    private boolean isValidRebootOptions() {
        String restartMessage;
        RebootOptions rebootOpt = this.getRebootOptions();
        if (!(rebootOpt == null || (restartMessage = rebootOpt.getOptPromptMessage()) == null || restartMessage.isEmpty() || UIUtilities.validateNoHtmlParams(restartMessage) && UIUtilities.validateNoScriptParams(restartMessage))) {
            UIUtilities.showErrorDialog(MSG_RES.getString("SoftwarePackagePropsInstallSettingsPanel.noScriptOrHtmlParamsInRestartMessage"));
            return false;
        }
        return true;
    }

    public void setReadOnly(boolean readOnly) {
        this.jCbxEnable.setEnabled(!readOnly);
        this.defaultInstallDirRB.setEnabled(!readOnly);
        this.customInstallDirRB.setEnabled(!readOnly);
        this.defaultInstallSizeRB.setEnabled(!readOnly);
        this.embeddedInstallSizeRB.setEnabled(!readOnly);
        this.darkNetworkInstallSizeRB.setEnabled(!readOnly);
        this.jRBKeep.setEnabled(!readOnly);
        this.jRBRemove.setEnabled(!readOnly);
        this.jTFInstallDir.setEditable(!readOnly);
        if (!this.jTFInstallDir.isEditable()) {
            this.jTFInstallDir.setForeground(Color.GRAY);
        }
        this.jTFInstallLogFileName.setEditable(!readOnly);
        if (!this.jTFInstallLogFileName.isEditable()) {
            this.jTFInstallLogFileName.setForeground(Color.GRAY);
        }
        this.jCbxStartAgentAfterInstall.setEnabled(!readOnly);
        this.jLInfoAgentStart.setEditable(!readOnly);
        this.jCbxAddProgramIntoStartMenu.setEnabled(!readOnly);
        this.noUninstallRB.setEnabled(!readOnly);
        this.uninstallThirdPartyRB.setEnabled(!readOnly);
        this.jCbxInstallLog.setEnabled(!readOnly);
        this.cbServer.setEnabled(!readOnly);
        this.installTypeCombo.setEnabled(!this.readOnly);
        UIUtilities.setContainerStatus(this.jSettingPanel, !readOnly);
    }
}

