/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SoftwarePackagePropsGeneralPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String AUTOMATION_PACKAGE_NAME = "PackagePropertiesName";
    private static final String AUTOMATION_PACKAGE_VERSION = "PackagePropertiesVersion";
    private static final int MAX_LEN_DESCRIPTION = 1024;
    private CurrentPackageObject currentPackageObject = null;
    private JTextField jTFName = new JTextField(new RestrictedPlainDocument(128), "", 40);
    JLabel jLPlatform = new JLabel();
    JLabel jLType = new JLabel();
    JLabel jLVersion = new JLabel();
    JLabel jLLanguage = new JLabel();
    JLabel jLSize = new JLabel();
    JLabel jLCreated = new JLabel();
    JLabel jLModified = new JLabel();
    JTextArea jTADesc = new JTextArea(new RestrictedPlainDocument(1024), "", 4, 40);
    String oldName = null;
    private boolean readOnly;

    public SoftwarePackagePropsGeneralPanel(boolean readOnly) {
        this.readOnly = readOnly;
        this.initialize();
        this.setReadOnly();
    }

    public void init(CurrentPackageObject cpo) {
        UIUtilities.setName(this.jTFName, "packageManagement", UIUtilities.ComponentType.TEXTFIELD, AUTOMATION_PACKAGE_NAME);
        UIUtilities.setName(this.jLVersion, "packageManagement", UIUtilities.ComponentType.JLABEL, AUTOMATION_PACKAGE_VERSION);
        this.currentPackageObject = cpo;
        if (this.currentPackageObject == null || this.currentPackageObject.getSoftwarePackage() == null) {
            return;
        }
        SoftwarePackageObject spo = this.currentPackageObject.getSoftwarePackageObject();
        this.oldName = spo.getName();
        this.jTFName.setText(this.oldName);
        JLabel tempLabel = this.currentPackageObject.getPlatformLabelForSwPackage();
        this.jLPlatform.setText(tempLabel.getText());
        this.jLPlatform.setIcon(tempLabel.getIcon());
        this.jLVersion.setText(spo.getVersion());
        this.jLType.setText(spo.getTypeDisplayString());
        this.jLLanguage.setText(spo.getLanguageDisplayString());
        this.jLSize.setText(spo.getSizeDisplayString());
        this.jLCreated.setText(spo.getCreationTimeDisplayString());
        this.jLModified.setText(spo.getLastModifiedTimeDisplayString());
        this.jTADesc.setText(spo.getDescription());
    }

    public String getDescription() {
        return this.jTADesc.getText();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPackageNamePanel(), "North");
        this.add((Component)this.getPackagePropertiesPanel(), "Center");
    }

    private JPanel getPackageNamePanel() {
        RestrictedPlainDocument doc = new RestrictedPlainDocument(128);
        doc.setValidator("\"/\\*?<>|:", false);
        this.jTFName.setDocument(doc);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SoftwarePackagePropsGeneralPanel.packageNameLabel")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        panel.add((Component)this.jTFName, new GridBagConstraints(2, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getPackagePropertiesPanel() {
        RestrictedPlainDocument descDoc = new RestrictedPlainDocument(1024);
        this.jTADesc.setDocument(descDoc);
        JScrollPane jScrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)jScrollPane, (JTextArea)this.jTADesc);
        this.jTADesc.setWrapStyleWord(true);
        this.jTADesc.setLineWrap(true);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SoftwarePackagePropsGeneralPanel.platformLabel")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.jLPlatform, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SoftwarePackagePropsGeneralPanel.packageTypeLabel")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.jLType, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SoftwarePackagePropsGeneralPanel.versionLabel")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.jLVersion, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SoftwarePackagePropsGeneralPanel.laguageLabel")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.jLLanguage, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SoftwarePackagePropsGeneralPanel.sizeLabel")), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.jLSize, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SoftwarePackagePropsGeneralPanel.createdLabel")), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.jLCreated, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SoftwarePackagePropsGeneralPanel.modifiedLabel")), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.jLModified, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SoftwarePackagePropsGeneralPanel.descriptionLabel")), new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 0), 0, 0));
        panel.add((Component)jScrollPane, new GridBagConstraints(1, 7, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        return panel;
    }

    public String getPackageName() {
        return this.jTFName.getText().trim();
    }

    public boolean isPackageNameChanged() {
        String packageName = this.getPackageName();
        return !packageName.equals(this.oldName);
    }

    protected boolean isValidate() {
        try {
            String packageName = this.getPackageName();
            if (packageName.length() == 0) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SoftwarePackagePropsGeneralPanel.packageNameCanntBeEmptyMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SoftwarePackagePropsGeneralPanel.error"), 0);
                return false;
            }
            if (!packageName.equals(this.oldName)) {
                if (SoftwarePackageHandler.isPackageNameExisting(packageName)) {
                    JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SoftwarePackagePropsGeneralPanel.packageNameExistsInServer"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SoftwarePackagePropsGeneralPanel.error"), 0);
                    return false;
                }
            } else {
                System.out.println("SoftwarePackage Name no change: " + this.oldName);
            }
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SoftwarePackagePropsGeneralPanel.error"), 0);
            if (ex.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            }
            return false;
        }
        String description = this.getDescription();
        if (description.length() > 1024) {
            Object[] obj = new Object[]{Integer.toString(1024)};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SoftwarePackagePropsGeneralPanel.descriptionIsLongerMsg");
            String fm = MessageFormat.format(str, obj);
            JOptionPane.showMessageDialog(this, fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SoftwarePackagePropsGeneralPanel.packagePropertiesMsg"), 0);
            this.jTADesc.requestFocus();
            return false;
        }
        return true;
    }

    private void setReadOnly() {
        this.jTFName.setEditable(!this.readOnly);
        this.jTADesc.setEditable(!this.readOnly);
    }
}

