/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AdditionalUserInfoCollectorObject;
import com.sygate.scm.console.logicobject.AdditionalUserInfoFieldMapObject;
import com.sygate.scm.console.logicobject.AdditionalUserInfoSnoozeObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.renderer.CheckBoxEditor;
import com.sygate.scm.console.ui.util.renderer.CheckBoxRenderer;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class SetUserInfoDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final int MAX_LENGTH_POPUPMSG = 150;
    private static final int LIST_VISIBLE_ROW_COUNT = 11;
    private static final String DESCRIPTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SetUserInfoDlg.description");
    private JTextArea jTADesc = new DescriptionTextArea(DESCRIPTION);
    private JPanel jUserInfoPanel = new JPanel(new GridBagLayout());
    private JCheckBox jCbxUserInfo = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SetUserInfoDlg.enableCollectingUserInforCkbox"), false);
    private JLabel jLPop = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SetUserInfoDlg.popupMessageLabel"));
    private JTextArea jTAPop = new JTextArea(4, 10);
    private JPanel jRemindPanel = new JPanel();
    private JCheckBox jCbxRemind = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SetUserInfoDlg.enableRemindMeLaterCkbox"), true);
    private JLabel jLRemind = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SetUserInfoDlg.remindMeInLabel"));
    private JTextField jTFRemind = new JTextField(10);
    private JLabel jLMin = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SetUserInfoDlg.minutesLabel"));
    private JLabel jLSelect = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SetUserInfoDlg.selectFieldsLabel"));
    private DefaultListModel<String> allModel = new DefaultListModel();
    private JList<String> jLTAll = new JList<String>(this.allModel);
    private JScrollPane jSPAll = new JScrollPane();
    private SelectTableModel selModel = new SelectTableModel();
    private JTable jTSelect = new StripesTable(this.selModel);
    private JScrollPane jSPSelect = new JScrollPane(this.jTSelect);
    private JPanel jMoveButtonPanel = new JPanel();
    private JButton jBAdd = new JButton(UIText.get(8));
    private JButton jBRemove = new JButton(UIText.get(4359));

    public SetUserInfoDlg(AdditionalUserInfoCollectorObject collector) {
        super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SetUserInfoDlg.userInfoCollectionTitle"), true);
        this.initialize();
        this.setData(collector);
        this.enableUserInfo();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public void updateData(AdditionalUserInfoCollectorObject collector) {
        collector.setEnabled(this.jCbxUserInfo.isSelected());
        collector.setAdditionalText(this.jTAPop.getText().trim());
        AdditionalUserInfoSnoozeObject snooze = collector.getAdditionalUserInfoSnoozeObject(true);
        snooze.setEnabled(this.jCbxRemind.isSelected());
        snooze.setRemindMePeriod(this.jTFRemind.getText());
        AdditionalUserInfoFieldMapObject map = collector.getAdditionalUserInfoFieldMapObject(true);
        this.updateMap(map);
    }

    private void initialize() {
        this.jCbxRemind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetUserInfoDlg.this.enableRemind();
            }
        });
        NumberPlainDocument remindDoc = new NumberPlainDocument(0x2222222L);
        this.jTFRemind.setDocument(remindDoc);
        Dimension size = this.jTFRemind.getPreferredSize();
        this.jTFRemind.setMaximumSize(size);
        this.jTFRemind.setMinimumSize(size);
        this.jTFRemind.setHorizontalAlignment(2);
        this.jTFRemind.setText("30");
        this.jRemindPanel.setLayout(new BoxLayout(this.jRemindPanel, 0));
        this.jRemindPanel.setBorder(BorderFactory.createTitledBorder(" "));
        this.jRemindPanel.add(Box.createHorizontalStrut(10));
        this.jRemindPanel.add(this.jLRemind);
        this.jRemindPanel.add(this.jTFRemind);
        this.jRemindPanel.add(this.jLMin);
        this.jRemindPanel.add(Box.createGlue());
        UiUtilities.setupScrollPane((JScrollPane)this.jSPAll, this.jLTAll);
        this.initialAllModel();
        this.jLTAll.setPrototypeCellValue(AdditionalUserInfoFieldMapObject.OFFICE_PHONE + "   ");
        this.jLTAll.setVisibleRowCount(11);
        this.jLTAll.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SetUserInfoDlg.this.enableAddButton();
            }
        });
        this.jLTAll.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    SetUserInfoDlg.this.jBAdd_actionPerformed();
                }
            }
        });
        this.jTSelect.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    SetUserInfoDlg.this.jBRemove_actionPerformed();
                }
            }
        });
        TableColumn column = this.jTSelect.getColumnModel().getColumn(0);
        column.setCellRenderer(new StringRenderer());
        column = this.jTSelect.getColumnModel().getColumn(1);
        column.setCellRenderer(new CheckBoxRenderer(true));
        column.setCellEditor(new SelectCheckBoxEditor(this.jTSelect));
        size = this.jTSelect.getPreferredScrollableViewportSize();
        this.jTSelect.setPreferredScrollableViewportSize(new Dimension(size.width * 1 / 2, (this.jTSelect.getRowHeight() + this.jTSelect.getRowMargin()) * 5 * 2));
        UIUtilities.resizeColumns(this.jTSelect, new float[]{0.7f, 0.3f}, (float)size.width * 1.0f / 2.0f, false);
        this.jTSelect.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SetUserInfoDlg.this.enableRemoveButton();
            }
        });
        this.jBAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetUserInfoDlg.this.jBAdd_actionPerformed();
            }
        });
        this.jBRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetUserInfoDlg.this.jBRemove_actionPerformed();
            }
        });
        RestrictedPlainDocument popDoc = new RestrictedPlainDocument(150);
        popDoc.setValidator("\r\n", false);
        this.jTAPop.setDocument(popDoc);
        this.jTAPop.setLineWrap(true);
        this.jTAPop.setWrapStyleWord(true);
        UIUtilities.layoutButtonPanel(this.jMoveButtonPanel, new JButton[]{this.jBAdd, this.jBRemove}, 1, 0, true);
        this.jUserInfoPanel.setBorder(BorderFactory.createTitledBorder(" "));
        this.jUserInfoPanel.add((Component)this.jLPop, new GridBagConstraints(0, 0, 6, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        JScrollPane jTaPopPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)jTaPopPane, (JTextArea)this.jTAPop);
        this.jUserInfoPanel.add((Component)jTaPopPane, new GridBagConstraints(0, 1, 6, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.jUserInfoPanel.add((Component)this.jCbxRemind, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 12, 0, 5), 0, 0));
        this.jUserInfoPanel.add((Component)this.jRemindPanel, new GridBagConstraints(0, 2, 6, 1, 1.0, 0.0, 10, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.jUserInfoPanel.add((Component)this.jLSelect, new GridBagConstraints(0, 3, 6, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        this.jUserInfoPanel.add((Component)this.jSPAll, new GridBagConstraints(0, 4, 2, 1, 0.5, 1.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        this.jUserInfoPanel.add((Component)this.jMoveButtonPanel, new GridBagConstraints(2, 4, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 5, 0), 0, 0));
        this.jUserInfoPanel.add((Component)this.jSPSelect, new GridBagConstraints(3, 4, 3, 1, 0.5, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.jCbxUserInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetUserInfoDlg.this.enableUserInfo();
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.jTADesc, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.jCbxUserInfo, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 12, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jUserInfoPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pack();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_client_dialog_install_packages_user_info";
    }

    private void initialAllModel() {
        this.allModel.addElement(AdditionalUserInfoFieldMapObject.FULL_NAME);
        this.allModel.addElement(AdditionalUserInfoFieldMapObject.EMAIL_ADDRESS);
        this.allModel.addElement(AdditionalUserInfoFieldMapObject.JOB_TITLE);
        this.allModel.addElement(AdditionalUserInfoFieldMapObject.DEPARTMENT);
        this.allModel.addElement(AdditionalUserInfoFieldMapObject.EMPLOYEE_NUMBER);
        this.allModel.addElement(AdditionalUserInfoFieldMapObject.EMPLOYMENT_STATUS);
        this.allModel.addElement(AdditionalUserInfoFieldMapObject.OFFICE_PHONE);
        this.allModel.addElement(AdditionalUserInfoFieldMapObject.MOBILE_PHONE);
        this.allModel.addElement(AdditionalUserInfoFieldMapObject.HOME_PHONE);
    }

    private void setData(AdditionalUserInfoCollectorObject collector) {
        AdditionalUserInfoFieldMapObject map;
        if (collector == null) {
            return;
        }
        this.jCbxUserInfo.setSelected(collector.isEnabled());
        this.jTAPop.setText(collector.getAdditionalText());
        AdditionalUserInfoSnoozeObject snooze = collector.getAdditionalUserInfoSnoozeObject(false);
        if (snooze != null) {
            this.jCbxRemind.setSelected(snooze.isEnabled());
            this.jTFRemind.setText(String.valueOf(snooze.getRemindMePeriod()));
        }
        if ((map = collector.getAdditionalUserInfoFieldMapObject(false)) != null) {
            this.moveFromListToTable(map);
        }
    }

    private void moveFromListToTable(AdditionalUserInfoFieldMapObject map) {
        this.updateModels(AdditionalUserInfoFieldMapObject.FULL_NAME, map.getFieldStatus(AdditionalUserInfoFieldMapObject.FULL_NAME));
        this.updateModels(AdditionalUserInfoFieldMapObject.EMAIL_ADDRESS, map.getFieldStatus(AdditionalUserInfoFieldMapObject.EMAIL_ADDRESS));
        this.updateModels(AdditionalUserInfoFieldMapObject.JOB_TITLE, map.getFieldStatus(AdditionalUserInfoFieldMapObject.JOB_TITLE));
        this.updateModels(AdditionalUserInfoFieldMapObject.DEPARTMENT, map.getFieldStatus(AdditionalUserInfoFieldMapObject.DEPARTMENT));
        this.updateModels(AdditionalUserInfoFieldMapObject.EMPLOYEE_NUMBER, map.getFieldStatus(AdditionalUserInfoFieldMapObject.EMPLOYEE_NUMBER));
        this.updateModels(AdditionalUserInfoFieldMapObject.EMPLOYMENT_STATUS, map.getFieldStatus(AdditionalUserInfoFieldMapObject.EMPLOYMENT_STATUS));
        this.updateModels(AdditionalUserInfoFieldMapObject.OFFICE_PHONE, map.getFieldStatus(AdditionalUserInfoFieldMapObject.OFFICE_PHONE));
        this.updateModels(AdditionalUserInfoFieldMapObject.MOBILE_PHONE, map.getFieldStatus(AdditionalUserInfoFieldMapObject.MOBILE_PHONE));
        this.updateModels(AdditionalUserInfoFieldMapObject.HOME_PHONE, map.getFieldStatus(AdditionalUserInfoFieldMapObject.HOME_PHONE));
    }

    private void updateModels(String fieldName, int fieldValue) {
        if (fieldValue > 0 && this.allModel.removeElement(fieldName)) {
            this.selModel.add(new TableItem(fieldName, fieldValue == 2));
        }
    }

    private void updateMap(AdditionalUserInfoFieldMapObject map) {
        map.clear();
        for (TableItem tableItem : this.selModel.getModelData()) {
            map.setFieldStatus(tableItem.getName(), tableItem.isOptional());
        }
    }

    @Override
    protected boolean isValidate() {
        if (!this.jCbxUserInfo.isSelected()) {
            return true;
        }
        if (this.jTSelect.getRowCount() < 1) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SetUserInfoDlg.doNotHaveSelectedFieldMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SetUserInfoDlg.error"), 0);
            return false;
        }
        String msg = this.jTAPop.getText().trim();
        if (msg == null || msg.length() < 1) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SetUserInfoDlg.specifyPopupMessageMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SetUserInfoDlg.error"), 0);
            return false;
        }
        if (this.jCbxRemind.isSelected()) {
            String period = this.jTFRemind.getText().trim();
            if (period == null || period.length() < 1) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SetUserInfoDlg.specifyValidTimeMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SetUserInfoDlg.error"), 0);
                return false;
            }
            int time = 0;
            try {
                time = Integer.parseInt(period);
            }
            catch (Throwable ex) {
                LoggerUtilities.logException((Throwable)ex);
                time = 0;
            }
            if (time < 1) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SetUserInfoDlg.specifyValidTimeMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SetUserInfoDlg.error"), 0);
                return false;
            }
        }
        return true;
    }

    private void enableUserInfo() {
        boolean isSelected = this.jCbxUserInfo.isSelected();
        this.jTAPop.setEnabled(isSelected);
        this.jCbxRemind.setEnabled(isSelected);
        this.enableRemind();
        this.jLTAll.setEnabled(isSelected);
        this.jTSelect.setEnabled(isSelected);
        this.enableAddButton();
        this.enableRemoveButton();
    }

    private void enableRemind() {
        this.jTFRemind.setEnabled(this.jCbxRemind.isEnabled() && this.jCbxRemind.isSelected());
    }

    private void enableAddButton() {
        this.jBAdd.setEnabled(this.jLTAll.isEnabled() && this.jLTAll.getSelectedIndex() != -1);
    }

    private void enableRemoveButton() {
        this.jBRemove.setEnabled(this.jTSelect.isEnabled() && this.jTSelect.getSelectedRowCount() > 0);
    }

    private void jBAdd_actionPerformed() {
        int[] selIndics = this.jLTAll.getSelectedIndices();
        int i = selIndics.length;
        while (--i >= 0) {
            String allItem = this.allModel.remove(selIndics[i]);
            this.selModel.add(new TableItem(allItem));
        }
    }

    private void jBRemove_actionPerformed() {
        int[] selIndics = this.jTSelect.getSelectedRows();
        int i = selIndics.length;
        while (--i >= 0) {
            TableItem selItem = (TableItem)this.selModel.remove(selIndics[i]);
            this.allModel.addElement(selItem.getName());
        }
    }

    private static class StringRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private StringRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setEnabled(table.isEnabled());
            return comp;
        }
    }

    private static class SelectCheckBoxEditor
    extends CheckBoxEditor {
        private static final long serialVersionUID = 1L;

        public SelectCheckBoxEditor(JTable table) {
            super(table);
        }

        @Override
        protected void updateModel(TableModel tableModel, int selIndex) {
            SelectTableModel model = (SelectTableModel)tableModel;
            AjaxSwingCommonUtil.executeOneBasedOnWebConsoleRunning(() -> model.edit(selIndex, Boolean.TRUE.equals(this.getCellEditorValue())), () -> model.edit(selIndex));
        }
    }

    private static class TableItem {
        private String name;
        private boolean isOptional = false;

        public TableItem(String name) {
            this.name = name;
        }

        public TableItem(String name, boolean isOptional) {
            this.name = name;
            this.isOptional = isOptional;
        }

        public String getName() {
            return this.name;
        }

        public boolean isOptional() {
            return this.isOptional;
        }

        public void setOptional(boolean isOptional) {
            this.isOptional = isOptional;
        }
    }

    private static class SelectTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private ArrayList<Object> list = new ArrayList();

        private SelectTableModel() {
        }

        public Collection<Object> getModelData() {
            return this.list;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        public void add(Object object) {
            this.list.add(object);
            this.fireTableDataChanged();
        }

        public void edit(int index) {
            TableItem item;
            if (index < 0 || index > this.getRowCount()) {
                return;
            }
            item.setOptional(!(item = (TableItem)this.list.get(index)).isOptional());
            this.fireTableDataChanged();
        }

        public void edit(int index, boolean value) {
            if (index < 0 || index > this.getRowCount()) {
                return;
            }
            TableItem item = (TableItem)this.list.get(index);
            item.setOptional(value);
            this.fireTableDataChanged();
        }

        public Object remove(int index) {
            if (index < 0 || index > this.getRowCount()) {
                return null;
            }
            Object item = this.list.remove(index);
            this.fireTableDataChanged();
            return item;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SetUserInfoDlg.filedName");
            }
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SetUserInfoDlg.optional");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            TableItem item = (TableItem)this.list.get(rowIndex);
            if (columnIndex == 0) {
                return item.getName();
            }
            return item.isOptional();
        }
    }
}

