/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.configobject.schema.HostAddress;
import com.sygate.scm.common.configobject.schema.SemServerBlock;
import com.sygate.scm.common.configobject.schema.SemServerList;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJTree;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class ServerListDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final String DESCRITPTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ServerListDlg.description");
    private JList<String> jLTDetail = new JList();
    private HtmlEnabledJTree serverListTree = this.getServerListTree();
    private DefaultMutableTreeNode root;
    private DefaultTreeModel serverListModel;

    public ServerListDlg(SemServerList semServerList) {
        super(Manager.getFrame(), "", true);
        Object[] obj = new Object[]{semServerList.getName()};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ServerListDlg.policyManagerListForMsg");
        String fm = MessageFormat.format(str, obj);
        super.setTitle(fm);
        this.initData(semServerList);
        this.initialize();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public void initData(SemServerList semServerList) {
        this.jLTDetail.setModel(new DefaultListModel());
        DefaultListModel listModel = (DefaultListModel)this.jLTDetail.getModel();
        if (semServerList == null) {
            listModel.addElement(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ServerListDlg.policyManagerListIsEmpty"));
            return;
        }
        int count = semServerList.getSemServerBlockCount();
        if (count == 0) {
            listModel.addElement(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ServerListDlg.policyManagerListIsEmpty"));
            return;
        }
        int blockIndex = 1;
        for (int j = 0; j < count; ++j) {
            boolean useHttps = false;
            if (semServerList.getOptCommSecurity() != null && semServerList.getOptCommSecurity().intValue() == SemServerList.HTTPS_ONLY.intValue()) {
                useHttps = true;
            }
            String hostStr = this.toString(semServerList.getSemServerBlock(j), useHttps);
            List<String> al = this.getObjectList(semServerList.getSemServerBlock(j), useHttps);
            if (hostStr.length() <= 0) continue;
            Object[] obj = new Object[]{Integer.toString(blockIndex)};
            String str = "<html>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ServerListDlg.htmlPriorityhtmlPlain") + "</html>";
            String fm = MessageFormat.format(str, obj);
            listModel.addElement(fm);
            Object[] level = new Object[]{fm.toString()};
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(level[0]);
            Object[] obj1 = new Object[]{hostStr};
            fm = MessageFormat.format(str, obj1);
            listModel.addElement(fm);
            ++blockIndex;
            this.addToSubTree(node, al);
        }
    }

    public void addToSubTree(DefaultMutableTreeNode parent, List<String> l) {
        int size = l.size();
        for (int i = 0; i < size; ++i) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(l.get(i));
            this.serverListModel.insertNodeInto(node, parent, i);
        }
        int count = this.root.getChildCount();
        if (this.root.getChildCount() == 0) {
            this.serverListModel.insertNodeInto(parent, this.root, 0);
        } else {
            this.serverListModel.insertNodeInto(parent, this.root, count);
        }
        UIUtilities.expandTreeByDepth((JTree)this.serverListTree, this.root, 2);
    }

    public void addToRootTree(List<String> l) {
        int size = l.size();
        for (int i = 0; i < size; ++i) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(l.get(i));
            this.serverListModel.insertNodeInto(node, this.root, i);
        }
    }

    @Override
    protected boolean isCancelButtonShown() {
        return false;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_install_packages_dialog_export_preview";
    }

    @Override
    protected String getOkButtonText() {
        return UIText.get(519);
    }

    protected String toString(SemServerBlock block, boolean useHttps) {
        if (block == null) {
            return "";
        }
        if (block.getOptEnable() == null ? block.getDefEnable() == false : block.getOptEnable() == false) {
            return "";
        }
        int hostCount = block.getHostAddressCount();
        if (hostCount == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int k = 0; k < hostCount; ++k) {
            Integer port;
            HostAddress host = block.getHostAddress(k);
            String ip = host.getContent();
            if (ip == null || ip.length() <= 0) continue;
            if (k != 0) {
                buf.append(", ");
            }
            buf.append(ip);
            Integer n = port = useHttps ? host.getOptSecurePort() : host.getOptPort();
            if (port == null) continue;
            buf.append(":");
            buf.append(port);
        }
        return buf.toString();
    }

    protected List<String> getObjectList(SemServerBlock block, boolean useHttps) {
        ArrayList<String> alist = new ArrayList<String>();
        int hostCount = block.getHostAddressCount();
        for (int k = 0; k < hostCount; ++k) {
            Integer port;
            HostAddress host = block.getHostAddress(k);
            String ip = host.getContent();
            StringBuffer buf = new StringBuffer();
            if (ip == null || ip.length() <= 0) continue;
            buf.append(ip);
            Integer n = port = useHttps ? host.getOptSecurePort() : host.getOptPort();
            if (port != null) {
                buf.append(":");
                buf.append(port);
            }
            alist.add(buf.toString());
        }
        return alist;
    }

    private void initialize() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new DescriptionTextArea(DESCRITPTION, 3, 40), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ServerListDlg.detailLabel")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 5, 0, 5), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.serverListTree), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
    }

    private HtmlEnabledJTree getServerListTree() {
        if (this.serverListTree == null) {
            this.root = new DefaultMutableTreeNode("root");
            this.serverListModel = new DefaultTreeModel(this.root);
            this.serverListTree = new HtmlEnabledJTree((TreeModel)this.serverListModel);
            this.serverListTree.setRootVisible(false);
            this.serverListTree.setShowsRootHandles(true);
            DefaultTreeCellRenderer treeRender = (DefaultTreeCellRenderer)this.serverListTree.getCellRenderer();
            treeRender.setLeafIcon(null);
            treeRender.setClosedIcon(null);
            treeRender.setOpenIcon(null);
        }
        return this.serverListTree;
    }
}

