/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.ui.client.GroupAccessDeniedPanel;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.GroupCheckBoxTree;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;

public class SelectGroupDlg
extends DialogBase
implements PropertyChangeListener {
    private static final long serialVersionUID = 1838647088451541926L;
    private DescriptionTextArea desc;
    private JPanel content = new JPanel();
    private DefaultMutableTreeNode node;
    private GroupCheckBoxTree groupTree;
    private ArrayList<GroupObject> listGroupObjs;
    private boolean isReadOnlyNodeValid = false;
    private static final String[] MODE_DESC = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SelectGroupDlg.viewGroupDesc"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SelectGroupDlg.copyGroupToDesc"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SelectGroupDlg.moveGroupToDesc"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SelectGroupDlg.editGroupToDesc"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SelectGroupDlg.deleteGroupToDesc"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SelectGroupDlg.copyGroupToDesc")};
    private int activeMode;
    public static final int VIEW_MODE = 0;
    public static final int COPY_MODE = 1;
    public static final int MOVE_MODE = 2;
    public static final int EDIT_MODE = 3;
    public static final int DELETE_MODE = 4;
    public static final int COPY_MODE_MUL = 5;

    public SelectGroupDlg(String title, int mode) {
        this(title, mode, false, null);
    }

    protected SelectGroupDlg(String title, int mode, boolean isReadOnlyNodeValid, String groupID) {
        super(Manager.getFrame(), title, true);
        this.isReadOnlyNodeValid = isReadOnlyNodeValid;
        this.activeMode = mode;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        UiUtilities.centerComponent((Component)this);
        if (groupID != null) {
            this.setSelectedGroup(groupID);
        }
    }

    public static SelectGroupDlg newReadOnlyNodeValidInstance(String title, TreeModel treeModel, int mode, String defaultGroupID) {
        return new SelectGroupDlg(title, mode, true, defaultGroupID);
    }

    public static SelectGroupDlg newInstanceForSearchClient(String title, TreeModel treeModel, int mode, String defaultGroupID) {
        return new SearchClientSelectGroupDlg(title, mode, true, defaultGroupID);
    }

    public ArrayList<GroupObject> getListGroupObjs() {
        return this.listGroupObjs;
    }

    public DefaultMutableTreeNode getNode() {
        return this.node;
    }

    public void setDescription(String text) {
        this.desc.setText(text);
        this.content.updateUI();
    }

    protected void setSelectedGroup(String groupID) {
        if (this.groupTree != null) {
            this.groupTree.setSelected(true, groupID, true, true);
            this.groupTree.revalidate();
            this.groupTree.repaint();
        }
    }

    @Override
    protected boolean isValidate() {
        this.listGroupObjs = this.getSelectedGroups();
        if (this.listGroupObjs == null || this.listGroupObjs.size() == 0) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SelectGroupDlg.notValidGroupMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SelectGroupDlg.error"), 0);
            return false;
        }
        for (GroupObject object : this.listGroupObjs) {
            if (this.validateGroup(object)) continue;
            String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.noPrivilegeToTargetGroupMsg");
            JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
            return false;
        }
        return true;
    }

    protected boolean validateGroup(GroupObject groupObj) {
        return this.isReadOnlyNodeValid ? groupObj.isReadable() : groupObj.isFullAccessible();
    }

    @Override
    protected boolean isHelpButtonShown() {
        return false;
    }

    private void jbInit() throws Exception {
        this.groupTree = this.newGroupTree();
        this.groupTree.addPropertyChangeListener("check", this);
        boolean hasGroupAccess = false;
        hasGroupAccess = this.groupTree.init(Manager.getCurrentDomainId(), true, this.activeMode == 2 || this.activeMode == 0);
        this.groupTree.setVisibleRowCount(10);
        this.groupTree.expandAll();
        this.groupTree.setEnabled(true);
        if (this.activeMode == 1 || this.activeMode == 2 || this.activeMode == 0) {
            this.groupTree.setSelectionMode(5);
        } else if (this.activeMode == 5) {
            this.groupTree.setSelectionMode(0);
        }
        this.content.setLayout(new BorderLayout());
        this.content.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        if (hasGroupAccess) {
            this.content.add((Component)this.getDescription(), "North");
            this.content.add((Component)new JScrollPane(this.groupTree), "Center");
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.content, "Center");
            this.getContentPane().add((Component)this.getButtonPanel(), "South");
        } else {
            GroupAccessDeniedPanel groupAccessDeniedPanel = new GroupAccessDeniedPanel();
            groupAccessDeniedPanel.setSelectedItem(new GroupObject());
            this.content.add((Component)groupAccessDeniedPanel, "Center");
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.content, "Center");
        }
        this.setSize(365, 400);
    }

    GroupCheckBoxTree newGroupTree() {
        return new GroupCheckBoxTree();
    }

    private JTextArea getDescription() {
        if (this.desc == null) {
            this.desc = new DescriptionTextArea(MODE_DESC[this.activeMode]);
        }
        return this.desc;
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    private ArrayList<GroupObject> getSelectedGroups() {
        ArrayList<GroupObject> groupList = new ArrayList<GroupObject>();
        this.groupTree.getSelectedObject(groupList, false);
        return groupList;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("check".equals(evt.getPropertyName()) && ((GroupCheckBoxTree)evt.getSource()).getSelectionPath() != null) {
            this.node = (DefaultMutableTreeNode)((GroupCheckBoxTree)evt.getSource()).getSelectionPath().getLastPathComponent();
        }
    }

    static class SearchClientSelectGroupDlg
    extends SelectGroupDlg {
        private static final long serialVersionUID = -7185932949177850037L;

        SearchClientSelectGroupDlg(String title, int mode, boolean isReadOnlyNodeValid, String groupID) {
            super(title, mode, isReadOnlyNodeValid, groupID);
        }

        SearchClientSelectGroupDlg(String title, int mode) {
            super(title, mode);
        }

        @Override
        GroupCheckBoxTree newGroupTree() {
            return GroupCheckBoxTree.newInstanceForSearchClient();
        }
    }
}

