/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.configobject.schema.SemServerList;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.ServerListObject;
import com.sygate.scm.console.logicobject.ServerListPool;
import com.sygate.scm.console.ui.policy.PolicyHelper;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;

public class SelectDefaultMgmtServerDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENTDLG = "com.sygate.scm.console.ui.client.dlg.clientdialog";
    private GroupObject groupObj;
    private JComboBox<ObjInfoObject> serverCB;
    private JButton jBYes = new JButton(UIText.get(6144));
    private JButton jBYesToAll = new JButton(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SelectDefaultMgmtServerDlg.button.YesToAll"));
    private JButton jBCancel = new JButton(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SelectDefaultMgmtServerDlg.button.Cancel"));
    private ServerListPool pool;
    private boolean isCancel = false;
    private boolean isYesToAll = false;

    public SelectDefaultMgmtServerDlg(GroupObject groupObj) {
        super(Manager.getFrame(), "", true);
        this.groupObj = groupObj;
        this.setTitle(this.createTitle(groupObj));
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    @Override
    protected JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel();
        ArrayList<JButton> buttonList = new ArrayList<JButton>();
        buttonList.add(this.initYesButton());
        buttonList.add(this.initYesToAllButton());
        buttonList.add(this.initCancelButton());
        UIUtilities.layoutButtonPanel(buttonPanel, buttonList.toArray(new JButton[0]), 0, 4, true);
        UiUtilities.setDefaultButton((RootPaneContainer)this, (JButton)this.jBYes);
        return buttonPanel;
    }

    private String createTitle(GroupObject groupObj) {
        Object[] arg = new Object[]{groupObj.getName()};
        return MessageFormat.format(MSGRES.getString(CLIENTDLG, "SelectDefaultMgmtServerDlg.title"), arg);
    }

    private void initialServerList() {
        try {
            this.pool = ServerListPool.getServerListPool();
            ObjInfoObject[] infoObj = this.pool.getInfoObjectList();
            this.serverCB = new JComboBox<ObjInfoObject>(infoObj);
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), MSGRES.getString(CLIENTDLG, "SelectDefaultMgmtServerDlg.error"), 0);
        }
    }

    private void jbInit() throws Exception {
        this.initialServerList();
        this.setBounds(new Rectangle(0, 0, 0, 0));
        this.setResizable(true);
        DescriptionTextArea descText = new DescriptionTextArea(MSGRES.getString(CLIENTDLG, "SelectDefaultMgmtServerDlg.selection"), 46);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)descText, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 5, 10), 0, 0));
        panel.add(this.serverCB, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 20, 10), 0, 0));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
    }

    private JButton initYesButton() {
        this.jBYes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectDefaultMgmtServerDlg.this.actionYesButton();
            }
        });
        return this.jBYes;
    }

    private JButton initYesToAllButton() {
        this.jBYesToAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectDefaultMgmtServerDlg.this.actionYesToAllButton();
            }
        });
        return this.jBYesToAll;
    }

    private JButton initCancelButton() {
        this.jBCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectDefaultMgmtServerDlg.this.actionCancelButton();
            }
        });
        return this.jBCancel;
    }

    private boolean actionYesButton() {
        this.dispose();
        return true;
    }

    private boolean actionYesToAllButton() {
        this.isYesToAll = true;
        this.dispose();
        return true;
    }

    private void actionCancelButton() {
        this.isCancel = true;
        this.dispose();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public boolean isYesToAll() {
        return this.isYesToAll;
    }

    public SemServerList getSemServerList() {
        SemServerList commonServerList = null;
        try {
            ObjInfoObject objInfo = (ObjInfoObject)this.serverCB.getSelectedItem();
            ServerListObject serverListObj = PolicyHelper.getServerListObject(objInfo);
            if (serverListObj != null) {
                commonServerList = serverListObj.getSemServerList();
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            Object[] obj = new Object[]{this.groupObj.getName(), ex.getMessage()};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "SelectDefaultMgmtServerDlg.error.failedRetServerListForGroup0");
            String fm = MessageFormat.format(str, obj);
            JOptionPane.showMessageDialog(this, fm, MSGRES.getString(CLIENTDLG, "SelectDefaultMgmtServerDlg.error"), 0);
        }
        return commonServerList;
    }
}

