/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.creamtec.ajaxswing.support.FileOpener;
import com.creamtec.sepm.ajaxswing.support.ComponentUtils;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.IPv6RangePane;
import com.sygate.scm.console.ui.util.IpRangePane;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.AjaxSwingUtil;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class SearchByDlg
extends DialogBase
implements ItemListener,
FileOpener {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENT = "com.sygate.scm.console.ui.client.client";
    private static final String CLIENTDIALOG = "com.sygate.scm.console.ui.client.dlg.clientdialog";
    private final JLabel jLblSearchBy = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SearchByDlg.lblSearchBy"));
    private final JRadioButton jRBIpRange = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.client.client", "NetworkAuditFrame.radiobutton.ipRange"), true);
    private final JRadioButton jRBComputerName = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SearchByDlg.radiobutton.computerNameOrIP"));
    private final JRadioButton jRBImport = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SearchByDlg.lblImportFileList"));
    private final String ipv4Version = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SearchByDlg.IPv.four");
    private final String ipv6Version = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SearchByDlg.IPv.six");
    private final JComboBox<String> ipVersion = new JComboBox();
    private JPanel ipRangePanel;
    private CardLayout ipRangePanelLayout;
    private IpRangePane ipRangePane;
    private IPv6RangePane ipv6RangePane;
    private JPanel ipv4Panel;
    private JPanel ipv6Panel;
    private static final String IPV_FOUR = "IPV4";
    private static final String IPV_SIX = "IPV6";
    private final JTextField jTFComputerName = new JTextField(20);
    private static final String SCAN_ALL_IP_BEGIN = "1.1.1.1";
    private static final String SCAN_ALL_IP_END = "255.255.255.255";
    private String tempIpFrom;
    private String tempIpTo;
    private String tempComputerName;
    private boolean tempIsIPRangeSelected = true;
    private final JTextField fileField = new JTextField(20);
    private String importFilePath = "";
    private final JButton importFileButton = new JButton(UIText.get(2049));

    public SearchByDlg(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.init();
    }

    public void openFile(File file) {
        this.fileField.setText(MessageResources.getInstance().getString(CLIENTDIALOG, "SearchByDlg.FileUploaded"));
    }

    protected void init() {
        Container ct = this.getContentPane();
        ct.setLayout(new GridBagLayout());
        ct.add((Component)this.getSearchPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 20, 0), 0, 0));
        ct.add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 16, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.initIPRange();
        this.searchOptionChanged();
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent event) {
                if (!SearchByDlg.this.jRBIpRange.isSelected()) {
                    SearchByDlg.this.jTFComputerName.requestFocus();
                }
            }
        });
    }

    @Override
    public boolean isHelpButtonShown() {
        return false;
    }

    private JPanel getIpRangePanel() {
        if (this.ipRangePanel == null) {
            this.ipRangePanel = new JPanel();
            this.ipRangePanelLayout = new CardLayout();
            this.ipRangePanel.setLayout(this.ipRangePanelLayout);
            this.ipRangePanel.add((Component)this.getIpv4RangePanel(), IPV_FOUR);
            this.ipRangePanel.add((Component)this.getIPv6RangePanel(), IPV_SIX);
        }
        return this.ipRangePanel;
    }

    private JPanel getIpv4RangePanel() {
        if (this.ipv4Panel == null) {
            this.ipv4Panel = new JPanel(new BorderLayout());
            JPanel ipPanel = new JPanel(new BorderLayout());
            this.ipv4Panel.add((Component)ipPanel, "North");
            this.ipRangePane = new IpRangePane();
            this.ipRangePane.setBorder(null);
            ipPanel.add((Component)this.ipRangePane, "Center");
            this.ipRangePane.getStartLabel().setPreferredSize(new JLabel(this.ipRangePane.getStartLabel().getText()).getPreferredSize());
            this.ipRangePane.getEndLabel().setPreferredSize(new JLabel(this.ipRangePane.getEndLabel().getText()).getPreferredSize());
            this.ipRangePane.setFromIP(SCAN_ALL_IP_BEGIN);
            this.ipRangePane.setToIP(SCAN_ALL_IP_END);
        }
        return this.ipv4Panel;
    }

    private JPanel getIPv6RangePanel() {
        if (this.ipv6Panel == null) {
            this.ipv6Panel = new JPanel(new BorderLayout());
            JPanel ipPanel = new JPanel(new BorderLayout());
            this.ipv6Panel.add((Component)ipPanel, "North");
            this.ipv6RangePane = new IPv6RangePane();
            this.ipv6RangePane.setBorder(null);
            ipPanel.add((Component)this.ipv6RangePane, "Center");
            this.ipv6RangePane.getStartLabel().setPreferredSize(new JLabel(this.ipv6RangePane.getStartLabel().getText()).getPreferredSize());
            this.ipv6RangePane.getEndLabel().setPreferredSize(new JLabel(this.ipv6RangePane.getEndLabel().getText()).getPreferredSize());
        }
        return this.ipv6Panel;
    }

    private JPanel getSearchPanel() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRBIpRange);
        group.add(this.jRBComputerName);
        group.add(this.jRBImport);
        this.ipVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (SearchByDlg.this.ipv4Version.equals(SearchByDlg.this.ipVersion.getSelectedItem())) {
                    SearchByDlg.this.ipRangePanelLayout.show(SearchByDlg.this.ipRangePanel, SearchByDlg.IPV_FOUR);
                    SearchByDlg.this.ipRangePane.setEnable(true);
                } else {
                    SearchByDlg.this.ipRangePanelLayout.show(SearchByDlg.this.ipRangePanel, SearchByDlg.IPV_SIX);
                    SearchByDlg.this.ipv6RangePane.setEnable(true);
                }
            }
        });
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> ComponentUtils.setFileOpener((JComponent)this.importFileButton, (FileOpener)this));
        this.importFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SearchByDlg.this.btnBrowseActionPerformed();
            }
        });
        this.jRBIpRange.addItemListener(this);
        this.jRBComputerName.addItemListener(this);
        this.jRBImport.addItemListener(this);
        int width = 4;
        int y = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        RestrictedPlainDocument nameDoc = new RestrictedPlainDocument(512);
        nameDoc.setValidator("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-.:", true);
        this.jTFComputerName.setDocument(nameDoc);
        panel.add((Component)this.jLblSearchBy, new GridBagConstraints(0, y, width, 1, 0.0, 0.0, 17, 0, new Insets(20, 25, 0, 25), 0, 0));
        panel.add((Component)this.jRBIpRange, new GridBagConstraints(0, ++y, width - 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 0, 25), 0, 0));
        panel.add(this.ipVersion, new GridBagConstraints(3, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 0, 30), 0, 0));
        panel.add((Component)this.getIpRangePanel(), new GridBagConstraints(0, ++y, width, 3, 1.0, 0.0, 17, 2, new Insets(5, 52, 0, 30), 0, 0));
        panel.add((Component)this.jRBComputerName, new GridBagConstraints(0, y += 3, width, 1, 0.0, 0.0, 17, 0, new Insets(10, 30, 0, 0), 0, 0));
        panel.add((Component)this.jTFComputerName, new GridBagConstraints(0, ++y, width, 1, 1.0, 0.0, 17, 2, new Insets(5, 52, 0, 30), 0, 0));
        panel.add((Component)this.jRBImport, new GridBagConstraints(0, ++y, width, 1, 0.0, 0.0, 17, 0, new Insets(10, 30, 0, 0), 0, 0));
        panel.add((Component)this.fileField, new GridBagConstraints(0, ++y, width - 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 52, 0, 10), 0, 0));
        panel.add((Component)this.importFileButton, new GridBagConstraints(width - 1, y, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 25), 0, 0));
        return panel;
    }

    private void initIPRange() {
        try {
            InetAddress[] localhostArray = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            InetAddress localHostAddress = InetAddress.getLocalHost();
            for (InetAddress localHostAddr : localhostArray) {
                if (localHostAddr.isLoopbackAddress() || NetworkInterface.getByInetAddress(localHostAddr) == null) continue;
                localHostAddress = localHostAddr;
                break;
            }
            NetworkInterface localNI = NetworkInterface.getByInetAddress(localHostAddress);
            List<InterfaceAddress> interfaceAddressArray = localNI.getInterfaceAddresses();
            for (InterfaceAddress interfaceAddress : interfaceAddressArray) {
                List<String> range;
                InetAddress localHostIp = interfaceAddress.getAddress();
                if (localHostIp instanceof Inet4Address) {
                    InterfaceAddress interfaceAddressIp = interfaceAddress;
                    if (!this.ipv4Version.equals(this.ipVersion.getItemAt(0)) && !this.ipv4Version.equals(this.ipVersion.getItemAt(1))) {
                        this.ipVersion.addItem(this.ipv4Version);
                    }
                    range = this.getIpRange(localHostIp, interfaceAddressIp);
                    this.ipRangePane.setFromIP(range.get(0));
                    this.ipRangePane.setToIP(range.get(1));
                    continue;
                }
                if (!(localHostIp instanceof Inet6Address)) continue;
                InterfaceAddress interfaceAddressIpv6 = interfaceAddress;
                if (!this.ipv6Version.equals(this.ipVersion.getItemAt(0)) && !this.ipv6Version.equals(this.ipVersion.getItemAt(1))) {
                    this.ipVersion.addItem(this.ipv6Version);
                }
                range = this.getIpRange(localHostIp, interfaceAddressIpv6);
                this.ipv6RangePane.setFromIP(range.get(0));
                this.ipv6RangePane.setToIP(range.get(1));
                break;
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private List<String> getIpRange(InetAddress localHostIp, InterfaceAddress interfaceAddress) {
        byte[] local = localHostIp.getAddress();
        short prefix = interfaceAddress.getNetworkPrefixLength();
        byte[] mask = new byte[local.length];
        for (int i = 0; i < mask.length; ++i) {
            mask[i] = -1;
        }
        int bit = 1;
        for (int i = local.length * 8 - 1; i >= prefix; --i) {
            bit = (i + 1) % 8 == 0 ? 1 : (int)((byte)(bit << 1));
            int n = i / 8;
            mask[n] = (byte)(mask[n] ^ bit);
        }
        byte[] start = new byte[local.length];
        byte[] end = new byte[local.length];
        for (int i = 0; i < local.length; ++i) {
            start[i] = (byte)(local[i] & mask[i]);
            end[i] = (byte)(local[i] | ~mask[i]);
        }
        if (start[start.length - 1] == 0) {
            start[start.length - 1] = 1;
        }
        ArrayList<String> range = new ArrayList<String>();
        try {
            InetAddress startAddr = InetAddress.getByAddress(start);
            InetAddress endAddr = InetAddress.getByAddress(end);
            range.add(startAddr.getHostAddress());
            range.add(endAddr.getHostAddress());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return range;
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        this.searchOptionChanged();
    }

    private void searchOptionChanged() {
        boolean isIpRange = this.jRBIpRange.isSelected();
        boolean isName = this.jRBComputerName.isSelected();
        this.ipVersion.setEnabled(isIpRange);
        if (isIpRange) {
            if (this.ipv4Version.equals(this.ipVersion.getSelectedItem())) {
                this.ipRangePane.getStartLabel().requestFocus();
                this.ipRangePane.setEnable(true);
            } else {
                this.ipv6RangePane.getStartLabel().requestFocus();
                this.ipv6RangePane.setEnable(true);
            }
        } else {
            this.ipRangePane.setEnable(false);
            this.ipv6RangePane.setEnable(false);
        }
        boolean isFile = this.jRBImport.isSelected();
        this.jTFComputerName.setEnabled(isName);
        if (isName) {
            this.jTFComputerName.requestFocus();
        }
        this.fileField.setEnabled(isFile);
        this.importFileButton.setEnabled(isFile);
        if (isFile) {
            this.fileField.requestFocus();
        }
    }

    public boolean isSearchByRange() {
        return this.jRBIpRange.isSelected();
    }

    public boolean isSearchByName() {
        return this.jRBComputerName.isSelected();
    }

    public boolean isSearchByImport() {
        return this.jRBImport.isSelected();
    }

    public String getComputerName() {
        return this.jTFComputerName.getText().trim();
    }

    public String getFromIp() {
        if (this.ipv4Version.equals(this.ipVersion.getSelectedItem())) {
            return this.ipRangePane.getFromIP();
        }
        return this.ipv6RangePane.getFromIP();
    }

    public String getToIp() {
        if (this.ipv4Version.equals(this.ipVersion.getSelectedItem())) {
            return this.ipRangePane.getToIP();
        }
        return this.ipv6RangePane.getToIP();
    }

    @Override
    public boolean isValidate() {
        boolean isValid = true;
        if (this.jRBComputerName.isSelected()) {
            boolean bl = isValid = !"".equals(this.jTFComputerName.getText().trim());
            if (!isValid) {
                JOptionPane.showMessageDialog(this, MSGRES.getString(CLIENTDIALOG, "SearchByDlg.errorInvalidComputerMsg"), MSGRES.getString(CLIENTDIALOG, "SearchByDlg.error"), 0);
                this.jTFComputerName.requestFocus();
            }
        } else if (this.jRBImport.isSelected()) {
            if (this.importFilePath.trim().length() == 0 || !IOUtilities.isValidFile((String)this.importFilePath)) {
                JOptionPane.showMessageDialog(this, MSGRES.getString(CLIENTDIALOG, "SearchByDlg.errorNoFileSelectedMsg"), MSGRES.getString(CLIENTDIALOG, "SearchByDlg.error"), 0);
                isValid = false;
            }
        } else if (this.ipv4Version.equals(this.ipVersion.getSelectedItem())) {
            if (!this.ipRangePane.isValidValue()) {
                String message = this.ipRangePane.getErrorMessage();
                JOptionPane.showMessageDialog(Manager.getFrame(), message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.title.InvalidIPRange"), 0);
                this.ipRangePane.requestFocus();
                isValid = false;
            }
        } else if (!this.ipv6RangePane.isValidValue()) {
            JOptionPane.showMessageDialog(Manager.frame, this.ipv6RangePane.getErrorMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.title.InvalidIPv6Address"), 0);
            this.ipv6RangePane.requestFocus();
            isValid = false;
        }
        return isValid;
    }

    protected void resetSearchByDlg(boolean isOK) {
        if (!isOK) {
            this.jTFComputerName.setText(this.tempComputerName);
            if (this.tempIsIPRangeSelected) {
                this.searchOptionChanged();
                this.jRBIpRange.setSelected(this.tempIsIPRangeSelected);
                if (this.ipv4Version.equals(this.ipVersion.getSelectedItem())) {
                    if (!this.ipRangePane.getFromIP().equals(this.tempIpFrom) || !this.ipRangePane.getToIP().equals(this.tempIpTo)) {
                        this.ipRangePane.setFromIP(this.tempIpFrom);
                        this.ipRangePane.setToIP(this.tempIpTo);
                    }
                } else if (!this.ipv6RangePane.getFromIP().equals(this.tempIpFrom) || !this.ipv6RangePane.getToIP().equals(this.tempIpTo)) {
                    this.ipv6RangePane.setFromIP(this.tempIpFrom);
                    this.ipv6RangePane.setToIP(this.tempIpTo);
                }
                if (this.tempIpFrom == null && this.tempIpTo == null) {
                    this.initIPRange();
                }
            } else {
                this.jRBComputerName.setSelected(!this.tempIsIPRangeSelected);
                this.searchOptionChanged();
            }
        } else {
            if (this.ipv4Version.equals(this.ipVersion.getSelectedItem())) {
                this.tempIpFrom = this.ipRangePane.getFromIP();
                this.tempIpTo = this.ipRangePane.getToIP();
            } else {
                this.tempIpFrom = this.ipv6RangePane.getFromIP();
                this.tempIpTo = this.ipv6RangePane.getToIP();
            }
            this.tempComputerName = this.jTFComputerName.getText();
            this.tempIsIPRangeSelected = this.jRBIpRange.isSelected();
        }
    }

    private void btnBrowseActionPerformed() {
        JFileChooser fc = new JFileChooser();
        fc.putClientProperty("ajaxswing.browseClient", true);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return MessageResources.getInstance().getString(SearchByDlg.CLIENTDIALOG, "SearchByDlg.infoFileDesc");
            }
        });
        fc.setApproveButtonText(MessageResources.getInstance().getString(CLIENTDIALOG, "SearchByDlg.browseDialogButtonText"));
        fc.setDialogTitle(MessageResources.getInstance().getString(CLIENTDIALOG, "SearchByDlg.browseDialogTitle"));
        fc.setFileSelectionMode(0);
        if (0 != fc.showOpenDialog(this)) {
            return;
        }
        File selectFile = fc.getSelectedFile();
        if (selectFile == null) {
            return;
        }
        this.fileField.setText(AjaxSwingUtil.getDisplayFileName(selectFile));
        this.importFilePath = selectFile.getAbsolutePath();
    }

    public String getComputerListFileName() {
        return this.importFilePath;
    }
}

