/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.configobject.schema.RebootOptions;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.ui.client.dlg.SMRRebootSelectDlg;
import com.sygate.scm.console.ui.policy.av.common.DashLine;
import com.sygate.scm.console.ui.util.DialogBase;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.UIManager;

public class ScanSelectPowerEraserDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private String name = "ScanNow_PowerEraser";
    private JRadioButton normalScan;
    private JRadioButton rootKitScan;
    private JButton jBRestartOptions;
    private RebootOptions rop;

    public ScanSelectPowerEraserDlg(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.init();
    }

    public String getScanName() {
        return this.name;
    }

    public RebootOptions getRebootOptions() {
        if ("ScanNow_PowerEraserRootkit".equals(this.name)) {
            return this.rop == null ? SMRRebootSelectDlg.getInstance().getRebootOptions() : this.rop;
        }
        return null;
    }

    @Override
    protected void commit() {
        this.name = this.normalScan.isSelected() ? "ScanNow_PowerEraser" : "ScanNow_PowerEraserRootkit";
    }

    protected void init() {
        String normalScanStr = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ScanSelectPowerEraserDlg.normalScan");
        String rootKitScanStr = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ScanSelectPowerEraserDlg.rootKitScan");
        String rootKitScanDescStr = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ScanSelectPowerEraserDlg.rootKitScanDesc");
        String internetScanNoteStr = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ScanSelectPowerEraserDlg.internetScanNote");
        String usageWarningStr = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ScanSelectPowerEraserDlg.usageWarning");
        String kbLinkStr = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ScanSelectPowerEraserDlg.kbLink");
        String questionStr = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ScanSelectPowerEraserDlg.selectScanText");
        this.normalScan = new JRadioButton(normalScanStr);
        this.normalScan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScanSelectPowerEraserDlg.this.enableButtons();
            }
        });
        this.rootKitScan = new JRadioButton(rootKitScanStr){
            private static final long serialVersionUID = 1L;

            @Override
            public JToolTip createToolTip() {
                JToolTip tip = super.createToolTip();
                tip.setForeground(UIManager.getColor("ToolTip.foreground"));
                tip.setBackground(UIManager.getColor("ToolTip.background"));
                return tip;
            }
        };
        this.rootKitScan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScanSelectPowerEraserDlg.this.enableButtons();
            }
        });
        this.normalScan.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        this.normalScan.setSelected(true);
        group.add(this.normalScan);
        group.add(this.rootKitScan);
        JPanel selectPanel = new JPanel();
        selectPanel.setLayout(new GridBagLayout());
        JLabel rootKitScanDescLabel = new JLabel(rootKitScanDescStr);
        JTextArea usageWarningLabel = new JTextArea(usageWarningStr, 5, 1);
        usageWarningLabel.setEditable(false);
        usageWarningLabel.setWrapStyleWord(true);
        usageWarningLabel.setLineWrap(true);
        usageWarningLabel.setOpaque(false);
        usageWarningLabel.setFont(rootKitScanDescLabel.getFont());
        JTextArea internetScanNoteLabel = new JTextArea(internetScanNoteStr, 3, 1);
        internetScanNoteLabel.setEditable(false);
        internetScanNoteLabel.setWrapStyleWord(true);
        internetScanNoteLabel.setLineWrap(true);
        internetScanNoteLabel.setOpaque(false);
        internetScanNoteLabel.setFont(rootKitScanDescLabel.getFont());
        HtmlEnabledJLabel kbLinkLabel = new HtmlEnabledJLabel(kbLinkStr, true);
        kbLinkLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HelpUtil.showHelpOrErrDlg("sesm_powereraser_whatyoushouldknow");
            }
        });
        JLabel question = new JLabel(questionStr);
        question.putClientProperty("cssClass", "avTemplatePanelTitleLabel");
        question.setFont(UIFontUtilities.BOLD_FONT);
        DashLine dashLine = new DashLine(UIColorUtilities.CONTROL_BACKGROUND, 550);
        dashLine.putClientProperty("cssClass", "avTemplatePaneldashLine");
        this.jBRestartOptions = new JButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ScanSelectPowerEraserDlg.btnRestartOptions"));
        this.jBRestartOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScanSelectPowerEraserDlg.this.restartOptionsBtnActionPerformed();
            }
        });
        this.jBRestartOptions.setEnabled(false);
        if (!AdminPrivilegeObject.hasCommandPrivilege("0xF4")) {
            this.rootKitScan.setEnabled(false);
            rootKitScanDescLabel.setEnabled(false);
            this.rootKitScan.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ScanSelectPowerEraserDlg.tooltipNoRestartPrivilege"));
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 7;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(12, 12, 12, 16);
        c.anchor = 12;
        ImageIcon img = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("yellow_alert.png")));
        selectPanel.add((Component)new JLabel(img), c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.insets = new Insets(5, 0, 0, 0);
        c.fill = 2;
        c.anchor = 23;
        selectPanel.add((Component)usageWarningLabel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(10, 0, 0, 0);
        c.fill = 2;
        selectPanel.add((Component)internetScanNoteLabel, c);
        c.gridx = 1;
        c.gridy = 2;
        c.insets = new Insets(10, 0, 25, 0);
        selectPanel.add((Component)kbLinkLabel, c);
        c.gridx = 1;
        c.gridy = 3;
        c.insets = new Insets(10, 0, 0, 0);
        selectPanel.add((Component)question, c);
        c.gridx = 1;
        c.gridy = 4;
        c.insets = new Insets(0, 0, 10, 0);
        selectPanel.add((Component)dashLine, c);
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        selectPanel.add((Component)this.normalScan, c);
        c.gridx = 1;
        c.gridy = 7;
        c.insets = new Insets(5, 0, 0, 0);
        selectPanel.add((Component)this.rootKitScan, c);
        c.gridx = 2;
        c.gridy = 7;
        c.insets = new Insets(5, 0, 0, 0);
        selectPanel.add((Component)this.jBRestartOptions, c);
        c.gridx = 1;
        c.gridy = 8;
        c.insets = new Insets(0, 22, 0, 0);
        selectPanel.add((Component)rootKitScanDescLabel, c);
        c.gridx = 1;
        c.gridy = 9;
        c.weighty = 1.0;
        c.fill = 1;
        selectPanel.add((Component)new JPanel(), c);
        GridBagConstraints gbc1 = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 37, 22, 37), 0, 0);
        GridBagConstraints gbc2 = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0);
        Container ct = this.getContentPane();
        ct.setLayout(new GridBagLayout());
        ct.add((Component)selectPanel, gbc1);
        ct.add((Component)this.getButtonPanel(), gbc2);
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    public static ScanSelectPowerEraserDlg getShowDialog() {
        String dlgTitle = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ScanSelectPowerEraserDlg.selectScanTypeDlgTitle");
        ScanSelectPowerEraserDlg dlg = new ScanSelectPowerEraserDlg(Manager.frame, dlgTitle, true);
        dlg.setVisible(true);
        if (!dlg.isOk()) {
            return null;
        }
        return dlg;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_monitors_logs_powereraser_type";
    }

    private void restartOptionsBtnActionPerformed() {
        this.rop = SMRRebootSelectDlg.getInstance().getRebootOptionsFromDialog();
    }

    private void enableButtons() {
        this.jBRestartOptions.setEnabled(this.rootKitScan.isSelected());
    }
}

