/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RenameGroupDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private JTextField nameField = new JTextField(30);
    private GroupObject group;

    public RenameGroupDlg(GroupObject group) {
        super(Manager.getFrame(), "", true);
        Object[] obj = new Object[]{group.getName()};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "RenameGroupDlg.renameGroupFor");
        String fm = MessageFormat.format(str, obj);
        super.setTitle(fm);
        this.group = group;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    @Override
    public String getName() {
        if (this.nameField == null) {
            return "";
        }
        return this.nameField.getText().trim();
    }

    @Override
    protected boolean isValidate() {
        String newGroupName = this.getName();
        if (newGroupName.length() == 0) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "RenameGroupDlg.inputaNewGroupNameMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "RenameGroupDlg.error"), 0);
            this.nameField.requestFocus();
            return false;
        }
        if (newGroupName.length() > 990) {
            Object[] obj = new Object[]{Integer.toString(990)};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "RenameGroupDlg.groupNameExceeds0Characters");
            String fm = MessageFormat.format(str, obj);
            JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "RenameGroupDlg.warning"), 2);
            this.nameField.requestFocus();
            return false;
        }
        if (this.group.getName().equals(this.getName())) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "RenameGroupDlg.groupNameSameAsOldOne"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "RenameGroupDlg.error"), 0);
            this.nameField.requestFocus();
            return false;
        }
        if (GroupHandler.getChildGroup(this.group.getParentGroup(), newGroupName) != null) {
            Object[] obj = new Object[]{this.getName()};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "RenameGroupDlg.groupNameExists");
            String fm = MessageFormat.format(str, obj);
            JOptionPane.showMessageDialog(this, fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "RenameGroupDlg.error"), 0);
            this.nameField.requestFocus();
            return false;
        }
        String fullPath = GroupHandler.getGroupFullPath(this.group.getParentGroup(), newGroupName);
        if (fullPath.length() > 1000) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "RenameGroupDlg.groupPathTooLong"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "RenameGroupDlg.error"), 0);
            this.nameField.requestFocus();
            return false;
        }
        if (!GroupHandler.isNewGroupNameValidForChildGroups(this.group, newGroupName)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "RenameGroupDlg.childGroupPathTooLong"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "RenameGroupDlg.error"), 0);
            this.nameField.requestFocus();
            return false;
        }
        return true;
    }

    private void jbInit() throws Exception {
        RestrictedPlainDocument nameDoc = new RestrictedPlainDocument(990);
        nameDoc.setValidator("\"/\\*?<>|&:", false);
        this.nameField.setDocument(nameDoc);
        if (this.group != null) {
            this.nameField.setText(this.group.getName());
            this.nameField.setSelectionStart(0);
            this.nameField.setSelectionEnd(this.nameField.getText().length());
        }
        JPanel namePanel = new JPanel();
        namePanel.add(new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "RenameGroupDlg.newGroupName")));
        namePanel.add(this.nameField);
        this.getContentPane().setLayout(new BorderLayout(0, 5));
        this.getContentPane().add((Component)namePanel, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_client_tree_dialog_rename_group";
    }

    @Override
    protected boolean isHelpButtonShown() {
        return false;
    }
}

