/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.ui.client.networkaudit.RemotePushComputerObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.ServerVersion;
import com.sygate.scm.util.URLUtility;
import com.sygate.scm.util.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class RemotePushComputerInfoDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENTDIALOG = "com.sygate.scm.console.ui.client.dlg.clientdialog";
    private static String LEGACY_INFO = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "RemotePushComputerInfoDlg.legacyInfoText");
    private RemotePushComputerObject computer = null;
    private JLabel jLblTitleName = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "RemotePushComputerInfoDlg.titleName"));
    private JLabel jLblTitleIP = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "RemotePushComputerInfoDlg.titleIP"));
    private JLabel jLblTitleDesc = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "RemotePushComputerInfoDlg.titleDesc"));
    private JLabel jLblTitleProtection = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "RemotePushComputerInfoDlg.titleProtection"));
    private HtmlEnabledJLabel jLbSystemRequirementLink;
    private DescriptionTextArea jLblName = new DescriptionTextArea("", 30);
    private DescriptionTextArea jLblIP = new DescriptionTextArea("", 30);
    private DescriptionTextArea jLblDesc = new DescriptionTextArea("", 30);
    private DescriptionTextArea jLblProtection = new DescriptionTextArea("", 30);
    private DescriptionTextArea legacyInfoText = new DescriptionTextArea(LEGACY_INFO);

    public RemotePushComputerInfoDlg(RemotePushComputerObject entry, JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.computer = entry;
        this.init();
    }

    protected void init() {
        this.jLblName.setText(this.computer.getComputerNode().getHostName());
        this.jLblIP.setText(this.computer.getComputerNode().getIP());
        this.jLblDesc.setText(this.computer.getDescription());
        this.jLblProtection.setText(this.computer.getProtection());
        if (this.jLblProtection.getText().equals(RemotePushComputerObject.UNPROTECTED)) {
            this.jLblProtection.setForeground(Color.RED);
        }
        String fmtString = MSGRES.getString(CLIENTDIALOG, "SystemRequirementLink.urlText");
        this.jLbSystemRequirementLink = new HtmlEnabledJLabel(this.getSystemRequirementLinkText(fmtString), true);
        this.jLbSystemRequirementLink.setIcon((Icon)ConsoleMain.whatsThisIcon);
        this.jLbSystemRequirementLink.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RemotePushComputerInfoDlg.this.showFeaturePanelHelp();
            }
        });
        Container ct = this.getContentPane();
        ct.setLayout(new GridBagLayout());
        ct.add((Component)this.getContentPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(20, 0, 30, 0), 0, 0));
        ct.add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 16, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    protected void showFeaturePanelHelp() {
        String language = Utility.getLanguage();
        Object[] obj = new Object[]{ServerVersion.CURRENT_CED_VERSION, language};
        String fmtString = MessageFormat.format(MSGRES.getString(CLIENTDIALOG, "SystemRequirementLink.url"), obj);
        try {
            if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                ClientAgent.getCurrentInstance().openInNewTab(fmtString);
                return;
            }
            URLUtility.showURL((String)fmtString);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, MSGRES.getString(CLIENTDIALOG, "InstallMethodsPanel.errorURL"), MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.error"), 0);
        }
    }

    private String getSystemRequirementLinkText(String fmtString) {
        StringBuffer strBuffDesc = new StringBuffer();
        strBuffDesc.append("<HTML><BODY>");
        strBuffDesc.append(fmtString);
        strBuffDesc.append("</BODY></HTML>");
        return strBuffDesc.toString();
    }

    @Override
    public boolean isHelpButtonShown() {
        return false;
    }

    @Override
    public boolean isCancelButtonShown() {
        return false;
    }

    @Override
    public String getOkButtonText() {
        return UIText.get(519);
    }

    private JPanel getContentPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        int xspace = 15;
        panel.add((Component)this.jLblTitleName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 0, 0), 0, 0));
        panel.add((Component)this.jLblName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, xspace, 0, 50), 0, 0));
        panel.add((Component)this.jLblTitleIP, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 0, 0), 0, 0));
        panel.add((Component)this.jLblIP, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, xspace, 0, 50), 0, 0));
        panel.add((Component)this.jLblTitleProtection, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 0, 0), 0, 0));
        panel.add((Component)this.jLblProtection, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, xspace, 0, 50), 0, 0));
        panel.add((Component)this.jLblTitleDesc, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 0, 0), 0, 0));
        panel.add((Component)this.jLblDesc, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, xspace, 0, 50), 0, 0));
        if (this.computer.isUnsupported()) {
            panel.add((Component)this.legacyInfoText, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 17, 2, new Insets(25, 30, 0, 30), 0, 0));
            this.updateLegacyInfoText(this.computer.getDescription());
            panel.add((Component)this.jLbSystemRequirementLink, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 30, 0, 0), 0, 0));
        }
        return panel;
    }

    public void updateLegacyInfoText(String ver) {
        String maxVer = this.computer.getMaxSEPVersion();
        String text = MessageFormat.format(LEGACY_INFO, ver, maxVer);
        this.legacyInfoText.setText(text);
    }

    public DescriptionTextArea getLegacyInfoText() {
        return this.legacyInfoText;
    }
}

