/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.configobject.rpc.NameValuePair;
import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.common.ui.SimpleProgressDlg;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.client.RemoteDeploymentHelper;
import com.sygate.scm.console.ui.client.dlg.ClientInstallationWizard;
import com.sygate.scm.console.ui.client.dlg.InstallClientWizardDialog;
import com.sygate.scm.console.ui.client.dlg.LoginInfoDlg;
import com.sygate.scm.console.ui.client.dlg.RemotePushComputerInfoDlg;
import com.sygate.scm.console.ui.client.dlg.SearchByDlg;
import com.sygate.scm.console.ui.client.dlg.SearchProgressDialog;
import com.sygate.scm.console.ui.client.networkaudit.NetworkAuditCommunicator;
import com.sygate.scm.console.ui.client.networkaudit.NetworkAuditComputerNode;
import com.sygate.scm.console.ui.client.networkaudit.NetworkAuditObject;
import com.sygate.scm.console.ui.client.networkaudit.NetworkAuditSearchListener;
import com.sygate.scm.console.ui.client.networkaudit.NetworkAuditSearchParams;
import com.sygate.scm.console.ui.client.networkaudit.RemotePushComputerObject;
import com.sygate.scm.console.ui.client.networkaudit.RemotePushComputerTableModel;
import com.sygate.scm.console.ui.client.networkaudit.ScanOptionDialog;
import com.sygate.scm.console.ui.client.networkaudit.ScanOptionObject;
import com.sygate.scm.console.ui.client.networkaudit.parser.Domain;
import com.sygate.scm.console.ui.client.networkaudit.parser.Network;
import com.sygate.scm.console.ui.client.networkaudit.parser.NetworkBrowseException;
import com.sygate.scm.console.ui.client.networkaudit.parser.NetworkParser;
import com.sygate.scm.console.ui.client.networkaudit.parser.TreeNodeGenerator;
import com.sygate.scm.console.ui.client.wizard.DeploymentTypePanel;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.util.BrowseTreeNode;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.HTMLEditorPane;
import com.sygate.scm.console.ui.util.ListMessageBox;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.SwingWorkerExecutor;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.renderer.BrowseTreeRenderer;
import com.sygate.scm.console.ui.util.renderer.RemotePushComputerRenderer;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.KeepAlive;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.HTMLUtilities;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.ServerVersion;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.URLUtility;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.validator.routines.InetAddressValidator;

public class RemoteMethodPanel
extends ClientInstallationWizard
implements ListSelectionListener,
ActionListener,
TreeWillExpandListener,
TreeSelectionListener,
ChangeListener,
PropertyChangeListener {
    private static final int MAX_SIZE_OF_COMPUTER_LIST_FILE = 0x1400000;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENTDIALOG = "com.sygate.scm.console.ui.client.dlg.clientdialog";
    private static final String delimaArray = " \t,;/\\\\\\*&\\^%#\\$@!?\\(\\)\\|";
    private final ArrayList<String> errorLines = new ArrayList();
    ArrayList<NetworkAuditComputerNode> hostsToAdd = null;
    private JButton jBtnAdd;
    private JButton jBtnDel;
    private JButton jBtnFind;
    private JButton jBtnClear;
    private JLabel jLblAvailable;
    private JLabel jLblInstall;
    private JLabel jLblHint;
    private JLabel jLblHintText;
    private DescriptionTextArea desc;
    private JLabel jLblErrorMsg;
    private RemotePushComputerTableModel searchResModel;
    private List<RemotePushComputerObject> lstSearchCache;
    private StripesTable jSearchTbl;
    private static final float[] colSizes = new float[]{0.4f, 0.15f, 0.45f};
    private RemotePushComputerTableModel selectedModel;
    private StripesTable jTblSelected;
    private JScrollPane jspSelected;
    private JTabbedPane jTabPane;
    private JPanel searchPanel;
    private JPanel hintPanel;
    private SearchByDlg searchDlg;
    private JPanel findClearButtonPanel;
    private JPanel errPanel;
    private JEditorPane jEpErrorPane;
    private SimpleProgressDlg searchProgDlg;
    private SimpleProgressDlg progress;
    private NetworkAuditSearchParams searchParams;
    private NetworkAuditCommunicator searchComm;
    private NetworkAuditCommunicator loginComm;
    private SearchListener searchListener;
    private String strUserName;
    private String strPassword;
    private String strDomainName;
    private boolean isDomain;
    private BrowseTreePerPlatform browseTrees;
    private boolean isClientRemoteLaunched;
    private static final String rootNodeName = "Entire Network";
    private static final String STR_LOGIN_ERROR_MSG = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "LoginDlg.errorLoginFailed");
    private static final String DUP_SELECT_ENTRY_ERR = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "RemoteMethodPanel.errorDuplicateSelectEntry");
    private BrowseProgressDialog browseProgDlgref;
    private String tmpUserName;
    private String tmpPassword;
    private String tmpDomainName;
    private boolean isTmpDomain;
    private ProgressMonitor progressMonitor;
    private ImportTask importTask;
    private String computerListFile;
    private int lineNum;
    private List<NetworkAuditComputerNode> computerList;
    private List<String> lastImportedItem;
    private boolean importOK;
    protected ScanOptionObject scanOptionObj;
    private boolean bCommunictaionSetting = false;
    private String endpointType;
    private JScrollPane browseScrollpane;
    private static final int DOUBLE_CLICK = 2;

    public RemoteMethodPanel(InstallClientWizardDialog wizard, boolean isSMB, List<RemotePushComputerObject> lstSearchCache) {
        super(wizard, isSMB);
        this.setCachedComputerList(lstSearchCache);
    }

    protected void setCachedComputerList(List<RemotePushComputerObject> lstSearchCache) {
        this.lstSearchCache = lstSearchCache;
        this.searchResModel.removeAll();
        for (RemotePushComputerObject node : lstSearchCache) {
            this.searchResModel.addRow(node);
        }
    }

    protected void setEndpointType(String endpointType) {
        this.endpointType = endpointType;
    }

    @Override
    protected String getTitleDescription() {
        return MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.titleDesc");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.browseTrees = new BrowseTreePerPlatform();
        this.jLblAvailable = new JLabel(MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.available"));
        this.jLblInstall = new JLabel(MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.installProtection"));
        this.jLblHint = new JLabel(MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.hint"));
        this.jLblHintText = new JLabel(MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.hintDesc"));
        this.desc = new DescriptionTextArea(MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.description"));
        this.jLblErrorMsg = new JLabel();
        this.searchResModel = new RemotePushComputerTableModel();
        this.strUserName = "";
        this.strPassword = "";
        this.strDomainName = "";
        this.isDomain = true;
        this.isClientRemoteLaunched = false;
        this.tmpUserName = "";
        this.tmpPassword = "";
        this.tmpDomainName = "";
        this.lineNum = 0;
        this.computerList = new ArrayList<NetworkAuditComputerNode>();
        this.lastImportedItem = new ArrayList<String>();
        this.importOK = false;
        this.scanOptionObj = new ScanOptionObject();
    }

    @Override
    protected String getTitle() {
        return MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.title");
    }

    @Override
    protected JPanel getCenterPanel() {
        this.desc.setMargin(new Insets(0, 5, 0, 5));
        this.hintPanel = this.getHintPanel();
        JPanel mainPanel = new JPanel(new BorderLayout(15, 15));
        mainPanel.setOpaque(false);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(15, 25, 10, 25));
        mainPanel.add((Component)this.desc, "North");
        JPanel centerPanel = new JPanel(new GridLayout(1, 2, 10, 10));
        mainPanel.add((Component)centerPanel, "Center");
        centerPanel.setOpaque(false);
        mainPanel.add((Component)this.hintPanel, "South");
        JPanel centerLeft = new JPanel(new BorderLayout(10, 10));
        centerPanel.add(centerLeft);
        centerLeft.setOpaque(false);
        centerLeft.add((Component)this.getLeftPanel(), "Center");
        centerLeft.add((Component)this.getAddDelButtonPanel(), "East");
        centerPanel.add(this.getRightPanel());
        this.jEpErrorPane = new HTMLEditorPane();
        this.jEpErrorPane.setText(this.getErrorPaneHelpText());
        this.errPanel = new JPanel(new BorderLayout());
        this.errPanel.setPreferredSize(new Dimension(700, 85));
        this.errPanel.add((Component)this.jLblErrorMsg, "North");
        this.errPanel.add(this.jEpErrorPane);
        AdminObject.retrieveCurrentAdminObject();
        Dimension centerPanelDim = centerPanel.getPreferredSize();
        this.updateButtons();
        centerPanel.setPreferredSize(centerPanelDim);
        return mainPanel;
    }

    private JPanel getLeftPanel() {
        this.browseTrees.initJTrees();
        this.browseScrollpane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)this.browseScrollpane, (JTree)this.browseTrees.getBrowseTree());
        this.browseScrollpane.getViewport().setPreferredSize(new Dimension(200, 150));
        this.initSearchTable();
        this.searchPanel = new JPanel(new BorderLayout());
        JScrollPane scrollPanel = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scrollPanel, (JTable)((Object)this.jSearchTbl));
        scrollPanel.getViewport().setPreferredSize(new Dimension(200, 150));
        scrollPanel.setColumnHeaderView(this.jSearchTbl.getTableHeader());
        float tblWidth = (float)scrollPanel.getPreferredSize().getWidth();
        UIUtilities.resizeColumns((JTable)((Object)this.jSearchTbl), colSizes, tblWidth, false);
        this.searchPanel.add((Component)scrollPanel, "Center");
        this.jTabPane = new JTabbedPane();
        this.jTabPane.addTab(MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.browseNet"), this.browseScrollpane);
        this.jTabPane.setMnemonicAt(0, 66);
        this.jTabPane.addTab(MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.search"), this.searchPanel);
        this.jTabPane.setMnemonicAt(1, 70);
        this.jTabPane.addChangeListener(this);
        JPanel leftPanel = new JPanel(new BorderLayout(10, 10));
        leftPanel.setOpaque(false);
        JPanel linkPanel = new JPanel(new GridLayout(2, 1));
        HtmlEnabledJLabel optionAction = new HtmlEnabledJLabel(true);
        String optionActionStr = MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.icmpOptions");
        optionAction.setText(optionActionStr);
        optionAction.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                new ScanOptionDialog(new JFrame(), RemoteMethodPanel.this.scanOptionObj, true);
            }
        });
        optionAction.putClientProperty((Object)"mouseEventListener", (Object)"onClick");
        linkPanel.add(this.jLblAvailable);
        linkPanel.add((Component)optionAction);
        leftPanel.add((Component)linkPanel, "North");
        this.jLblAvailable.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        leftPanel.add((Component)this.jTabPane, "Center");
        leftPanel.add((Component)this.getFindClearButtonPanel(), "South");
        return leftPanel;
    }

    private JPanel getRightPanel() {
        this.initTable();
        this.jspSelected = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)this.jspSelected, (JTable)((Object)this.jTblSelected));
        this.jspSelected.getViewport().setPreferredSize(new Dimension(200, 150));
        this.jspSelected.setColumnHeaderView(this.jTblSelected.getTableHeader());
        float tblWidth = (float)this.jspSelected.getPreferredSize().getWidth();
        UIUtilities.resizeColumns((JTable)((Object)this.jTblSelected), colSizes, tblWidth, false);
        JPanel rightPanel = new JPanel(new BorderLayout(10, 10));
        rightPanel.setOpaque(false);
        rightPanel.add((Component)this.jLblInstall, "North");
        this.jLblInstall.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        rightPanel.add((Component)this.jspSelected, "Center");
        return rightPanel;
    }

    private JPanel getHintPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        JPanel hintPanel = new JPanel(new GridLayout(2, 1));
        JPanel msgpanel = new JPanel();
        msgpanel.setLayout(new BoxLayout(msgpanel, 0));
        msgpanel.add(this.jLblHint);
        msgpanel.add(this.jLblHintText);
        hintPanel.add(msgpanel);
        panel.add(hintPanel);
        panel.add(Box.createHorizontalStrut(25));
        ImageIcon alertIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("alertTriangle.gif")));
        JLabel warningLabel = new JLabel(MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.warningPanelMessage"));
        warningLabel.setIcon(alertIcon);
        return panel;
    }

    private JPanel getAddDelButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        this.jBtnAdd = new JButton(UIText.get(1538));
        this.jBtnAdd.setEnabled(false);
        this.jBtnAdd.addActionListener(this);
        this.jBtnDel = new JButton(UIText.get(1537));
        this.jBtnDel.setEnabled(false);
        this.jBtnDel.addActionListener(this);
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(this.jBtnAdd);
        buttonPanel.add(Box.createVerticalStrut(10));
        buttonPanel.add(this.jBtnDel);
        buttonPanel.add(Box.createGlue());
        return buttonPanel;
    }

    private JPanel getFindClearButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.jBtnFind = new JButton(MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.findComputers"));
        this.jBtnFind.addActionListener(this);
        buttonPanel.add(this.jBtnFind);
        buttonPanel.add(Box.createHorizontalStrut(10));
        this.jBtnClear = new JButton(MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.clearSearch"));
        this.jBtnClear.addActionListener(this);
        this.jBtnClear.setEnabled(this.searchResModel.getRowCount() > 0);
        buttonPanel.add(this.jBtnClear);
        this.findClearButtonPanel = buttonPanel;
        return buttonPanel;
    }

    private void initSearchTable() {
        this.searchResModel = new RemotePushComputerTableModel();
        this.jSearchTbl = new StripesTable(this.searchResModel, true, false){
            private static final long serialVersionUID = 1L;

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    jc.setToolTipText(this.getValueAt(row, column).toString());
                }
                return c;
            }
        };
        this.jSearchTbl.setRowHeight(20);
        this.jSearchTbl.getTableHeader().setReorderingAllowed(false);
        this.jSearchTbl.setAutoResizeMode(1);
        this.jSearchTbl.setCellSelectionEnabled(false);
        this.jSearchTbl.setColumnSelectionAllowed(false);
        this.jSearchTbl.setRowSelectionAllowed(true);
        this.jSearchTbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (RemoteMethodPanel.this.jSearchTbl.getSelectedRowCount() > 0) {
                    RemoteMethodPanel.this.jBtnAdd.setEnabled(true);
                }
                if (me.getClickCount() == 2) {
                    RemoteMethodPanel.this.addActionPerformed();
                }
            }
        });
        int colidxHostname = this.jSearchTbl.getColumnModel().getColumnIndex(RemotePushComputerTableModel.HOST_NAME);
        this.jSearchTbl.addMouseMotionListener(new TableHandColumnMotionListener((JTable)((Object)this.jSearchTbl), colidxHostname));
        TableColumnModel tblColModel = this.jSearchTbl.getColumnModel();
        TableColumn colHostName = this.jSearchTbl.getColumn(RemotePushComputerTableModel.HOST_NAME);
        TableColumn colStatus = this.jSearchTbl.getColumn(RemotePushComputerTableModel.DEP_STATUS);
        TableColumn colDesc = this.jSearchTbl.getColumn(RemotePushComputerTableModel.OS_DESC);
        TableColumn colbitType = this.jSearchTbl.getColumn(RemotePushComputerTableModel.BIT_TYPE);
        TableColumn colProtection = this.jSearchTbl.getColumn(RemotePushComputerTableModel.PROTECTION);
        TableColumn colProgress = this.jSearchTbl.getColumn(RemotePushComputerTableModel.PROGRESS);
        TableColumn updStatus = this.jSearchTbl.getColumn(RemotePushComputerTableModel.UPD_STATUS);
        tblColModel.removeColumn(colHostName);
        tblColModel.removeColumn(colDesc);
        tblColModel.removeColumn(colbitType);
        tblColModel.removeColumn(colStatus);
        tblColModel.removeColumn(colProtection);
        tblColModel.removeColumn(colProgress);
        tblColModel.removeColumn(updStatus);
        this.searchResModel.addMouseListenerToHeaderInTable((JTable)((Object)this.jSearchTbl));
        TableColumn colComputerHostName = this.jSearchTbl.getColumn(RemotePushComputerTableModel.COMPUTER_HOST_NAME);
        colComputerHostName.setCellRenderer(new RemotePushComputerRenderer(false));
    }

    private void initTable() {
        this.selectedModel = new RemotePushComputerTableModel();
        this.jTblSelected = new StripesTable(this.selectedModel, true, false);
        final int COL_IDX_HOST_NAME = this.jTblSelected.getColumnModel().getColumnIndex(RemotePushComputerTableModel.HOST_NAME);
        this.jTblSelected.setRowHeight(20);
        this.jTblSelected.getTableHeader().setReorderingAllowed(false);
        this.jTblSelected.setAutoResizeMode(1);
        this.jTblSelected.setCellSelectionEnabled(false);
        this.jTblSelected.setColumnSelectionAllowed(false);
        this.jTblSelected.setRowSelectionAllowed(true);
        this.jTblSelected.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                int col = RemoteMethodPanel.this.jTblSelected.getSelectedColumn();
                int row = RemoteMethodPanel.this.jTblSelected.getSelectedRow();
                if (col == COL_IDX_HOST_NAME) {
                    RemotePushComputerObject entry = (RemotePushComputerObject)RemoteMethodPanel.this.selectedModel.getRow(row);
                    new RemotePushComputerInfoDlg(entry, Manager.getFrame(), MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemotePushComputerInfoDlg.title"), true);
                }
                if (RemoteMethodPanel.this.jTblSelected.getSelectedRowCount() > 0) {
                    RemoteMethodPanel.this.jBtnDel.setEnabled(true);
                }
                if (me.getClickCount() == 2) {
                    RemoteMethodPanel.this.deleteFromList();
                }
            }
        });
        this.jTblSelected.addMouseMotionListener(new TableHandColumnMotionListener((JTable)((Object)this.jTblSelected), COL_IDX_HOST_NAME));
        TableColumnModel tblColModel = this.jTblSelected.getColumnModel();
        TableColumn colCompterHostName = this.jTblSelected.getColumn(RemotePushComputerTableModel.COMPUTER_HOST_NAME);
        TableColumn colStatus = this.jTblSelected.getColumn(RemotePushComputerTableModel.DEP_STATUS);
        TableColumn colDesc = this.jTblSelected.getColumn(RemotePushComputerTableModel.OS_DESC);
        TableColumn colIPAddr = this.jTblSelected.getColumn(RemotePushComputerTableModel.IP_ADDR);
        TableColumn colProgress = this.jTblSelected.getColumn(RemotePushComputerTableModel.PROGRESS);
        TableColumn updStatus = this.jTblSelected.getColumn(RemotePushComputerTableModel.UPD_STATUS);
        tblColModel.removeColumn(colCompterHostName);
        tblColModel.removeColumn(colStatus);
        tblColModel.removeColumn(colDesc);
        tblColModel.removeColumn(colIPAddr);
        tblColModel.removeColumn(colProgress);
        tblColModel.removeColumn(updStatus);
        this.selectedModel.addMouseListenerToHeaderInTable((JTable)((Object)this.jTblSelected));
        TableColumn colHostName = this.jTblSelected.getColumn(RemotePushComputerTableModel.HOST_NAME);
        colHostName.setCellRenderer(new RemotePushComputerRenderer(true));
    }

    public boolean isClientRemoteLaunched() {
        return this.isClientRemoteLaunched;
    }

    private NameValuePair createNameValuePair(String name, String value) {
        NameValuePair pair = new NameValuePair();
        pair.setName(name);
        pair.setOptValue(value);
        return pair;
    }

    private boolean isRealResponse(String line) {
        return (line = line.trim()).length() != 0;
    }

    private String getErrorMessageInResponse(String line) {
        String msg = null;
        if ((line = line.trim()).length() > 0 && line.contains("<error>")) {
            msg = line.substring(line.indexOf("<error>") + "<error>".length(), line.indexOf("</error>"));
        }
        return msg;
    }

    private String getTreePath(TreePath path) {
        Object[] elements = path.getPath();
        StringBuffer strBuffer = new StringBuffer("\\\\");
        int n = elements.length;
        for (int i = 0; i < n; ++i) {
            strBuffer.append(elements[i]);
            if (i >= n - 1) continue;
            strBuffer.append("\\");
        }
        return strBuffer.toString();
    }

    private void updateBrowseTree(DefaultMutableTreeNode resultsNode, BrowseTreeNode treeNode, DefaultTreeModel workingTreeModel) {
        if (resultsNode == null || treeNode == null) {
            return;
        }
        for (int i = 0; i < resultsNode.getChildCount(); ++i) {
            DefaultMutableTreeNode resultsChild = (DefaultMutableTreeNode)resultsNode.getChildAt(i);
            BrowseTreeNode treeChild = null;
            if (treeNode.isExplored()) {
                for (int j = 0; j < treeNode.getChildCount() && treeChild == null; ++j) {
                    BrowseTreeNode tempChild = (BrowseTreeNode)treeNode.getChildAt(j);
                    if (!resultsChild.toString().equals(tempChild.toString())) continue;
                    treeChild = tempChild;
                }
            }
            if (treeChild == null) {
                treeChild = new BrowseTreeNode(resultsChild.getUserObject());
                if (treeChild.getUserObject() instanceof NetworkAuditComputerNode) {
                    treeChild.setExplored(true);
                }
                if (!treeNode.isExplored()) {
                    treeNode.setExplored(true);
                    workingTreeModel.nodesWereRemoved(treeNode, new int[]{0}, new Object[]{treeNode.dummyChild});
                }
                treeNode.add(treeChild);
                workingTreeModel.nodesWereInserted(treeNode, new int[]{treeNode.getIndex(treeChild)});
            }
            this.updateBrowseTree(resultsChild, treeChild, workingTreeModel);
        }
    }

    private boolean isServerNode(DefaultMutableTreeNode selectedNode) {
        return selectedNode != null && !selectedNode.isRoot() && selectedNode.getUserObject() instanceof NetworkAuditComputerNode;
    }

    private void populateBrowseTree(String data, DefaultMutableTreeNode selectedNode, BrowseTreeNode workingTreeRoot, DefaultTreeModel workingTreeModel) throws NetworkBrowseException {
        if (data == null) {
            return;
        }
        if ((data = data.trim()).length() == 0) {
            return;
        }
        NetworkParser instance = NetworkParser.getInstance();
        ArrayList<Network> networks = instance.parse(data);
        DefaultMutableTreeNode resultsRoot = new DefaultMutableTreeNode(rootNodeName);
        TreeNodeGenerator nodeCreator = TreeNodeGenerator.getInstance();
        for (Network network : networks) {
            nodeCreator.getChildNode(resultsRoot, network);
        }
        if (resultsRoot.getChildCount() >= 1) {
            if ("Windows".equalsIgnoreCase(this.endpointType)) {
                DefaultMutableTreeNode mwn = null;
                String mwnName = MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.MicrosoftWindowsNetwork");
                int childCount = resultsRoot.getChildCount();
                for (int i = 0; i < childCount && mwn == null; ++i) {
                    if (!((DefaultMutableTreeNode)resultsRoot.getChildAt(i)).toString().equals(mwnName)) continue;
                    mwn = (DefaultMutableTreeNode)resultsRoot.getChildAt(i);
                }
                if (mwn != null) {
                    resultsRoot.removeAllChildren();
                    resultsRoot.add(mwn);
                }
            } else if ("Mac".equalsIgnoreCase(this.endpointType)) {
                DefaultMutableTreeNode macn = null;
                String macnName = MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.MacBonjourNetwork");
                int childCount = resultsRoot.getChildCount();
                for (int i = 0; i < childCount && macn == null; ++i) {
                    if (!((DefaultMutableTreeNode)resultsRoot.getChildAt(i)).toString().equals(macnName)) continue;
                    macn = (DefaultMutableTreeNode)resultsRoot.getChildAt(i);
                }
                if (macn != null) {
                    resultsRoot.removeAllChildren();
                    resultsRoot.add(macn);
                }
            }
        }
        this.updateBrowseTree(resultsRoot, workingTreeRoot, workingTreeModel);
    }

    public void getNetworkData(final String sNodePath, final BrowseTreeNode selectedNode, final boolean expandChild) {
        final StringBuffer buffer = new StringBuffer();
        this.isClientRemoteLaunched = true;
        com.sygate.scm.util.SwingWorker worker = new com.sygate.scm.util.SwingWorker(){
            BrowseTreeNode workingTreeRoot;
            JTree workingTree;
            DefaultTreeModel workingTreeModel;
            {
                this.workingTreeRoot = RemoteMethodPanel.this.browseTrees.getRootTreeNode();
                this.workingTree = RemoteMethodPanel.this.browseTrees.getBrowseTree();
                this.workingTreeModel = RemoteMethodPanel.this.browseTrees.getBrowseTreeModel();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                BufferedReader reader = null;
                try {
                    KeepAlive.suspend();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (RemoteMethodPanel.this.browseProgDlgref == null) {
                                RemoteMethodPanel.this.browseProgDlgref = new BrowseProgressDialog(Manager.getFrame(), MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.browseProcessTitle"), MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.browseProcessDesc"), true, sNodePath);
                            }
                            RemoteMethodPanel.this.browseProgDlgref.setVisible(true);
                        }
                    });
                    String strNodePath = sNodePath == null ? "\\\\Entire Network" : sNodePath;
                    RpcData data = new RpcData();
                    data.addNameValuePair(RemoteMethodPanel.this.createNameValuePair("BROWSE_PATH", strNodePath));
                    if ("Windows".equalsIgnoreCase(RemoteMethodPanel.this.endpointType)) {
                        data.addNameValuePair(RemoteMethodPanel.this.createNameValuePair("BROWSE", "BROWSE_WIN"));
                    } else if ("Mac".equalsIgnoreCase(RemoteMethodPanel.this.endpointType)) {
                        data.addNameValuePair(RemoteMethodPanel.this.createNameValuePair("BROWSE", "BROWSE_MAC"));
                    }
                    if (RemoteMethodPanel.this.scanOptionObj != null) {
                        data.addNameValuePair(RemoteMethodPanel.this.createNameValuePair("PINGTIMEOUT", RemoteMethodPanel.this.scanOptionObj.getIcmpTimeout()));
                    }
                    reader = new BufferedReader(new InputStreamReader(GUIManager.getInputStreamForAction(data, "BrowseNetwork"), "UTF-8"));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        if (!RemoteMethodPanel.this.isRealResponse(line)) continue;
                        String errormsg = RemoteMethodPanel.this.getErrorMessageInResponse(line);
                        if (errormsg != null) {
                            if ("Mac".equalsIgnoreCase(RemoteMethodPanel.this.endpointType)) {
                                BrowseTreeNode rootNode = (BrowseTreeNode)this.workingTreeModel.getRoot();
                                if (null == rootNode) break;
                                DefaultMutableTreeNode childNode = rootNode.dummyChild;
                                if (null != childNode) {
                                    childNode.setUserObject(errormsg);
                                }
                                this.workingTreeModel.reload(childNode);
                                break;
                            }
                            String title = MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.ErrorBrowsingTitle");
                            UIUtilities.showErrorDialog(errormsg, title);
                            break;
                        }
                        buffer.append(line);
                    }
                    System.out.println("*************Client Side**********" + buffer.toString());
                    String string = buffer.toString();
                    return string;
                }
                catch (IOException e) {
                    LoggerUtilities.logException((Throwable)e);
                }
                catch (ConsoleException e) {
                    RemoteMethodPanel.this.handleException(e);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {}
                    }
                    KeepAlive.resume();
                }
                return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
            }

            public void finished() {
                block8: {
                    try {
                        RemoteMethodPanel.this.populateBrowseTree(buffer.toString(), selectedNode, this.workingTreeRoot, this.workingTreeModel);
                    }
                    catch (NetworkBrowseException wne) {
                        if (RemoteMethodPanel.this.browseProgDlgref == null || RemoteMethodPanel.this.browseProgDlgref.isCancelled()) break block8;
                        RemoteMethodPanel.this.setProgressVisible(RemoteMethodPanel.this.browseProgDlgref, false);
                        JOptionPane.showMessageDialog(Manager.getFrame(), wne.getMessage(), MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.error"), 0);
                    }
                }
                if (expandChild && selectedNode.isExplored() && selectedNode.getChildCount() > 0) {
                    try {
                        this.workingTree.expandPath(new TreePath(this.workingTreeModel.getPathToRoot(selectedNode.getChildAt(0))));
                    }
                    catch (Exception e) {
                        if (RemoteMethodPanel.this.browseProgDlgref != null) {
                            RemoteMethodPanel.this.browseProgDlgref.dispose();
                        }
                    }
                } else if (RemoteMethodPanel.this.browseProgDlgref != null) {
                    RemoteMethodPanel.this.browseProgDlgref.dispose();
                }
            }
        };
        worker.start();
    }

    public void cancelBrowseRequest(String sNodePath) {
        if (sNodePath == null) {
            sNodePath = "\\\\Entire Network";
        }
        try {
            RpcData data = new RpcData();
            data.addNameValuePair(this.createNameValuePair("BROWSE_PATH", sNodePath));
            data.addNameValuePair(this.createNameValuePair("BROWSE", "CANCEL"));
            GUIManager.getInputStreamForAction(data, "BrowseNetwork");
        }
        catch (ConsoleException e) {
            this.handleException(e);
        }
    }

    public void stopBrowseRequest() {
        try {
            RpcData data = new RpcData();
            data.addNameValuePair(this.createNameValuePair("BROWSE", "STOP"));
            GUIManager.getInputStreamForAction(data, "BrowseNetwork");
        }
        catch (ConsoleException e) {
            this.handleException(e);
        }
    }

    public void initBrowseNetworkTree() {
        this.initializeData();
        if (this.browseScrollpane != null) {
            this.browseScrollpane.getViewport().add(this.browseTrees.getBrowseTree());
        }
        if (!this.browseTrees.getRootTreeNode().isExplored()) {
            TreePath path = new TreePath(this.browseTrees.getRootTreeNode());
            boolean expandChild = true;
            if ("Mac".equalsIgnoreCase(this.endpointType)) {
                expandChild = false;
            }
            this.getNetworkData(this.getTreePath(path), this.browseTrees.getRootTreeNode(), expandChild);
        }
    }

    private NetworkAuditComputerNode getFirstComputerFromDomain(DefaultMutableTreeNode parentNode) {
        DefaultMutableTreeNode childnode = null;
        NetworkAuditComputerNode entry = null;
        try {
            for (int j = 0; j < parentNode.getChildCount(); ++j) {
                childnode = (DefaultMutableTreeNode)parentNode.getChildAt(j);
                if (!childnode.isLeaf() && childnode.getUserObject() instanceof Domain) {
                    entry = this.getFirstComputerFromDomain(childnode);
                    break;
                }
                if (childnode.getUserObject() instanceof NetworkAuditComputerNode) {
                    entry = (NetworkAuditComputerNode)childnode.getUserObject();
                    break;
                }
                System.out.println("Can not add Workgroup or Network");
            }
        }
        catch (ClassCastException ce) {
            LoggerUtilities.logException((Throwable)ce);
        }
        return entry;
    }

    private List<NetworkAuditComputerNode> addChildForDomain(DefaultMutableTreeNode parentNode) {
        ArrayList<NetworkAuditComputerNode> results = new ArrayList<NetworkAuditComputerNode>();
        DefaultMutableTreeNode childnode = null;
        NetworkAuditComputerNode entry = null;
        try {
            for (int j = 0; j < parentNode.getChildCount(); ++j) {
                childnode = (DefaultMutableTreeNode)parentNode.getChildAt(j);
                if (!childnode.isLeaf() && childnode.getUserObject() instanceof Domain) {
                    this.addChildForDomain(childnode);
                    continue;
                }
                if (childnode.getUserObject() instanceof NetworkAuditComputerNode) {
                    entry = (NetworkAuditComputerNode)childnode.getUserObject();
                    results.add(entry);
                    continue;
                }
                System.out.println("Can not add Workgroup or Network");
            }
        }
        catch (ClassCastException ce) {
            LoggerUtilities.logException((Throwable)ce);
        }
        return results;
    }

    private void addActionPerformed() {
        NetworkAuditComputerNode entry = null;
        this.hostsToAdd = new ArrayList();
        if (this.jTabPane.getSelectedIndex() == 0) {
            TreePath[] selectedNodes = this.browseTrees.getBrowseTree().getSelectionPaths();
            for (int i = 0; i < selectedNodes.length; ++i) {
                System.out.println(((DefaultMutableTreeNode)selectedNodes[i].getLastPathComponent()).getUserObject());
                try {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedNodes[i].getLastPathComponent();
                    if (!node.isRoot() && node.isLeaf() && node.getUserObject() instanceof NetworkAuditComputerNode) {
                        entry = (NetworkAuditComputerNode)node.getUserObject();
                        if (this.isDuplicateSelectEntry(entry)) continue;
                        this.hostsToAdd.add(entry);
                        continue;
                    }
                    if (node.isRoot() || !(node.getUserObject() instanceof Domain) || this.isDuplicateSelectEntry(entry = this.getFirstComputerFromDomain(node))) continue;
                    this.hostsToAdd.addAll(this.addChildForDomain(node));
                    continue;
                }
                catch (ClassCastException ce) {
                    LoggerUtilities.logException((Throwable)ce);
                }
            }
        } else if (this.jTabPane.getSelectedIndex() == 1) {
            int[] arrSelected = this.jSearchTbl.getSelectedRows();
            for (int i = arrSelected.length - 1; i >= 0; --i) {
                try {
                    RemotePushComputerObject selecctedEntry = (RemotePushComputerObject)this.searchResModel.getRow(arrSelected[i]);
                    entry = selecctedEntry.getComputerNode();
                    this.hostsToAdd.add(entry);
                    continue;
                }
                catch (ClassCastException ce) {
                    LoggerUtilities.logException((Throwable)ce);
                }
            }
        }
        this.selectHosts(this.hostsToAdd);
    }

    private void selectHosts(final List<NetworkAuditComputerNode> hosts) {
        if (hosts.size() <= 0) {
            return;
        }
        com.sygate.scm.util.SwingWorker worker = new com.sygate.scm.util.SwingWorker(){
            private Exception ex = null;
            private boolean cancel;
            LoginListener listener;

            public Object construct() {
                RemoteMethodPanel.this.progress = new SimpleProgressDlg(Manager.getFrame(), MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.selectProcessTitle"), MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.selectProcessDesc"), true){
                    private static final long serialVersionUID = 1L;

                    public void cancel() {
                        System.out.println("User canceled login progress.");
                        cancel = true;
                        this.setProgressMessage(MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.selectProcessCancel"));
                        this.setCancelEnabled(false);
                        listener.cancel = true;
                        super.cancel();
                    }
                };
                RemoteMethodPanel.this.progress.setCancelEnabled(true);
                RemoteMethodPanel.this.progress.setCancelVisible(true);
                RemoteMethodPanel.this.progress.addWindowListener((WindowListener)new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        RemoteMethodPanel.this.progress.cancel();
                    }
                });
                String progressMsg = MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.selectProcessMsg");
                RemoteMethodPanel.this.strUserName = null;
                boolean isAnyFailedConnection = false;
                int numberOfHosts = hosts.size();
                int successfullConnection = 0;
                boolean shouldInterrupt = false;
                for (NetworkAuditComputerNode host : hosts) {
                    String strHostNameIP;
                    if (RemoteMethodPanel.this.strUserName == null || RemoteMethodPanel.this.strUserName.trim().length() == 0) {
                        RemoteMethodPanel.this.setProgressVisible(RemoteMethodPanel.this.progress, false);
                        LoginInfoDlg loginDlg = new LoginInfoDlg(Manager.getFrame(), MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "LoginDlg.title"), true, RemoteMethodPanel.this.tmpUserName, RemoteMethodPanel.this.tmpPassword, RemoteMethodPanel.this.tmpDomainName, host.getDisplayString(), RemoteMethodPanel.this.isTmpDomain, RemoteMethodPanel.this.bCommunictaionSetting, RemoteMethodPanel.this.endpointType);
                        if (!loginDlg.isOk()) {
                            System.out.println("User cancelled login screen.");
                            RemoteMethodPanel.this.tmpUserName = "";
                            RemoteMethodPanel.this.tmpPassword = "";
                            RemoteMethodPanel.this.tmpDomainName = "";
                            RemoteMethodPanel.this.isTmpDomain = true;
                            continue;
                        }
                        RemoteMethodPanel.this.tmpDomainName = loginDlg.getDomain();
                        RemoteMethodPanel.this.tmpPassword = loginDlg.getPassword();
                        RemoteMethodPanel.this.tmpUserName = loginDlg.getUserName();
                        RemoteMethodPanel.this.isTmpDomain = loginDlg.isDomain();
                    }
                    System.out.println("Adding host " + host.getDisplayString());
                    if (RemoteMethodPanel.this.progress != null) {
                        RemoteMethodPanel.this.progress.setProgressMessage(MessageFormat.format(progressMsg, host.getDisplayString()));
                    }
                    RemoteMethodPanel.this.setProgressVisible(RemoteMethodPanel.this.progress, true);
                    boolean domain = RemoteMethodPanel.this.isDomain;
                    String userName = RemoteMethodPanel.this.strUserName;
                    String password = RemoteMethodPanel.this.strPassword;
                    String domainName = RemoteMethodPanel.this.strDomainName;
                    if (RemoteMethodPanel.this.strUserName == null || "".equals(RemoteMethodPanel.this.strUserName)) {
                        domain = RemoteMethodPanel.this.isTmpDomain;
                        userName = RemoteMethodPanel.this.tmpUserName;
                        password = RemoteMethodPanel.this.tmpPassword;
                        domainName = RemoteMethodPanel.this.tmpDomainName;
                    }
                    if ((strHostNameIP = host.getIP()) == null || strHostNameIP.trim().length() == 0) {
                        strHostNameIP = host.getHostName();
                    }
                    NetworkAuditSearchParams params = new NetworkAuditSearchParams(domain, strHostNameIP, userName, password, domainName, null, RemoteMethodPanel.this.endpointType);
                    params.setKnownHostsFileName(RemoteMethodPanel.this.getWizard().getKnownHostsFileName());
                    this.listener = new LoginListener(params);
                    RemoteMethodPanel.this.loginComm = new NetworkAuditCommunicator(1, params, this.listener, "CIW");
                    try {
                        RemoteMethodPanel.this.loginComm.sendRequest();
                    }
                    catch (ConsoleException e) {
                        this.ex = e;
                        return null;
                    }
                    RemoteMethodPanel.this.isDomain = domain;
                    RemoteMethodPanel.this.strUserName = userName;
                    RemoteMethodPanel.this.strPassword = password;
                    RemoteMethodPanel.this.strDomainName = domainName;
                    if (!this.listener.isSuccess) {
                        shouldInterrupt = RemoteMethodPanel.this.isFlowNeedToBeIntruppted(RemoteMethodPanel.this.loginComm, numberOfHosts, this.cancel, RemoteMethodPanel.this.strDomainName.isEmpty());
                        if (!shouldInterrupt) continue;
                        JOptionPane.showMessageDialog(Manager.getFrame(), RemoteMethodPanel.this.loginComm.getMessage(), MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.error"), 0);
                        break;
                    }
                    ++successfullConnection;
                    while (!this.cancel && !this.listener.isSuccess) {
                        RemoteMethodPanel.this.setProgressVisible(RemoteMethodPanel.this.progress, false);
                        final String strErrMessage = MessageFormat.format(STR_LOGIN_ERROR_MSG, host.getDisplayString());
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                RemoteMethodPanel.this.jLblErrorMsg.setText(strErrMessage);
                            }
                        });
                        RemoteMethodPanel.this.errPanel.revalidate();
                        JOptionPane.showMessageDialog(Manager.getFrame(), RemoteMethodPanel.this.errPanel, MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.error"), 0);
                        LoginInfoDlg loginDlg = new LoginInfoDlg(Manager.getFrame(), MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "LoginDlg.title"), true, userName, password, domainName, host.getDisplayString(), domain, RemoteMethodPanel.this.bCommunictaionSetting, RemoteMethodPanel.this.endpointType);
                        if (!loginDlg.isOk()) {
                            System.out.println("User cancelled login screen.");
                            RemoteMethodPanel.this.tmpUserName = "";
                            RemoteMethodPanel.this.tmpPassword = "";
                            RemoteMethodPanel.this.tmpDomainName = "";
                            RemoteMethodPanel.this.isTmpDomain = true;
                            break;
                        }
                        RemoteMethodPanel.this.setProgressVisible(RemoteMethodPanel.this.progress, true);
                        domainName = loginDlg.getDomain();
                        password = loginDlg.getPassword();
                        userName = loginDlg.getUserName();
                        domain = loginDlg.isDomain();
                        String strRetryHostNameIP = host.getIP();
                        if (strRetryHostNameIP == null || strRetryHostNameIP.trim().length() == 0) {
                            strRetryHostNameIP = host.getHostName();
                        }
                        params = new NetworkAuditSearchParams(RemoteMethodPanel.this.isDomain, strRetryHostNameIP, userName, password, domainName, null, RemoteMethodPanel.this.endpointType);
                        params.setKnownHostsFileName(RemoteMethodPanel.this.getWizard().getKnownHostsFileName());
                        this.listener = new LoginListener(params);
                        RemoteMethodPanel.this.loginComm = new NetworkAuditCommunicator(1, params, this.listener, "CIW");
                        try {
                            RemoteMethodPanel.this.loginComm.sendRequest();
                        }
                        catch (ConsoleException e) {
                            this.ex = e;
                            return null;
                        }
                    }
                    if (this.cancel) {
                        return null;
                    }
                    if (!this.listener.isSuccess()) continue;
                    RemoteMethodPanel.this.isDomain = domain;
                    RemoteMethodPanel.this.strUserName = userName;
                    RemoteMethodPanel.this.strPassword = password;
                    RemoteMethodPanel.this.strDomainName = domainName;
                    System.out.println("RemoteMethodPanel>> Last successful credentials updated.");
                }
                if (numberOfHosts > 0 && successfullConnection < numberOfHosts && !shouldInterrupt) {
                    String strMessage = null;
                    if (hosts.size() > 1) {
                        strMessage = MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.connectionFailMsgForMultiClient");
                        JOptionPane.showMessageDialog(Manager.getFrame(), strMessage, MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.error"), 0);
                    }
                }
                return null;
            }

            public void finished() {
                if (RemoteMethodPanel.this.progress != null) {
                    RemoteMethodPanel.this.progress.dispose();
                }
                if (this.ex != null) {
                    RemoteMethodPanel.this.handleException(this.ex);
                    return;
                }
            }
        };
        worker.start();
    }

    private boolean isFlowNeedToBeIntruppted(NetworkAuditCommunicator loginComm, int numberOfHosts, boolean cancel, boolean isDomainEmpty) {
        String genericMessageForSingleComputer = MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.connectionFailMsgForSingleClientGenericMessage");
        String strMessage = MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.stopTestingConnection");
        strMessage = MessageFormat.format(strMessage, this.strDomainName);
        boolean response = false;
        if (numberOfHosts == 1) {
            loginComm.setMessage(genericMessageForSingleComputer);
            response = true;
        } else if (numberOfHosts > 1 && !isDomainEmpty) {
            response = true;
            loginComm.setMessage(strMessage);
        }
        return response;
    }

    private boolean isDuplicateSelectEntry(NetworkAuditComputerNode entry) {
        for (RemotePushComputerObject node : this.selectedModel.getData()) {
            if (!node.getComputerNode().equals(entry)) continue;
            return true;
        }
        return false;
    }

    private boolean isDuplicateSearchEntry(NetworkAuditComputerNode entry) {
        for (RemotePushComputerObject node : this.searchResModel.getData()) {
            if (!node.getComputerNode().equals(entry)) continue;
            return true;
        }
        return false;
    }

    private boolean isDuplicateInAvailableListForRemotePush(RemotePushComputerObject entry) {
        for (RemotePushComputerObject node : this.searchResModel.getData()) {
            if (!node.equals(entry)) continue;
            return true;
        }
        return false;
    }

    private void deleteFromList() {
        int[] arrSelected = this.jTblSelected.getSelectedRows();
        for (int i = arrSelected.length - 1; i >= 0; --i) {
            TableRow obj = this.selectedModel.getRow(arrSelected[i]);
            this.selectedModel.removeRow(arrSelected[i]);
            boolean isPresent = this.isDuplicateInAvailableListForRemotePush((RemotePushComputerObject)obj);
            if (!isPresent) {
                this.searchResModel.addRow(obj);
            }
            if (arrSelected[i] <= 0) continue;
            Object value = this.selectedModel.getValueAt(0, this.jTblSelected.getEditingColumn());
            this.jTblSelected.setEditingRow(0);
        }
        this.updateButtons();
    }

    private void clearSearchResults() {
        this.searchResModel.removeAll();
        this.lstSearchCache.clear();
        this.updateButtons();
    }

    private void clearEntryFromSearchResults(RemotePushComputerObject entry) {
        boolean removeResult = this.searchResModel.getDataVector().remove(entry);
        if (!removeResult) {
            NetworkAuditComputerNode nodeWithEmptyIP = new NetworkAuditComputerNode("", entry.getComputerNode().getHostName());
            NetworkAuditComputerNode nodeWithEmptyHostName = new NetworkAuditComputerNode(entry.getComputerNode().getIP(), "");
            RemotePushComputerObject rpcObjectEmptyIP = new RemotePushComputerObject(null, nodeWithEmptyIP, null, null, null, null);
            RemotePushComputerObject rpcObjectEmptyHostName = new RemotePushComputerObject(null, nodeWithEmptyHostName, null, null, null, null);
            if (!this.searchResModel.getDataVector().remove(rpcObjectEmptyIP)) {
                this.searchResModel.getDataVector().remove(rpcObjectEmptyHostName);
            }
        }
        this.lstSearchCache.clear();
        this.searchResModel.fireTableDataChanged();
        this.updateButtons();
    }

    private void showSearchDlg() {
        if (this.searchDlg == null) {
            this.searchDlg = new SearchByDlg(Manager.getFrame(), MSGRES.getString(CLIENTDIALOG, "SearchByDlg.title"), true);
        }
        this.searchDlg.setVisible(true);
        boolean issearchDlgOK = this.searchDlg.isOk();
        if (issearchDlgOK) {
            if (this.searchDlg.isSearchByImport()) {
                this.computerListFile = this.searchDlg.getComputerListFileName();
                this.importComputerListFile(this.computerListFile);
                return;
            }
            if (this.jTabPane.getTabCount() == 2) {
                this.jTabPane.setSelectedComponent(this.searchPanel);
            }
            this.searchParams = this.prepareSearchParams();
            this.searchListener = new SearchListener();
            this.searchComm = new NetworkAuditCommunicator(1, this.searchParams, this.searchListener, "CIW");
            com.sygate.scm.util.SwingWorker worker = new com.sygate.scm.util.SwingWorker(){
                private Exception ex = null;

                public Object construct() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RemoteMethodPanel.this.searchProgDlg = new SearchProgressDialog(Manager.getFrame(), MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.scanProcessTitle"), MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.scanProcessDesc"), true, RemoteMethodPanel.this.searchComm);
                            RemoteMethodPanel.this.searchProgDlg.setVisible(true);
                        }
                    });
                    try {
                        RemoteMethodPanel.this.searchComm.sendRequest();
                    }
                    catch (ConsoleException e) {
                        this.ex = e;
                    }
                    return null;
                }

                public void finished() {
                    if (RemoteMethodPanel.this.searchProgDlg != null) {
                        RemoteMethodPanel.this.searchProgDlg.dispose();
                    }
                    if (this.ex != null) {
                        RemoteMethodPanel.this.handleException(this.ex);
                        return;
                    }
                    if (!RemoteMethodPanel.this.searchListener.isEntryFound()) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.searchReturnedNoResults"), MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.error"), 0);
                    } else if (RemoteMethodPanel.this.searchListener.isDuplicate()) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.searchReturnedDupResults"), MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.error"), 0);
                    }
                }
            };
            worker.start();
        }
        this.searchDlg.resetSearchByDlg(issearchDlgOK);
    }

    private NetworkAuditSearchParams prepareSearchParams() {
        ScanOptionObject scanOption;
        try {
            scanOption = this.scanOptionObj.clone();
            scanOption.setContinueAudit(false);
        }
        catch (CloneNotSupportedException cnse) {
            LoggerUtilities.logException((Throwable)cnse);
            scanOption = this.scanOptionObj;
        }
        if (this.searchDlg.isSearchByRange()) {
            return new NetworkAuditSearchParams(true, this.searchDlg.getFromIp(), this.searchDlg.getToIp(), null, null, null, scanOption, this.endpointType);
        }
        String hostName = this.searchDlg.getComputerName();
        if (hostName.compareToIgnoreCase("127.0.0.1") == 0 || hostName.compareToIgnoreCase("localhost") == 0) {
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                LoggerUtilities.logException((Throwable)e);
            }
        }
        return new NetworkAuditSearchParams(true, hostName, null, null, null, scanOption, this.endpointType);
    }

    public Vector<RemotePushComputerObject> getSearchEntries() {
        if (this.searchResModel != null) {
            return this.searchResModel.getData();
        }
        return null;
    }

    public Vector<RemotePushComputerObject> getSelectedComputers() {
        if (this.selectedModel != null) {
            return this.selectedModel.getData();
        }
        return null;
    }

    private void updateButtons() {
        if (this.jTabPane.getSelectedIndex() == 0) {
            boolean hasSelection;
            boolean bl = hasSelection = this.browseTrees.getBrowseTree() != null && this.browseTrees.getBrowseTree().getSelectionCount() > 0;
            if (hasSelection) {
                boolean hasClientSelection = true;
                TreePath[] paths = this.browseTrees.getBrowseTree().getSelectionPaths();
                if (paths != null && paths.length > 0) {
                    for (TreePath path : paths) {
                        BrowseTreeNode node;
                        if (!(path.getLastPathComponent() instanceof BrowseTreeNode) || (node = (BrowseTreeNode)path.getLastPathComponent()).getUserObject() instanceof NetworkAuditComputerNode) continue;
                        hasClientSelection = false;
                        break;
                    }
                    this.jBtnAdd.setEnabled(hasClientSelection);
                } else {
                    this.jBtnAdd.setEnabled(false);
                }
            } else {
                this.jBtnAdd.setEnabled(false);
            }
            this.findClearButtonPanel.setVisible(false);
        } else {
            this.jBtnAdd.setEnabled(this.jSearchTbl != null && this.jSearchTbl.getRowCount() > 0);
            this.findClearButtonPanel.setVisible(true);
            this.jBtnClear.setEnabled(this.searchResModel != null && this.searchResModel.getRowCount() > 0);
        }
        this.jBtnDel.setEnabled(this.jTblSelected != null && this.jTblSelected.getSelectedRowCount() > 0);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel searchTableListSelectionModel = this.jSearchTbl.getSelectionModel();
        if (e.getSource().equals(searchTableListSelectionModel)) {
            this.updateButtons();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.jBtnAdd)) {
            this.addActionPerformed();
        } else if (e.getSource().equals(this.jBtnDel)) {
            this.deleteFromList();
        } else if (e.getSource().equals(this.jBtnFind)) {
            this.showSearchDlg();
        } else if (e.getSource().equals(this.jBtnClear)) {
            this.clearSearchResults();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        if (event.getSource().equals(this.browseTrees.getBrowseTree())) {
            this.updateButtons();
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) {
        TreePath path;
        BrowseTreeNode selectedNode;
        if (event.getSource().equals(this.browseTrees.getBrowseTree()) && (selectedNode = (BrowseTreeNode)(path = event.getPath()).getLastPathComponent()).equals(this.browseTrees.getRootTreeNode()) && selectedNode.isExplored()) {
            selectedNode.removeAllChildren();
            this.browseTrees.getBrowseTreeModel().nodeStructureChanged(selectedNode);
            selectedNode.setExplored(false);
            this.browseTrees.getBrowseTreeModel().nodesWereInserted(selectedNode, new int[]{0});
        }
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) {
        TreePath path;
        BrowseTreeNode selectedNode;
        if (event.getSource().equals(this.browseTrees.getBrowseTree()) && !(selectedNode = (BrowseTreeNode)(path = event.getPath()).getLastPathComponent()).isExplored()) {
            selectedNode.setExplored(true);
            this.browseTrees.getBrowseTreeModel().nodesWereRemoved(selectedNode, new int[]{0}, new Object[]{selectedNode.dummyChild});
            if (!this.isServerNode(selectedNode)) {
                String nodePath = this.getTreePath(event.getPath());
                this.getNetworkData(nodePath, selectedNode, false);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource().equals(this.jTabPane)) {
            this.updateButtons();
        }
    }

    public boolean validatePanel(boolean isRemotePushSylink) throws GUICheckException {
        boolean isValid = true;
        if (this.jTblSelected == null || this.jTblSelected.getRowCount() <= 0) {
            throw new GUICheckException(MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.errorNoComputer"));
        }
        if (!this.isSMB() && !isRemotePushSylink) {
            isValid = isValid && this.hostsValidated();
        }
        if (isValid && !isRemotePushSylink) {
            isValid = this.verifyIfHostUpdatable();
        }
        return isValid;
    }

    private boolean verifyIfHostUpdatable() {
        boolean isValid = true;
        try {
            CurrentPackageObject packageObj = this.getWizard().getSelectedPackage().get(0);
            Vector<RemotePushComputerObject> hosts = this.getSelectedComputers();
            for (int i = 0; i < hosts.size(); ++i) {
                RemotePushComputerObject obj = hosts.elementAt(i);
                boolean bl = isValid = !RemoteDeploymentHelper.isLatestVersionAlreadyInstalled(packageObj, obj);
                if (isValid) continue;
                String strMessage = MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.errorLatestSEPInstalled");
                strMessage = MessageFormat.format(strMessage, obj.getComputerNode().getDisplayString());
                JOptionPane.showMessageDialog(null, strMessage, MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.selectProcessTitle"), 0);
                break;
            }
        }
        catch (Exception e) {
            ConsoleLogger.log("Exception while verifying the version of installed host");
            ConsoleLogger.log(e);
        }
        return isValid;
    }

    private boolean hostsValidated() {
        boolean valid = true;
        boolean islegacy = false;
        Vector<RemotePushComputerObject> hosts = this.getSelectedComputers();
        for (int i = 0; i < hosts.size(); ++i) {
            String strMessage;
            RemotePushComputerObject obj = hosts.elementAt(i);
            valid = this.platformValidated(obj);
            String pkgVersion = null;
            if (!this.getWizard().isUseExportedPackage()) {
                CurrentPackageObject packageObj = this.getWizard().getSelectedPackage().get(0);
                pkgVersion = packageObj.getSoftwarePackageObject().getVersion(true);
            }
            islegacy = RemoteDeploymentHelper.isLegacyOS(obj, pkgVersion);
            if (!valid) {
                strMessage = MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.errorIncompatibleHostMessage");
                if (obj.getBitType().equalsIgnoreCase(RemotePushComputerObject.STR_TYPE_DONT_KNOW)) {
                    String an = MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.an");
                    strMessage = MessageFormat.format(strMessage, an + " " + obj.getBitType());
                } else {
                    strMessage = MessageFormat.format(strMessage, obj.getBitType());
                }
                JOptionPane.showMessageDialog(null, strMessage, MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.selectProcessTitle"), 0);
                break;
            }
            if (!islegacy || JOptionPane.showConfirmDialog(null, strMessage = MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.errorLegacyHostMessage"), MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.selectProcessTitle"), 0) == 0) continue;
            valid = false;
            break;
        }
        return valid;
    }

    private boolean platformValidated(RemotePushComputerObject entry) {
        if (this.getWizard().isUseExportedPackage() || this.getWizard().isUseCommunicationPackage()) {
            return true;
        }
        boolean is32bit = entry.is32Bit();
        boolean valid = true;
        valid = is32bit ? this.getWizard().is32BitPackageSelected() : (entry.getBitType().compareToIgnoreCase(RemotePushComputerObject.STR_TYPE_64_BIT) == 0 ? this.getWizard().is64BitPackageSelected() : (entry.getBitType().compareToIgnoreCase(RemotePushComputerObject.STR_TYPE_MAC) == 0 ? this.getWizard().isMacPackageSelected() : false));
        return valid;
    }

    public void legacySystemCheck(RemotePushComputerObject entry) {
        if (this.getWizard().isUseCommunicationPackage()) {
            return;
        }
        if (this.getWizard().isUseExportedPackage()) {
            return;
        }
        boolean islegacy = false;
        CurrentPackageObject packageObj = this.getWizard().getSelectedPackage().get(0);
        String pkgVersion = packageObj.getSoftwarePackageObject().getVersion(true);
        if (Utility.compareVersion((String)pkgVersion, (String)"12.1.0.0") > 0) {
            islegacy = RemoteDeploymentHelper.isLegacyOS(entry, pkgVersion);
            entry.setUnsupported(islegacy);
            if (islegacy) {
                if (!LicenseObject.getInstance().isSBProduct()) {
                    entry.setBitType(RemotePushComputerObject.STR_TYPE_DONT_KNOW);
                }
                entry.setMaxSEPVersion(this.getWizard().getMaxLegacyVersion(pkgVersion));
            }
        }
    }

    private String getErrorPaneHelpText() {
        Object[] obj = new Object[]{ServerVersion.CURRENT_CED_VERSION, Utility.getLanguage()};
        String strErrPaneHelpText = MessageFormat.format(MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.errorPaneHelpText"), obj);
        StringBuffer strBuff = new StringBuffer();
        strBuff.append("<HTML><BODY><DIV " + HTMLUtilities.WIZARD_CONTENT_STYLE_STD + "\">");
        strBuff.append(strErrPaneHelpText);
        strBuff.append("</DIV>");
        strBuff.append("</BODY></HTML>");
        return strBuff.toString();
    }

    private void handleException(Exception ex) {
        if (ex instanceof ConsoleException) {
            this.showErrorMessage(((ConsoleException)ex).getMessageWithoutErrorCode());
            if (((ConsoleException)ex).needRelogin()) {
                Manager.getFrame().showLoginPanel();
                return;
            }
        } else {
            this.showErrorMessage(ex.getMessage());
        }
    }

    private void showErrorMessage(String message) {
        JOptionPane.showMessageDialog(this.getWizardStagePanel(), message, MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.error"), 0);
    }

    private void setProgressVisible(final SimpleProgressDlg dlg, final boolean showDlg) {
        if (dlg != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                dlg.setVisible(showDlg);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        dlg.setVisible(showDlg);
                    }
                });
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            this.progressMonitor.setProgress(progress);
            String message = String.format(MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.completed") + "\n", progress);
            this.progressMonitor.setNote(message);
            if ((this.progressMonitor.isCanceled() || this.importTask.isDone()) && this.progressMonitor.isCanceled()) {
                this.importTask.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean processFile() {
        boolean done;
        block9: {
            BufferedReader reader = null;
            String fileName = this.computerListFile;
            done = false;
            this.setLineNum(0);
            if (fileName != null && fileName.length() > 0) {
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), Charset.defaultCharset()));
                    while ((line = reader.readLine()) != null) {
                        this.increaseLineNum(1);
                        if (StringUtilities.isEmpty((String)line)) continue;
                        this.processLine(line);
                    }
                    this.addEntries();
                    done = this.errorLines.size() <= 0;
                    IOUtilities.closeReader((Reader)reader);
                }
                catch (FileNotFoundException e) {
                    done = false;
                }
                catch (IOException e2) {
                    done = false;
                    break block9;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    IOUtilities.closeReader(reader);
                }
            }
        }
        return done;
    }

    private String getFirstEntry(String line) {
        String regs = "([^ \t,;/\\\\\\*&\\^%#\\$@!?\\(\\)\\|]+)";
        Pattern p = Pattern.compile(regs);
        Matcher m = p.matcher(line);
        if (m.find() && m.groupCount() == 1) {
            if (m.group().equals(line)) {
                return m.group();
            }
            if (m.start() >= 1 && line.length() > m.end() && line.substring(0, m.start()).equals(line.substring(m.end(), m.end() + m.start()))) {
                return m.group();
            }
        }
        return null;
    }

    private void processLine(String line) {
        String firstEntry = this.getFirstEntry(line);
        if (null != firstEntry) {
            String ip = "";
            String host = "";
            if (InetAddressValidator.getInstance().isValid(firstEntry)) {
                ip = firstEntry;
            } else if (Utility.isValidateHostName((String)firstEntry)) {
                host = firstEntry;
            }
            if (ip.equals("") && host.equals("")) {
                this.errorLines.add(MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.line") + this.lineNum + ": \t" + line);
                return;
            }
            NetworkAuditComputerNode node = new NetworkAuditComputerNode(ip, host);
            if (!this.computerList.contains(node)) {
                this.computerList.add(node);
            }
        } else {
            this.errorLines.add(MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.line") + this.lineNum + ": \t" + line);
        }
    }

    public void addEntries() {
        if (this.computerList != null && this.computerList.size() > 0) {
            for (int i = 0; i < this.computerList.size(); ++i) {
                NetworkAuditComputerNode node = this.computerList.get(i);
                RemotePushComputerObject entry = new RemotePushComputerObject("", node, "", "", "", "");
                if (this.isDuplicateSearchEntry(node)) continue;
                this.searchResModel.addRow(entry);
            }
            this.updateButtons();
        }
    }

    private boolean importComputerListFile(String file) {
        if (new File(file).length() > 0x1400000L) {
            UIUtilities.showErrorDialog(MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.fileTooBig"));
            return false;
        }
        boolean tf = true;
        this.computerList.clear();
        if (this.getLastImportedItem().contains(file) && this.isImportOK()) {
            return true;
        }
        UIManager.put("ProgressMonitor.progressText", MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.progress"));
        this.progressMonitor = new ProgressMonitor(this.getWizardStagePanel(), MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.importing"), "", 0, 100);
        this.progressMonitor.setProgress(0);
        this.importTask = new ImportTask();
        this.importTask.addPropertyChangeListener(this);
        SwingWorkerExecutor.getInstance().execute(this.importTask);
        tf = this.isImportOK();
        return tf;
    }

    public void setLineNum(int lineNum) {
        this.lineNum = lineNum;
    }

    public void increaseLineNum(int lineNum) {
        this.lineNum += lineNum;
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public void setLastImportedItem() {
        this.lastImportedItem.clear();
        this.lastImportedItem.add(this.computerListFile);
    }

    public List<String> getLastImportedItem() {
        return this.lastImportedItem;
    }

    public void setImportOK(boolean importOK) {
        this.importOK = importOK;
    }

    public boolean isImportOK() {
        return this.importOK;
    }

    public void updateUIForCommunicationSettings(boolean bCommSetting) {
        if (bCommSetting) {
            this.bCommunictaionSetting = true;
            this.desc.setText(MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.descriptionCommunication"));
            this.jLblInstall.setText(MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.installCommunication"));
        } else {
            this.bCommunictaionSetting = false;
            this.desc.setText(MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.description"));
            this.jLblInstall.setText(MSGRES.getString(CLIENTDIALOG, "RemoteMethodPanel.installProtection"));
        }
    }

    protected void initializeData() {
        DeploymentTypePanel wzDlg = this.getWizard().getWizardTypePanel();
        this.endpointType = "Windows";
        if (wzDlg.useExistingPackage()) {
            if (wzDlg.isMacPackage()) {
                this.endpointType = "Mac";
            }
        } else if (wzDlg.isSylinkDrop()) {
            if (!wzDlg.isSylinkDropWin()) {
                this.endpointType = "Mac";
            }
        } else if (1 == this.getWizard().getGroupFeaturePanel().getPackageOSType()) {
            this.endpointType = "Mac";
        }
        if (this.endpointType == "Mac") {
            this.setCachedComputerList(InstallClientWizardDialog.lstSearchCacheMac);
        } else {
            this.setCachedComputerList(InstallClientWizardDialog.lstSearchCache);
        }
        this.updateUIForCommunicationSettings(this.getWizard().getWizardTypePanel().isSylinkDrop());
    }

    class ImportTask
    extends SwingWorker<Boolean, Void> {
        ImportTask() {
        }

        @Override
        public Boolean doInBackground() {
            RemoteMethodPanel.this.errorLines.clear();
            Random random = new Random();
            int progress = 0;
            boolean succeeded = true;
            this.setProgress(0);
            try {
                succeeded = RemoteMethodPanel.this.processFile();
                Thread.sleep(50L);
                while (progress < 100 && !RemoteMethodPanel.this.progressMonitor.isCanceled()) {
                    Thread.sleep(random.nextInt(50));
                    this.setProgress(Math.min(progress += random.nextInt(10), 100));
                }
                if (RemoteMethodPanel.this.progressMonitor.isCanceled()) {
                    succeeded = false;
                }
            }
            catch (InterruptedException ie) {
                succeeded = false;
            }
            return succeeded;
        }

        @Override
        public void done() {
            this.setProgress(100);
            boolean succeeded = true;
            try {
                succeeded = (Boolean)this.get();
            }
            catch (InterruptedException e) {
                succeeded = false;
            }
            catch (ExecutionException e) {
                succeeded = false;
            }
            RemoteMethodPanel.this.setImportOK(succeeded);
            RemoteMethodPanel.this.progressMonitor.close();
            if (RemoteMethodPanel.this.errorLines.size() > 0) {
                String msg = MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.lineError");
                String title = MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "ExportPackageDlg.invalidListWarningMsg");
                ListMessageBox msgBox = new ListMessageBox(RemoteMethodPanel.this.getWizard(), 50, title, msg, 2, -1, RemoteMethodPanel.this.errorLines);
                RemoteMethodPanel.this.errorLines.clear();
                msgBox.show();
            }
        }
    }

    private class TableHandColumnMotionListener
    implements MouseMotionListener {
        JTable targetTable;
        int handColumn;

        public TableHandColumnMotionListener(JTable table, int column) {
            this.targetTable = table;
            this.handColumn = column;
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            Point point = me.getPoint();
            int colIndex = this.targetTable.columnAtPoint(point);
            if (colIndex == this.handColumn) {
                RemoteMethodPanel.this.jTblSelected.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                RemoteMethodPanel.this.jTblSelected.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }
    }

    private class LoginListener
    implements NetworkAuditSearchListener {
        NetworkAuditSearchParams searchParams = null;
        public boolean cancel;
        boolean isSuccess;

        public LoginListener(NetworkAuditSearchParams params) {
            this.searchParams = params;
        }

        @Override
        public void entryFound(NetworkAuditObject obj) {
            NetworkAuditComputerNode searchEntry = new NetworkAuditComputerNode(obj.getComputerName(), obj.getHostName());
            if (obj.isLoginSuccess()) {
                String strDomain;
                if (RemoteMethodPanel.this.isDuplicateSelectEntry(searchEntry)) {
                    System.out.println("Skipping duplicate host.");
                    RemoteMethodPanel.this.setProgressVisible(RemoteMethodPanel.this.progress, false);
                    String strMessage = MessageFormat.format(DUP_SELECT_ENTRY_ERR, searchEntry.getDisplayString());
                    RemoteMethodPanel.this.setProgressVisible(RemoteMethodPanel.this.progress, true);
                    if (!this.cancel) {
                        this.isSuccess = true;
                    }
                    return;
                }
                if (obj.isSEPMManaged()) {
                    System.out.println("RemoteMethodPanel>> " + obj.getHostName() + " ALREADY MANAGED BY SEPM");
                    String strMessage = MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.msgManagedComputer");
                    strMessage = MessageFormat.format(strMessage, obj.getHostName());
                    int ret = JOptionPane.showConfirmDialog(null, strMessage, MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.selectProcessTitle"), 0);
                    if (ret != 0) {
                        if (!this.cancel) {
                            this.isSuccess = true;
                        }
                        return;
                    }
                }
                if ((strDomain = this.searchParams.getDomain()) == null || strDomain.trim().length() == 0) {
                    strDomain = obj.getHostName();
                }
                RemotePushComputerObject entry = new RemotePushComputerObject(obj.getPlatformType(), searchEntry, this.searchParams.getUserName(), this.searchParams.getPassword(), strDomain, obj.getDescription());
                entry.setProtection(obj.getSecuritySoftware());
                entry.setServicePack(obj.getServicePack());
                entry.setSEPInstalled(obj.isSEPInstalled());
                entry.setSepVersion(obj.getSepVersion());
                if (!RemoteMethodPanel.this.isSMB() && !RemoteMethodPanel.this.platformValidated(entry)) {
                    String strMessage = MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.errorIncompatibleHost");
                    int ret = JOptionPane.showConfirmDialog(null, strMessage = MessageFormat.format(strMessage, entry.getBitType()), MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.selectProcessTitle"), 0);
                    if (ret != 0) {
                        if (!this.cancel) {
                            this.isSuccess = true;
                        }
                        return;
                    }
                }
                RemoteMethodPanel.this.legacySystemCheck(entry);
                if (!this.cancel) {
                    RemoteMethodPanel.this.selectedModel.addRow(entry);
                    RemoteMethodPanel.this.clearEntryFromSearchResults(entry);
                    this.isSuccess = true;
                }
            }
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }

        @Override
        public void stateChanged(int state) {
        }
    }

    private class SearchListener
    implements NetworkAuditSearchListener {
        private boolean entryFound = false;
        private boolean dupEntriesFound = false;

        private SearchListener() {
        }

        @Override
        public void entryFound(NetworkAuditObject obj) {
            this.entryFound = true;
            NetworkAuditComputerNode searchEntry = new NetworkAuditComputerNode(obj.getComputerName(), obj.getHostName());
            String strDomain = RemoteMethodPanel.this.searchParams.getDomain();
            if (strDomain == null || strDomain.trim().length() == 0) {
                strDomain = obj.getHostName();
            }
            RemotePushComputerObject entry = new RemotePushComputerObject(obj.getPlatformType(), searchEntry, RemoteMethodPanel.this.searchParams.getUserName(), RemoteMethodPanel.this.searchParams.getPassword(), strDomain, obj.getDescription());
            entry.setProtection(obj.getSecuritySoftware());
            entry.setServicePack(obj.getServicePack());
            entry.setSEPInstalled(obj.isSEPInstalled());
            entry.setSepVersion(obj.getSepVersion());
            if (!RemoteMethodPanel.this.isDuplicateSearchEntry(searchEntry) && InetAddressValidator.getInstance().isValid(searchEntry.getIP())) {
                RemoteMethodPanel.this.searchResModel.addRow(entry);
                RemoteMethodPanel.this.lstSearchCache.add(entry);
                RemoteMethodPanel.this.jBtnClear.setEnabled(true);
                if (RemoteMethodPanel.this.jTabPane.getTabCount() != 2) {
                    RemoteMethodPanel.this.jTabPane.addTab(MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.search"), RemoteMethodPanel.this.searchPanel);
                    RemoteMethodPanel.this.jTabPane.setMnemonicAt(1, 70);
                    RemoteMethodPanel.this.jTabPane.setSelectedComponent(RemoteMethodPanel.this.searchPanel);
                }
            } else {
                this.dupEntriesFound = true;
                String strMessage = MSGRES.getString(RemoteMethodPanel.CLIENTDIALOG, "RemoteMethodPanel.errorDuplicateSearchEntry");
                strMessage = MessageFormat.format(strMessage, searchEntry.getHostName() + "(" + searchEntry.getIP() + ")");
                ConsoleLogger.log(strMessage);
            }
        }

        public boolean isEntryFound() {
            return this.entryFound;
        }

        public boolean isDuplicate() {
            return this.dupEntriesFound;
        }

        @Override
        public void stateChanged(int state) {
        }
    }

    private class BrowseProgressDialog
    extends SimpleProgressDlg {
        private static final long serialVersionUID = 1L;
        private String cancelPath;

        public BrowseProgressDialog(Frame frame, String title, String message, boolean modal, String cancelPath) {
            super(frame, title, message, modal);
            this.cancelPath = null;
            this.setCancelVisible(true);
            this.setCancelEnabled(true);
            this.cancelPath = cancelPath;
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    BrowseProgressDialog.this.cancel();
                }
            });
        }

        public void cancel() {
            RemoteMethodPanel.this.cancelBrowseRequest(this.cancelPath);
            super.cancel();
        }
    }

    private class BrowseTreePerPlatform {
        private JTree browseTreeWin = new JTree();
        private final DefaultTreeModel browseTreeModelWin;
        private final BrowseTreeNode treeRootNodeWin;
        private JTree browseTreeMac = new JTree();
        private final DefaultTreeModel browseTreeModelMac;
        private final BrowseTreeNode treeRootNodeMac;

        public BrowseTreePerPlatform() {
            this.browseTreeWin = new JTree();
            this.treeRootNodeWin = new BrowseTreeNode(RemoteMethodPanel.rootNodeName);
            this.browseTreeModelWin = new DefaultTreeModel(this.treeRootNodeWin, true);
            this.browseTreeMac = new JTree();
            this.treeRootNodeMac = new BrowseTreeNode(RemoteMethodPanel.rootNodeName);
            this.browseTreeModelMac = new DefaultTreeModel(this.treeRootNodeMac, true);
        }

        public JTree getBrowseTree() {
            if ("Mac".equals(RemoteMethodPanel.this.endpointType)) {
                return this.browseTreeMac;
            }
            return this.browseTreeWin;
        }

        public DefaultTreeModel getBrowseTreeModel() {
            if ("Mac".equals(RemoteMethodPanel.this.endpointType)) {
                return this.browseTreeModelMac;
            }
            return this.browseTreeModelWin;
        }

        public BrowseTreeNode getRootTreeNode() {
            if ("Mac".equals(RemoteMethodPanel.this.endpointType)) {
                return this.treeRootNodeMac;
            }
            return this.treeRootNodeWin;
        }

        public void initJTrees() {
            this.initJTree(this.browseTreeWin, this.treeRootNodeWin, this.browseTreeModelWin);
            this.initJTree(this.browseTreeMac, this.treeRootNodeMac, this.browseTreeModelMac);
        }

        private void initJTree(final JTree browseTree, BrowseTreeNode treeRootNode, DefaultTreeModel browseTreeModel) {
            browseTree.setModel(browseTreeModel);
            browseTree.setRootVisible(false);
            browseTree.addTreeWillExpandListener(RemoteMethodPanel.this);
            browseTree.addTreeSelectionListener(RemoteMethodPanel.this);
            browseTree.setShowsRootHandles(true);
            browseTree.setCellRenderer(new BrowseTreeRenderer());
            browseTree.putClientProperty("tree.selectionModel", "DISCONTIGUOUS_TREE_SELECTION");
            browseTree.putClientProperty("JTree.lineStyle", "Angled");
            browseTree.setToggleClickCount(2);
            browseTree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)browseTree.getLastSelectedPathComponent();
                    if (me.getClickCount() == 2) {
                        try {
                            if (RemoteMethodPanel.this.isServerNode(selectedNode)) {
                                RemoteMethodPanel.this.addActionPerformed();
                                return;
                            }
                        }
                        catch (Exception ex) {
                            RemoteMethodPanel.this.handleException(ex);
                        }
                    } else if (me.getClickCount() == 1) {
                        String strLinkBegin = "<a href=\"";
                        String strLinkEnd = "\">";
                        if (selectedNode != null) {
                            int end;
                            String strCheck;
                            int begin;
                            Object usrObj = selectedNode.getUserObject();
                            if (null != usrObj && usrObj instanceof String && (begin = (strCheck = (String)usrObj).indexOf("<a href=\"")) >= 0 && (end = strCheck.indexOf("\">", begin)) > 0) {
                                String url = strCheck.substring(begin + "<a href=\"".length(), end);
                                URLUtility.showURL((String)url);
                            }
                        } else {
                            ConsoleLogger.log("RemoteMethodPanel >> Selected node is empty or null");
                        }
                    }
                }
            });
        }
    }
}

