/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.console.ui.client.dlg.ClientInstallationWizard;
import com.sygate.scm.console.ui.client.dlg.InstallClientWizardDialog;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.util.HTMLUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class ReadyToInstallPanel
extends ClientInstallationWizard {
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENTDIALOG = "com.sygate.scm.console.ui.client.dlg.clientdialog";
    private static final String strTop = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ReadyToInstallPanel.descriptionTop");
    private static final String strTopSepCommunicationUpdater = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ReadyToInstallPanel.descriptionTopSepCommunicationUpdater");
    private static final String title = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ReadyToInstallPanel.title");
    private JLabel jLbChoice;
    private JLabel jLbClickFinish;
    private JPanel topPanel;
    private DescriptionTextArea descTop;
    private JEditorPane featureTop;
    private DescriptionTextArea descBottom;
    private JScrollPane jsp;
    private Border border;
    public static final int TYPE_EMAIL = 1;
    public static final int TYPE_REMOTE = 2;
    public static final int TYPE_CUSTOM_SINGLE = 3;
    public static final int TYPE_CUSTOM_SEPERATE = 4;

    public ReadyToInstallPanel(InstallClientWizardDialog wizard, boolean isSMB) {
        super(wizard, isSMB);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.jLbChoice = new JLabel(MSGRES.getString(CLIENTDIALOG, "ReadyToInstallPanel.lblCustomSeperate"));
        this.jLbClickFinish = new JLabel(MSGRES.getString(CLIENTDIALOG, "ReadyToInstallPanel.lblClickFinishEmail"));
        this.topPanel = new JPanel(new BorderLayout());
        this.descTop = new DescriptionTextArea();
        this.featureTop = new JEditorPane();
        this.descBottom = new DescriptionTextArea();
        this.jsp = new JScrollPane(this.descBottom);
        this.border = this.jsp.getBorder();
    }

    @Override
    protected String getTitleDescription() {
        return "";
    }

    @Override
    protected String getTitle() {
        return title;
    }

    @Override
    protected JPanel getCenterPanel() {
        Insets insets = new Insets(0, 5, 0, 5);
        this.featureTop.setMargin(insets);
        this.featureTop.setEditable(false);
        this.featureTop.setOpaque(false);
        this.descTop.setMargin(insets);
        this.descBottom.setMargin(insets);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new GridBagLayout());
        centerPanel.add((Component)this.topPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.3, 18, 1, insertToLogo, 0, 0));
        this.jLbChoice.setFont(this.jLbChoice.getFont().deriveFont(1));
        AjaxSwingCommonUtil.executeIfWebConsoleIsNotRunning(() -> {
            centerPanel.add((Component)this.jLbChoice, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, insertToLogo, 0, 0));
            centerPanel.add((Component)this.jsp, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.7, 17, 1, new Insets(0, 25, 5, 50), 0, 0));
        });
        this.jLbClickFinish.setFont(this.jLbClickFinish.getFont().deriveFont(1));
        centerPanel.add((Component)this.jLbClickFinish, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.7, 17, 1, new Insets(0, 25, 10, 50), 0, 0));
        return centerPanel;
    }

    public void setTopDesc(String strGroupName, List<? extends Object> listProtectionNames) {
        this.descTop.setText(MessageFormat.format(strTop, strGroupName));
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("<HTML><BODY><DIV " + HTMLUtilities.WIZARD_CONTENT_STYLE_STD + "\">");
        strBuilder.append("<UL>");
        for (Object object : listProtectionNames) {
            List lstSubFeatures;
            if (object instanceof List && (lstSubFeatures = (List)object).size() > 0) {
                strBuilder.append("<UL>");
                for (Object strSubFeature : lstSubFeatures) {
                    strBuilder.append("<LI >" + strSubFeature + "</LI>");
                }
                strBuilder.append("</UL>");
            }
            if (!(object instanceof String)) continue;
            strBuilder.append("<LI >" + object + "</LI>");
        }
        strBuilder.append("</UL>");
        strBuilder.append("</DIV></BODY></HTML>");
        this.featureTop.setContentType("text/html");
        this.featureTop.setText(strBuilder.toString());
        this.topPanel.add((Component)this.descTop, "North");
        this.topPanel.add((Component)this.featureTop, "Center");
    }

    public void setChoice(int choice) {
        switch (choice) {
            case 3: {
                this.jLbChoice.setText(MSGRES.getString(CLIENTDIALOG, "ReadyToInstallPanel.lblCustomSingle"));
                this.jLbClickFinish.setText(MSGRES.getString(CLIENTDIALOG, "ReadyToInstallPanel.lblClickFinishSingle"));
                break;
            }
            case 4: {
                this.jLbChoice.setText(MSGRES.getString(CLIENTDIALOG, "ReadyToInstallPanel.lblCustomSeperate"));
                this.jLbClickFinish.setText(MSGRES.getString(CLIENTDIALOG, "ReadyToInstallPanel.lblClickFinishSeperate"));
                break;
            }
        }
        if (choice == 4 || choice == 3) {
            this.jsp.setBorder(null);
        } else {
            this.jsp.setBorder(this.border);
        }
    }

    public void setBottomDesc(List<String> listEntries) {
        StringBuilder strBuilder = new StringBuilder();
        for (String strEntry : listEntries) {
            strBuilder.append(strEntry + "\n");
        }
        this.descBottom.setText(strBuilder.toString());
    }

    public void updateUIForSepCommunicationUpdater(String strGroupName) {
        this.descTop.setText(MessageFormat.format(strTopSepCommunicationUpdater, strGroupName));
        this.topPanel.add((Component)this.descTop, "North");
        this.jLbChoice.setText(MSGRES.getString(CLIENTDIALOG, "ReadyToInstallPanel.lblSepCommunicationUpdater"));
        this.jLbClickFinish.setText(MSGRES.getString(CLIENTDIALOG, "ReadyToInstallPanel.lblClickFinishSepCommunicationUpdater"));
        this.jsp.setBorder(null);
    }
}

