/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.client.dlg.ClientInstallationWizard;
import com.sygate.scm.console.ui.client.dlg.InstallClientWizardDialog;
import com.sygate.scm.console.ui.client.networkaudit.RemotePushComputerObject;
import com.sygate.scm.console.ui.client.networkaudit.RemotePushComputerTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.renderer.RemotePushComputerRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ReadyToDeployPanel
extends ClientInstallationWizard {
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENTDIALOG = "com.sygate.scm.console.ui.client.dlg.clientdialog";
    private JLabel jLblInst;
    private static final float[] colSizes = new float[]{0.45f, 0.4f, 0.15f};
    private RemotePushComputerTableModel tblModel;
    private StripesTable jTblComputers;
    private JScrollPane jsp;

    public ReadyToDeployPanel(InstallClientWizardDialog wizard, boolean isSMB) {
        super(wizard, isSMB);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.jLblInst = new JLabel(MSGRES.getString(CLIENTDIALOG, "ReadyToDeployPanel.lblInstallProtection"));
        this.tblModel = new RemotePushComputerTableModel(false);
        this.jTblComputers = new StripesTable(this.tblModel, true, false);
        this.jsp = new JScrollPane((Component)((Object)this.jTblComputers));
    }

    @Override
    protected String getTitleDescription() {
        return MSGRES.getString(CLIENTDIALOG, "ReadyToDeployPanel.titleDesc");
    }

    @Override
    protected String getTitle() {
        return MSGRES.getString(CLIENTDIALOG, "ReadyToDeployPanel.title");
    }

    @Override
    protected JPanel getCenterPanel() {
        this.jsp.setPreferredSize(new Dimension(200, 150));
        this.setUpTable();
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new GridBagLayout());
        centerPanel.add((Component)this.jLblInst, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 25, 0, 25), 0, 0));
        centerPanel.add((Component)this.jsp, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 25, 30, 50), 0, 0));
        return centerPanel;
    }

    public void setData(Vector<RemotePushComputerObject> data) {
        if (data != null) {
            this.tblModel.setData(data);
        }
    }

    public Vector<RemotePushComputerObject> getData() {
        if (this.tblModel != null) {
            return this.tblModel.getData();
        }
        return null;
    }

    private void setUpTable() {
        this.jTblComputers.setRowHeight(20);
        this.jTblComputers.setFocusable(false);
        this.jTblComputers.setCellSelectionEnabled(false);
        this.jTblComputers.getTableHeader().setReorderingAllowed(false);
        this.jTblComputers.setAutoResizeMode(1);
        TableColumnModel tblColModel = this.jTblComputers.getColumnModel();
        TableColumn colStatus = this.jTblComputers.getColumn(RemotePushComputerTableModel.DEP_STATUS);
        tblColModel.removeColumn(colStatus);
        TableColumn colComputerHostName = this.jTblComputers.getColumn(RemotePushComputerTableModel.COMPUTER_HOST_NAME);
        tblColModel.removeColumn(colComputerHostName);
        TableColumn colIPAddr = this.jTblComputers.getColumn(RemotePushComputerTableModel.IP_ADDR);
        tblColModel.removeColumn(colIPAddr);
        TableColumn colProgress = this.jTblComputers.getColumn(RemotePushComputerTableModel.PROGRESS);
        tblColModel.removeColumn(colProgress);
        TableColumn updStatus = this.jTblComputers.getColumn(RemotePushComputerTableModel.UPD_STATUS);
        tblColModel.removeColumn(updStatus);
        this.tblModel.addMouseListenerToHeaderInTable((JTable)((Object)this.jTblComputers));
        this.setRenderers();
        float tblWidth = (float)this.jTblComputers.getPreferredScrollableViewportSize().getWidth();
        UIUtilities.resizeColumns((JTable)((Object)this.jTblComputers), colSizes, tblWidth, false);
    }

    private void setRenderers() {
        RemotePushComputerRenderer renderer = new RemotePushComputerRenderer();
        TableColumn colHostName = this.jTblComputers.getColumn(RemotePushComputerTableModel.HOST_NAME);
        colHostName.setCellRenderer(renderer);
    }

    public boolean validatePanel() {
        return true;
    }

    public void updateUIForCommunicationSettings(boolean bCommSetting) {
        if (bCommSetting) {
            this.jLblInst.setText(MSGRES.getString(CLIENTDIALOG, "ReadyToDeployPanel.lblInstallCommunication"));
        } else {
            this.jLblInst.setText(MSGRES.getString(CLIENTDIALOG, "ReadyToDeployPanel.lblInstallProtection"));
        }
    }
}

