/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.HTMLEditorPane;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class PowerEraserScanProgressLinkDlg
extends DialogBase {
    private static final Image InfoImage = Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("Inform.png"));
    private static final ImageIcon infoIcon = new ImageIcon(InfoImage);
    private static ImageIcon ICON_BULLET = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("bullet.png")));
    private static final long serialVersionUID = 1L;

    public PowerEraserScanProgressLinkDlg() {
        super(Manager.frame, PowerEraserScanProgressLinkDlg.getI18nString("PowerEraserScanProgressLinkDlg.title"), true);
        this.init();
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    protected void init() {
        JPanel contentPanel = new JPanel();
        JPanel leftPanel = new JPanel();
        leftPanel.add(new JLabel(infoIcon));
        contentPanel.add((Component)leftPanel, "West");
        JPanel rightPanel = new JPanel(new GridBagLayout());
        contentPanel.add((Component)rightPanel, "West");
        JLabel icon = new JLabel();
        icon.setIcon(ICON_BULLET);
        rightPanel.add((Component)new JLabel(PowerEraserScanProgressLinkDlg.getI18nString("PowerEraserScanProgressLinkDlg.powerEraseInfoTitle")), new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        rightPanel.add((Component)icon, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        rightPanel.add((Component)this.createCommandStatusLinkPane(), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        rightPanel.add((Component)new JPanel(), new GridBagConstraints(2, 1, 1, 2, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 5), 0, 0));
        icon = new JLabel();
        icon.setIcon(ICON_BULLET);
        rightPanel.add((Component)icon, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        rightPanel.add((Component)this.createScanLogsLinkPane(), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.getContentPane().add((Component)contentPanel, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(0, 0, true), "South");
    }

    private HTMLEditorPane createCommandStatusLinkPane() {
        HTMLEditorPane pane = new HTMLEditorPane(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    PowerEraserScanProgressLinkDlg.this.showCommandStatus();
                }
            }
        });
        pane.setText(PowerEraserScanProgressLinkDlg.wrapHtml(PowerEraserScanProgressLinkDlg.getI18nString("PowerEraserScanProgressLinkDlg.powerEraseInfoCommandStatusLinkLabel")));
        return pane;
    }

    private void showCommandStatus() {
        Manager.getFrame().showCommandStatus(null);
        this.dispose();
    }

    private HTMLEditorPane createScanLogsLinkPane() {
        HTMLEditorPane pane = new HTMLEditorPane(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    PowerEraserScanProgressLinkDlg.this.showScanLogs();
                }
            }
        });
        pane.setText(PowerEraserScanProgressLinkDlg.wrapHtml(PowerEraserScanProgressLinkDlg.getI18nString("PowerEraserScanProgressLinkDlg.powerEraseInfoScanLogLinkLabel")));
        return pane;
    }

    private void showScanLogs() {
        Manager.getFrame().showScanLogs(null);
        this.dispose();
    }

    @Override
    protected boolean isCancelButtonShown() {
        return false;
    }

    @Override
    protected boolean isHelpButtonShown() {
        return false;
    }

    private static String getI18nString(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", key);
    }

    private static String wrapHtml(String text) {
        String htmlText = "<HTML><HEAD><style type=\"text/css\">BODY {background-color:transparent; color: #000; margin:0px 0px 0px 0px}</style></HEAD><BODY>" + text + "</BODY></HTML>";
        return htmlText;
    }
}

