/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.ui.client.dlg.SoftwarePackagePropsGeneralPanel;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JTabbedPane;

public class PackagePropertyDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final String AUTOMATION_BUTTON_OK = "PropertyButtonOK";
    private static final String AUTOMATION_BUTTON_CANCEL = "PropertyButtonCancel";
    private JTabbedPane jTabPane = new JTabbedPane();
    private SoftwarePackagePropsGeneralPanel generalPanel = null;
    boolean isCancelled = true;
    boolean isShowGeneralPanel = true;

    public PackagePropertyDlg(CurrentPackageObject cpo, boolean isShowGeneralPanel, boolean readOnly) {
        super(Manager.getFrame(), "", true);
        this.readOnly = readOnly;
        this.generalPanel = new SoftwarePackagePropsGeneralPanel(this.readOnly);
        Object[] obj = new Object[]{cpo.getPackageName()};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "PackagePropertyDlg.title");
        String fm = MessageFormat.format(str, obj);
        super.setTitle(fm);
        this.initialize();
        this.initData(cpo, isShowGeneralPanel);
        UiUtilities.centerComponent((Component)this);
        this.setReadOnlyStatus();
        this.setVisible(true);
    }

    public String getDescription() {
        return this.generalPanel.getDescription();
    }

    public String getPackageName() {
        return this.generalPanel.getPackageName();
    }

    public boolean isPackageNameChanged() {
        return this.generalPanel.isPackageNameChanged();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_install_packages_dialog_properties";
    }

    private void initialize() {
        UIUtilities.setName(this.jBOk, "packageManagement", UIUtilities.ComponentType.BUTTON, AUTOMATION_BUTTON_OK);
        UIUtilities.setName(this.jBCancel, "packageManagement", UIUtilities.ComponentType.BUTTON, AUTOMATION_BUTTON_CANCEL);
        this.jTabPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.jTabPane.add((Component)this.generalPanel, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "PackagePropertyDlg.generalTab"));
        this.getContentPane().add((Component)this.generalPanel, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
    }

    private void initData(CurrentPackageObject cpo, boolean isShowGeneralPanel) {
        this.isShowGeneralPanel = isShowGeneralPanel;
        if (this.isShowGeneralPanel) {
            this.generalPanel.init(cpo);
        } else {
            this.jTabPane.remove(this.generalPanel);
        }
        this.pack();
    }

    @Override
    protected boolean isValidate() {
        return this.generalPanel.isValidate();
    }
}

