/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.client.dlg.ExportPackageDlg;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class PackageContentPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENTDIALOG = "com.sygate.scm.console.ui.client.dlg.clientdialog";
    private JPanel content = null;
    private JCheckBox jCBIncludeAllContent = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SelectContentDialog.CheckBoxAllContent"));
    private static final String allContentDesc = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SelectContentDialog.AllContentDesc");
    private DescriptionTextArea descDefault = new DescriptionTextArea(allContentDesc, 20);
    private int contentOption = 0;
    private ExportPackageDlg callBackDlg = null;

    public PackageContentPanel(int contentOption) {
        this.contentOption = contentOption;
        this.initialize();
    }

    public void toggleAllContent(boolean toggle) {
        this.jCBIncludeAllContent.setEnabled(toggle);
        this.jCBIncludeAllContent.setSelected(toggle);
    }

    public PackageContentPanel(int contentOption, ExportPackageDlg callBackDlg) {
        this.contentOption = contentOption;
        this.callBackDlg = callBackDlg;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 10));
        this.add((Component)this.getCenterPanel(), "Center");
        this.setContentCheckboxOption();
    }

    private JPanel getCenterPanel() {
        if (this.content == null) {
            this.content = new JPanel(new GridBagLayout());
            this.content.add((Component)this.jCBIncludeAllContent, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 20), 0, 0));
            this.content.add((Component)this.descDefault, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 23, 5, 20), 0, 0));
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    PackageContentPanel.this.updateContentOption();
                }
            };
            this.jCBIncludeAllContent.addActionListener(listener);
        }
        return this.content;
    }

    private void setContentCheckboxOption() {
        if (this.contentOption == 0) {
            this.jCBIncludeAllContent.setSelected(true);
        } else {
            this.jCBIncludeAllContent.setSelected(false);
        }
    }

    protected void updateContentOption() {
        this.contentOption = this.jCBIncludeAllContent.isSelected() ? 0 : 1;
        if (this.callBackDlg != null) {
            this.callBackDlg.setPackageContentOption(this.getSelectedOption());
            this.callBackDlg.calculatePackageSize();
        }
    }

    public int getSelectedOption() {
        this.contentOption = this.jCBIncludeAllContent.isSelected() ? 0 : 1;
        return this.contentOption;
    }
}

