/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.configobject.schema.CommunicationOption;
import com.sygate.scm.common.configobject.schema.InstallationOption;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.RebootOptions;
import com.sygate.scm.common.configobject.schema.SemServerList;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.ui.policy.dialog.RebootOptionsPanel;
import com.sygate.scm.console.ui.util.ServerListComboBox;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.PackageUtil;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;

public class MacClientInstallationSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final MessageResourcesFile RES = new MessageResourcesFile("com.sygate.scm.console.ui.client.dlg.clientdialog");
    private RebootOptions rebootOptObject;
    private final JPanel upgradeSettingPanel = new JPanel(new GridBagLayout());
    private final JRadioButton jRBKeep = new JRadioButton(MacClientInstallationSettingsPanel.getResMsg("keepSetting"), true);
    private final JRadioButton jRBRemove = new JRadioButton(MacClientInstallationSettingsPanel.getResMsg("removePreviousSetting"));
    private final ServerListComboBox communicationOptionComb = new ServerListComboBox();
    private RebootOptionsPanel rebootOptionsPanel;
    private boolean readOnly;
    private JTabbedPane tabPane;

    public MacClientInstallationSettingsPanel() {
        this(false);
    }

    public MacClientInstallationSettingsPanel(boolean isReadOnly) {
        this.readOnly = isReadOnly;
        this.initialize();
        this.setReadOnly(this.readOnly);
    }

    private static String getResMsg(String key) {
        return RES.getString("MacClientInstallationSettingsPanel." + key);
    }

    public InstallationOption generateInstallationOption() {
        return SoftwarePackageObject.newInstallationOption(false, this.jRBKeep.isSelected(), InstallationOption.NORMAL, false, "", false, false, true, "", false, false, false, false);
    }

    public CommunicationOption generateCommunicationOption() {
        return SoftwarePackageObject.newCommunicationOption(this.getServerListId());
    }

    public RebootOptions generateRebootOptions() {
        return this.getRebootOptions();
    }

    public void setData(InstallationOption installationOption, CommunicationOption com, RebootOptions ro) {
        this.rebootOptObject = ro;
        if (this.rebootOptObject == null) {
            this.rebootOptObject = new RebootOptions(false);
            int restart = PackageUtil.getRestartSetting((InstallationOption)installationOption);
            if (restart == InstallationOption.SILENT_RESTART) {
                this.rebootOptObject.setOptPromptUser(Boolean.valueOf(false));
            }
        }
        this.rebootOptionsPanel.updateSettings(this.rebootOptObject);
        boolean keep = PackageUtil.isKeepAllDataOnUpgrade((InstallationOption)installationOption);
        this.jRBKeep.setSelected(keep);
        this.jRBRemove.setSelected(!keep);
        ArrayList<SemServerList> listServerList = null;
        try {
            listServerList = SoftwarePackageHandler.getServerList(true);
        }
        catch (Exception ex) {
            ConsoleLogger.log(ex);
        }
        this.communicationOptionComb.init(listServerList, true);
        ObjReference ref = com.getOptObjReference();
        if (ref != null) {
            this.communicationOptionComb.setSelectedServerListId(ref.getTargetId());
        }
    }

    private void initialize() {
        this.rebootOptionsPanel = new RebootOptionsPanel(2, RebootOptionsPanel.Platform.MAC);
        if (this.rebootOptObject == null) {
            this.rebootOptObject = new RebootOptions(false);
        }
        this.rebootOptionsPanel.updateSettings(this.rebootOptObject);
        this.tabPane = new JTabbedPane();
        this.tabPane.add(MacClientInstallationSettingsPanel.getResMsg("RebootTabTitle"), this.rebootOptionsPanel);
        this.tabPane.add(MacClientInstallationSettingsPanel.getResMsg("UpgradeTabTitle"), this.getSettingPanel());
        this.add(this.tabPane);
    }

    public void setTabPaneEnabled(boolean enabled) {
        this.tabPane.setEnabled(enabled);
    }

    private JPanel getSettingPanel() {
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.jRBKeep);
        group2.add(this.jRBRemove);
        this.upgradeSettingPanel.setLayout(new VerticalFlowLayout());
        this.upgradeSettingPanel.add(new JPanel());
        this.upgradeSettingPanel.add(this.jRBKeep);
        this.upgradeSettingPanel.add(this.jRBRemove);
        return this.upgradeSettingPanel;
    }

    private String getServerListId() {
        SemServerList serverList = this.communicationOptionComb.getSelectedSemServerList();
        if (serverList == null) {
            return null;
        }
        return serverList.getId();
    }

    private RebootOptions getRebootOptions() {
        return this.rebootOptionsPanel.saveSettings(this.rebootOptObject);
    }

    public void setReadOnly(boolean readOnly) {
        this.jRBKeep.setEnabled(!readOnly);
        this.jRBRemove.setEnabled(!readOnly);
        this.communicationOptionComb.setEnabled(!readOnly);
    }
}

