/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.SEPMPasswordField;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class LoginInfoDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENTDIALOG = "com.sygate.scm.console.ui.client.dlg.clientdialog";
    private JLabel jLblTitleDesc = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "LoginDlg.titleDesc"));
    private JLabel jLblUserName = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "LoginDlg.lblUserName"));
    private JLabel jLblPassword = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "LoginDlg.lblPwd"));
    private DescriptionTextArea jLblDomain = new DescriptionTextArea(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "LoginDlg.lblDomain"), 15);
    private DescriptionTextArea descMsg = null;
    private JTextField jTfUserName = null;
    private JPasswordField jTfPassword = null;
    private JTextField jTfDomain = null;
    private final String STR_USER_CRED_MSG = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "LoginDlg.lblMessage");
    private final String STR_USER_CRED_MSG_COMMUNICATION = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "LoginDlg.lblMessageCommunication");

    public LoginInfoDlg(JFrame frame, String title, boolean modal) {
        this(frame, title, modal, "Administrator", "", "", "", true, false, "Windows");
    }

    public LoginInfoDlg(JFrame frame, String title, boolean modal, String strUserName, String strPassword, String strDomain, String strHostName, boolean isDomain, boolean bCommunictaionSetting, String endpointType) {
        super(frame, title, modal);
        this.jTfUserName = "".equals(strUserName) ? new JTextField("Administrator") : new JTextField(strUserName);
        this.jTfUserName.selectAll();
        this.jTfPassword = new SEPMPasswordField(strPassword);
        this.jTfDomain = new JTextField(strDomain);
        this.descMsg = bCommunictaionSetting ? new DescriptionTextArea(MessageFormat.format(this.STR_USER_CRED_MSG_COMMUNICATION, strHostName)) : new DescriptionTextArea(MessageFormat.format(this.STR_USER_CRED_MSG, strHostName));
        this.init(endpointType);
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    protected void init(String endpoint) {
        Container ct = this.getContentPane();
        ct.setLayout(new BorderLayout());
        ct.add((Component)this.getContentPanel(endpoint), "Center");
        ct.add((Component)this.getButtonPanel(), "South");
        this.jLblTitleDesc.setFont(UIFontUtilities.SUBTITLE_FONT);
    }

    @Override
    public boolean isHelpButtonShown() {
        return false;
    }

    private JPanel getContentPanel(String endpointType) {
        JPanel panel = new JPanel(new GridBagLayout());
        this.descMsg.setPreferredSize(this.descMsg.getPreferredSize());
        this.jLblDomain.setPreferredSize(this.jLblDomain.getPreferredSize());
        int lastItemBottomPadding = "Windows".equalsIgnoreCase(endpointType) ? 0 : 30;
        panel.add((Component)this.descMsg, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 18, 1, new Insets(20, 30, 0, 30), 0, 0));
        panel.add((Component)this.jLblTitleDesc, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 30, 0, 0), 0, 0));
        panel.add((Component)this.jLblUserName, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 30, 0, 0), 0, 0));
        panel.add((Component)this.jTfUserName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 30), 0, 0));
        panel.add((Component)this.jLblPassword, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 30, lastItemBottomPadding, 0), 0, 0));
        panel.add((Component)this.jTfPassword, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, lastItemBottomPadding, 30), 0, 0));
        if ("Windows".equalsIgnoreCase(endpointType)) {
            lastItemBottomPadding = 30;
            panel.add((Component)this.jLblDomain, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 30, lastItemBottomPadding, 0), 0, 0));
            panel.add((Component)this.jTfDomain, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, lastItemBottomPadding, 30), 0, 0));
        }
        return panel;
    }

    public boolean isDomain() {
        return true;
    }

    public String getUserName() {
        return this.jTfUserName.getText().trim();
    }

    public String getPassword() {
        return new String(this.jTfPassword.getPassword());
    }

    public String getDomain() {
        return this.jTfDomain.getText().trim();
    }

    @Override
    public boolean isValidate() {
        String strUserName = this.getUserName();
        if ("".equals(strUserName)) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(CLIENTDIALOG, "LoginDlg.invalidUserErrorMsg"), MSGRES.getString(CLIENTDIALOG, "LoginDlg.error"), 0);
            this.jTfUserName.requestFocus();
            return false;
        }
        if (strUserName.length() > 256) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(CLIENTDIALOG, "LoginDlg.maxLenUserErrorMsg"), MSGRES.getString(CLIENTDIALOG, "LoginDlg.error"), 0);
            this.jTfUserName.requestFocus();
            return false;
        }
        if (this.getPassword().length() > 128) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(CLIENTDIALOG, "LoginDlg.maxLenPwdErrorMsg"), MSGRES.getString(CLIENTDIALOG, "LoginDlg.error"), 0);
            this.jTfPassword.requestFocus();
            return false;
        }
        if (this.getDomain().length() > 256) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(CLIENTDIALOG, "LoginDlg.maxLenDomainErrorMsg"), MSGRES.getString(CLIENTDIALOG, "LoginDlg.error"), 0);
            this.jTfDomain.requestFocus();
            return false;
        }
        return true;
    }
}

