/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.configobject.rpc.SemLoginInfo;
import com.sygate.scm.common.configobject.schema.AmlLowBandwidth;
import com.sygate.scm.common.configobject.schema.ClientFeature;
import com.sygate.scm.common.configobject.schema.EnabledClientFeatures;
import com.sygate.scm.common.configobject.schema.PackageInfo;
import com.sygate.scm.common.configobject.schema.PackageLuInfo;
import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.common.ui.SupportLink;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationFeatureObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationSettingObject;
import com.sygate.scm.console.ui.client.AbstractExportPackageValidator;
import com.sygate.scm.console.ui.client.ExportPackageSettings;
import com.sygate.scm.console.ui.client.ExportPackageWorkerFacotry;
import com.sygate.scm.console.ui.client.WindowsPackageSizeCalculator;
import com.sygate.scm.console.ui.client.dlg.ClientInstallationWizard;
import com.sygate.scm.console.ui.client.dlg.CreatePackagePanel;
import com.sygate.scm.console.ui.client.dlg.DeployProgressPanel;
import com.sygate.scm.console.ui.client.dlg.DeploySummaryPanel;
import com.sygate.scm.console.ui.client.dlg.ExportFolderChooser;
import com.sygate.scm.console.ui.client.dlg.InstallClientDefineEmailPanel;
import com.sygate.scm.console.ui.client.dlg.ReadyToDeployPanel;
import com.sygate.scm.console.ui.client.dlg.ReadyToInstallPanel;
import com.sygate.scm.console.ui.client.dlg.RemoteMethodPanel;
import com.sygate.scm.console.ui.client.networkaudit.RemotePushComputerObject;
import com.sygate.scm.console.ui.client.wizard.AddPackageProgressPanel;
import com.sygate.scm.console.ui.client.wizard.DeploymentTypePanel;
import com.sygate.scm.console.ui.client.wizard.InstallMethodPanel;
import com.sygate.scm.console.ui.client.wizard.PackageHandlingOptionPanel;
import com.sygate.scm.console.ui.client.wizard.PackageOptionsPanel;
import com.sygate.scm.console.ui.client.wizard.SavePackagePanel;
import com.sygate.scm.console.ui.client.wizard.SylinkdropOptionsPanel;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.lu.LuUtility;
import com.sygate.scm.console.ui.policy.util.PolicyUtil;
import com.sygate.scm.console.ui.util.HTMLEditorPane;
import com.sygate.scm.console.ui.util.MultiLineMsgBox;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.WizardBase;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.HTMLUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.PackageUtil;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.SwingWorker;
import com.sygate.scm.util.URLUtility;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class InstallClientWizardDialog
extends WizardBase {
    private static final long serialVersionUID = -1075708993879060996L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENTDIALOG = "com.sygate.scm.console.ui.client.dlg.clientdialog";
    private boolean showWelcomeTour = false;
    private boolean isNextButtonDirty = false;
    private static final int STAGE_COUNT = 20;
    private static final int STAGE_SYLINKDROP_PAKAGE = -2;
    private static final int STAGE_WELCOME_TOUR = -1;
    private static final int STAGE_DEPLOY_TYPE = 0;
    private static final int STAGE_EXISTING_PACKAGE = 1;
    private static final int STAGE_GROUP_FEATURE = 2;
    private static final int STAGE_DEFINE_EMAIL = 3;
    private static final int STAGE_SELECT_REMOTE_METHOD = 4;
    private static final int STAGE_CREATE_PACKAGE = 6;
    private static final int STAGE_READY_TO_INSTALL = 7;
    private static final int STAGE_READY_TO_DEPLOY = 9;
    private static final int STAGE_DEPLOY_PROGRESS = 10;
    private static final int STAGE_DEPLOY_SUMMARY = 11;
    private static final int STAGE_COMPLETE = 19;
    private static final int STAGE_INSTALL_METHOD = 14;
    private static final int STAGE_PACKAGE_METHOD = 15;
    private static final int STAGE_SAVE_PACKAGE = 16;
    public static final int SNAC_ONLY = 0;
    public static final int SAV_ONLY = 1;
    public static final int SNAC_AND_SAV = 2;
    private String strExportDir = Utility.getTempDir() + File.separator + "ClientPackages";
    private boolean useExportedPackage = false;
    private boolean usingPackageFolder = false;
    private boolean useCommunicationPackage = false;
    private static LicenseObject license = LicenseObject.getInstance();
    private GroupObject groupObject = null;
    private final WizardBase.WelcomeAndFinishPanel welcomeTourPanel = new InstallClientWelcomePanel(0, null, null);
    private final InstallClientFinishPanel completePanel = new InstallClientFinishPanel(1, MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "InstallClientWizardDialog.completeTitle"), "");
    private InstallClientDefineEmailPanel defineEmail = null;
    private RemoteMethodPanel remotePanel = null;
    private ReadyToInstallPanel readyToInstallPanel = null;
    private ReadyToDeployPanel readyToDeployPanel = null;
    private CreatePackagePanel createPackagePanel = null;
    private DeployProgressPanel deployProgressPanel = null;
    private DeploySummaryPanel deploySummaryPanel = null;
    private ArrayList<String> arrListGroupIds = null;
    private DeploymentTypePanel wizardTypePanel = null;
    private PackageOptionsPanel groupFeaturePanel = null;
    private InstallMethodPanel installMethodPanel = null;
    private PackageHandlingOptionPanel packageHandlingPanel = null;
    private SavePackagePanel savePackagePanel = null;
    private AddPackageProgressPanel existingPackagePanel = null;
    private SylinkdropOptionsPanel sylinkdropOptionsPanel = null;
    static final List<RemotePushComputerObject> lstSearchCache = new ArrayList<RemotePushComputerObject>();
    static final List<RemotePushComputerObject> lstSearchCacheMac = new ArrayList<RemotePushComputerObject>();
    private Map<String, CurrentPackageObject> mLatestPackages = null;
    private final List<CurrentPackageObject> selectedPackage = new ArrayList<CurrentPackageObject>();
    private boolean isSMB = false;
    private boolean cloudEnrolled = false;
    private boolean cleanUpServerDirRequired = false;

    public InstallClientWizardDialog(boolean isSCWContext) {
        super(MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.installClient"), true, WizardBase.HelpButtonState.OFF);
        if (isSCWContext) {
            this.showWelcomeTour = true;
        }
        this.initDialog();
    }

    public InstallClientWizardDialog(GroupObject groupObject) {
        super(MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.installClient"), true, WizardBase.HelpButtonState.OFF);
        if (groupObject != null) {
            this.groupObject = groupObject;
        }
        this.initDialog();
    }

    protected PackageOptionsPanel createDefaultPackageOptionsPanel() {
        return new PackageOptionsPanel(this, this.isSMB);
    }

    protected Dimension getDimension() {
        return this.groupFeaturePanel.getPreferredSize();
    }

    private void initDialog() {
        try {
            this.isSMB = LicenseObject.getInstance().isSBProduct();
        }
        catch (Exception e) {
            this.isSMB = false;
        }
        try {
            this.mLatestPackages = this.fetchLatestPackagesFromDB();
            this.groupFeaturePanel = this.groupObject == null ? this.createDefaultPackageOptionsPanel() : new PackageOptionsPanel(this, this.groupObject, this.isSMB);
            this.cloudEnrolled = CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId());
        }
        catch (ConsoleException ce) {
            this.handleException(ce);
            return;
        }
        catch (Exception ex) {
            this.handleException(new ConsoleException(ex));
            return;
        }
        this.wizardTypePanel = new DeploymentTypePanel(this, this.isSMB);
        this.installMethodPanel = new InstallMethodPanel(this, this.isSMB);
        this.packageHandlingPanel = new PackageHandlingOptionPanel(this, this.isSMB);
        this.savePackagePanel = new SavePackagePanel(this, this.isSMB);
        this.existingPackagePanel = new AddPackageProgressPanel(this, this.isSMB);
        this.sylinkdropOptionsPanel = new SylinkdropOptionsPanel(this, this.isSMB);
        this.defineEmail = new InstallClientDefineEmailPanel(this, this.isSMB);
        this.remotePanel = new RemoteMethodPanel(this, this.isSMB, lstSearchCache);
        this.readyToInstallPanel = new ReadyToInstallPanel(this, this.isSMB);
        this.readyToDeployPanel = new ReadyToDeployPanel(this, this.isSMB);
        this.createPackagePanel = new CreatePackagePanel(this, this.isSMB);
        this.deployProgressPanel = new DeployProgressPanel(this, this.isSMB);
        this.deploySummaryPanel = new DeploySummaryPanel(this, this.isSMB);
        this.welcomeTourPanel.setLogoVisible(this.isSMB);
        this.completePanel.setLogoVisible(false);
        if (this.showWelcomeTour) {
            this.addStage(this.welcomeTourPanel, -1);
            this.setCurrentStageIndex(-1);
        }
        this.addStage(this.wizardTypePanel, 0);
        this.addStage(this.existingPackagePanel, 1);
        this.addStage(this.sylinkdropOptionsPanel, -2);
        this.addStage(this.groupFeaturePanel, 2);
        this.addStage(this.defineEmail, 3);
        this.addStage(this.remotePanel, 4);
        this.addStage(this.createPackagePanel, 6);
        this.addStage(this.readyToInstallPanel, 7);
        this.addStage(this.readyToDeployPanel, 9);
        this.addStage(this.deployProgressPanel, 10);
        this.addStage(this.deploySummaryPanel, 11);
        this.addStage(this.completePanel, 19);
        this.addStage(this.installMethodPanel, 14);
        this.addStage(this.packageHandlingPanel, 15);
        this.addStage(this.savePackagePanel, 16);
        Dimension size = this.getDimension();
        this.welcomeTourPanel.setSize(size);
        this.defineEmail.setSize(size);
        this.remotePanel.setSize(size);
        this.readyToDeployPanel.setSize(size);
        this.deployProgressPanel.setSize(size);
        this.deploySummaryPanel.setSize(size);
        this.completePanel.setSize(size);
        this.sylinkdropOptionsPanel.setSize(size);
        this.arrListGroupIds = new ArrayList();
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public GroupObject getGroup() {
        if (this.groupFeaturePanel != null) {
            return this.groupFeaturePanel.getGroup();
        }
        return null;
    }

    protected void addStage(ClientInstallationWizard wizardStage, int index) {
        super.addStage(wizardStage.getWizardStagePanel(), index);
    }

    @Override
    @Deprecated
    protected void addStage(Component comp, int index) {
        super.addStage(comp, index);
    }

    private List<Object> getDisplayFeatrueList() {
        ArrayList<Object> ret = new ArrayList<Object>();
        CurrentPackageObject selectedPkgObj = this.groupFeaturePanel.getSelectedPackages().get(0);
        String snacDes = MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.SNAC");
        boolean enabledWinFeatureIncluded = false;
        boolean macSAVFeatureIncluded = false;
        SoftwarePackage sp = selectedPkgObj.getSoftwarePackage();
        String platform = PackageUtil.getSoftwarePackagePlatformType((SoftwarePackage)sp);
        int type = sp.getPackageInfo().getType();
        String packageVersion = selectedPkgObj.getPackageVersion();
        if (151 == type || 300 == type) {
            if (!ret.contains(snacDes)) {
                ret.add(snacDes);
            }
        } else if (105 == type) {
            if (("WIN32BIT".equals(platform) || "WIN64BIT".equals(platform)) && !enabledWinFeatureIncluded) {
                ret.addAll(this.getWinEnabledFeatureList());
                enabledWinFeatureIncluded = true;
            } else if ("Mac".equals(platform) && !macSAVFeatureIncluded) {
                ret.addAll(this.getMacEnabledFeatureList(packageVersion));
                macSAVFeatureIncluded = true;
            } else if (ConstantValue.isLinuxPlatform((String)platform) || ConstantValue.isLinuxStubPlatform((String)platform)) {
                ret.addAll(this.getLinuxEnabledFeatureList());
            }
        }
        return ret;
    }

    private List<Object> getLinuxEnabledFeatureList() {
        ArrayList<Object> enabledFeatureList = new ArrayList<Object>();
        enabledFeatureList.add(MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.SAVMain"));
        return enabledFeatureList;
    }

    private List<Object> getMacEnabledFeatureList(String packageVersion) {
        ArrayList<Object> listStrProtection = new ArrayList<Object>();
        boolean isIPSIncluded = true;
        listStrProtection.add(MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.SAVMain"));
        if (packageVersion != null && packageVersion.length() > 0 && Utility.compareVersion((String)"12.1.3500.0", (String)packageVersion) > 0) {
            isIPSIncluded = false;
        }
        ArrayList<String> lstSubFeatures = new ArrayList<String>();
        if (isIPSIncluded) {
            listStrProtection.add(MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.NTPMain"));
            lstSubFeatures.add(MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.ITPMain"));
            listStrProtection.add(lstSubFeatures);
        }
        return listStrProtection;
    }

    private List<String> getWinEnabledFeatureList() {
        String strOutlook = MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.OutlookSnapin");
        String strPop3 = MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.Pop3Smtp");
        String strCOH = MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.COHMain");
        String strLotusNotes = MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.NotesSnapin");
        String strFeatureName = "";
        ArrayList<String> listStrProtection = new ArrayList<String>();
        EnabledClientFeatures enabledFeatures = null;
        enabledFeatures = this.groupFeaturePanel.getEnabledFeatures();
        Vector vEnabled = enabledFeatures.getClientFeature();
        try {
            for (ClientFeature feature : vEnabled) {
                Boolean isFeatureEnabled = feature.getOptEnabled();
                if (feature.getFeatureName() == null || feature.getFeatureName().trim().length() < 1 || isFeatureEnabled == null || !isFeatureEnabled.booleanValue()) continue;
                strFeatureName = MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog." + feature.getFeatureName());
                if (this.isSMB && (strFeatureName.equals(strOutlook) || strFeatureName.equals(strCOH)) || strFeatureName.equals(strLotusNotes) || strFeatureName.equals(strPop3) || listStrProtection.contains(strFeatureName)) continue;
                listStrProtection.add(strFeatureName);
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            this.handleException(ex);
        }
        return listStrProtection;
    }

    private String getSelectedPackageId(String defaultSecurityFixBuildNumber) {
        if (this.groupFeaturePanel != null) {
            return this.groupFeaturePanel.getSelectedPackage(defaultSecurityFixBuildNumber);
        }
        return null;
    }

    @Override
    protected void showNextPanel(int stage) {
        super.showNextPanel(stage);
        if (stage == 4) {
            this.remotePanel.initBrowseNetworkTree();
        }
    }

    @Override
    protected void prepareNext(int stage) {
        if (stage == 1) {
            this.setUseExportedPackage(this.wizardTypePanel.useExistingPackage());
            this.setUsingPackageFolder(this.wizardTypePanel.isUsingPackageFolder());
        } else if (stage == -2) {
            this.setUseCommunicationPackage(this.wizardTypePanel.isSylinkDrop());
        } else if (stage == 14) {
            if (this.wizardTypePanel.isSylinkDrop()) {
                this.defineEmail.generateBodyForSepCommunicationUpdater(this.sylinkdropOptionsPanel.getSelectedGroupId());
            } else {
                List<CurrentPackageObject> thepackage = this.groupFeaturePanel.getSelectedPackages();
                this.setSelectedPackage(thepackage);
                this.defineEmail.generateBody(this.getGroup().getId(), thepackage, this.groupFeaturePanel.isMac1015OrUp());
            }
        } else if (stage == 7) {
            ArrayList<String> listEntries = new ArrayList<String>();
            if (this.wizardTypePanel.isSylinkDrop()) {
                listEntries = new ArrayList();
                this.strExportDir = this.savePackagePanel.getDirPath();
                listEntries.add(this.strExportDir);
                this.readyToInstallPanel.updateUIForSepCommunicationUpdater(this.sylinkdropOptionsPanel.getSelectedGroup().getFullGroupPath());
                this.readyToInstallPanel.setBottomDesc(listEntries);
            } else if (this.groupFeaturePanel.getPackageOSType() != 1 && this.groupFeaturePanel.getPackageOSType() != 2) {
                this.readyToInstallPanel.setTopDesc(this.getGroup().getFullGroupPath(), this.getDisplayFeatrueList());
                if (this.installMethodPanel.isCustomSelected()) {
                    listEntries = new ArrayList();
                    this.strExportDir = this.savePackagePanel.getDirPath();
                    listEntries.add(this.strExportDir);
                    if (this.savePackagePanel.isSingleFileSelected()) {
                        this.readyToInstallPanel.setChoice(3);
                    } else {
                        this.readyToInstallPanel.setChoice(4);
                    }
                }
                this.readyToInstallPanel.setBottomDesc(listEntries);
            } else {
                this.readyToInstallPanel.setTopDesc(this.getGroup().getFullGroupPath(), this.getDisplayFeatrueList());
                if (this.installMethodPanel.isCustomSelected()) {
                    listEntries = new ArrayList();
                    this.strExportDir = this.savePackagePanel.getDirPath();
                    listEntries.add(this.strExportDir);
                    this.readyToInstallPanel.setChoice(4);
                }
                this.readyToInstallPanel.setBottomDesc(listEntries);
            }
        } else if (stage == 9) {
            this.readyToDeployPanel.updateUIForCommunicationSettings(this.wizardTypePanel.isSylinkDrop());
            this.readyToDeployPanel.setData(this.remotePanel.getSelectedComputers());
        } else if (stage == 19) {
            String strMessage = "";
            if (this.installMethodPanel.isEmailSelected()) {
                strMessage = MSGRES.getString(CLIENTDIALOG, "InstallClientFinishPanel.emailMessage");
            } else if (this.installMethodPanel.isRemoteSelected()) {
                int totalNodes = this.getTotalNodes();
                int deployedNode = this.getFinishedNodes();
                if (this.wizardTypePanel.isSylinkDrop()) {
                    if (deployedNode < totalNodes) {
                        String text = MSGRES.getString(CLIENTDIALOG, "InstallClientFinishPanel.remotePushFailedMessageCommunication");
                        strMessage = MessageFormat.format(text, totalNodes - deployedNode, totalNodes);
                    } else {
                        strMessage = MSGRES.getString(CLIENTDIALOG, "InstallClientFinishPanel.remotePushMessageCommunication");
                    }
                } else if (deployedNode < totalNodes) {
                    String text = MSGRES.getString(CLIENTDIALOG, "InstallClientFinishPanel.remotePushFailedMessage");
                    strMessage = MessageFormat.format(text, totalNodes - deployedNode, totalNodes);
                } else {
                    strMessage = MSGRES.getString(CLIENTDIALOG, "InstallClientFinishPanel.remotePushMessage");
                }
            } else if (this.installMethodPanel.isCustomSelected()) {
                strMessage = AjaxSwingCommonUtil.isAjaxSwingRunning() ? MSGRES.getString(CLIENTDIALOG, "InstallClientFinishPanel.customMessageWeb") : MSGRES.getString(CLIENTDIALOG, "InstallClientFinishPanel.customMessage");
                String realExportDir = this.strExportDir;
                String exportURL = new File(realExportDir).toURI().toString();
                strMessage = StringUtilities.formatHTML((String)strMessage, (String[])new String[]{exportURL, realExportDir});
            }
            this.completePanel.setFinishMessage(strMessage);
        }
    }

    private int getFinishedNodes() {
        return this.deployProgressPanel.getFinishedNodes();
    }

    private int getTotalNodes() {
        return this.deployProgressPanel.getTotalNodes();
    }

    @Override
    protected boolean validatePanel(int stage) {
        boolean isValid;
        try {
            switch (stage) {
                case 0: {
                    isValid = this.wizardTypePanel.validatePanel();
                    if (isValid && this.wizardTypePanel.getWizardType() == 0 && this.getLatestPackages().isEmpty()) {
                        throw new GUICheckException(MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.noPackageError"));
                    }
                    break;
                }
                case 3: {
                    isValid = this.defineEmail.validatePanel();
                    break;
                }
                case 2: {
                    isValid = this.validGroupPanel();
                    try {
                        GroupObject selectedGroup = this.groupFeaturePanel.getGroup();
                        ArrayList<GroupObject> selectedGroups = new ArrayList<GroupObject>();
                        selectedGroups.add(selectedGroup);
                        ArrayList<SoftwarePackage> selectedPackages = new ArrayList<SoftwarePackage>();
                        List<CurrentPackageObject> selectPkgObjs = this.groupFeaturePanel.getSelectedPackages();
                        for (int i = 0; i < selectPkgObjs.size(); ++i) {
                            SoftwarePackage sp = selectPkgObjs.get(i).getSoftwarePackage();
                            selectedPackages.add(sp);
                        }
                        ArrayList<GroupObject> unAvaliableGroups = LuUtility.checkHIContentAvailable(selectedGroups, selectedPackages);
                        if (null != unAvaliableGroups) {
                            throw new GUICheckException(MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.checkHIConetentFail"));
                        }
                        break;
                    }
                    catch (Exception e) {
                        throw new GUICheckException(e.getMessage());
                    }
                }
                case 14: {
                    isValid = this.installMethodPanel.validateInstallMethodPanel();
                    break;
                }
                case 4: {
                    boolean isRemotePushSylink = false;
                    if (this.wizardTypePanel.isSylinkDrop()) {
                        isRemotePushSylink = true;
                    }
                    isValid = this.remotePanel.validatePanel(isRemotePushSylink);
                    break;
                }
                case 9: {
                    isValid = this.readyToDeployPanel.validatePanel();
                    break;
                }
                case 16: {
                    isValid = this.savePackagePanel.validatePanel(this.groupFeaturePanel.getGroup());
                    if (isValid) {
                        ArrayList<GroupObject> listGroups = new ArrayList<GroupObject>(1);
                        listGroups.add(this.getGroup());
                        ArrayList<SoftwarePackageObject> listExportedPackage = new ArrayList<SoftwarePackageObject>(1);
                        if (this.isSMB) {
                            if (this.is32BitPackageSelected()) {
                                CurrentPackageObject cpo32Bit = this.getLatestPackage("WIN32BIT");
                                listExportedPackage.add(cpo32Bit.getSoftwarePackageObject());
                            }
                            if (this.is64BitPackageSelected()) {
                                CurrentPackageObject cpo64Bit = this.getLatestPackage("WIN64BIT");
                                listExportedPackage.add(cpo64Bit.getSoftwarePackageObject());
                            }
                        }
                        if (listExportedPackage.size() == 0) {
                            List<CurrentPackageObject> selPackage = this.getSelectedPackage();
                            for (CurrentPackageObject packageObj : selPackage) {
                                listExportedPackage.add(packageObj.getSoftwarePackageObject());
                            }
                        }
                        AbstractExportPackageValidator validator = ExportPackageWorkerFacotry.getInstance().getExportPackageValidator(listExportedPackage);
                        this.strExportDir = this.savePackagePanel.getDirPath();
                        CurrentPackageObject packageObj = this.groupFeaturePanel.getSelectedPackages().get(0);
                        String platform = packageObj.getSoftwarePackage().getPackageInfo().getOptPlatformType();
                        if ("WIN32BIT".equals(platform) || "WIN64BIT".equals(platform)) {
                            ClientInstallationSettingObject settings = this.getInstallSettings();
                            ClientInstallationFeatureObject ciFeature = new ClientInstallationFeatureObject(this.groupFeaturePanel.getFeatures());
                            WindowsPackageSizeCalculator pkgCal = new WindowsPackageSizeCalculator();
                            long hbPkgSizeWithLatestContent = pkgCal.calculateOnePackageSize(packageObj, settings, ciFeature, this.getContentOption(), this.savePackagePanel.isSingleFileSelected(), false);
                            long lbPkgSizeWithLatestContent = pkgCal.calculateOnePackageSize(packageObj, settings, ciFeature, this.getContentOption(), this.savePackagePanel.isSingleFileSelected(), true);
                            isValid = validator.validateExportDir(this.strExportDir, this.savePackagePanel.isSingleFileSelected(), listGroups, 0, hbPkgSizeWithLatestContent, lbPkgSizeWithLatestContent, "");
                            break;
                        }
                        isValid = validator.validateExportDir(this.strExportDir, this.savePackagePanel.isSingleFileSelected(), listGroups, 0, "");
                    }
                    break;
                }
                default: {
                    isValid = true;
                }
            }
        }
        catch (GUICheckException ex) {
            MultiLineMsgBox optionPane = new MultiLineMsgBox(Manager.getFrame(), MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.error"));
            optionPane.init(ex.getMessage(), 60, 0, -1);
            optionPane.show();
            JComponent errorComp = ex.getErrorComponent();
            if (errorComp != null) {
                errorComp.requestFocus();
            }
            isValid = false;
        }
        return isValid;
    }

    private boolean validGroupPanel() throws GUICheckException {
        return this.groupFeaturePanel.validatePanel();
    }

    public boolean isSMBProduct() {
        return this.isSMB;
    }

    public boolean is32BitPackageSelected() {
        if (this.isSMBProduct()) {
            return true;
        }
        return this.groupFeaturePanel.is32BitSelected();
    }

    public boolean is64BitPackageSelected() {
        if (this.isSMBProduct()) {
            return true;
        }
        return this.groupFeaturePanel.is64BitSelected();
    }

    public boolean isMacPackageSelected() {
        return this.groupFeaturePanel.isMacSelected();
    }

    public int getInstallStyle() {
        return this.groupFeaturePanel.getInstallStyle();
    }

    @Override
    protected int getStageCount() {
        return 20;
    }

    @Override
    protected int getNextStage(int currentStage) {
        if (currentStage == 0) {
            if (this.wizardTypePanel.getWizardType() == 1) {
                return 1;
            }
            if (this.wizardTypePanel.isSylinkDrop()) {
                return -2;
            }
            return 2;
        }
        if (currentStage == 1) {
            if (!this.existingPackagePanel.isValidated()) {
                return 1;
            }
            this.installMethodPanel.setInstall_method(1);
            if (this.isDeployExistingPackageForMac()) {
                return 14;
            }
            return 4;
        }
        if (currentStage == -2) {
            if (this.wizardTypePanel.isSylinkDropMac()) {
                return 14;
            }
            this.installMethodPanel.setInstall_method(2);
            if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                return 7;
            }
            return 16;
        }
        if (currentStage == 3 || currentStage == 11) {
            return 19;
        }
        if (currentStage == 4) {
            return 9;
        }
        if (currentStage == 7) {
            if (this.installMethodPanel.isCustomSelected()) {
                return 6;
            }
            if (this.installMethodPanel.isRemoteSelected()) {
                return 19;
            }
        } else {
            if (currentStage == 9) {
                return 10;
            }
            if (currentStage == 10) {
                return 11;
            }
            if (currentStage == 6) {
                return 19;
            }
            if (currentStage == 2) {
                return 14;
            }
            if (currentStage == 14) {
                if (this.installMethodPanel.isRemoteSelected()) {
                    return 4;
                }
                if (this.installMethodPanel.isCustomSelected()) {
                    if (this.wizardTypePanel.isSylinkDrop() && AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                        return 7;
                    }
                    return 16;
                }
                return 3;
            }
            if (currentStage == 15) {
                if (this.packageHandlingPanel.getPackage_method() != 0) {
                    return 16;
                }
                return 3;
            }
            if (currentStage == 16) {
                return 7;
            }
        }
        return super.getNextStage(currentStage);
    }

    @Override
    protected int getPreviousStage(int currentStage) {
        if (currentStage == 4) {
            if (this.wizardTypePanel.getWizardType() == 1 && !this.isDeployExistingPackageForMac()) {
                return 0;
            }
            return 14;
        }
        if (currentStage == 7) {
            if (this.installMethodPanel.isCustomSelected()) {
                if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                    if (this.wizardTypePanel.isSylinkDropWin()) {
                        return -2;
                    }
                    if (this.wizardTypePanel.isSylinkDropMac()) {
                        return 14;
                    }
                }
                return 16;
            }
        } else {
            if (currentStage == 9) {
                return 4;
            }
            if (currentStage == 10) {
                return 9;
            }
            if (currentStage == 0) {
                return -1;
            }
            if (currentStage == 2) {
                return 0;
            }
            if (currentStage == 14) {
                if (this.isDeployExistingPackageForMac()) {
                    return 0;
                }
                if (this.wizardTypePanel.isSylinkDrop()) {
                    return -2;
                }
                return 2;
            }
            if (currentStage == -2) {
                return 0;
            }
            if (currentStage == 15) {
                return 14;
            }
            if (currentStage == 3) {
                return 14;
            }
            if (currentStage == 16) {
                if (this.wizardTypePanel.isSylinkDropWin()) {
                    return -2;
                }
                return 14;
            }
        }
        return super.getPreviousStage(currentStage);
    }

    @Override
    protected boolean disableBackButtonAtCompletePanel() {
        return true;
    }

    @Override
    protected boolean disableCancelButtonAtCompletePanel() {
        return true;
    }

    @Override
    protected void updateButtons(int stage) {
        super.updateButtons(stage);
        if (this.showWelcomeTour) {
            if (stage == 0) {
                this.jBBack.setEnabled(true);
            }
            if (stage == -1) {
                this.jBBack.setEnabled(false);
            }
        }
        if (!this.isSMBProduct() && stage == 0) {
            this.jBBack.setEnabled(false);
        }
        if (stage == 1) {
            this.jBBack.setEnabled(false);
        }
        if (stage == 7 || stage == 9) {
            String strButtonText = this.installMethodPanel.isEmailSelected() ? MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.exportButton") : (this.installMethodPanel.isCustomSelected() ? UIText.get(3328) : MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.installButton"));
            this.jBNext.setText(strButtonText);
            this.isNextButtonDirty = true;
        }
        if (this.isNextButtonDirty && (stage == 3 || stage == 4)) {
            this.jBNext.setText(UIText.get(3328));
        }
        if (stage == 6 || stage == 10) {
            this.jBBack.setEnabled(false);
            this.jBNext.setText(UIText.get(3328));
            this.jBNext.setEnabled(false);
        }
        if (stage == 11) {
            this.jBBack.setEnabled(false);
            this.jBNext.requestFocus();
        }
    }

    @Override
    protected void handleException(Exception ex) {
        String errMsg = "";
        int code = 0;
        if (ex != null) {
            LoggerUtilities.logException((Throwable)ex);
        }
        if (ex instanceof ConsoleException) {
            ConsoleException ce = (ConsoleException)ex;
            code = ce.getErrorCode();
            switch (code) {
                case -267714560: {
                    errMsg = MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.noPackageError");
                    break;
                }
                case 0x19010000: {
                    errMsg = MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.failedtoSendEmail");
                    break;
                }
                default: {
                    errMsg = ex.getMessage();
                }
            }
        }
        if (code != 0x19010000 && errMsg != null && !errMsg.isEmpty()) {
            JOptionPane.showMessageDialog(this, errMsg, MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.error"), 0);
        }
        this.dispose();
    }

    @Override
    protected void cancel() {
        if (0 != JOptionPane.showConfirmDialog(Manager.getFrame(), new HtmlEnabledJLabel("<html>" + MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.CancelMessage") + "</html>"), MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.warningDialogTitle"), 0)) {
            return;
        }
        if (this.getCurrentStageIndex() == 6) {
            this.createPackagePanel.stopInMiddle();
        } else if (this.getCurrentStageIndex() == 10) {
            this.deployProgressPanel.cancel();
        }
        if (this.remotePanel.isClientRemoteLaunched()) {
            this.remotePanel.stopBrowseRequest();
        }
        this.cleanUpServerTmpPkgDirIfRequired();
        this.isOk = false;
        this.dispose();
    }

    public boolean getisOk() {
        return this.isOk;
    }

    @Override
    protected boolean isHelpButtonShown() {
        return false;
    }

    public void enableNetxButton(boolean enableButton) {
        this.jBNext.setEnabled(enableButton);
    }

    public void doNextClicked() {
        this.jBNext.doClick();
    }

    public void setNextButtonText(String text) {
        this.jBNext.setText(text);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void showStage(int stage) {
        selectedOption = this.groupFeaturePanel.getSelectedInstallSettings().getInstallationOption();
        reducedSize = selectedOption.getOptSpecifyReducedInstallSize() == null ? selectedOption.getDefSpecifyReducedInstallSize() : selectedOption.getOptSpecifyReducedInstallSize();
        darkNetwork = selectedOption.getOptDarkNetwork() == null ? selectedOption.getDefDarkNetwork() : selectedOption.getOptDarkNetwork();
        switch (stage) {
            case 1: {
                this.existingPackagePanel.setPackagePath(this.wizardTypePanel.getFilePath(), this.wizardTypePanel.getFileName());
                break;
            }
            case -2: {
                this.sylinkdropOptionsPanel.setAppropriateVisible();
                break;
            }
            case 6: {
                if (this.arrListGroupIds != null) {
                    this.arrListGroupIds.add(this.getSelectedGroupID());
                }
                if (this.wizardTypePanel.isSylinkDrop()) {
                    groups = new ArrayList<String>();
                    groups.add(this.sylinkdropOptionsPanel.getSelectedGroupId());
                    agentMode = this.sylinkdropOptionsPanel.getAgentMode();
                    packageSettings = new ExportPackageSettings(this.savePackagePanel.getDirPath(), groups, agentMode, this.wizardTypePanel.isSylinkDropWin() == false);
                    this.createPackagePanel.exportSepCommunicationUpdaterPackage(packageSettings);
                    break;
                }
                groups = new ArrayList<String>();
                groups.add(this.groupFeaturePanel.getGroup().getId());
                settings = new ArrayList<ExportPackageSettings>();
                selectPkgObjs = this.groupFeaturePanel.getSelectedPackages();
                for (i = 0; i < selectPkgObjs.size(); ++i) {
                    sp = selectPkgObjs.get(i).getSoftwarePackageObject();
                    packageSettings = new ExportPackageSettings(sp, this.savePackagePanel.getDirPath(), groups, this.savePackagePanel.isSingleFileSelected(), true, true, this.getInstallSettings(), new ClientInstallationFeatureObject(this.groupFeaturePanel.getFeatures()), false, "", this.getContentOption(), false);
                    packageSettings.setAgentMode(this.groupFeaturePanel.getPolicyMode());
                    packageSettings.setKeepAllDataOnUpgrade(this.groupFeaturePanel.isMaintainOldSettingsMac());
                    packageSettings.setMac1015OrUp(this.groupFeaturePanel.isMac1015OrUp());
                    settings.add(packageSettings);
                }
                if (this.isSMBProduct() && this.savePackagePanel.legacyPackageSelected() && (legacyPackages = this.groupFeaturePanel.getLegacyPackageList()) != null && legacyPackages.size() > 0) {
                    sp = legacyPackages.get(0).getSoftwarePackageObject();
                    packageSetting = new ExportPackageSettings(sp, this.savePackagePanel.getDirPath(), groups, this.savePackagePanel.isSingleFileSelected(), true, true, this.getInstallSettings(), new ClientInstallationFeatureObject(this.groupFeaturePanel.getFeatures()), false, "", this.getContentOption(), false);
                    packageSetting.setAgentMode(this.groupFeaturePanel.getPolicyMode());
                    packageSetting.setKeepAllDataOnUpgrade(this.groupFeaturePanel.isMaintainOldSettingsMac());
                    packageSetting.setMac1015OrUp(this.groupFeaturePanel.isMac1015OrUp());
                    settings.add(packageSetting);
                }
                this.createPackagePanel.exportPackages(settings, this.strExportDir);
                break;
            }
            case 10: {
                try {
                    this.deployProgressPanel.setData(this.readyToDeployPanel.getData());
                    if (this.wizardTypePanel.isSylinkDrop()) {
                        isMac = this.wizardTypePanel.isSylinkDropWin() == false;
                        agentMode = this.sylinkdropOptionsPanel.getAgentMode();
                        this.deployProgressPanel.sendRequestForSepCommunicationUpdater(this.readyToDeployPanel.getData(), this.sylinkdropOptionsPanel.getSelectedGroupId(), agentMode, isMac, this.getKnownHostsFileName());
                        break;
                    }
                    if (this.wizardTypePanel.useExistingPackage()) {
                        lowBandwidthEnabled = this.isLowBandwidthEnabled(this.groupFeaturePanel, darkNetwork);
                        this.deployProgressPanel.sendRequest(this.getSelectedPackageId(null), this.readyToDeployPanel.getData(), this.getGroup().getId(), this.groupFeaturePanel.getFeatures().getString(), this.getContentOption(), this.existingPackagePanel.getSavedFilePath(), this.existingPackagePanel.getSavedFileName(), this.groupFeaturePanel.getPolicyMode(), false, false, this.groupFeaturePanel.isMaintainOldSettingsMac(), this.groupFeaturePanel.isMac1015OrUp(), this.getKnownHostsFileName(), reducedSize, darkNetwork, lowBandwidthEnabled);
                        break;
                    }
                    lowBandwidthEnabled = this.isLowBandwidthEnabled(this.groupFeaturePanel, darkNetwork);
                    selectedInstallSettingsName = this.groupFeaturePanel.getSelectedInstallSettingsName();
                    this.deployProgressPanel.sendRequest(this.getSelectedPackageId(this.groupFeaturePanel.getSecurityFixBuildNumber()), this.readyToDeployPanel.getData(), this.getGroup().getId(), this.groupFeaturePanel.getFeatures().getString(), this.getContentOption(), selectedInstallSettingsName, this.groupFeaturePanel.getPolicyMode(), false, false, this.groupFeaturePanel.isMaintainOldSettingsMac(), this.groupFeaturePanel.isMac1015OrUp(), this.getKnownHostsFileName(), reducedSize, darkNetwork, lowBandwidthEnabled);
                }
                catch (ConsoleException ce) {
                    this.handleException(ce);
                }
                catch (Exception ex) {
                    this.handleException(new ConsoleException(ex));
                }
                break;
            }
            case 11: {
                if (this.wizardTypePanel.isSylinkDrop()) {
                    this.deploySummaryPanel.updateUIForCommunicationSettings();
                } else {
                    this.deploySummaryPanel.updateUIForPackageDeployment();
                }
                this.deploySummaryPanel.setData(this.deployProgressPanel.getData());
                break;
            }
            case 14: {
                this.installMethodPanel.setInstallOptionEnable(true, true, true);
                this.installMethodPanel.setInstallOptionVisible(true, true, true);
                this.installMethodPanel.setControlsVisibility(this.groupFeaturePanel.getSelectedPackages(), this.wizardTypePanel.isSylinkDrop(), this.wizardTypePanel.isSylinkDropWin());
                if (!this.isDeployExistingPackageForMac()) break;
                this.installMethodPanel.setInstallOptionEnable(false, true, false);
                break;
            }
            case 16: {
                this.savePackagePanel.updateUIForMacOrLinux(this.groupFeaturePanel.getPackageOSType() == 1 || this.groupFeaturePanel.getPackageOSType() == 2, this.groupFeaturePanel.isMac1015OrUp());
                this.savePackagePanel.updateUIForCommunicationSettings(this.wizardTypePanel.isSylinkDrop());
                break;
            }
            case 19: {
                if (!this.installMethodPanel.isEmailSelected()) ** GOTO lbl104
                try {
                    lowBandwidthEnabled = this.isLowBandwidthEnabled(this.groupFeaturePanel, darkNetwork);
                    if (!this.wizardTypePanel.isSylinkDrop()) ** GOTO lbl94
                    this.sendRequest(3, this.sylinkdropOptionsPanel.getSelectedGroupId(), this.sylinkdropOptionsPanel.getAgentMode(), this.defineEmail.getBody(), this.defineEmail.getRecepients(), this.defineEmail.getSubject(), reducedSize, darkNetwork, lowBandwidthEnabled);
                    ** GOTO lbl106
lbl94:
                    // 1 sources

                    selectedInstallSettingsId = this.groupFeaturePanel.getSelectedInstallSettingsId();
                    isMac1015OrUp = this.groupFeaturePanel.isMac1015OrUp();
                    this.sendRequest(this.getSelectedPackageId(this.groupFeaturePanel.getSecurityFixBuildNumber()), this.getInstallType(), this.getGroup().getFullGroupPathForExport(), this.getGroup().getId(), this.defineEmail.getBody(), this.defineEmail.getRecepients(), this.defineEmail.getSubject(), this.groupFeaturePanel.getFeatures().getString(), this.getContentOption(), this.getInstallStyle(), selectedInstallSettingsId, false, false, this.groupFeaturePanel.isMaintainOldSettingsMac(), reducedSize, darkNetwork, lowBandwidthEnabled, isMac1015OrUp, this.groupFeaturePanel.getSecurityFixBuildNumber());
                }
                catch (ConsoleException ce) {
                    this.handleException(ce);
                }
                catch (Exception ex) {
                    this.handleException(new ConsoleException(ex));
                }
                ** GOTO lbl106
lbl104:
                // 1 sources

                if (this.installMethodPanel.isCustomSelected() && AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                    this.webConsoleExportPackages();
                }
lbl106:
                // 7 sources

                if (!this.remotePanel.isClientRemoteLaunched()) break;
                this.remotePanel.stopBrowseRequest();
                break;
            }
        }
        super.showStage(stage);
    }

    private boolean isLowBandwidthEnabled(PackageOptionsPanel packageOptionsPanel, boolean darkNetwork) throws Exception {
        boolean lowBandwidthEnabled = new AmlLowBandwidth().getDefEnableLowBandwidth();
        if (this.cloudEnrolled && !darkNetwork) {
            CurrentPackageObject selectedPkgObj = packageOptionsPanel.getSelectedPackages().get(0);
            String packageVersion = selectedPkgObj.getPackageVersion();
            lowBandwidthEnabled = PolicyUtil.isLowBandwidthEnabled(this.getGroup(), packageVersion);
        }
        return lowBandwidthEnabled;
    }

    private void webConsoleExportPackages() {
        String zipFileName = "setup_" + Env.getWebConsoleIndex() + ".zip";
        String exportFileName = Utility.getTempDir() + File.separator + zipFileName;
        String zipFilePath = "";
        try {
            ExportFolderChooser fc = new ExportFolderChooser();
            fc.setDialogType(1);
            fc.setSelectedFile(new File(zipFileName));
            fc.updateUI();
            if (0 == fc.showSaveDialog(Manager.getFrame())) {
                zipFilePath = fc.getSelectedFile().getAbsolutePath();
                File zipFile = new File(zipFilePath);
                if (zipFile.exists()) {
                    Utility.delete((File)zipFile);
                }
                if (!new File(exportFileName).renameTo(new File(zipFilePath))) {
                    throw new Exception();
                }
            }
        }
        catch (Throwable ex) {
            System.out.println("PackageWorker>> createSingleZip: Error-> Failed to create single zip: " + zipFilePath);
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private ClientInstallationSettingObject getInstallSettings() {
        return this.groupFeaturePanel.getSelectedInstallSettings();
    }

    public int getContentOption() {
        return this.groupFeaturePanel.getContentOption();
    }

    private int getInstallType() {
        int installType = 1;
        installType = license.isSNACOnlyProduct() ? 0 : (license.isSAVOnlyProduct() ? 1 : 2);
        return installType;
    }

    public static void cleanUpForLogout() {
        ConsoleLogger.log("cleanUpForLogout >> lstSearchCache: " + lstSearchCache.size() + ", lstSearchCacheMac: " + lstSearchCacheMac.size());
        lstSearchCache.clear();
        lstSearchCacheMac.clear();
        ConsoleLogger.log("cleanUpForLogout >> done! lstSearchCache: " + lstSearchCache.size() + ", lstSearchCacheMac: " + lstSearchCacheMac.size());
    }

    public void setSelectedPackage(List<CurrentPackageObject> thepackage) {
        this.selectedPackage.clear();
        this.selectedPackage.addAll(thepackage);
    }

    public List<CurrentPackageObject> getSelectedPackage() {
        return this.selectedPackage;
    }

    public CurrentPackageObject getLatestPackage(String strBitType) {
        return this.mLatestPackages.get(strBitType);
    }

    public Map<String, CurrentPackageObject> getLatestPackages() {
        return this.mLatestPackages;
    }

    public String getKnownHostsFileName() {
        return this.installMethodPanel.getKnownHostsFileName();
    }

    public List<CurrentPackageObject> getLegacyPackages() {
        return this.groupFeaturePanel.getLegacyPackageList();
    }

    public String getMaxLegacyVersion(String version) {
        return this.groupFeaturePanel.getMaxLegacyPackageVersion(version);
    }

    private Map<String, CurrentPackageObject> fetchLatestPackagesFromDB() throws ConsoleException {
        HashMap<String, CurrentPackageObject> map = new HashMap<String, CurrentPackageObject>();
        ArrayList<CurrentPackageObject> arrListPackages = SoftwarePackageHandler.getCurrentSoftwarePackages();
        CurrentPackageObject max32PackageObj = null;
        CurrentPackageObject max64PackageObj = null;
        CurrentPackageObject maxMacPackageObj = null;
        CurrentPackageObject maxLinuxDPKGPackageObj = null;
        CurrentPackageObject maxLinuxRPMPackageObj = null;
        CurrentPackageObject maxLinuxStubPackageObj = null;
        int numPackages = arrListPackages.size();
        for (int i = 0; i < numPackages; ++i) {
            CurrentPackageObject currPackageObj = (CurrentPackageObject)arrListPackages.get(i);
            if ("WIN32BIT".equals(currPackageObj.getSoftwarePackage().getPackageInfo().getOptPlatformType())) {
                if (max32PackageObj == null) {
                    max32PackageObj = currPackageObj;
                    continue;
                }
                if (this.comparePackages(currPackageObj, max32PackageObj) <= 0) continue;
                max32PackageObj = currPackageObj;
                continue;
            }
            if ("WIN64BIT".equals(currPackageObj.getSoftwarePackage().getPackageInfo().getOptPlatformType())) {
                if (max64PackageObj == null) {
                    max64PackageObj = currPackageObj;
                    continue;
                }
                if (this.comparePackages(currPackageObj, max64PackageObj) <= 0) continue;
                max64PackageObj = currPackageObj;
                continue;
            }
            if ("Mac".equals(currPackageObj.getSoftwarePackage().getPackageInfo().getOptPlatformType())) {
                if (maxMacPackageObj == null) {
                    maxMacPackageObj = currPackageObj;
                    continue;
                }
                if (this.comparePackages(currPackageObj, maxMacPackageObj) <= 0) continue;
                maxMacPackageObj = currPackageObj;
                continue;
            }
            if ("LINUXDPKG".equals(currPackageObj.getSoftwarePackage().getPackageInfo().getOptPlatformType())) {
                if (maxLinuxDPKGPackageObj == null) {
                    maxLinuxDPKGPackageObj = currPackageObj;
                    continue;
                }
                if (this.comparePackages(currPackageObj, maxLinuxDPKGPackageObj) <= 0) continue;
                maxLinuxDPKGPackageObj = currPackageObj;
                continue;
            }
            if ("LINUXRPM".equals(currPackageObj.getSoftwarePackage().getPackageInfo().getOptPlatformType())) {
                if (maxLinuxRPMPackageObj == null) {
                    maxLinuxRPMPackageObj = currPackageObj;
                    continue;
                }
                if (this.comparePackages(currPackageObj, maxLinuxRPMPackageObj) <= 0) continue;
                maxLinuxRPMPackageObj = currPackageObj;
                continue;
            }
            if (!PackageUtil.isLinuxStub((String)currPackageObj.getSoftwarePackage().getPackageInfo().getOptPlatformType())) continue;
            if (maxLinuxStubPackageObj == null) {
                maxLinuxStubPackageObj = currPackageObj;
                continue;
            }
            if (this.comparePackages(currPackageObj, maxLinuxStubPackageObj) <= 0) continue;
            maxLinuxStubPackageObj = currPackageObj;
        }
        if (max32PackageObj != null) {
            ConsoleLogger.log("InstallClientWizardDialog >> LATEST 32 BIT PACKAGE VERSION : " + max32PackageObj.getSoftwarePackage().getPackageInfo().getVersion());
        }
        if (max64PackageObj != null) {
            ConsoleLogger.log("InstallClientWizardDialog >> LATEST 64 BIT PACKAGE VERSION : " + max64PackageObj.getSoftwarePackage().getPackageInfo().getVersion());
        }
        if (maxMacPackageObj != null) {
            ConsoleLogger.log("InstallClientWizardDialog >> LATEST MAC PACKAGE VERSION : " + maxMacPackageObj.getSoftwarePackage().getPackageInfo().getVersion());
        }
        if (maxLinuxDPKGPackageObj != null) {
            ConsoleLogger.log("InstallClientWizardDialog >> LATEST LINUX DPKG PACKAGE VERSION : " + maxLinuxDPKGPackageObj.getSoftwarePackage().getPackageInfo().getVersion());
        }
        if (maxLinuxRPMPackageObj != null) {
            ConsoleLogger.log("InstallClientWizardDialog >> LATEST LINUX RPM PACKAGE VERSION : " + maxLinuxRPMPackageObj.getSoftwarePackage().getPackageInfo().getVersion());
        }
        if (maxLinuxStubPackageObj != null) {
            ConsoleLogger.log("InstallClientWizardDialog >> LATEST LINUX STUB PACKEG VERSION : " + maxLinuxStubPackageObj.getSoftwarePackage().getPackageInfo().getVersion());
        }
        if (max32PackageObj != null) {
            map.put("WIN32BIT", max32PackageObj);
        }
        if (max64PackageObj != null) {
            map.put("WIN64BIT", max64PackageObj);
        }
        if (maxMacPackageObj != null) {
            map.put("Mac", maxMacPackageObj);
        }
        if (maxLinuxDPKGPackageObj != null) {
            map.put("LINUXDPKG", maxLinuxDPKGPackageObj);
        }
        if (maxLinuxRPMPackageObj != null) {
            map.put("LINUXRPM", maxLinuxRPMPackageObj);
        }
        if (maxLinuxStubPackageObj != null) {
            map.put("LINUXSTUB", maxLinuxStubPackageObj);
        }
        return map;
    }

    private int comparePackages(CurrentPackageObject first, CurrentPackageObject second) {
        PackageInfo firstPackInf = first.getSoftwarePackage().getPackageInfo();
        PackageLuInfo firstLUInfo = firstPackInf.getOptPackageLuInfo();
        String szFirstProduct = firstLUInfo.getServerProduct();
        String szFirstLang = firstPackInf.getOptLanuage();
        String szFirstPlatform = firstPackInf.getOptPlatformType();
        String szFirstVer = firstPackInf.getVersion();
        if (firstPackInf.getOptSecurityFixPackage() != null && firstPackInf.getOptSecurityFixPackage().booleanValue()) {
            szFirstVer = firstPackInf.getOptProductBuildNum();
        }
        PackageInfo secondPackInf = second.getSoftwarePackage().getPackageInfo();
        PackageLuInfo secondLuInfo = secondPackInf.getOptPackageLuInfo();
        String szSecondProduct = secondLuInfo.getServerProduct();
        String szSecondLang = secondPackInf.getOptLanuage();
        String szSecondPlatform = secondPackInf.getOptPlatformType();
        String szSecondVer = secondPackInf.getVersion();
        if (secondPackInf.getOptSecurityFixPackage() != null && secondPackInf.getOptSecurityFixPackage().booleanValue()) {
            szSecondVer = secondPackInf.getOptProductBuildNum();
        }
        if (szFirstProduct.equals(szSecondProduct) && szFirstLang.equals(szSecondLang) && szFirstPlatform.equals(szSecondPlatform)) {
            return Utility.compareVersion((String)szFirstVer, (String)szSecondVer);
        }
        return -1;
    }

    @Override
    protected void commit() {
        System.out.println("Commit Called");
        if (this.remotePanel.isClientRemoteLaunched()) {
            this.remotePanel.stopBrowseRequest();
        }
    }

    private String getSelectedGroupID() {
        return this.groupFeaturePanel.getGroup().getId();
    }

    public void sendRequest(String pkgId, int installtype, String strGroupExportPath, String strGroupId, String strMessage, String strRecipients, String strSubject, String strXMLEnabledFeatures, int option, int uiLevel, String installSettingsId, boolean isCUEnable, boolean isPreInstallCleanupEnable, boolean keepAllDataOnUpgradeMac, boolean reducedSize, boolean darkNetwork, boolean lowBandwidthEnabled, boolean isMac1015OrUp, String securityFixBuildNum) throws ConsoleException {
        final HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("PackageIds", String.valueOf(pkgId));
        variables.put("InstallType", String.valueOf(installtype));
        variables.put("ClientGroupExportPath", strGroupExportPath);
        variables.put("ClientGroupId", strGroupId);
        variables.put("ClientEmailMessage", strMessage);
        variables.put("ClientEmailSecurityFixBuildNum", securityFixBuildNum);
        variables.put("ClientEmailRecipient", strRecipients);
        variables.put("ClientEmailSubject", strSubject);
        variables.put("EnabledClientFeatures", String.valueOf(strXMLEnabledFeatures));
        variables.put("ClientPackageContentOption", String.valueOf(option));
        variables.put("INSTALLSTYLE", String.valueOf(uiLevel));
        variables.put("reducedSize", String.valueOf(reducedSize));
        variables.put("darkNetwork", String.valueOf(darkNetwork));
        variables.put("ClientInstallSettings", String.valueOf(installSettingsId));
        variables.put("KEEP_PREVIOUS_SETTING_MAC", String.valueOf(keepAllDataOnUpgradeMac));
        variables.put("IS_10_15_OR_UP_MAC", String.valueOf(isMac1015OrUp));
        variables.put("lowBandwidth", String.valueOf(lowBandwidthEnabled));
        SwingWorker worker = new SwingWorker(){
            private Exception exception = null;

            public Object construct() {
                try {
                    SemLoginInfo loginInfo = DataobjectManager.getInstance().getLoginInformation();
                    String currentDomainId = loginInfo.getOptDomainGUID();
                    variables.put("DomainId", currentDomainId);
                    GUIManager.sendPackageEmailRequest(variables);
                }
                catch (Exception e) {
                    LoggerUtilities.logException((Throwable)e);
                    ConsoleLogger.log("InstallClientWizard>> sendRequest:Warning-> Email request was not successful. " + e.getLocalizedMessage());
                    this.exception = e;
                }
                return null;
            }

            public void finished() {
                if (this.exception != null) {
                    if (this.exception instanceof ConsoleException) {
                        if (((ConsoleException)this.exception).needRelogin()) {
                            Manager.getFrame().showLoginPanel();
                            return;
                        }
                        if (((ConsoleException)this.exception).getErrorCode() == 0x19010000) {
                            ConsoleLogger.log("InstallClientWizard>> sendRequest:Warning-> Sending email was not successful. ");
                        }
                    } else {
                        LoggerUtilities.logException((Throwable)this.exception);
                    }
                    InstallClientWizardDialog.this.handleException(this.exception);
                    return;
                }
            }
        };
        worker.start();
    }

    public void sendRequest(int installtype, String strGroupId, int agentMode, String strMessage, String strRecipients, String strSubject, boolean reducedSize, boolean darkNetwork, boolean lowBandwidthEnabled) throws ConsoleException {
        final HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("InstallType", String.valueOf(installtype));
        variables.put("GroupId", String.valueOf(strGroupId));
        variables.put("AgentMode", String.valueOf(agentMode));
        variables.put("ClientEmailMessage", strMessage);
        variables.put("ClientEmailRecipient", strRecipients);
        variables.put("ClientEmailSubject", strSubject);
        variables.put("reducedSize", String.valueOf(reducedSize));
        variables.put("darkNetwork", String.valueOf(darkNetwork));
        variables.put("lowBandwidth", String.valueOf(lowBandwidthEnabled));
        SwingWorker worker = new SwingWorker(){
            private Exception exception = null;

            public Object construct() {
                try {
                    SemLoginInfo loginInfo = DataobjectManager.getInstance().getLoginInformation();
                    String currentDomainId = loginInfo.getOptDomainGUID();
                    variables.put("DomainId", currentDomainId);
                    GUIManager.sendPackageEmailRequest(variables);
                }
                catch (Exception e) {
                    LoggerUtilities.logException((Throwable)e);
                    ConsoleLogger.log("InstallClientWizard>> sendRequest:Warning-> Email request was not successful. " + e.getLocalizedMessage());
                    this.exception = e;
                }
                return null;
            }

            public void finished() {
                if (this.exception != null) {
                    if (this.exception instanceof ConsoleException) {
                        if (((ConsoleException)this.exception).needRelogin()) {
                            Manager.getFrame().showLoginPanel();
                            return;
                        }
                        if (((ConsoleException)this.exception).getErrorCode() == 0x19010000) {
                            ConsoleLogger.log("InstallClientWizard>> sendRequest:Warning-> Sending email was not successful. ");
                        }
                    } else {
                        LoggerUtilities.logException((Throwable)this.exception);
                    }
                    InstallClientWizardDialog.this.handleException(this.exception);
                    return;
                }
            }
        };
        worker.start();
    }

    public void setUseExportedPackage(boolean useExportedPackage) {
        this.useExportedPackage = useExportedPackage;
    }

    public boolean isUseExportedPackage() {
        return this.useExportedPackage;
    }

    public boolean isUseCommunicationPackage() {
        return this.useCommunicationPackage;
    }

    public void setUseCommunicationPackage(boolean useCommunicationPackage) {
        this.useCommunicationPackage = useCommunicationPackage;
    }

    public void setUsingPackageFolder(boolean usingPackageFolder) {
        this.usingPackageFolder = usingPackageFolder;
    }

    public boolean isUsingPackageFolder() {
        return this.usingPackageFolder;
    }

    public boolean createSingleExeFromFolder() {
        return this.wizardTypePanel.createSingleExefromFolder();
    }

    @Override
    protected String getDefaultContentSensitiveHelpToken() {
        return "sesm_clients_client_deployment_wizard";
    }

    public void refresh() {
        this.pack();
    }

    protected PackageOptionsPanel getGroupFeaturePanel() {
        return this.groupFeaturePanel;
    }

    public DeploymentTypePanel getWizardTypePanel() {
        return this.wizardTypePanel;
    }

    public boolean isDeployExistingPackageForMac() {
        boolean isDeployExistingMacPackage = false;
        if (this.wizardTypePanel.getWizardType() == 1 && this.wizardTypePanel.isMacPackage()) {
            isDeployExistingMacPackage = true;
        }
        return isDeployExistingMacPackage;
    }

    public boolean isCleanUpServerDirRequired() {
        return this.cleanUpServerDirRequired;
    }

    public void setCleanUpServerDirRequired(boolean cleanUpServerDirRequired) {
        this.cleanUpServerDirRequired |= cleanUpServerDirRequired;
    }

    private void cleanUpServerTmpPkgDirIfRequired() {
        if (this.isCleanUpServerDirRequired()) {
            try {
                GUIManager.cleanUpTempPackageFolderCDW();
            }
            catch (Exception e) {
                ConsoleLogger.log("Exception cleaning up server temp directory");
                ConsoleLogger.log(e);
            }
        }
    }

    private class InstallClientFinishPanel
    extends WizardBase.WelcomeAndFinishPanel {
        private static final long serialVersionUID = 1L;
        private JEditorPane editorPane;
        private final JPanel contentPanel;
        private JPanel hPanel;
        private final String title;

        public InstallClientFinishPanel(int pageType, String heading, String instruction) {
            super(InstallClientWizardDialog.this, pageType, heading, instruction);
            this.editorPane = null;
            this.contentPanel = new JPanel();
            this.hPanel = null;
            this.title = heading;
            this.initialize();
        }

        private void initialize() {
            this.editorPane = new HTMLEditorPane();
            this.contentPanel.setLayout(new BorderLayout());
            this.editorPane.setEditable(false);
            this.editorPane.setBorder(BorderFactory.createEmptyBorder(10, 25, 0, 30));
            this.hPanel = UIUtilities.getTopBannerWithLogo(this.title, "");
            this.contentPanel.add((Component)this.hPanel, "North");
            this.contentPanel.add((Component)this.editorPane, "Center");
        }

        public void setFinishMessage(String strMessage) {
            this.editorPane.setText(HTMLUtilities.HTML_DOCUMENT_BEGIN + "<DIV " + HTMLUtilities.WIZARD_CONTENT_STYLE_STD + "\">" + strMessage + " </DIV></BODY></HTML>");
            this.setContainerPanel(this.contentPanel);
            InstallClientWizardDialog.this.cleanUpServerTmpPkgDirIfRequired();
        }
    }

    private class InstallClientWelcomePanel
    extends WizardBase.WelcomeAndFinishPanel {
        private static final long serialVersionUID = 1L;
        private JEditorPane jEPHeadPane;
        private JEditorPane jEPDescTour;
        private HtmlEnabledJLabel jLblFootNote;

        public InstallClientWelcomePanel(int pageType, String heading, String instruction) {
            super(InstallClientWizardDialog.this, pageType, heading, instruction);
            this.jEPHeadPane = null;
            this.jEPDescTour = null;
            this.jLblFootNote = null;
        }

        @Override
        protected String getWelcomeContinueMessage() {
            return "";
        }

        @Override
        protected JPanel getMiddlePanel() {
            JPanel panel = new JPanel();
            this.jEPHeadPane = new JEditorPane();
            this.jEPHeadPane.setEditable(false);
            this.jEPHeadPane.setContentType("text/html");
            this.jEPHeadPane.setText(this.getHtmlText(HTMLUtilities.HTML_TITLE_FONT_STYLE, MSGRES.getString(InstallClientWizardDialog.CLIENTDIALOG, "InstallClientWizardDialog.welcomeTitle")));
            this.jEPDescTour = new JEditorPane();
            this.jEPDescTour.setEditable(false);
            this.jEPDescTour.setContentType("text/html");
            String tourType = Utility.getCDWTourType((boolean)LicenseObject.getInstance().isSBProduct());
            Object[] obj = new Object[]{Env.getSemCedVersion(), Utility.getLanguage(), tourType};
            String fmtString = MessageFormat.format(MSGRES.getString(InstallClientWizardDialog.CLIENTDIALOG, "InstallClientWizardDialog.welcomeTourDesc"), obj);
            this.jEPDescTour.setText(this.getHtmlText(HTMLUtilities.WIZARD_CONTENT_STYLE_STD, fmtString));
            this.jEPDescTour.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        try {
                            String strURL = e.getURL().toString();
                            if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                                ClientAgent.getCurrentInstance().openInNewTab(strURL);
                                return;
                            }
                            URLUtility.showURL((String)strURL);
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(null, MSGRES.getString(InstallClientWizardDialog.CLIENTDIALOG, "InstallClientWizardDialog.errorURL"), MSGRES.getString(InstallClientWizardDialog.CLIENTDIALOG, "InstallClientWizardDialog.error"), 0);
                        }
                    }
                }
            });
            this.jLblFootNote = new HtmlEnabledJLabel(this.getHtmlText(HTMLUtilities.WIZARD_FOOT_CONTENT_STYLE, MSGRES.getString(InstallClientWizardDialog.CLIENTDIALOG, "InstallClientWizardDialog.runLaterNote")));
            panel.setLayout(new GridBagLayout());
            panel.add((Component)this.jEPHeadPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(30, 20, 5, 20), 0, 0));
            panel.add((Component)this.jEPDescTour, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(20, 20, 5, 20), 0, 0));
            panel.add(Box.createGlue(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.jLblFootNote, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 16, 2, new Insets(0, 20, 20, 20), 0, 0));
            panel.add((Component)new SupportLink(), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 16, 2, new Insets(0, 20, 20, 20), 0, 0));
            return panel;
        }

        private String getHtmlText(String strFontStyle, String strContent) {
            StringBuffer strBuff = new StringBuffer();
            strBuff.append(HTMLUtilities.HTML_DOCUMENT_BEGIN);
            strBuff.append("<DIV ");
            strBuff.append(strFontStyle);
            strBuff.append("\">");
            strBuff.append(strContent);
            strBuff.append("</DIV>");
            strBuff.append("</BODY></HTML>");
            return strBuff.toString();
        }
    }
}

