/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.RestrictedPlainDocument;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.ServerHandler;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.logicobject.ServerObject;
import com.sygate.scm.console.ui.client.HtmlPanel;
import com.sygate.scm.console.ui.client.dlg.ClientInstallationWizard;
import com.sygate.scm.console.ui.client.dlg.InstallClientWizardDialog;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.server.ServersPanel;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.EmailValidator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.PackageUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class InstallClientDefineEmailPanel
extends ClientInstallationWizard {
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENTDIALOG = "com.sygate.scm.console.ui.client.dlg.clientdialog";
    private static final String CONSOLE_UI = "com.sygate.scm.console.ui.ui";
    private static final String strDefaultBody = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "InstallClientDefineEmailPanel.defaultBody");
    private static final String strDefaultBodyEE = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "InstallClientDefineEmailPanel.defaultBodyEE");
    private static final String strDefaultBodyForSepComUpd = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "InstallClientDefineEmailPanel.defaultBodySepComUpd");
    private static final String WIN_INSTALL_FILE_NAME = "Setup.zip";
    private static final String URL_BASE = "http://{0}:{1,number,#####}/EmailInstallPackages";
    private static final String LOCALHOST = "localhost";
    private String packageTypeString = "";
    private static final JLabel jLblrecepients = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "InstallClientDefineEmailPanel.recipients"));
    private static final JLabel jLblSubject = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "InstallClientDefineEmailPanel.subject"));
    private static final JLabel jLblBody = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "InstallClientDefineEmailPanel.body"));
    private static final DescriptionTextArea desc = new DescriptionTextArea(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "InstallClientDefineEmailPanel.description"));
    private JEditorPane packageURIDesc;
    private static final String urlLinkString = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "InstallClientDefineEmailPanel.linkUrl");
    private String packageURIString = "";
    private JTextField jTxtEmailTo;
    private static final JButton emailServerButton = new JButton(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "InstallClientDefineEmailPanel.emailServerButtonText"));
    private static final JTextField jTxtEmailSub = new JTextField(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "InstallClientDefineEmailPanel.defaultSubject"));
    private JTextPane jTxtPBody;

    public InstallClientDefineEmailPanel(InstallClientWizardDialog wizard, boolean isSMB) {
        super(wizard, isSMB);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.packageTypeString = "";
        this.packageURIString = "";
        this.jTxtEmailTo = new JTextField();
        this.jTxtPBody = new HtmlPanel();
    }

    @Override
    protected String getTitleDescription() {
        return MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.titleDesc");
    }

    @Override
    protected String getTitle() {
        return MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.title");
    }

    @Override
    protected JPanel getCenterPanel() {
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new GridBagLayout());
        desc.setMargin(new Insets(0, 5, 0, 5));
        this.packageURIDesc = this.getToolBarButton(MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.linkUrl"));
        this.jTxtPBody.setContentType("text/html");
        if (this.isSMB()) {
            this.jTxtPBody.setText(strDefaultBody);
        } else {
            this.jTxtPBody.setText(strDefaultBodyEE);
        }
        JScrollPane jsp = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)jsp, (JTextPane)this.jTxtPBody);
        jsp.setHorizontalScrollBarPolicy(30);
        jsp.setVerticalScrollBarPolicy(20);
        this.jTxtPBody.setEditable(true);
        int y = 0;
        centerPanel.add((Component)desc, new GridBagConstraints(0, y, 2, 1, 1.0, 0.0, 18, 2, insertToLogo, 0, 0));
        centerPanel.add((Component)jLblrecepients, new GridBagConstraints(0, ++y, 2, 1, 0.0, 0.0, 18, 2, new Insets(20, 25, 5, 0), 0, 0));
        centerPanel.add((Component)this.jTxtEmailTo, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 25, 0, 20), 0, 0));
        centerPanel.add((Component)jLblSubject, new GridBagConstraints(0, ++y, 2, 1, 0.0, 0.0, 18, 2, new Insets(10, 25, 5, 0), 0, 0));
        centerPanel.add((Component)jTxtEmailSub, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 25, 0, 20), 0, 0));
        centerPanel.add((Component)jLblBody, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 25, 5, 0), 0, 0));
        centerPanel.add((Component)jsp, new GridBagConstraints(0, ++y, 2, 0, 1.0, 1.0, 18, 1, new Insets(0, 25, 20, 20), 0, 0));
        centerPanel.add(Box.createGlue(), new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        emailServerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                InstallClientDefineEmailPanel.this.ConfigEmailSettings();
            }
        });
        RestrictedPlainDocument emailDoc = new RestrictedPlainDocument(500);
        this.jTxtEmailTo.setDocument((Document)emailDoc);
        this.updateUIForDefaultSetting();
        return centerPanel;
    }

    private void ConfigEmailSettings() {
        Cursor curCursor = this.getWizard().getCursor();
        try {
            this.getWizard().setCursor(new Cursor(3));
            ServerObject server = ServerHandler.getSBServer();
            if (server != null) {
                ServersPanel.showEditServerDialog(server);
            } else {
                UIUtilities.showErrorDialog(MSGRES.getString(CONSOLE_UI, "WelcomeDialog.errorLoadingServer"));
            }
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            UIUtilities.showErrorDialog(MSGRES.getString(CONSOLE_UI, "WelcomeDialog.error"));
        }
        finally {
            this.getWizard().setCursor(curCursor);
        }
    }

    public String getRecepients() {
        return this.jTxtEmailTo.getText();
    }

    public String getSubject() {
        return jTxtEmailSub.getText();
    }

    public String getBody() {
        return this.jTxtPBody.getText();
    }

    public boolean validatePanel() throws GUICheckException {
        String strSub = jTxtEmailSub.getText().trim();
        this.validateEmailAddresses();
        Document messageDoc = this.jTxtPBody.getDocument();
        String strBody = "";
        try {
            strBody = messageDoc.getText(0, messageDoc.getLength()).trim();
        }
        catch (BadLocationException e) {
            LoggerUtilities.logException((Throwable)e);
        }
        if (strBody == null || "".equals(strBody)) {
            throw new GUICheckException(MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.errorBody"), this.jTxtPBody);
        }
        if (strSub == null || "".equals(strSub)) {
            throw new GUICheckException(MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.errorSubject"), jTxtEmailSub);
        }
        if (strSub.length() > 1000) {
            throw new GUICheckException(MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.errorMaxSubject"), jTxtEmailSub);
        }
        return true;
    }

    private void validateEmailAddresses() throws GUICheckException {
        String strRecipients = this.jTxtEmailTo.getText().trim();
        if (strRecipients.length() == 0) {
            throw new GUICheckException(MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.errorNoRecipient"), this.jTxtEmailTo);
        }
        if (strRecipients.length() > 500) {
            throw new GUICheckException(MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.errorMaxEmail"), this.jTxtEmailTo);
        }
        if (!EmailValidator.isValidEmailAddress((String)strRecipients)) {
            throw new GUICheckException(MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.errorEmail"), this.jTxtEmailTo);
        }
    }

    private void updateUIForCommunicationSetting() {
        desc.setText(MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.descriptionForSepComUpd"));
        jTxtEmailSub.setText(MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.defaultSubjectForSepComUpd"));
    }

    private void updateUIForDefaultSetting() {
        desc.setText(MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.description"));
        jTxtEmailSub.setText(MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.defaultSubject"));
    }

    public void generateBodyForSepCommunicationUpdater(String strGroupId) {
        this.updateUIForCommunicationSetting();
        String strServer = ScmProperties.get("scm.server.hostname", LOCALHOST);
        if (strServer.equalsIgnoreCase(LOCALHOST)) {
            try {
                strServer = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                System.out.println("Please check your IP configuration. 'Localhost' is used by default.");
                LoggerUtilities.logException((Throwable)e);
            }
        }
        Object[] arrObjServer = new Object[]{strServer, Env.getREPORTING_PORT_HTTP()};
        String strURI = MessageFormat.format(URL_BASE, arrObjServer);
        StringBuffer allText = new StringBuffer();
        String[] clickStrings = new String[1];
        String[] descStrings = new String[1];
        String pkgURLs = null;
        String strMailBody = "";
        Object clickHere = "";
        Object descriptions = "";
        String packageURI = null;
        String clickHerecontent = null;
        String descriptionContent = null;
        clickHerecontent = MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.SepCommunicationUpdaterClickHere");
        descriptionContent = MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.SepCommunicationUpdaterDescription");
        String FileName = "SepCommunicationUpdater.zip";
        pkgURLs = packageURI = strURI + "/" + strGroupId + "/" + FileName;
        Object[] arrObjPackage = new Object[]{packageURI};
        clickStrings[0] = clickHere = (String)clickHere + MessageFormat.format(clickHerecontent, arrObjPackage);
        descStrings[0] = descriptions = (String)descriptions + MessageFormat.format(descriptionContent, arrObjPackage);
        this.setPackageURIString(pkgURLs, false);
        Object[] arrObjContent = new Object[]{this.packageTypeString, clickStrings[0], descStrings[0]};
        strMailBody = MessageFormat.format(strDefaultBodyForSepComUpd, arrObjContent);
        allText.append(strMailBody);
        allText.append("\n");
        this.jTxtPBody.setText(this.getHTMLText(allText.toString()));
        this.jTxtPBody.setCaretPosition(0);
    }

    public void generateBody(String strGroupId, List<CurrentPackageObject> packages, boolean isMac1015OrUp) {
        this.updateUIForDefaultSetting();
        String strServer = this.getServer();
        Object[] arrObjServer = new Object[]{strServer, Env.getREPORTING_PORT_HTTP()};
        String strURI = MessageFormat.format(URL_BASE, arrObjServer);
        int count = packages.size();
        if (count < 1) {
            return;
        }
        String[] clickStrings = new String[count];
        String[] descStrings = new String[count];
        for (int j = 0; j < count; ++j) {
            clickStrings[j] = "";
            descStrings[j] = "";
        }
        StringBuilder pkgURLs = new StringBuilder();
        SoftwarePackage sp = null;
        AtomicBoolean isWindowPlatForm = new AtomicBoolean(false);
        AtomicBoolean isLinuxPlatForm = new AtomicBoolean(false);
        AtomicBoolean isMacPlatForm = new AtomicBoolean(false);
        for (int i = 0; i < count; ++i) {
            sp = packages.get(i).getSoftwarePackage();
            this.setPackageTypeStringHelper(sp);
            StringBuilder packageURI = new StringBuilder();
            StringBuilder clickHerecontent = new StringBuilder();
            StringBuilder descriptionContent = new StringBuilder();
            String platform = PackageUtil.getSoftwarePackagePlatformType((SoftwarePackage)sp);
            this.setContentHelper(platform, clickHerecontent, descriptionContent, packageURI, isWindowPlatForm, isLinuxPlatForm, isMacPlatForm, strURI, strGroupId, sp, isMac1015OrUp);
            if (i == 0) {
                pkgURLs.append(packageURI.toString());
            } else {
                pkgURLs.append("\n" + packageURI);
            }
            this.setClickAndDescStringsHelper(clickStrings, descStrings, i, packageURI, clickHerecontent, descriptionContent);
        }
        this.setPackageURIString(pkgURLs.toString(), false);
        StringBuilder allPackageLinkBuilder = new StringBuilder();
        StringBuilder allPackageUrlBuilder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            allPackageLinkBuilder.append(clickStrings[i]);
            allPackageUrlBuilder.append(descStrings[i]);
        }
        this.setPackageLinkHelper(allPackageLinkBuilder, isWindowPlatForm, isLinuxPlatForm, isMacPlatForm);
        String strMailBody = "";
        Object[] packageInfoObj = new Object[]{this.packageTypeString, allPackageLinkBuilder.toString(), allPackageUrlBuilder.toString()};
        strMailBody = MessageFormat.format(strDefaultBody, packageInfoObj);
        StringBuilder allText = new StringBuilder();
        allText.append(strMailBody);
        allText.append("\n");
        this.jTxtPBody.setText(this.getHTMLText(allText.toString()));
        this.jTxtPBody.setCaretPosition(0);
    }

    protected String getServer() {
        String strServer = ScmProperties.get("scm.server.hostname", LOCALHOST);
        try {
            if (!strServer.equalsIgnoreCase(LOCALHOST)) {
                strServer = InetAddress.getByName(strServer).getCanonicalHostName();
            } else if (Env.isRemoteConsole()) {
                strServer = Env.getSEM_SERVER();
                strServer = InetAddress.getByName(strServer).getCanonicalHostName();
            } else {
                strServer = InetAddress.getLocalHost().getCanonicalHostName();
            }
        }
        catch (UnknownHostException e) {
            ConsoleLogger.log("Please check your IP configuration. SEPM server IP/Name can not be resolved.");
            LoggerUtilities.logException((Throwable)e);
        }
        return strServer;
    }

    protected void setPackageTypeStringHelper(SoftwarePackage sp) {
        int type = sp.getPackageInfo().getType();
        this.packageTypeString = type == 151 ? MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.packageTypeSNAC") : MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.packageTypeSEP");
    }

    protected void setLinuxContentHelper(String platform, StringBuilder clickHerecontent, StringBuilder descriptionContent) {
        if ("LINUXDPKG".equals(platform)) {
            clickHerecontent.append(MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.linuxDpkgClickHere"));
            descriptionContent.append(MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.linuxDpkgDescription"));
        } else if ("LINUXRPM".equals(platform)) {
            clickHerecontent.append(MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.linuxRpmClickHere"));
            descriptionContent.append(MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.linuxRpmDescription"));
        } else if (PackageUtil.isLinuxStub((String)platform)) {
            clickHerecontent.append(MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.linuxStubClickHere"));
            descriptionContent.append(MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.linuxStubDescription"));
        }
    }

    protected void setContentHelper(String platform, StringBuilder clickHerecontent, StringBuilder descriptionContent, StringBuilder packageURI, AtomicBoolean isWindowPlatForm, AtomicBoolean isLinuxPlatForm, AtomicBoolean isMacPlatForm, String strURI, String strGroupId, SoftwarePackage sp, boolean isMac1015OrUp) {
        if ("WIN32BIT".equals(platform)) {
            clickHerecontent.append(MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.win32ClickHere"));
            descriptionContent.append(MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.win32Description"));
            packageURI.append(strURI + "/" + strGroupId + "_" + platform + "/" + PackageUtil.getSoftwarePackageProductTypeName((SoftwarePackage)sp) + "/Setup.zip");
            isWindowPlatForm.set(true);
        } else if ("WIN64BIT".equals(platform)) {
            clickHerecontent.append(MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.win64ClickHere"));
            descriptionContent.append(MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.win64Description"));
            packageURI.append(strURI + "/" + strGroupId + "_" + platform + "/" + PackageUtil.getSoftwarePackageProductTypeName((SoftwarePackage)sp) + "/Setup.zip");
            isWindowPlatForm.set(true);
        } else if ("Mac".equals(platform)) {
            clickHerecontent.append(MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.macClickHere"));
            descriptionContent.append(MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.macDescription"));
            String zipFileName = PackageUtil.getMacExportCIPZipFileName((SoftwarePackage)sp);
            String mac1015OrUp = isMac1015OrUp ? "_" + ConstantValue.getMacExportPath((String)sp.getPackageInfo().getVersion()) : "";
            try {
                zipFileName = URLEncoder.encode(zipFileName, "UTF-8");
                zipFileName = zipFileName.replaceAll("\\+", "%20");
            }
            catch (UnsupportedEncodingException e) {
                zipFileName = PackageUtil.getMacExportCIPZipFileName((SoftwarePackage)sp);
            }
            packageURI.append(strURI + "/" + strGroupId + "_" + platform + mac1015OrUp + "/" + PackageUtil.getSoftwarePackageProductTypeName((SoftwarePackage)sp) + "/" + zipFileName);
            isMacPlatForm.set(true);
        } else if (ConstantValue.isLinuxPlatform((String)platform) || ConstantValue.isLinuxStubPlatform((String)platform) || ConstantValue.isLinuxStubArm64Platform((String)platform)) {
            this.setLinuxContentHelper(platform, clickHerecontent, descriptionContent);
            String zipFileName = PackageUtil.getLinuxExportCIPZipFileName((SoftwarePackage)sp);
            try {
                zipFileName = URLEncoder.encode(zipFileName, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                zipFileName = PackageUtil.getLinuxExportCIPZipFileName((SoftwarePackage)sp);
            }
            packageURI.append(strURI + "/" + strGroupId + "_" + platform + "/" + PackageUtil.getSoftwarePackageProductTypeName((SoftwarePackage)sp) + "/" + zipFileName);
            isLinuxPlatForm.set(true);
        }
    }

    protected void setPackageLinkHelper(StringBuilder allPackageLinkBuilder, AtomicBoolean isWindowPlatForm, AtomicBoolean isLinuxPlatForm, AtomicBoolean isMacPlatForm) {
        String installStepsString = null;
        String versionInfoString = null;
        if (isWindowPlatForm.get()) {
            Object[] clientDialogObj = new Object[]{MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.windowsVersionInfoUrl")};
            versionInfoString = MessageFormat.format(MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.notSureofWindowsVersion"), clientDialogObj);
            installStepsString = MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.installationSteps");
        } else if (isLinuxPlatForm.get()) {
            installStepsString = MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.linuxInstallationSteps");
            installStepsString = MessageFormat.format(installStepsString, MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.linuxInstallationStepsUrl"));
        } else if (isMacPlatForm.get()) {
            installStepsString = MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.macInstallationSteps");
            installStepsString = MessageFormat.format(installStepsString, MSGRES.getString(CLIENTDIALOG, "InstallClientDefineEmailPanel.macInstallationStepsUrl"));
        }
        if (versionInfoString != null) {
            allPackageLinkBuilder.append("\n<br>");
            allPackageLinkBuilder.append(versionInfoString);
        }
        if (installStepsString != null) {
            allPackageLinkBuilder.append(installStepsString);
        }
    }

    protected void setClickAndDescStringsHelper(String[] clickStrings, String[] descStrings, int index, StringBuilder packageURI, StringBuilder clickHerecontent, StringBuilder descriptionContent) {
        Object[] arrObjPackage = new Object[]{packageURI};
        if (clickHerecontent != null) {
            clickStrings[index] = MessageFormat.format(clickHerecontent.toString(), arrObjPackage);
        }
        if (descriptionContent != null) {
            descStrings[index] = MessageFormat.format(descriptionContent.toString(), arrObjPackage);
        }
    }

    private String getHTMLText(String strContent) {
        StringBuffer strBuff = new StringBuffer("<HTML><BODY>");
        strBuff.append(strContent);
        strBuff.append("</BODY></HTML>");
        return strBuff.toString();
    }

    private JEditorPane getToolBarButton(String text) {
        JEditorPane pane = new JEditorPane();
        pane.setOpaque(false);
        pane.setContentType("text/html");
        Object[] urlObj = new Object[]{this.getHtmlRefText(this.packageURIString)};
        String urlString = MessageFormat.format(text, urlObj);
        pane.setText(urlString);
        pane.setEditable(false);
        return pane;
    }

    private String getHtmlRefText(String text) {
        return "<html><a href=''>" + text + "</a></html>";
    }

    public void setPackageURIString(String url, boolean append) {
        this.packageURIString = !append ? url : this.packageURIString + "\n" + url;
        String urlString = this.getFormatedURLString(urlLinkString);
        this.packageURIDesc.setText(urlString);
    }

    private String getFormatedURLString(String text) {
        Object[] urlObj = new Object[]{this.getHtmlRefText(this.packageURIString)};
        String urlString = MessageFormat.format(text, urlObj);
        return urlString;
    }

    public String getPackageURIString() {
        return this.packageURIString;
    }

    public void setPackageTypeString(String packageTypeString) {
        this.packageTypeString = packageTypeString;
    }

    public String getPackageTypeString() {
        return this.packageTypeString;
    }
}

