/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.acl.AuthorizationManager;
import com.sygate.scm.common.acl.Permission;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.ui.client.PackageProgressListener;
import com.sygate.scm.console.ui.client.PackageWorker;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.SwingWorker;
import com.sygate.scm.util.TimeCounter;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.ZipUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.RootPaneContainer;

public class InProgressDlg
extends JDialog
implements PackageProgressListener {
    private static final long serialVersionUID = 6611621505241397122L;
    private static final String AUTOMATION_EXPORT_FINISH_BUTTON = "ExportPackageFinish";
    private static final String AUTOMATION_EXPORT_FINISH_ICON = "ExportPackageFinishIcon";
    private boolean isCancelled = false;
    private boolean isFinished = false;
    private SwingWorker worker = null;
    private final GridBagLayout gridBagLayoutMainPanel = new GridBagLayout();
    private final JButton stopBtn = new JButton();
    private final JButton exportPackageBtn = new JButton();
    private final JProgressBar progressBar = new JProgressBar();
    private JScrollPane spMsg = null;
    private final JTextArea taMsg = new JTextArea();
    private final JPanel mainPanel = new JPanel();
    private final JPanel buttonPanel = new JPanel();
    private PackageWorker packageWorker;
    private String stopWarningTitle = null;
    private String stopWarningMsg = null;

    public InProgressDlg(Frame frame, boolean modal) {
        super(frame, modal);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(426, 317));
        UIUtilities.setName(this.stopBtn, "packageManagement", UIUtilities.ComponentType.BUTTON, AUTOMATION_EXPORT_FINISH_BUTTON);
        this.stopBtn.setText(UIText.get(512));
        UiUtilities.setDefaultButton((RootPaneContainer)this, (JButton)this.stopBtn);
        this.stopBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InProgressDlg.this.stopBtn_actionPerformed(e);
            }
        });
        this.exportPackageBtn.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "InProgressDlg.export"));
        this.setExportVisible(false);
        this.exportPackageBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InProgressDlg.this.packageWorker != null) {
                    InProgressDlg.this.packageWorker.setRequestExport(true);
                }
                InProgressDlg.this.dispose();
            }
        });
        this.spMsg = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)this.spMsg, (JTextArea)this.taMsg);
        this.taMsg.setEditable(false);
        this.progressBar.setMaximum(10);
        JLabel label = new JLabel();
        label.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "InProgressDlg.messageLabel"));
        this.mainPanel.setLayout(this.gridBagLayoutMainPanel);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        this.mainPanel.add((Component)label, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.spMsg, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 370, 80));
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        this.exportPackageBtn.setEnabled(AuthorizationManager.getInstance().checkPermission(context, (Permission)AuthorizationManager.SpecialPermission.ONE_GROUP_FULL_ACCESS));
        this.buttonPanel.add(this.exportPackageBtn);
        this.buttonPanel.add(this.stopBtn);
        this.mainPanel.add((Component)this.buttonPanel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.progressBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 3));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        UiUtilities.centerComponent((Component)this);
        this.pack();
    }

    public void init(SwingWorker worker, String title, String message, WindowListener pWorker) {
        if (pWorker != null) {
            this.addWindowListener(pWorker);
        } else {
            this.setDefaultCloseOperation(0);
        }
        if (pWorker != null) {
            this.packageWorker = (PackageWorker)pWorker;
        }
        this.worker = worker;
        this.setTitle(title);
    }

    public void appendMsg(String message) {
        if (this.taMsg.getText().length() > 0) {
            this.taMsg.append(System.getProperty("line.separator"));
        }
        this.taMsg.append(message);
        try {
            this.taMsg.scrollRectToVisible(this.taMsg.modelToView(this.taMsg.getLineStartOffset(this.taMsg.getLineCount() - 1)));
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void stopNormally() {
        this.isCancelled = false;
        this.dispose();
    }

    @Override
    public void stopInMiddle() {
        if (!this.isFinished) {
            if (this.worker != null) {
                this.worker.interrupt();
            }
            this.isCancelled = true;
        } else {
            System.out.println("is Export Request: " + this.packageWorker.isRequestExport());
            if (AjaxSwingCommonUtil.isAjaxSwingRunning() && this.packageWorker.isRequestExport()) {
                this.packageWorker.downloadSingleFile();
            }
            this.isCancelled = false;
        }
        this.dispose();
    }

    public void setStopWarningMsg(String title, String msg) {
        this.stopWarningTitle = title;
        this.stopWarningMsg = msg;
    }

    private void stopBtn_actionPerformed(ActionEvent e) {
        if (this.stopWarningMsg != null && !this.isFinished && 1 == JOptionPane.showConfirmDialog(this, this.stopWarningMsg, this.stopWarningTitle, 0)) {
            return;
        }
        this.stopInMiddle();
    }

    public void enableStopButton(boolean enabled) {
        this.stopBtn.setEnabled(enabled);
    }

    public void showStopButton(boolean enabled) {
        this.stopBtn.setVisible(enabled);
    }

    public void setProgress(int value) {
        this.progressBar.setValue(value);
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    @Override
    public void showFinished(boolean showOK, String text) {
        this.isFinished = true;
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 150, 80);
        this.mainPanel.remove(this.progressBar);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JLabel label = new JLabel();
        label.setText(text);
        label.setHorizontalAlignment(0);
        label.setHorizontalTextPosition(11);
        label.setFont(UIFontUtilities.SUBTITLE_FONT);
        panel.add((Component)label, "Center");
        constraints.ipadx = 0;
        constraints.ipady = 0;
        if (showOK) {
            Image imageOK = Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("tasklist_result_ok.png"));
            ImageIcon iconOK = new ImageIcon(imageOK);
            label.setIcon(iconOK);
            UIUtilities.setName(label, "packageManagement", UIUtilities.ComponentType.JLABEL, AUTOMATION_EXPORT_FINISH_ICON);
            this.mainPanel.add((Component)panel, constraints);
        } else {
            Image imageError = Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("tasklist_result_error.gif"));
            ImageIcon iconError = new ImageIcon(imageError);
            label.setIcon(iconError);
            this.mainPanel.add((Component)panel, constraints);
        }
        this.mainPanel.validate();
        this.stopBtn.setEnabled(true);
        if (AjaxSwingCommonUtil.isAjaxSwingRunning() && this.packageWorker.isRequestExport()) {
            this.webConsolePreparePackages();
            this.stopBtn.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "InProgressDlg.download"));
        } else {
            this.stopBtn.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "InProgressDlg.close"));
        }
        if (this.packageWorker != null && this.packageWorker.getExportBtnVisible() && showOK) {
            this.setExportVisible(true);
        }
    }

    public void setExportVisible(boolean flag) {
        this.exportPackageBtn.setVisible(flag);
    }

    public void exportRequest() {
        this.packageWorker.setRequestExport(true);
        this.dispose();
    }

    @Override
    public void setProgressMsg(String title, String msg, boolean bold, boolean enableStopButton, int value) {
        if (title != null && title.length() > 0) {
            this.setTitle(title);
        }
        this.appendMsg(msg);
        this.enableStopButton(enableStopButton);
        this.showStopButton(enableStopButton);
        if (value > 0) {
            this.setProgress(value);
        }
    }

    @Override
    public int getMaxValue() {
        if (this.progressBar != null) {
            return this.progressBar.getMaximum();
        }
        return 0;
    }

    @Override
    public int getMinValue() {
        if (this.progressBar != null) {
            return this.progressBar.getMinimum();
        }
        return 0;
    }

    @Override
    public int getProgressValue() {
        if (this.progressBar != null) {
            return this.progressBar.getValue();
        }
        return 0;
    }

    @Override
    public void disposeUI() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void webConsolePreparePackages() {
        String exportPath = Utility.getTempDir() + File.separator + Env.getWebConsoleIndex();
        String zipFilePath = Utility.getTempDir() + File.separator + Env.getCurrentPackageZipName();
        try {
            TimeCounter counter = new TimeCounter();
            counter.start();
            ZipUtil.zipData((int)-1, (String)exportPath, (String)zipFilePath);
            counter.stop();
            System.out.println("Done Zip: " + zipFilePath + ", elapsed time=" + counter.getDuration() + " (" + counter.getDuration() / 1000L + "s)");
        }
        catch (Throwable ex) {
            System.out.println("PackageWorker>> createSingleZip: Error-> Failed to create single zip: " + zipFilePath);
            LoggerUtilities.logException((Throwable)ex);
        }
        finally {
            Utility.deleteDir((String)exportPath);
        }
    }
}

