/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.configobject.schema.DirectoryServer;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.AjaxSwingManager;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.ImportADSIHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.OrganizationalUnitObject;
import com.sygate.scm.console.ui.client.dlg.NoParentChildSelectionListener;
import com.sygate.scm.console.ui.dlg.SwingWorkerProgressDialog;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.NonEditableComboBoxWithTooltip;
import com.sygate.scm.console.ui.util.renderer.CustomTreeCellRenderer;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.KeepAlive;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.ldap.LdapPath;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ImportADSIDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private JComboBox<String> jCmbDomain = new NonEditableComboBoxWithTooltip<String>();
    private JButton jBRefresh = new JButton(UIText.get(4352));
    private TreeModel model;
    private JTree jTOU = new JTree();
    private HashMap<String, DirectoryServer> hmDirectoryServer = new HashMap();
    private DirectoryServer aDS = null;
    private String m_queryId = null;
    private boolean failedToConnect;

    public ImportADSIDlg() {
        super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ImportADSIDlg.integrateWithOUTreeTitle"), true);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        UiUtilities.centerComponent((Component)this);
    }

    public ArrayList<OrganizationalUnitObject> getSelectionList() {
        int count = this.jTOU.getSelectionCount();
        ArrayList<OrganizationalUnitObject> list = new ArrayList<OrganizationalUnitObject>(count);
        TreePath[] paths = this.jTOU.getSelectionPaths();
        for (int i = 0; i < count; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
            OrganizationalUnitObject ou = (OrganizationalUnitObject)node.getUserObject();
            list.add(ou);
        }
        return list;
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    protected boolean isValidate() {
        ArrayList<OrganizationalUnitObject> list = this.getSelectionList();
        if (list.size() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ImportADSIDlg.selectOneOUMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ImportADSIDlg.error"), 0);
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            OrganizationalUnitObject ou = list.get(i);
            if (!this.searchGroupByAdPath(ou)) continue;
            return false;
        }
        return true;
    }

    private void jbInit() throws Exception {
        this.jTOU.addTreeSelectionListener(new NoParentChildSelectionListener());
        this.jTOU.setCellRenderer(new CustomTreeCellRenderer());
        this.jTOU.putClientProperty("JTree.lineStyle", "Angled");
        this.jTOU.setVisibleRowCount(10);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel basePanel = new JPanel(new BorderLayout(5, 5));
        basePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        basePanel.add((Component)this.getDomainPanel(), "North");
        JScrollPane sp = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)sp, (JTree)this.jTOU);
        Dimension size = new Dimension(300, 300);
        sp.setPreferredSize(size);
        basePanel.add((Component)sp, "Center");
        basePanel.add((Component)this.getButtonPanel(), "South");
        this.getContentPane().add((Component)basePanel, "Center");
        this.pack();
        size = this.getPreferredSize();
        this.setSize(size.width < 400 ? 400 : size.width, size.height);
    }

    private JPanel getDomainPanel() {
        this.jCmbDomain.setPrototypeDisplayValue(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ImportADSIDlg.selectDomainMenu"));
        this.jCmbDomain.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && ImportADSIDlg.this.jCmbDomain.getSelectedIndex() > 0) {
                    ImportADSIDlg.this.startSetupTreeThread();
                }
            }
        });
        this.jBRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportADSIDlg.this.startSetupTreeThread();
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ImportADSIDlg.domainLabel")));
        panel.add(Box.createRigidArea(new Dimension(5, 1)));
        panel.add(this.jCmbDomain);
        panel.add(Box.createHorizontalGlue());
        panel.add(this.jBRefresh);
        return panel;
    }

    public void initData(ArrayList<DirectoryServer> directoryServers) {
        this.setupDomainList(directoryServers);
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(this::startSetupTreeThread);
    }

    private void setupDomainList(ArrayList<DirectoryServer> server) {
        this.jCmbDomain.removeAllItems();
        this.jCmbDomain.addItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ImportADSIDlg.selectDomainMenu"));
        this.hmDirectoryServer.clear();
        int len = server == null ? 0 : server.size();
        for (int i = 0; i < len; ++i) {
            DirectoryServer ds = server.get(i);
            this.jCmbDomain.addItem(ds.getName());
            this.hmDirectoryServer.put(ds.getName(), ds);
        }
    }

    private boolean searchGroupByAdPath(OrganizationalUnitObject ou) {
        try {
            String adPath = ou.getADsPath();
            if (ImportADSIHandler.findGroupByAdPath(adPath, 5) != null) {
                Object[] obj = new Object[]{ou.getName()};
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ImportADSIDlg.alreadyExistsMsg");
                String fm = MessageFormat.format(str, obj);
                JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ImportADSIDlg.error"), 0);
                return true;
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupADTree() throws ConsoleException {
        try {
            KeepAlive.suspend();
            Object selItem = this.jCmbDomain.getSelectedItem();
            if (selItem == null) {
                return;
            }
            this.aDS = this.hmDirectoryServer.get(selItem);
            if (this.aDS == null) {
                return;
            }
            this.m_queryId = GUIDGenerator.getInstance().getGUIDString();
            if (this.aDS.getOptGuid() != null) {
                this.model = ImportADSIHandler.getOUTree(this.aDS.getOptGuid(), "", this.m_queryId);
            } else {
                boolean ssl = this.aDS.getOptUseSSL() != null ? this.aDS.getOptUseSSL() : this.aDS.getDefUseSSL();
                boolean disableCertValidation = Optional.ofNullable(this.aDS.getOptDisableCertValidate()).orElse(this.aDS.getDefDisableCertValidate());
                String ldapPath = LdapPath.getLdapAddress((DirectoryServer)this.aDS);
                this.model = ImportADSIHandler.getOUTree(ldapPath, this.aDS.getType(), this.aDS.getOptUsername() == null ? "admin" : this.aDS.getOptUsername(), this.aDS.getOptPassword() == null ? "" : this.aDS.getOptPassword(), "", ssl, disableCertValidation, this.m_queryId);
            }
        }
        finally {
            KeepAlive.resume();
        }
    }

    private void setupTree() {
        block3: {
            try {
                this.failedToConnect = false;
                this.setupADTree();
            }
            catch (ConsoleException ex) {
                this.failedToConnect = true;
                String msg = ex.getMessageString();
                if (ex.getErrorCode() == -534708224) {
                    msg = MessageFormat.format(msg, this.aDS.getServerAddress(), this.aDS.getOptPort());
                }
                JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ImportADSIDlg.serverError"), 0);
                if (!ex.needRelogin()) break block3;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    private void startSetupTreeThread() {
        if (this.model != null) {
            DefaultTreeModel treeModel = (DefaultTreeModel)this.model;
            treeModel.setRoot(null);
        }
        this.jTOU.updateUI();
        SwingWorkerProgressDialog dlg = new SwingWorkerProgressDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ImportADSIDlg.updateMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ImportADSIDlg.updatingDialogMsg")){

            @Override
            public void run(ActionEvent e) {
                ImportADSIDlg.this.setupTree();
            }

            @Override
            public void doCancelled() {
                ImportADSIHandler.stopLdapQuery(ImportADSIDlg.this.m_queryId);
                AjaxSwingManager.endOperation();
            }

            @Override
            public void doFinished() {
                ImportADSIDlg.this.jTOU.setModel(ImportADSIDlg.this.model);
                ImportADSIDlg.this.jTOU.updateUI();
                ImportADSIDlg.this.jBOk.setEnabled(ImportADSIDlg.this.model != null);
                if (!ImportADSIDlg.this.failedToConnect && ImportADSIDlg.this.model == null && ImportADSIDlg.this.aDS != null) {
                    Object[] obj = new Object[]{ImportADSIDlg.this.aDS.getName()};
                    String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ImportADSIDlg.noOrganizationUnitFoundMsg");
                    String fm = MessageFormat.format(str, obj);
                    JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ImportADSIDlg.error"), 0);
                }
                AjaxSwingManager.endOperation();
            }
        };
        AjaxSwingManager.beginOperation();
        dlg.start();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_client_tree_dialog_import_ou";
    }
}

