/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SemClientHandler;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GroupPropertiesDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private JTextField jTFName = new JTextField(30);
    private JTextField jTFID = new JTextField(30);
    private JTextField jTFDesc = new JTextField();
    private JTextField jTFPath = new JTextField();
    private JTextField jTFComputer = new JTextField();
    private JTextField jTFUser = new JTextField();
    private JTextField jTFAdminName = new JTextField();
    private JTextField jTFCreateTime = new JTextField();
    private JTextField jTFModifyTime = new JTextField();
    private JTextField jTFProfileVersion = new JTextField();
    private JTextField jTFIdsVersion = new JTextField();
    private JTextField jTFProfileDate = new JTextField();
    private JCheckBox cbBlockUsers = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "GroupPropertiesDlg.blockNewUsersOrComputers"));
    private GroupObject group = null;

    public GroupPropertiesDlg(GroupObject group) throws ConsoleException {
        super(Manager.getFrame(), "", true);
        Object[] obj = new Object[]{group.getName()};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "GroupPropertiesDlg.groupPropertiesForMsg");
        String fm = MessageFormat.format(str, obj);
        this.setTitle(fm);
        this.initialize();
        this.initData(group);
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    @Override
    protected void commit() {
        String desc = this.jTFDesc.getText().trim();
        String oldDesc = this.group.getDescription();
        oldDesc = oldDesc.trim();
        boolean oldBlock = this.group.doesBlockNewUser();
        boolean newBlock = this.cbBlockUsers.isSelected();
        if (!oldDesc.equals(desc) || oldBlock != newBlock) {
            this.group.setBlockNewUser(newBlock);
            this.group.setDescription(desc);
            try {
                GroupHandler.updateGroup(this.group);
                String groupName = this.group.getName();
                MessageResources msgRes = MessageResources.getInstance();
                String description = MessageFormat.format(msgRes.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "GroupPropertiesDlg.groupPropertiesChanged"), groupName);
                ConsoleLogger.logAdminEvent(8197, description);
            }
            catch (ConsoleException cex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), cex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "GroupPropertiesDlg.error"), 0);
                if (cex.needRelogin()) {
                    Manager.getFrame().showLoginPanel();
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "GroupPropertiesDlg.error"), 0);
                LoggerUtilities.logException((Throwable)ex);
            }
        }
    }

    private void initialize() {
        this.cbBlockUsers.setOpaque(false);
        RestrictedPlainDocument descriptionDoc = new RestrictedPlainDocument(1024);
        this.jTFDesc.setDocument(descriptionDoc);
        this.jTFID.setEditable(false);
        this.jTFName.setEditable(false);
        this.jTFPath.setEditable(false);
        this.jTFComputer.setEditable(false);
        this.jTFUser.setEditable(false);
        this.jTFAdminName.setEditable(false);
        this.jTFCreateTime.setEditable(false);
        this.jTFModifyTime.setEditable(false);
        this.jTFProfileVersion.setEditable(false);
        this.jTFProfileDate.setEditable(false);
        this.jTFIdsVersion.setEditable(false);
        JPanel upPanel = new JPanel(new GridBagLayout());
        upPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        upPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "GroupPropertiesDlg.groupIDLabel")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        upPanel.add((Component)this.jTFID, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 0), 0, 0));
        upPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "GroupPropertiesDlg.nameLabel")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        upPanel.add((Component)this.jTFName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 0), 0, 0));
        upPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "GroupPropertiesDlg.descriptionLabel")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        upPanel.add((Component)this.jTFDesc, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 0), 0, 0));
        upPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "GroupPropertiesDlg.fullPathNameLabel")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        upPanel.add((Component)this.jTFPath, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 0), 0, 0));
        upPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "GroupPropertiesDlg.numberOfPhysicalComputersLabel")), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        upPanel.add((Component)this.jTFComputer, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 0), 0, 0));
        upPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "GroupPropertiesDlg.numberOfRegisteredUsersLabel")), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        upPanel.add((Component)this.jTFUser, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 0), 0, 0));
        upPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "GroupPropertiesDlg.createdByLabel")), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        upPanel.add((Component)this.jTFAdminName, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 0), 0, 0));
        upPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "GroupPropertiesDlg.dateCreatedLabel")), new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        upPanel.add((Component)this.jTFCreateTime, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 0), 0, 0));
        upPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "GroupPropertiesDlg.lastModifiedLabel")), new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        upPanel.add((Component)this.jTFModifyTime, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 0), 0, 0));
        upPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "GroupPropertiesDlg.profileSerialNumberLabel")), new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        upPanel.add((Component)this.jTFProfileVersion, new GridBagConstraints(1, 9, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 0), 0, 0));
        upPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "GroupPropertiesDlg.profileDateLabel")), new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        upPanel.add((Component)this.jTFProfileDate, new GridBagConstraints(1, 10, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 0), 0, 0));
        if (!LicenseObject.getInstance().isSBProduct()) {
            upPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "GroupPropertiesDlg.signatureFileSerialNumberLabel")), new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            upPanel.add((Component)this.jTFIdsVersion, new GridBagConstraints(1, 11, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 0), 0, 0));
        }
        upPanel.add((Component)this.cbBlockUsers, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, -5, 5, 0), 0, 0));
        this.getContentPane().add((Component)upPanel, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
    }

    private void initData(GroupObject group) throws ConsoleException {
        String admin;
        block7: {
            this.group = group;
            this.jTFID.setText(group.getId());
            this.jTFID.setToolTipText(this.jTFID.getText());
            this.jTFName.setText(group.getDisplayName());
            this.jTFName.setToolTipText(this.jTFName.getText());
            String description = group.getDescription();
            this.jTFDesc.setText(description);
            this.jTFPath.setText(GroupHandler.getGroupFullPath(group));
            this.jTFPath.setToolTipText(this.jTFPath.getText());
            String str = Integer.toString(SemClientHandler.getCountOfDistinctPhysicalComputers(group.getId()));
            this.jTFComputer.setText(str);
            this.jTFComputer.setToolTipText(str);
            str = Integer.toString(SemClientHandler.getCountOfDistinctRegisteredUsers(group.getId()));
            this.jTFUser.setText(str);
            this.jTFUser.setToolTipText(this.jTFUser.getText());
            admin = group.getSemClientGroup().getCreator();
            try {
                SemAdministrator semAdmin = AdminHandler.retrieveAdmin(admin);
                if (semAdmin != null) {
                    admin = semAdmin.getName();
                }
            }
            catch (ConsoleException ex) {
                if (!ex.needRelogin()) break block7;
                throw ex;
            }
        }
        this.jTFAdminName.setText(admin);
        this.jTFAdminName.setToolTipText(this.jTFAdminName.getText());
        this.jTFCreateTime.setText(group.getCreationTimeDisplayString());
        this.jTFCreateTime.setToolTipText(this.jTFCreateTime.getText());
        this.jTFModifyTime.setText(group.getModificationTimeDisplayString());
        this.jTFModifyTime.setToolTipText(this.jTFModifyTime.getText());
        String[] serialNumbers = null;
        serialNumbers = group.getSerialNumbers();
        if (serialNumbers[0] != null) {
            this.jTFProfileVersion.setText(serialNumbers[0]);
        }
        if (serialNumbers[1] != null) {
            this.jTFProfileDate.setText(serialNumbers[1]);
        }
        if (serialNumbers[2] != null) {
            this.jTFIdsVersion.setText(serialNumbers[2]);
        } else {
            this.jTFIdsVersion.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "GroupPropertiesDlg.signatureFileSerialNumberNotApplicable"));
        }
        this.cbBlockUsers.setEnabled(!group.isTypeAd());
        this.cbBlockUsers.setSelected(group.doesBlockNewUser());
        boolean isFullAccess = group.getAccessConstraint() == 0;
        this.cbBlockUsers.setEnabled(isFullAccess);
        this.jTFDesc.setEditable(isFullAccess);
        this.resetOKButton(isFullAccess);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_client_tree_dialog_group_properties";
    }
}

