/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.client.FindObjectPanel;
import com.sygate.scm.console.ui.client.dlg.SelectGroupDlg;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class FindObjectDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final String TYPE_COMPUTER = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FindObjectDlg.typeComputer");
    private static final String TYPE_USER = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FindObjectDlg.typeUser");
    private static final Object[] SEARCH_MODE = new Object[]{TYPE_COMPUTER, TYPE_USER};
    private final JTextField jTFGroupPath = new JTextField();
    private final JButton jBBrowse = new JButton(UIText.get(257));
    private final JButton jBClose = new JButton(UIText.get(519));
    private final JCheckBox jCbxSubGroup = new JCheckBox(UIText.get(4613), true);
    private final JComboBox<Object> jCmbMode = new JComboBox<Object>(SEARCH_MODE);
    private FindObjectPanel findPanel;
    private boolean isCancelled = true;
    String selectGroupId = null;

    public FindObjectDlg() {
        this((JFrame)null, (String)null, true);
    }

    public FindObjectDlg(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.initialize();
    }

    public static FindObjectDlg newInstanceForSearchClient(JFrame frame, String title, boolean modal) {
        return new SearchClientFindObjectDlg(frame, title, modal);
    }

    public void init(GroupObject groupObj) throws ConsoleException {
        if (groupObj == null) {
            return;
        }
        this.selectGroupId = groupObj.getId();
        String groupFullPath = GroupHandler.getGroupFullPath(this.selectGroupId);
        this.jTFGroupPath.setText(groupFullPath);
        this.jTFGroupPath.setEditable(false);
    }

    public String getGroupPath() {
        String path = this.jTFGroupPath.getText().trim();
        if (path.indexOf("\\\\") > 0) {
            return null;
        }
        if (path.length() > 0 && path.charAt(path.length() - 1) == '\\') {
            path = path.substring(0, path.length() - 1);
            System.out.println("** Path got is--" + path);
        }
        return path;
    }

    public ArrayList<GroupObject> getGroupList() {
        return this.getGroupList(0);
    }

    ArrayList<GroupObject> getGroupList(int access) {
        ArrayList<Object> groupList = null;
        String groupPath = this.getGroupPath();
        GroupObject group = null;
        try {
            if (groupPath != null) {
                group = GroupHandler.getGroupByFullPath(groupPath);
                groupList = group != null ? GroupHandler.getAllowedChildGroups(group, this.jCbxSubGroup.isSelected(), access) : new ArrayList();
            }
        }
        catch (Exception e) {
            System.out.println("Failed to get group, exception = ");
            LoggerUtilities.logException((Throwable)e);
        }
        return groupList;
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    protected boolean ok() {
        if (super.ok()) {
            this.dispose();
        }
        return true;
    }

    @Override
    protected void cancel() {
        super.cancel();
        this.dispose();
    }

    @Override
    protected void commit() {
        this.isCancelled = false;
    }

    private void initialize() {
        this.findPanel = new FindObjectPanel(this);
        this.findPanel.setTitlePanel(this.getGroupPanel());
        this.getContentPane().add((Component)this.findPanel, "Center");
        this.getContentPane().add((Component)this.createButtonPanel(), "South");
        this.setBackgroundColorForAllPanels(this.getContentPane());
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    private JPanel getGroupPanel() {
        this.jCmbMode.putClientProperty("dynamicEventsEnabled", true);
        this.jCmbMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindObjectDlg.this.findPanel.setSearchMode(TYPE_COMPUTER.equals(FindObjectDlg.this.jCmbMode.getSelectedItem()));
            }
        });
        this.jBBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindObjectDlg.this.browse();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        if (!LicenseObject.getInstance().isSBProduct()) {
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FindObjectDlg.findLabel")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add(this.jCmbMode, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FindObjectDlg.inGroupLabel")), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        } else {
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FindObjectDlg.searchLabel")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        panel.add((Component)this.jTFGroupPath, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.jBBrowse, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.jCbxSubGroup, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        return panel;
    }

    private JPanel createButtonPanel() {
        this.jBClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindObjectDlg.this.dispose();
            }
        });
        this.jBHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindObjectDlg.this.help();
            }
        });
        JPanel buttonPanel = new JPanel();
        UIUtilities.layoutButtonPanel(buttonPanel, new JButton[]{this.jBClose, this.jBHelp}, 0, 4, true);
        return buttonPanel;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_client_tree_dialog_search_computers_users";
    }

    private void browse() {
        try {
            DefaultMutableTreeNode rootNode = GroupHandler.getGroups();
            DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
            SelectGroupDlg dlg = this.newSelectGroupDialog(treeModel);
            dlg.setVisible(true);
            if (dlg.isOk()) {
                ArrayList<GroupObject> newParentGroups = dlg.getListGroupObjs();
                for (GroupObject newParentGroup : newParentGroups) {
                    String fullPath = GroupHandler.getGroupFullPath(newParentGroup);
                    this.jTFGroupPath.setText(fullPath);
                    this.selectGroupId = newParentGroup.getId();
                }
            }
            dlg.dispose();
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FindObjectDlg.error"), 0);
        }
    }

    SelectGroupDlg newSelectGroupDialog(DefaultTreeModel treeModel) {
        return SelectGroupDlg.newReadOnlyNodeValidInstance(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FindObjectDlg.browseGroupTitle"), treeModel, 0, this.selectGroupId);
    }

    public FindObjectPanel getFindObjectPanel() {
        return this.findPanel;
    }

    static class SearchClientFindObjectDlg
    extends FindObjectDlg {
        private static final long serialVersionUID = 8287051701276627964L;

        SearchClientFindObjectDlg() {
        }

        SearchClientFindObjectDlg(JFrame frame, String title, boolean modal) {
            super(frame, title, modal);
        }

        @Override
        SelectGroupDlg newSelectGroupDialog(DefaultTreeModel treeModel) {
            return SelectGroupDlg.newInstanceForSearchClient(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FindObjectDlg.browseGroupTitle"), treeModel, 0, this.selectGroupId);
        }

        @Override
        public ArrayList<GroupObject> getGroupList() {
            return this.getGroupList(2);
        }
    }
}

