/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class FilterObjectDlg
extends DialogBase {
    private static final long serialVersionUID = -3877271653329968618L;
    private static final MessageResources MRS = MessageResources.getInstance();
    private static final int MIN_COUNT = 1;
    public static final int MAX_COUNT = 1000;
    private JLabel panelLabel = new JLabel();
    private JLabel clientTypeLabel = new JLabel();
    private JLabel computerTypeLabel = new JLabel(MRS.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FilterObjectDlg.computerTypeLabel"));
    private JRadioButton usersAndComputersRadio = new JRadioButton(MRS.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FilterObjectDlg.showAllRB"));
    private JRadioButton usersRadio = new JRadioButton(MRS.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FilterObjectDlg.showAllUsersRB"));
    private JRadioButton computersRadio = new JRadioButton(MRS.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FilterObjectDlg.showAllComputersRB"));
    private JCheckBox jCHKWindows = new JCheckBox(MRS.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FilterObjectDlg.showWindowsCbox"), true);
    private JCheckBox jCHKMac = new JCheckBox(MRS.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FilterObjectDlg.showMacCbox"), true);
    private JCheckBox jCHKLinux = new JCheckBox(MRS.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FilterObjectDlg.showLinuxCbox"), true);
    private JCheckBox jCHKenableOsFilter = new JCheckBox(MRS.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FilterObjectDlg.enableOsFilterCbox"), true);
    private JCheckBox jCbxUnknownOS = new JCheckBox("<html>" + MRS.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FilterObjectDlg.shownNewClientsOSCbox") + "</html>", true);
    private JCheckBox jCbxODCHosted = new JCheckBox(MRS.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FilterObjectDlg.shownODCHostedCbox"), true);
    private JTextField jTFCount = new JTextField(new NumberPlainDocument(1000L), String.valueOf(1000), 3);
    private JCheckBox jCbxOfflineNPVDIClients = new JCheckBox(MRS.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FilterObjectDlg.ExcludeOfflineNPVDIClients"), true);

    public FilterObjectDlg(int filter, int displayMax, boolean isOnline, boolean platformFilterAll, boolean platformFilterWin, boolean platformFilterMac, boolean platformFilterLinux, boolean unknownOSFilter, boolean ODCHostedFilter, boolean isOfflineNPVDIClient) {
        super(Manager.getFrame(), "Set Display Filter", true);
        String title = MRS.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FilterObjectDlg.dlgTitle");
        this.setTitle(title);
        String panelLabelText = MRS.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FilterObjectDlg.clientsSelectLabel");
        this.panelLabel.setText(panelLabelText);
        String clientTypeLabelText = MRS.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FilterObjectDlg.clientTypeLabel");
        this.clientTypeLabel.setText(clientTypeLabelText);
        this.initialize();
        this.initData(filter, displayMax, isOnline, platformFilterAll, platformFilterWin, platformFilterMac, platformFilterLinux, unknownOSFilter, ODCHostedFilter, isOfflineNPVDIClient);
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public int getFilterType() {
        if (this.usersAndComputersRadio.isSelected()) {
            return 2;
        }
        if (this.usersRadio.isSelected()) {
            return 0;
        }
        return 1;
    }

    public boolean getPlatformFilterAll() {
        return !this.jCHKenableOsFilter.isSelected();
    }

    public boolean getPlatformFilterWin() {
        return this.jCHKWindows.isSelected();
    }

    public boolean getPlatformFilterMac() {
        return this.jCHKMac.isSelected();
    }

    public boolean getPlatformFilterLinux() {
        return this.jCHKLinux.isSelected();
    }

    public boolean getNewClients() {
        return this.jCbxUnknownOS.isSelected();
    }

    public boolean getODCHosted() {
        return this.jCbxODCHosted.isSelected();
    }

    public int getCount() {
        return Integer.parseInt(this.jTFCount.getText().trim());
    }

    public boolean getOnlineStatus() {
        return true;
    }

    public boolean getOfflineNPVDIClients() {
        return this.jCbxOfflineNPVDIClients.isSelected();
    }

    @Override
    protected boolean isValidate() {
        boolean selected;
        Object[] obj = new Object[]{Integer.toString(1), Integer.toString(1000)};
        String str = MRS.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FilterObjectDlg.maximumNumberShould01Msg");
        String fm = MessageFormat.format(str, obj);
        String strOsSelection = MRS.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FilterObjectDlg.osSelectionMsg");
        String text = this.jTFCount.getText().trim();
        try {
            int count = Integer.parseInt(text);
            if (count > 1000 || count < 1) {
                JOptionPane.showMessageDialog(this, fm, MRS.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FilterObjectDlg.error"), 0);
                return false;
            }
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, fm, MRS.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FilterObjectDlg.error"), 0);
            return false;
        }
        boolean bl = selected = this.jCHKWindows.isSelected() || this.jCHKMac.isSelected() || this.jCHKLinux.isSelected();
        if (this.jCHKenableOsFilter.isSelected() && !selected) {
            JOptionPane.showMessageDialog(this, strOsSelection, MRS.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FilterObjectDlg.error"), 0);
            return false;
        }
        return true;
    }

    private void initialize() {
        this.getContentPane().setLayout(new VerticalFlowLayout());
        this.getContentPane().add(this.getFilterPanel());
        this.getContentPane().add(this.getPagePanel());
        this.getContentPane().add(this.getButtonPanel());
        this.pack();
    }

    private void enableOsPlatform() {
        boolean selected;
        this.jCHKWindows.setEnabled(this.jCHKenableOsFilter.isSelected());
        this.jCHKMac.setEnabled(this.jCHKenableOsFilter.isSelected());
        this.jCHKLinux.setEnabled(this.jCHKenableOsFilter.isSelected());
        boolean bl = selected = this.jCHKWindows.isSelected() || this.jCHKMac.isSelected() || this.jCHKLinux.isSelected();
        if (this.jCHKenableOsFilter.isSelected() && !selected) {
            this.jCHKWindows.setSelected(true);
            this.jCHKMac.setSelected(true);
            this.jCHKLinux.setSelected(true);
        }
    }

    private JPanel getFilterPanel() {
        this.jCHKenableOsFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterObjectDlg.this.enableOsPlatform();
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 23;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.panelLabel, c);
        c.gridx = 0;
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)this.computerTypeLabel, c);
        ++c.gridy;
        c.insets = new Insets(5, 5, 0, 0);
        panel.add((Component)this.jCHKenableOsFilter, c);
        ++c.gridy;
        c.insets = new Insets(0, 15, 0, 0);
        panel.add((Component)this.jCHKWindows, c);
        c.gridx = 0;
        ++c.gridy;
        c.insets = new Insets(0, 15, 0, 0);
        panel.add((Component)this.jCHKMac, c);
        ++c.gridy;
        c.insets = new Insets(0, 15, 0, 0);
        panel.add((Component)this.jCHKLinux, c);
        c.gridx = 0;
        c.gridy += 2;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)this.clientTypeLabel, c);
        c.gridx = 0;
        ++c.gridy;
        if (!LicenseObject.getInstance().isSEPSBProduct()) {
            c.insets = new Insets(0, 5, 0, 0);
            panel.add((Component)this.usersAndComputersRadio, c);
            c.gridx = 0;
            ++c.gridy;
        }
        c.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)this.computersRadio, c);
        c.gridx = 0;
        ++c.gridy;
        if (!LicenseObject.getInstance().isSEPSBProduct()) {
            c.insets = new Insets(0, 5, 0, 0);
            panel.add((Component)this.usersRadio, c);
            ++c.gridy;
        }
        c.gridx = 0;
        c.gridy += 4;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)this.jCbxUnknownOS, c);
        if (!LicenseObject.getInstance().isSEPSBProduct()) {
            ++c.gridy;
            ++c.gridy;
            c.insets = new Insets(10, 0, 0, 0);
            panel.add((Component)this.jCbxOfflineNPVDIClients, c);
        }
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.usersAndComputersRadio);
        buttonGroup1.add(this.usersRadio);
        buttonGroup1.add(this.computersRadio);
        return panel;
    }

    private JPanel getPagePanel() {
        this.jTFCount.setHorizontalAlignment(4);
        Object[] obj = new Object[]{Integer.toString(1), Integer.toString(1000)};
        String str = MRS.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FilterObjectDlg.range0~1Msg");
        String fm = MessageFormat.format(str, obj);
        this.jTFCount.setToolTipText(fm);
        JLabel maximumNumberOfClientsPerPageLabel = new JLabel(MRS.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FilterObjectDlg.maximumNumberOfClientsPerPageLabel"));
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(maximumNumberOfClientsPerPageLabel);
        panel.add(this.jTFCount);
        return panel;
    }

    private void initData(int filter, int displayMax, boolean isOnline, boolean platformFilterAll, boolean platformFilterWin, boolean platformFilterMac, boolean platformFilterLinux, boolean unknownOSFilter, boolean ODCHostedFilter, boolean isOfflineNPVDIClient) {
        this.usersRadio.setSelected(filter == 0);
        this.usersAndComputersRadio.setSelected(filter == 2);
        if (!LicenseObject.getInstance().isSEPSBProduct()) {
            this.computersRadio.setSelected(filter == 1);
        } else {
            this.computersRadio.setSelected(true);
        }
        this.jTFCount.setText(String.valueOf(displayMax));
        if (!LicenseObject.getInstance().isSEPSBProduct()) {
            this.jCbxOfflineNPVDIClients.setSelected(isOfflineNPVDIClient);
        }
        this.jCHKenableOsFilter.setSelected(!platformFilterAll);
        this.jCHKWindows.setSelected(platformFilterWin);
        this.jCHKMac.setSelected(platformFilterMac);
        this.jCHKLinux.setSelected(platformFilterLinux);
        this.jCbxUnknownOS.setSelected(unknownOSFilter);
        this.jCbxODCHosted.setSelected(ODCHostedFilter);
        this.enableOsPlatform();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_client_dialog_computers_users_set_display_filter";
    }
}

