/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class ExportSylinkDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final String CONFIG_XML = "sylink.xml";
    private static final int EXTENDED_WIDTH = 200;
    private final JTextArea jTADesc = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportSylinkDlg.description"), 2, 30);
    private final JLabel jLFile = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportSylinkDlg.exportFileLabel"));
    private final JTextField jTFFile = new JTextField();
    private final JButton jBBrowse = new JButton(UIText.get(257));
    private final JRadioButton jRBUserMode = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportSylinkDlg.userMode"));
    private final JRadioButton jRBComputerMode = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportSylinkDlg.computerMode"), true);
    private final String confirmLocationTitle = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportSylinkDlg.comfirmLocationTitle");
    private final String confirmLocationContent = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportSylinkDlg.comfirmLocationContent");
    private String groupPath;

    public ExportSylinkDlg(String groupPath) {
        super(Manager.getFrame(), "", true);
        this.groupPath = groupPath;
        int index = groupPath.lastIndexOf("\\");
        String shortPath = groupPath;
        if (index != -1) {
            shortPath = groupPath.substring(index + 1);
        }
        Object[] obj = new Object[]{shortPath};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportSylinkDlg.ExportSylinkFor0Msg");
        String fm = MessageFormat.format(str, obj);
        super.setTitle(fm);
        this.initialize();
        Dimension size = this.getSize();
        this.setSize((int)size.getWidth() + 200, (int)size.getHeight());
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public String getDefaultExportFileName() {
        String fileName = this.groupPath;
        fileName = fileName.replace(File.separator, "_");
        return fileName + "_sylink.xml";
    }

    private void btnBrowseActionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setDialogTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportSylinkDlg.browseDlgTitle"));
        fc.setApproveButtonText(UIText.get(3584));
        fc.setSelectedFile(new File(this.getDefaultExportFileName()));
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = Utility.getFileExtension((File)f);
                return extension != null && extension.equals("xml");
            }

            @Override
            public String getDescription() {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportSylinkDlg.fileTypeDesc");
            }
        });
        fc.updateUI();
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            fc.setDialogType(1);
            if (0 == fc.showSaveDialog(this) && fc.getSelectedFile() != null) {
                String path = fc.getSelectedFile().getAbsolutePath();
                this.jTFFile.setText(path);
            }
        } else if (0 == fc.showOpenDialog(this) && fc.getSelectedFile() != null) {
            String path = fc.getSelectedFile().getAbsolutePath();
            this.jTFFile.setText(path);
        }
    }

    private void initialize() {
        RestrictedPlainDocument doc = new RestrictedPlainDocument(260);
        this.jTFFile.setDocument(doc);
        this.jBBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportSylinkDlg.this.btnBrowseActionPerformed(e);
            }
        });
        JPanel topPanel = (JPanel)this.getContentPane();
        topPanel.setLayout(new GridBagLayout());
        topPanel.add((Component)this.jTADesc, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 10, 5), 0, 0));
        if (!AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            topPanel.add((Component)this.jLFile, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
            topPanel.add((Component)this.jTFFile, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
            topPanel.add((Component)this.jBBrowse, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        JPanel modePanel = new JPanel(new GridBagLayout());
        if (!LicenseObject.getInstance().isSBProduct()) {
            topPanel.add((Component)modePanel, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        topPanel.add((Component)new JPanel(), new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)this.getButtonPanel(), new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRBUserMode);
        group.add(this.jRBComputerMode);
        modePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportSylinkDlg.modeSetting"))));
        String modeDesc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportSylinkDlg.modeDesc");
        modePanel.add((Component)new DescriptionTextArea(modeDesc, 2, 30), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel modelRBPanel = new JPanel(new GridBagLayout());
        modelRBPanel.add((Component)this.jRBComputerMode, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        modelRBPanel.add((Component)this.jRBUserMode, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        modePanel.add((Component)modelRBPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.pack();
    }

    @Override
    protected String getOkButtonText() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportSylinkDlg.okButtonText");
    }

    @Override
    protected boolean isValidate() {
        String path = this.getExportPath();
        if (path == null || path.length() == 0) {
            this.jTFFile.requestFocus();
            return false;
        }
        File exportFile = new File(path);
        String canonicalPath = null;
        try {
            canonicalPath = exportFile.getCanonicalPath();
        }
        catch (IOException e) {
            return false;
        }
        if (canonicalPath.length() >= 260) {
            this.jTFFile.requestFocus();
            return false;
        }
        if (!path.equalsIgnoreCase(canonicalPath) && 0 != UIUtilities.confirmYesNoOptionDialog(this.confirmLocationContent + path, this.confirmLocationTitle)) {
            this.jTFFile.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_clients_group_registeration_setting_export";
    }

    public String getExportPath() {
        String dir;
        if (this.jTFFile.getText().length() == 0 && AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            this.btnBrowseActionPerformed(null);
        }
        if ((dir = this.jTFFile.getText().trim()).endsWith(File.separator)) {
            dir = dir.substring(0, dir.length() - 1);
        }
        return dir;
    }

    public boolean isComputerMode() {
        return this.jRBComputerMode.isSelected();
    }

    public static void main(String[] args) {
        Manager.setFrame(null);
        new ExportSylinkDlg("Global");
    }
}

