/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.configobject.schema.ClientFeature;
import com.sygate.scm.common.configobject.schema.ClientInstallationFeatures;
import com.sygate.scm.common.configobject.schema.EnabledClientFeatures;
import com.sygate.scm.common.configobject.schema.InstallationOption;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.configobject.schema.SemClientGroupTree;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientInstallFeatureSetUtility;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.SecurityFixContentInfoObject;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallFeaturePoolObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallPoolObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationFeatureObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationSettingObject;
import com.sygate.scm.console.ui.client.AbstractExportPackageValidator;
import com.sygate.scm.console.ui.client.ExportPackageSettings;
import com.sygate.scm.console.ui.client.ExportPackageWorkerFacotry;
import com.sygate.scm.console.ui.client.WindowsPackageSizeCalculator;
import com.sygate.scm.console.ui.client.dlg.ExportFolderChooser;
import com.sygate.scm.console.ui.client.dlg.PackageContentPanel;
import com.sygate.scm.console.ui.client.wizard.PackageOptionsPanel;
import com.sygate.scm.console.ui.policy.lu.LuUtility;
import com.sygate.scm.console.ui.policy.util.PolicyUtil;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.GroupCheckBoxTree;
import com.sygate.scm.console.ui.util.ListMessageBox;
import com.sygate.scm.console.ui.util.MultiLineMsgBox;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.ui.util.renderer.ToolTipComboBoxRenderer;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.PackageUtil;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ExportPackageDlg
extends DialogBase
implements PropertyChangeListener,
ItemListener {
    private static final int PREFERRED_COMBOBOX_WIDTH = 120;
    private static final String AUTOMATION_BUTTON_OK = "ExportButtonOK";
    private static final String AUTOMATION_BUTTON_CANCEL = "ExportButtonCancel";
    private static final String AUTOMATION_PACKAGE_BUILD_SELECTION = "PackageBuildSelection";
    private static final long serialVersionUID = 1L;
    public static final String VALID_PATH = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789~`!@#$%^&()-_+={}[]\\/:;,. ";
    private static final String DESCRIPTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.exportedPackageCanBeUsedToMsg");
    public static final int EXPORT_MAX_GROUPS_WARNING = 10;
    protected JTextArea jTADesc = null;
    protected JPanel jDetailPanel = new JPanel(new GridBagLayout());
    protected JLabel jLDirectory = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.exportDirectoryLabel"));
    protected JTextField jTFDirectory = new JTextField();
    protected JButton jBBrowse = new JButton(UIText.get(257));
    protected JCheckBox jCBAutomaticGroup = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.automaticClientGroup"), true);
    protected JCheckBox jCbxSingleEXE = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.createSingleExeCkbox"));
    protected JRadioButton jRBUnManaged = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.exportUnmanagegedClient"));
    protected JRadioButton jRBManaged = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.exportManagedClient"), true);
    protected JCheckBox jCbxGroup = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.exportPackageWithSecurityPoliciesRB"), true);
    protected JRadioButton userModeRButton;
    protected JRadioButton hostModeRButton;
    protected GroupCheckBoxTree groupTree = new GroupCheckBoxTree();
    protected JScrollPane jSPGroupTree = new JScrollPane(this.groupTree);
    protected JTextArea jTxtInfo = new JTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.1PackageWillBeExported"));
    protected JLabel noHbDefsWarningLbl = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.noAVDefsWarningMsg"));
    protected JLabel noLbDefsWarningLbl = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.noAMLStaticDefsWarningMsg"));
    protected JPanel topPanel;
    private JPanel installPanel;
    private JPanel securityFixPanel;
    protected JPanel securityPanel;
    protected JPanel statusPanel;
    private JLabel installSettingLbl = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.Pickup_installation"));
    private JLabel installFeatureLbl = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.Pickup_feature"));
    private JLabel securityFixBuildNumbertLbl = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.Pickup_securityFixBuildNumber"));
    private JCheckBox maintainExistingFeaturesChkBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.forceUpdateCkBox"), false);
    private DescriptionTextArea featuresWarning = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.FeaturesWarning"));
    private JComboBox<ClientInstallationSettingObject> settingComboBox;
    private JComboBox<ClientInstallationFeatureObject> featureComboBox;
    private JComboBox<SecurityFixContentInfoObject> securityFixBuildNumberComboBox;
    protected JLabel selectContentsLbl = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.labelSelectContents"));
    protected JButton jBContents = new JButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.selectContentButtonText"));
    protected CurrentPackageObject currentPackageObj = null;
    private int packageContentOption = 0;
    boolean hasGroupAccess = false;
    protected boolean isLimitedAdmin = false;
    protected String clientExportZipFilePath = null;
    private String version = "";
    private String platform = "";
    private long hbPkgSizeWithLatestContent = 0L;
    private long lbPkgSizeWithLatestContent = 0L;
    private Boolean isNoHbDefsWarningShouldBeShown = false;
    private Boolean isNoLbDefsWarningShouldBeShown = false;
    private boolean isLbGroupUseHbContent = false;
    private PackageContentPanel packageContentPanel = null;

    public ExportPackageDlg(CurrentPackageObject cpo, String title, boolean isLimitedAdmin) throws Exception {
        super(Manager.getFrame(), title, true);
        this.currentPackageObj = cpo;
        this.isLimitedAdmin = isLimitedAdmin;
        this.jTADesc = new DescriptionTextArea(DESCRIPTION, 2, 30);
        this.version = cpo.getSoftwarePackageObject().getVersion(true);
        this.platform = cpo.getPlatformType();
        boolean isSavPackage = cpo.getPackageType() == 105;
        ConsoleLogger.log("ExportPackageDlg>>ExportPackageDlg: package version: " + this.version);
        ConsoleLogger.log("ExportPackageDlg>>ExportPackageDlg: package platform: " + this.platform);
        ConsoleLogger.log("ExportPackageDlg>>ExportPackageDlg: is SAV package: " + isSavPackage);
        this.jbInit();
        this.init();
        this.setMinimumSize(new Dimension(850, 521));
        UiUtilities.centerComponent((Component)this);
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
            this.jLDirectory.setEnabled(false);
            this.jTFDirectory.setEnabled(false);
            this.jBBrowse.setEnabled(false);
        });
        this.setVisible(true);
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
            this.jLDirectory.setVisible(false);
            this.jTFDirectory.setVisible(false);
            this.jBBrowse.setVisible(false);
        });
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_install_packages_dialog_export";
    }

    protected void jbInit() throws Exception {
        UIUtilities.setName(this.jBOk, "packageManagement", UIUtilities.ComponentType.BUTTON, AUTOMATION_BUTTON_OK);
        UIUtilities.setName(this.jBCancel, "packageManagement", UIUtilities.ComponentType.BUTTON, AUTOMATION_BUTTON_CANCEL);
        this.jCBAutomaticGroup.putClientProperty("dynamicEventsEnabled", true);
        this.jCbxGroup.putClientProperty("dynamicEventsEnabled", true);
        this.jCbxSingleEXE.putClientProperty("dynamicEventsEnabled", true);
        this.groupTree.setVisibleRowCount(7);
        if (this.isLimitedAdmin) {
            this.jCbxGroup.setEnabled(false);
            this.jCbxGroup.setSelected(true);
            this.jCBAutomaticGroup.setEnabled(false);
            this.jRBUnManaged.setEnabled(false);
        }
        this.jBBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportPackageDlg.this.btnBrowseActionPerformed(e);
            }
        });
        this.jCbxSingleEXE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportPackageDlg.this.chkSingleEXE_actionPerformed(e);
            }
        });
        this.jCbxSingleEXE.setSelected(true);
        this.jRBUnManaged.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportPackageDlg.this.jCBAutomaticGroup.setEnabled(false);
                ExportPackageDlg.this.calculatePackageSize();
            }
        });
        this.jRBManaged.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportPackageDlg.this.exportTypeChanged();
            }
        });
        this.jCbxGroup.setOpaque(false);
        this.jCbxGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportPackageDlg.this.exportTypeChanged();
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRBUnManaged);
        group.add(this.jRBManaged);
        RestrictedPlainDocument doc = new RestrictedPlainDocument(260);
        this.jTFDirectory.setDocument(doc);
        UIUtilities.fitJComponent(new JButton[]{this.jBBrowse});
        int y = 0;
        this.jDetailPanel.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 15));
        this.jDetailPanel.add((Component)this.getTopPanel(), new GridBagConstraints(0, y++, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        if (this.currentPackageObj.getSoftwarePackageObject().isSecurityFixContent()) {
            this.jDetailPanel.add((Component)this.getSecurityFixBuildNumberPanel(), new GridBagConstraints(0, y, 1, 1, 0.5, 0.0, 10, 1, new Insets(2, 0, 0, 5), 0, 0));
            this.jDetailPanel.add((Component)this.getSecurityPanel(), new GridBagConstraints(1, y, 1, 4, 0.5, 0.0, 10, 3, new Insets(2, 0, 5, 0), 0, 0));
            this.jDetailPanel.add((Component)this.getInstallPanel(), new GridBagConstraints(0, ++y, 1, 1, 0.5, 0.0, 10, 1, new Insets(2, 0, 0, 5), 0, 0));
        } else {
            this.jDetailPanel.add((Component)this.getInstallPanel(), new GridBagConstraints(0, y, 1, 1, 0.5, 0.0, 10, 1, new Insets(2, 0, 0, 5), 0, 0));
            this.jDetailPanel.add((Component)this.getSecurityPanel(), new GridBagConstraints(1, y, 1, 3, 0.5, 0.0, 10, 3, new Insets(2, 0, 5, 0), 0, 0));
        }
        this.jDetailPanel.add((Component)this.getAgentModePanel(), new GridBagConstraints(0, ++y, 1, 1, 0.5, 0.0, 10, 1, new Insets(2, 0, 0, 5), 0, 0));
        this.jDetailPanel.add((Component)new JPanel(), new GridBagConstraints(0, ++y, 1, 1, 0.5, 1.0, 10, 1, new Insets(2, 5, 5, 5), 0, 0));
        this.jDetailPanel.add((Component)this.getStatusPanel(), new GridBagConstraints(0, ++y, 3, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 5, 0), 0, 0));
        JPanel wrapperJDetailPanel = new JPanel(new BorderLayout());
        wrapperJDetailPanel.add((Component)this.jDetailPanel, "Center");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)wrapperJDetailPanel, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
    }

    protected JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            if (Utilities.isWindowsPackage(this.platform)) {
                this.jTxtInfo.setBackground(this.getBackground());
                this.noHbDefsWarningLbl.setForeground(Color.red);
                this.noHbDefsWarningLbl.setVisible(false);
                this.noHbDefsWarningLbl.setOpaque(true);
                this.noHbDefsWarningLbl.setBackground(this.getBackground());
                this.noLbDefsWarningLbl.setForeground(Color.red);
                this.noLbDefsWarningLbl.setVisible(false);
                this.noLbDefsWarningLbl.setOpaque(true);
                this.noLbDefsWarningLbl.setBackground(this.getBackground());
                this.statusPanel = new JPanel(new GridBagLayout());
                this.statusPanel.add((Component)this.jTxtInfo, new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.statusPanel.add((Component)this.noHbDefsWarningLbl, new GridBagConstraints(0, 1, 0, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.statusPanel.add((Component)this.noLbDefsWarningLbl, new GridBagConstraints(0, 2, 0, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                this.jTxtInfo.setBackground(this.getBackground());
                this.statusPanel = new JPanel(new BorderLayout());
                this.statusPanel.add(this.jTxtInfo);
            }
        }
        return this.statusPanel;
    }

    protected JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel(new GridBagLayout());
            this.topPanel.add((Component)this.jTADesc, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
            AjaxSwingCommonUtil.executeIfWebConsoleIsNotRunning(() -> {
                this.topPanel.add((Component)this.jLDirectory, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
                this.jLDirectory.setLabelFor(this.jTFDirectory);
                this.topPanel.add((Component)this.jTFDirectory, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
                this.topPanel.add((Component)this.jBBrowse, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
            });
            this.topPanel.add((Component)this.jCbxSingleEXE, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        }
        return this.topPanel;
    }

    private String getRes(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg." + key);
    }

    protected JPanel getAgentModePanel() {
        this.userModeRButton = new JRadioButton(this.getRes("userMode"));
        this.hostModeRButton = new JRadioButton(this.getRes("hostMode"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.userModeRButton);
        bg.add(this.hostModeRButton);
        this.hostModeRButton.setSelected(true);
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this.hostModeRButton);
        panel.add(this.userModeRButton);
        JPanel result = new JPanel(new GridBagLayout());
        result.add((Component)new DescriptionTextArea(this.getRes("modeDesc"), 20), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 2, 0, 0), 0, 0));
        result.add((Component)panel, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        result.setBorder(BorderFactory.createTitledBorder(this.getRes("modeTitle")));
        return result;
    }

    protected JPanel getInstallPanel() throws ConsoleException {
        int y = 0;
        if (this.installPanel == null) {
            boolean isSNAC = this.currentPackageObj.getPackageType() == 151;
            this.installPanel = new JPanel(new GridBagLayout());
            this.installPanel.add((Component)this.maintainExistingFeaturesChkBox, new GridBagConstraints(0, y, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 2, 0, 2), 0, 0));
            this.installPanel.add((Component)this.installFeatureLbl, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 10, 0, 2), 0, 0));
            this.installPanel.add(this.getFeatureComboBox(), new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
            this.installPanel.add((Component)this.featuresWarning, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 10, 0, 2), 0, 1));
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.InstallSettingOnly");
            this.installFeatureLbl.setLabelFor(this.featureComboBox);
            title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.InstallSetting");
            this.installPanel.add((Component)this.installSettingLbl, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 17, 1, new Insets(5, 2, 0, 2), 0, 0));
            this.installPanel.add(this.getSettingComboBox(), new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 2, 0, 10), 0, 0));
            this.installSettingLbl.setLabelFor(this.settingComboBox);
            this.packageContentPanel = new PackageContentPanel(this.packageContentOption, this);
            this.installPanel.add((Component)this.packageContentPanel, new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 2, 0, 2), 0, 0));
            this.packageContentPanel.setVisible(!isSNAC);
            this.installPanel.setBorder(BorderFactory.createTitledBorder(title));
        }
        return this.installPanel;
    }

    protected JPanel getSecurityFixBuildNumberPanel() throws ConsoleException {
        int y = 0;
        if (this.securityFixPanel == null) {
            this.securityFixPanel = new JPanel(new GridBagLayout());
            this.securityFixBuildNumbertLbl.setLabelFor(this.getSecurityFixBuildNumberComboBox());
            this.securityFixPanel.add((Component)this.securityFixBuildNumbertLbl, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 2, 0, 2), 0, 0));
            this.securityFixPanel.add(this.getSecurityFixBuildNumberComboBox(), new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 2, 0, 10), 0, 0));
            String settingsTitle = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.SecurityFixSetting");
            this.securityFixPanel.setBorder(BorderFactory.createTitledBorder(settingsTitle));
        }
        return this.securityFixPanel;
    }

    protected void setPackageContentOption(int option) {
        this.packageContentOption = option;
    }

    public int getPackageContentOption() {
        return this.packageContentOption;
    }

    private void setFeaturesState() {
        if (this.maintainExistingFeaturesChkBox.isSelected()) {
            this.featureComboBox.setSelectedIndex(0);
        }
        this.installFeatureLbl.setEnabled(!this.maintainExistingFeaturesChkBox.isSelected());
        this.featureComboBox.setEnabled(!this.maintainExistingFeaturesChkBox.isSelected());
    }

    protected JComboBox<ClientInstallationFeatureObject> getFeatureComboBox() throws ConsoleException {
        if (this.featureComboBox == null) {
            ClientInstallFeaturePoolObject pool = new ClientInstallFeaturePoolObject();
            Vector<ClientInstallationFeatureObject> allSettings = new Vector<ClientInstallationFeatureObject>(pool.getAllObjects());
            this.featureComboBox = new JComboBox<ClientInstallationFeatureObject>(allSettings);
            this.featureComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ExportPackageDlg.this.calculatePackageSize();
                    boolean isTdadOnly = PackageOptionsPanel.isFeatureSetTdadOnly((ClientInstallationFeatureObject)ExportPackageDlg.this.featureComboBox.getSelectedItem());
                    ExportPackageDlg.this.packageContentPanel.toggleAllContent(!isTdadOnly);
                }
            });
            this.maintainExistingFeaturesChkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportPackageDlg.this.setFeaturesState();
                }
            });
        }
        this.featureComboBox.setRenderer(new ToolTipComboBoxRenderer());
        this.featureComboBox.setPreferredSize(new Dimension(120, this.featureComboBox.getPreferredSize().height));
        return this.featureComboBox;
    }

    protected JComboBox<SecurityFixContentInfoObject> getSecurityFixBuildNumberComboBox() throws ConsoleException {
        if (this.securityFixBuildNumberComboBox == null) {
            this.securityFixBuildNumberComboBox = new JComboBox<SecurityFixContentInfoObject>(this.currentPackageObj.getSoftwarePackageObject().getSecurityFixContentBuildNumbers());
            this.securityFixBuildNumberComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ExportPackageDlg.this.securityFixBuildNumberComboBoxSelectionChange();
                }
            });
            UIUtilities.setName(this.securityFixBuildNumberComboBox, "packageManagement", UIUtilities.ComponentType.COMBOBOX, AUTOMATION_PACKAGE_BUILD_SELECTION);
            this.securityFixBuildNumberComboBox.setSelectedIndex(0);
            this.securityFixBuildNumberComboBoxSelectionChange();
        }
        this.securityFixBuildNumberComboBox.setRenderer(new ToolTipComboBoxRenderer());
        this.securityFixBuildNumberComboBox.setPreferredSize(new Dimension(120, this.securityFixBuildNumberComboBox.getPreferredSize().height));
        return this.securityFixBuildNumberComboBox;
    }

    protected void securityFixBuildNumberComboBoxSelectionChange() {
        SecurityFixContentInfoObject selectedBuild = (SecurityFixContentInfoObject)this.securityFixBuildNumberComboBox.getSelectedItem();
        ConsoleLogger.log("The selected security fix build number is: " + selectedBuild.getSecurityFixContentInfo().getProductBuildNum() + ", PackageChecksum: " + selectedBuild.getSecurityFixContentInfo().getPackageChecksum());
        this.currentPackageObj.getSoftwarePackageObject().getPackageInfo().setOptProductBuildNum(selectedBuild.getSecurityFixContentInfo().getProductBuildNum());
        this.currentPackageObj.getSoftwarePackageObject().getPackageInfo().setChecksum(selectedBuild.getSecurityFixContentInfo().getPackageChecksum());
    }

    protected JComboBox<ClientInstallationSettingObject> getSettingComboBox() throws ConsoleException {
        if (this.settingComboBox == null) {
            ClientInstallPoolObject pool = new ClientInstallPoolObject();
            Vector<ClientInstallationSettingObject> allSettings = new Vector<ClientInstallationSettingObject>(pool.getObjectsByPlatform(this.platform));
            this.settingComboBox = new JComboBox<ClientInstallationSettingObject>(allSettings);
            this.settingComboBox.setRenderer(new ToolTipComboBoxRenderer());
            this.settingComboBox.addItemListener(this);
            this.settingComboBox.setPreferredSize(new Dimension(120, this.settingComboBox.getPreferredSize().height));
        }
        return this.settingComboBox;
    }

    private boolean isLinuxPackage(String packagePlatformStr) {
        return "LINUXRPM".equalsIgnoreCase(packagePlatformStr) || "LINUXDPKG".equalsIgnoreCase(packagePlatformStr);
    }

    protected JPanel getSecurityPanel() {
        if (this.securityPanel == null) {
            this.securityPanel = new JPanel(new GridBagLayout());
            this.securityPanel.add((Component)this.jRBManaged, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.securityPanel.add((Component)this.jRBUnManaged, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.securityPanel.add((Component)this.jCbxGroup, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            Dimension preferSize = new Dimension(this.securityPanel.getWidth() - 20, this.groupTree.getHeight());
            this.jSPGroupTree.setPreferredSize(preferSize);
            this.securityPanel.add((Component)this.jSPGroupTree, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
            this.securityPanel.add((Component)this.jCBAutomaticGroup, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.SecuritySetting");
            this.securityPanel.setBorder(BorderFactory.createTitledBorder(title));
        }
        return this.securityPanel;
    }

    public void btnBrowseActionPerformed(ActionEvent e) {
        ExportFolderChooser fc = new ExportFolderChooser();
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            fc.setDialogType(1);
            fc.setSelectedFile(new File("setup.zip"));
            if (0 != fc.showSaveDialog(Manager.getFrame())) {
                return;
            }
        } else if (0 != fc.showOpenDialog(Manager.getFrame())) {
            return;
        }
        if (fc.getSelectedFile() == null) {
            return;
        }
        String path = fc.getSelectedFile().getAbsolutePath();
        AjaxSwingCommonUtil.executeOneBasedOnWebConsoleRunning(() -> {
            this.clientExportZipFilePath = path;
        }, () -> this.jTFDirectory.setText(path));
    }

    protected void exportTypeChanged() {
        this.groupTree.setEnabled(this.isExportToGroups());
        if (!this.isLimitedAdmin) {
            this.jCBAutomaticGroup.setEnabled(this.isExportToGroups() && this.isManaged());
        }
        this.calculatePackageSize();
    }

    private ArrayList<GroupObject> checkHIContentAvailable(List<GroupObject> groups) throws Exception {
        ArrayList<SoftwarePackage> sps = new ArrayList<SoftwarePackage>();
        sps.add(this.currentPackageObj.getSoftwarePackage());
        return LuUtility.checkHIContentAvailable(groups, sps);
    }

    @Override
    protected boolean isValidate() {
        boolean isWindowsPackage;
        try {
            if (this.isExportToGroups()) {
                ArrayList<GroupObject> unAvaliableGroups;
                ArrayList<GroupObject> listGroupObjs = this.getSelectedGroupObjs();
                ArrayList<String> listEmptyGroups = SoftwarePackageHandler.retrieveEmptyDefaultServerListGroups(listGroupObjs);
                if (listEmptyGroups != null && listEmptyGroups.size() > 0) {
                    ListMessageBox msgBox;
                    String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.groupsContainEmptyDefaultServerListsMsg");
                    if (listEmptyGroups.size() == 1) {
                        msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.groupContainsEmptyListMsg");
                    }
                    if (0 != (msgBox = new ListMessageBox(this, 50, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.exportPackageMsg"), msg, 3, 0, listEmptyGroups)).show()) {
                        return false;
                    }
                }
                if (null != (unAvaliableGroups = this.checkHIContentAvailable(listGroupObjs))) {
                    String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.hiContentUnavailableMsg");
                    ListMessageBox msgBox = new ListMessageBox(this, 50, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.exportPackageMsg"), msg, 0, -1, unAvaliableGroups);
                    msgBox.show();
                    for (GroupObject go : unAvaliableGroups) {
                        this.groupTree.setSelected(false, go.getId(), true, true);
                    }
                    return false;
                }
            }
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.consoleError"), 0);
            if (ex.needRelogin()) {
                Manager.getFrame().showLoginPanel();
                this.cancel();
            }
            return false;
        }
        catch (Throwable ex) {
            ConsoleLogger.log(ex);
            return false;
        }
        if (this.isExportToGroups()) {
            ArrayList<String> list = this.getSelectedGroups();
            if ((list == null || list.size() < 1) && this.isManaged()) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.selectAtLeastOneGroupMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.error"), 0);
                return false;
            }
            if (list.size() > 10) {
                Object[] obj = new Object[]{Integer.toString(10)};
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.moreThan0PackagesWillBeExportedMsg");
                String fm = MessageFormat.format(str, obj);
                if (1 == JOptionPane.showConfirmDialog(this, fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.exportPackageMsg"), 0)) {
                    return false;
                }
            }
        }
        ArrayList<GroupObject> listGroups = new ArrayList();
        if (this.isExportToGroups()) {
            listGroups = this.getSelectedGroupObjs();
        }
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> this.jTFDirectory.setText(Utility.getTempDir() + File.separator + Env.getWebConsoleIndex()));
        String dirName = this.getExportDirectory();
        if (dirName == null || dirName.length() < 1) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.exportDirectoryInvalid"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.error"), 0);
            return false;
        }
        AbstractExportPackageValidator validator = ExportPackageWorkerFacotry.getInstance().getExportPackageValidator(this.currentPackageObj.getSoftwarePackageObject());
        String platform = this.currentPackageObj.getSoftwarePackage().getPackageInfo().getOptPlatformType();
        boolean bl = isWindowsPackage = "WIN32BIT".equals(platform) || "WIN64BIT".equals(platform);
        if (isWindowsPackage ? !validator.validateExportDir(dirName, this.isCreateExe(), listGroups, this.getPackageContentOption(), this.hbPkgSizeWithLatestContent, this.lbPkgSizeWithLatestContent, "") : !validator.validateExportDir(dirName, this.isCreateExe(), listGroups, this.getPackageContentOption(), this.getOsForExport())) {
            return false;
        }
        try {
            if ((PackageUtil.isUnInstallEnabled((InstallationOption)this.getInstallationOption()) || PackageUtil.isPreInstallCleanupEnabled((InstallationOption)this.getInstallationOption())) && !this.continueIfCuNotApplicable(this.currentPackageObj.getSoftwarePackageObject())) {
                return false;
            }
        }
        catch (ConsoleException ce) {
            JOptionPane.showMessageDialog(this, ce.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.error"), 0);
            return false;
        }
        return true;
    }

    private boolean continueIfCuNotApplicable(SoftwarePackageObject pkg) {
        if (!PackageUtil.isCuApplicablePackage((SoftwarePackage)pkg.getSoftwarePackage())) {
            return 0 == MultiLineMsgBox.show(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CompetitiveUninstall.warning"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CompetitiveUninstall.notApplicableMsg"), 40, 2, 0);
        }
        return true;
    }

    protected ClientInstallationFeatureObject updateEnabledFeatures(ClientInstallationFeatureObject featureObj) {
        int count;
        ClientInstallationFeatureObject obj = featureObj;
        ClientInstallationFeatures features = obj.getClientInstallationFeatures();
        String version = this.currentPackageObj.getSoftwarePackageObject().getVersion(true);
        EnabledClientFeatures enabledFeature = ClientInstallFeatureSetUtility.findFeatureVersionFromFeatureSet((String)version, (ClientInstallationFeatures)features);
        if (enabledFeature != null && (count = enabledFeature.getClientFeatureCount()) > 0) {
            for (int i = 0; i < count; ++i) {
                ClientFeature cFeature = enabledFeature.getClientFeature(i);
                if (cFeature.getOptEnabled() != null) continue;
                cFeature.setOptEnabled(Boolean.valueOf(true));
            }
        }
        return obj;
    }

    protected void init() throws Exception {
        this.hasGroupAccess = this.groupTree.init(Manager.getCurrentDomainId(), true, false);
        if (this.hasGroupAccess) {
            this.groupTree.addPropertyChangeListener("check", this);
            this.groupTree.expandAll();
            this.groupTree.setEnabled(true);
            this.jSPGroupTree.setVerticalScrollBarPolicy(20);
            this.jSPGroupTree.setHorizontalScrollBarPolicy(30);
        } else {
            this.jSPGroupTree.getViewport().remove(this.groupTree);
            DescriptionTextArea taGroupAccessDenied = new DescriptionTextArea();
            taGroupAccessDenied.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.noGroupYouCanAccessMsg"));
            this.jSPGroupTree.getViewport().add((Component)taGroupAccessDenied, null);
            this.jSPGroupTree.setVerticalScrollBarPolicy(20);
        }
        this.calculatePackageSize();
        if (!ClientInstallationFeatureObject.hasCustomizedFeatures(this.currentPackageObj.getPackageType())) {
            this.getFeatureComboBox().setEnabled(false);
        }
    }

    public ArrayList<String> getSelectedGroups() {
        ArrayList<String> list = new ArrayList<String>();
        this.groupTree.getSelection(list, false, true);
        return list;
    }

    public boolean isExportDefault() {
        return !this.isExportToGroups();
    }

    public boolean isExportToGroups() {
        return this.jCbxGroup.isSelected();
    }

    public boolean isUnmanaged() {
        return this.jRBUnManaged.isSelected();
    }

    public boolean isManaged() {
        return this.jRBManaged.isSelected();
    }

    public boolean isCreateExe() {
        return this.jCbxSingleEXE.isSelected();
    }

    public String getExportDirectory() {
        String dir = this.jTFDirectory.getText().trim();
        if (dir.endsWith(File.separator)) {
            dir = dir.substring(0, dir.length() - 1);
        }
        return dir;
    }

    protected void calculatePackageSize() {
        this.noHbDefsWarningLbl.setVisible(false);
        this.isNoHbDefsWarningShouldBeShown = false;
        this.noLbDefsWarningLbl.setVisible(false);
        this.isNoLbDefsWarningShouldBeShown = false;
        this.isLbGroupUseHbContent = false;
        this.hbPkgSizeWithLatestContent = this.calculateOnePackageSize(false);
        this.lbPkgSizeWithLatestContent = this.calculateOnePackageSize(true);
        long sizeTotal = 0L;
        int groupCount = 0;
        int hbGroupCount = 0;
        int lbGroupCount = 0;
        if (this.hasGroupAccess) {
            if (this.isExportDefault()) {
                hbGroupCount = 1;
            } else {
                ArrayList<GroupObject> list = this.getSelectedGroupObjs();
                if (list != null) {
                    groupCount = list.size();
                    for (GroupObject grpObj : list) {
                        try {
                            if (PolicyUtil.isLowBandwidthEnabled(grpObj, this.version) && !this.isLbGroupUseHbContent) {
                                ++lbGroupCount;
                                continue;
                            }
                            ++hbGroupCount;
                        }
                        catch (Exception ex) {
                            ConsoleLogger.log(ex);
                            ++hbGroupCount;
                        }
                    }
                }
            }
            if (this.isUnmanaged() && groupCount == 0) {
                hbGroupCount = 1;
            }
            if (hbGroupCount > 0 || lbGroupCount > 0) {
                sizeTotal = this.hbPkgSizeWithLatestContent * (long)hbGroupCount + this.lbPkgSizeWithLatestContent * (long)lbGroupCount;
            }
        }
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(2);
        NumberFormat ifm = NumberFormat.getIntegerInstance();
        Object[] obj = new Object[]{ifm.format(groupCount), nf.format((double)sizeTotal / 1048576.0)};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.total0PackagesWillBeExported");
        String fm = MessageFormat.format(str, obj);
        this.jTxtInfo.setLineWrap(true);
        this.jTxtInfo.setEditable(false);
        this.jTxtInfo.setText(fm);
        if (Utilities.isWindowsPackage(this.platform) && this.packageContentOption == 0) {
            if (hbGroupCount > 0 && this.isNoHbDefsWarningShouldBeShown.booleanValue()) {
                this.noHbDefsWarningLbl.setVisible(true);
            }
            if (lbGroupCount > 0 && this.isNoLbDefsWarningShouldBeShown.booleanValue()) {
                this.noLbDefsWarningLbl.setVisible(true);
            }
        }
    }

    protected long calculateOnePackageSize(boolean lowBandwidth) {
        try {
            ClientInstallationSettingObject settings = this.getInstallationSettingObj();
            ClientInstallationFeatureObject ciFeature = this.getInstallationFeatureObj();
            WindowsPackageSizeCalculator pkgCal = new WindowsPackageSizeCalculator();
            long onePackageSize = pkgCal.calculateOnePackageSize(this.currentPackageObj, settings, ciFeature, this.packageContentOption, this.isCreateExe(), lowBandwidth);
            if (lowBandwidth) {
                if (pkgCal.getIsUsingLowBandwidthContent()) {
                    this.isNoLbDefsWarningShouldBeShown = pkgCal.getIsNoDefsWarningShouldBeShown();
                } else {
                    this.isNoHbDefsWarningShouldBeShown = pkgCal.getIsNoDefsWarningShouldBeShown();
                    this.isLbGroupUseHbContent = true;
                }
            } else {
                this.isNoHbDefsWarningShouldBeShown = pkgCal.getIsNoDefsWarningShouldBeShown();
            }
            return onePackageSize;
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.consoleError"), 0);
            if (ex.needRelogin()) {
                Manager.getFrame().showLoginPanel();
                this.cancel();
            }
            return this.currentPackageObj.getSize();
        }
    }

    private void chkSingleEXE_actionPerformed(ActionEvent e) {
        this.calculatePackageSize();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (!e.getPropertyName().equals("check")) {
            return;
        }
        if (this.isExportToGroups()) {
            this.calculatePackageSize();
        }
    }

    public ArrayList<GroupObject> getSelectedGroupObjs() {
        ArrayList<String> listGroupIds = this.getSelectedGroups();
        ArrayList<GroupObject> listGroupObjs = new ArrayList<GroupObject>();
        if (listGroupIds == null || listGroupIds.size() < 1) {
            return listGroupObjs;
        }
        SemClientGroup groupGlobal = null;
        try {
            DataobjectManager data = DataobjectManager.getInstance();
            SemDomain domain = (SemDomain)data.getObjectByGUID("SemDomain", Manager.getCurrentDomainId());
            String groupTreeId = domain.getObjReference().getTargetId();
            SemClientGroupTree tree = (SemClientGroupTree)DataobjectManager.getInstance().getObjectByGUID("SemClientGroupTree", groupTreeId);
            groupGlobal = tree.getSemClientGroup();
        }
        catch (ConsoleException ex) {
            System.out.println("ExportPackageDlg>> getSelectedGroupObjs: Exception while retrieving global group");
            ConsoleLogger.log(ex);
            return listGroupObjs;
        }
        for (int i = 0; i < listGroupIds.size(); ++i) {
            String idGroup = listGroupIds.get(i);
            GroupObject groupObj = null;
            if (groupGlobal.getId().equals(idGroup)) {
                groupObj = new GroupObject(groupGlobal);
            } else {
                try {
                    groupObj = GroupHandler.getGroupById(groupGlobal, idGroup);
                }
                catch (ConsoleException ex) {
                    System.out.println("ExportPackageDlg>> getSelectedGroupObjs: Exception while retrieving group id=" + idGroup);
                    ConsoleLogger.log(ex);
                    return listGroupObjs;
                }
            }
            listGroupObjs.add(groupObj);
        }
        return listGroupObjs;
    }

    private int getAgentMode() {
        if (this.userModeRButton.isSelected()) {
            return 0;
        }
        return 1;
    }

    private ClientInstallationSettingObject getInstallationSettingObj() throws ConsoleException {
        return this.isLinuxPackage(this.platform) ? null : (ClientInstallationSettingObject)this.getSettingComboBox().getSelectedItem();
    }

    private InstallationOption getInstallationOption() throws ConsoleException {
        InstallationOption ret = null;
        ClientInstallationSettingObject obj = this.getInstallationSettingObj();
        if (obj == null) {
            if (this.currentPackageObj != null) {
                ret = this.currentPackageObj.getInstallationOption();
            }
        } else {
            ret = obj.getInstallationOption();
        }
        return ret;
    }

    private boolean retainExistingClientFeatures() {
        return this.maintainExistingFeaturesChkBox.isSelected();
    }

    private ClientInstallationFeatureObject getInstallationFeatureObj() throws ConsoleException {
        return (ClientInstallationFeatureObject)this.getFeatureComboBox().getSelectedItem();
    }

    private boolean isPreferedGroupSet() {
        if (this.isLimitedAdmin) {
            return this.jCBAutomaticGroup.isSelected();
        }
        return this.jCBAutomaticGroup.isEnabled() && this.jCBAutomaticGroup.isSelected();
    }

    public ExportPackageSettings getExportPackageSettings() throws ConsoleException {
        boolean isCreateExe = this.isCreateExe();
        int agentMode = this.getAgentMode();
        String exportDir = this.getExportDirectory();
        ArrayList<String> listGroups = this.getSelectedGroups();
        ClientInstallationSettingObject settingObj = this.getInstallationSettingObj();
        ClientInstallationFeatureObject featureObj = this.getInstallationFeatureObj();
        this.updateEnabledFeatures(featureObj);
        boolean isManaged = this.isManaged();
        boolean isPrefGroupSet = this.isPreferedGroupSet();
        int option = this.getPackageContentOption();
        ExportPackageSettings settings = new ExportPackageSettings(this.currentPackageObj.getSoftwarePackageObject(), exportDir, listGroups, isCreateExe, isManaged, isPrefGroupSet, settingObj, featureObj, false, null, option, this.retainExistingClientFeatures());
        settings.setAgentMode(agentMode);
        settings.setClientExportZipFilePath(this.clientExportZipFilePath);
        return settings;
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1 && this.isExportToGroups()) {
            this.calculatePackageSize();
        }
    }

    protected String getOsForExport() {
        return "";
    }
}

