/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.ui.client.ExportPackageSettings;
import com.sygate.scm.console.ui.client.dlg.ExportNonWindowsPackageDlg;
import com.sygate.scm.console.ui.client.dlg.UpgradeSettingsPanelMac;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ExportMacPackageDlg
extends ExportNonWindowsPackageDlg
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private UpgradeSettingsPanelMac upgradeSettingsPanel;

    public ExportMacPackageDlg(CurrentPackageObject cpo, String title, boolean modal) throws Exception {
        super(cpo, title, modal);
    }

    @Override
    protected void jbInit() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getMainPane(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
    }

    private JPanel getMainPane() {
        this.jDetailPanel.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 15));
        this.jDetailPanel.add((Component)this.getTopPanel(), new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 2, new Insets(5, 0, 0, 40), 0, 0));
        this.upgradeSettingsPanel = new UpgradeSettingsPanelMac(this.isCurrentVersionGreaterOrEqual("12.1.3.0"), true);
        this.jDetailPanel.add((Component)this.upgradeSettingsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(2, 0, 0, 0), 0, 0));
        String packageName = this.currentPackageObj.getSoftwarePackageObject().getClientPackageDisplayStringType();
        this.jDetailPanel.add((Component)this.getSecurityPanel(), new GridBagConstraints(1, 1, 2, 2, 4.0, 4.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        this.jDetailPanel.add((Component)this.getStatusPanel(), new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 2, new Insets(2, 0, 5, 0), 0, 0));
        return this.jDetailPanel;
    }

    private boolean isCurrentVersionGreaterOrEqual(String supportedVersion) {
        boolean result = true;
        String version = (String)this.currentPackageObj.getValueAt(3);
        try {
            if (version != null && version.length() > 0 && supportedVersion != null && supportedVersion.length() > 0 && Utility.compareVersion((String)version, (String)supportedVersion) < 0) {
                result = false;
            }
        }
        catch (Exception e) {
            System.out.println("Exception parsing version in the Mac package: " + version);
            System.out.println("Verifying version in the Mac package against version: " + supportedVersion);
        }
        return result;
    }

    @Override
    protected JPanel getSecurityPanel() {
        if (this.securityPanel == null) {
            this.securityPanel = new JPanel(new GridBagLayout());
            this.securityPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder(this.getString("ExportMacPackageDlg.groupMembership"))));
            this.exportTypeChanged();
            ButtonGroup group = new ButtonGroup();
            group.add(this.jRBUnManaged);
            group.add(this.jRBManaged);
            this.securityPanel.add((Component)this.jRBManaged, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
            this.securityPanel.add((Component)this.jRBUnManaged, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
            this.jSPGroupTree.setPreferredSize(new Dimension(300, this.jSPGroupTree.getPreferredSize().height));
            this.securityPanel.add((Component)this.jSPGroupTree, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 20, 0, 0), 0, 0));
            this.jRBUnManaged.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportMacPackageDlg.this.exportTypeChanged();
                }
            });
            this.jRBManaged.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportMacPackageDlg.this.exportTypeChanged();
                }
            });
        }
        return this.securityPanel;
    }

    private void enableGroupTree(boolean isEnable) {
        if (!isEnable) {
            this.groupTree.setSelectedAll(false, true);
        }
        this.groupTree.setEnabled(isEnable);
        this.calculatePackageSize();
    }

    @Override
    public boolean isExportToGroups() {
        return this.jRBManaged.isSelected();
    }

    @Override
    public ExportPackageSettings getExportPackageSettings() throws ConsoleException {
        String exportDir = this.getExportDirectory();
        ArrayList<String> listGroups = this.getSelectedGroups();
        boolean isManaged = this.isManaged();
        boolean isExportGroupPolicy = this.isExportToGroups();
        return new ExportPackageSettings(this.currentPackageObj.getSoftwarePackageObject(), exportDir, listGroups, super.getPackageContentOption(), isManaged, isExportGroupPolicy, this.upgradeSettingsPanel.isMaintainOldSettings(), true);
    }

    @Override
    protected long calculateOnePackageSize(boolean lowBandwidth) {
        long sizeToConsider = this.currentPackageObj.getSize();
        if (1 == this.getPackageContentOption()) {
            sizeToConsider = this.currentPackageObj.getSoftwarePackageObject().getPkgSizeWithoutDefs();
        }
        return sizeToConsider;
    }

    @Override
    public boolean isManaged() {
        return this.jRBManaged.isSelected();
    }

    @Override
    protected void exportTypeChanged() {
        this.enableGroupTree(this.isManaged());
    }

    @Override
    protected boolean isValidate() {
        if (!super.isValidate()) {
            return false;
        }
        ArrayList<String> list = this.getSelectedGroups();
        if (this.isExportToGroups() && (list == null || list.size() < 1)) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.selectAtLeastOneGroupMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.error"), 0);
            return false;
        }
        return true;
    }

    @Override
    protected String getOsForExport() {
        return ConstantValue.getMacExportPath((String)this.currentPackageObj.getSoftwarePackageObject().getPackageInfo().getVersion());
    }
}

