/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.ui.client.ExportPackageSettings;
import com.sygate.scm.console.ui.client.dlg.ExportNonWindowsPackageDlg;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.PackageUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ExportLinuxPackageDlg
extends ExportNonWindowsPackageDlg
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;

    public ExportLinuxPackageDlg(CurrentPackageObject cpo, String title, boolean modal) throws Exception {
        super(cpo, title, modal);
    }

    @Override
    public ExportPackageSettings getExportPackageSettings() throws ConsoleException {
        String exportDir = super.getExportDirectory();
        ArrayList<String> listGroups = super.getSelectedGroups();
        boolean isManaged = this.isManaged();
        boolean isExportGroupPolicy = super.isExportToGroups();
        return new ExportPackageSettings(this.currentPackageObj.getSoftwarePackageObject(), exportDir, listGroups, super.getPackageContentOption(), isManaged, isExportGroupPolicy, true, false);
    }

    @Override
    public boolean isManaged() {
        return this.jRBManaged.isSelected();
    }

    @Override
    protected boolean isValidate() {
        if (!super.isValidate()) {
            return false;
        }
        ArrayList<String> list = super.getSelectedGroups();
        if (this.isManaged() && super.isExportToGroups() && (list == null || list.size() < 1)) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.selectAtLeastOneGroupMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.error"), 0);
            return false;
        }
        return true;
    }

    @Override
    protected long calculateOnePackageSize(boolean lowBandwidth) {
        long sizeToConsider = this.currentPackageObj.getSize();
        return sizeToConsider;
    }

    @Override
    protected void jbInit() {
        super.getContentPane().setLayout(new BorderLayout());
        super.getContentPane().add((Component)this.getMainPane(), "Center");
        super.getContentPane().add((Component)this.getButtonPanel(), "South");
        super.pack();
    }

    @Override
    protected JPanel getSecurityPanel() {
        if (this.securityPanel == null) {
            this.securityPanel = new JPanel(new GridBagLayout());
            this.securityPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder(this.getString("ExportMacPackageDlg.groupMembership"))));
            this.exportLinuxTypeChanged();
            ButtonGroup group = new ButtonGroup();
            group.add(this.jRBUnManaged);
            group.add(this.jRBManaged);
            if (!PackageUtil.isLinuxStub((String)this.currentPackageObj.getSoftwarePackage().getPackageInfo().getOptPlatformType())) {
                this.securityPanel.add((Component)this.jRBManaged, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
                this.securityPanel.add((Component)this.jRBUnManaged, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
            }
            this.securityPanel.add((Component)this.jCbxGroup, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
            this.jSPGroupTree.setPreferredSize(new Dimension(300, this.jSPGroupTree.getPreferredSize().height));
            this.securityPanel.add((Component)this.jSPGroupTree, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 20, 0, 0), 0, 0));
            this.jRBUnManaged.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportLinuxPackageDlg.this.exportLinuxTypeChanged();
                }
            });
            this.jRBManaged.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportLinuxPackageDlg.this.exportLinuxTypeChanged();
                }
            });
            this.jCbxGroup.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    if (!ExportLinuxPackageDlg.this.jCbxGroup.isSelected()) {
                        ExportLinuxPackageDlg.this.groupTree.setSelectedAll(false, true);
                    }
                    ExportLinuxPackageDlg.this.groupTree.setEnabled(ExportLinuxPackageDlg.this.jCbxGroup.isSelected());
                    ExportLinuxPackageDlg.this.calculatePackageSize();
                }
            });
        }
        return this.securityPanel;
    }

    private void exportLinuxTypeChanged() {
        if (this.isManaged()) {
            this.jCbxGroup.setSelected(true);
            this.jCbxGroup.setEnabled(false);
            this.jSPGroupTree.setEnabled(true);
        } else {
            this.jCbxGroup.setSelected(true);
            this.jCbxGroup.setEnabled(true);
        }
        this.calculatePackageSize();
    }

    private JPanel getMainPane() {
        this.jDetailPanel.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 15));
        this.jDetailPanel.add((Component)this.getTopPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.jDetailPanel.add((Component)this.getSecurityPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        this.jDetailPanel.add((Component)this.getStatusPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 5, 0), 0, 0));
        return this.jDetailPanel;
    }
}

