/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.util.UIText;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class ExportFolderChooser
extends JFileChooser {
    private static final long serialVersionUID = 1L;
    private static MessageResourcesFile res = new MessageResourcesFile("com.sygate.scm.console.ui.client.dlg.clientdialog");

    public ExportFolderChooser() {
        this.initDialog();
    }

    public ExportFolderChooser(String strCurrentDir) {
        super(strCurrentDir);
        this.initDialog();
    }

    private void initDialog() {
        FolderFilter filter = new FolderFilter();
        this.setFileFilter(filter);
        this.setFileSelectionMode(2);
        ((BasicFileChooserUI)this.getUI()).setFileName(this.getCurrentDirectory().getAbsolutePath());
        this.setApproveButtonText(UIText.get(3584));
        this.setDialogTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.browseDlgTitle"));
        this.setAcceptAllFileFilterUsed(false);
        this.putClientProperty("ajaxswing.browseClient", false);
    }

    @Override
    public void setCurrentDirectory(File dir) {
        super.setCurrentDirectory(dir);
        try {
            ((BasicFileChooserUI)this.getUI()).setFileName(this.getCurrentDirectory().getCanonicalPath());
        }
        catch (IOException e) {
            String currentPath = this.getPathForNonSystemFile(this.getCurrentDirectory());
            File currentFile = new File(currentPath);
            if (currentFile.exists()) {
                ((BasicFileChooserUI)this.getUI()).setFileName(currentPath);
            }
            ((BasicFileChooserUI)this.getUI()).setFileName("");
        }
    }

    @Override
    public File getSelectedFile() {
        File selectedFile;
        block3: {
            selectedFile = super.getSelectedFile();
            if (selectedFile != null) {
                try {
                    selectedFile.getCanonicalPath();
                }
                catch (IOException e) {
                    String selectedPath = this.getPathForNonSystemFile(selectedFile);
                    File newSelectedFile = new File(selectedPath);
                    if (!newSelectedFile.exists() || !newSelectedFile.isDirectory()) break block3;
                    selectedFile = newSelectedFile;
                }
            }
        }
        return selectedFile;
    }

    private String getPathForNonSystemFile(File f) {
        String userHome = System.getProperty("user.home");
        String newPath = userHome + File.separator + f.toString().trim();
        return newPath;
    }

    static class FolderFilter
    extends FileFilter {
        FolderFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory();
        }

        @Override
        public String getDescription() {
            return res.getString("ExportFolderChooser.allFolders");
        }
    }
}

