/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.client.dlg.ClientInstallationWizard;
import com.sygate.scm.console.ui.client.dlg.InstallClientWizardDialog;
import com.sygate.scm.console.ui.client.networkaudit.RemotePushComputerObject;
import com.sygate.scm.console.ui.client.networkaudit.RemotePushComputerTableModel;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.renderer.RemotePushComputerRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DeploySummaryPanel
extends ClientInstallationWizard {
    private static final MessageResources MSGRES;
    private static final String CLIENTDIALOG = "com.sygate.scm.console.ui.client.dlg.clientdialog";
    private static final String strDesc;
    private static final String strDescCommunication;
    private static final String strFooterDesc;
    private static final String strFooterDescForCommunication;
    private DescriptionTextArea desc;
    private DescriptionTextArea descFooter;
    private static final float[] colSizes;
    private RemotePushComputerTableModel tblModel;
    private StripesTable jTblComputers;
    private JScrollPane jsp;
    private Action printAction;
    private JButton jBtnPrint;
    private static boolean isSepCommunicationSetting;

    public DeploySummaryPanel(InstallClientWizardDialog wizard, boolean isSMB) {
        super(wizard, isSMB);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.desc = new DescriptionTextArea(strDesc);
        this.descFooter = new DescriptionTextArea(strFooterDesc);
        this.tblModel = new RemotePushComputerTableModel(false);
        this.jTblComputers = new StripesTable(this.tblModel, true, false);
        this.jsp = new JScrollPane((Component)((Object)this.jTblComputers));
    }

    @Override
    protected String getTitleDescription() {
        return MSGRES.getString(CLIENTDIALOG, "DeploySummaryPanel.titleDesc");
    }

    @Override
    protected String getTitle() {
        return MSGRES.getString(CLIENTDIALOG, "DeploySummaryPanel.title");
    }

    @Override
    protected JPanel getCenterPanel() {
        Insets insets = new Insets(0, 5, 0, 5);
        this.desc.setMargin(insets);
        this.descFooter.setMargin(insets);
        this.jsp.setPreferredSize(new Dimension(200, 150));
        super.setUpTableView((JTable)((Object)this.jTblComputers), colSizes);
        TableColumnModel tblColModel = this.jTblComputers.getColumnModel();
        TableColumn colComputerHostName = this.jTblComputers.getColumn(RemotePushComputerTableModel.COMPUTER_HOST_NAME);
        TableColumn colIPAddr = this.jTblComputers.getColumn(RemotePushComputerTableModel.IP_ADDR);
        TableColumn colSWInfo = this.jTblComputers.getColumn(RemotePushComputerTableModel.PROTECTION);
        TableColumn instStatus = this.jTblComputers.getColumn(RemotePushComputerTableModel.PROGRESS);
        tblColModel.removeColumn(colComputerHostName);
        tblColModel.removeColumn(colIPAddr);
        tblColModel.removeColumn(colSWInfo);
        tblColModel.removeColumn(instStatus);
        this.setRenderers();
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new GridBagLayout());
        centerPanel.add((Component)this.getDescPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.3, 18, 1, new Insets(10, 25, 10, 50), 0, 0));
        centerPanel.add((Component)this.jsp, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.5, 17, 1, new Insets(10, 25, 10, 50), 0, 0));
        centerPanel.add((Component)this.getFooterPanel(), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 45, 10, 50), 0, 0));
        centerPanel.add(Box.createGlue(), new GridBagConstraints(0, 6, 1, 1, 1.0, 0.5, 17, 1, new Insets(10, 25, 10, 50), 0, 0));
        return centerPanel;
    }

    private JPanel getDescPanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 10));
        panel.add((Component)this.descFooter, "Center");
        panel.add((Component)this.desc, "South");
        return panel;
    }

    private JPanel getFooterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.printAction = new AbstractAction(MSGRES.getString(CLIENTDIALOG, "DeploySummaryPanel.btnPrint")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DeploySummaryPanel.this.printTable();
            }
        };
        this.jBtnPrint = new JButton(this.printAction);
        AjaxSwingCommonUtil.executeIfWebConsoleIsNotRunning(() -> panel.add((Component)this.jBtnPrint, "East"));
        return panel;
    }

    public void setData(Vector<RemotePushComputerObject> data) {
        if (data != null) {
            int succeededCount = 0;
            this.tblModel.setData(data);
            for (RemotePushComputerObject record : data) {
                if (isSepCommunicationSetting) {
                    if (0 == record.getUpdateCommunicationStatus()) {
                        ++succeededCount;
                        continue;
                    }
                    System.out.println("Failed to updated the communication on : HostName =" + record.getComputerNode().getHostName() + ": Deploy Status = " + record.getInstallStatus() + ": Communication Update Status =" + record.getUpdateCommunicationStatus() + ": Communication Update Status desc =" + record.getCommunicationStatusDesc());
                    continue;
                }
                if (1 == record.getInstallStatus()) {
                    ++succeededCount;
                    continue;
                }
                System.out.println("Failed to deploy the Package on : HostName =" + record.getComputerNode().getHostName() + ": Deploy Status = " + record.getInstallStatus());
            }
            if (isSepCommunicationSetting) {
                this.desc.setText(strDescCommunication + " " + MessageFormat.format(MSGRES.getString(CLIENTDIALOG, "DeploySummaryPanel.summary"), succeededCount, data.size() - succeededCount));
            } else {
                this.desc.setText(strDesc + " " + MessageFormat.format(MSGRES.getString(CLIENTDIALOG, "DeploySummaryPanel.summary"), succeededCount, data.size() - succeededCount));
            }
        }
    }

    private void setRenderers() {
        RemotePushComputerRenderer renderer = new RemotePushComputerRenderer();
        TableColumn colHostName = this.jTblComputers.getColumn(RemotePushComputerTableModel.HOST_NAME);
        colHostName.setCellRenderer(renderer);
        TableColumn colStatus = this.jTblComputers.getColumn(RemotePushComputerTableModel.DEP_STATUS);
        colStatus.setCellRenderer(new DeploymentStatusRenderer());
        TableColumn communicationStatus = this.jTblComputers.getColumn(RemotePushComputerTableModel.UPD_STATUS);
        communicationStatus.setCellRenderer(new DeploymentStatusRenderer());
    }

    private void printTable() {
        try {
            PrinterJob pJob = PrinterJob.getPrinterJob();
            pJob.setPrintable(this.jTblComputers.getPrintable(JTable.PrintMode.FIT_WIDTH, new MessageFormat(""), new MessageFormat("")));
            if (pJob.printDialog()) {
                pJob.print();
                JOptionPane.showMessageDialog(this.getWizardStagePanel(), MSGRES.getString(CLIENTDIALOG, "DeploySummaryPanel.printingComplete"), MSGRES.getString(CLIENTDIALOG, "DeploySummaryPanel.printingResult"), 1);
            }
        }
        catch (PrinterException pe) {
            String errorMessage = MessageFormat.format(MSGRES.getString(CLIENTDIALOG, "DeploySummaryPanel.printingFailed"), pe.getMessage());
            JOptionPane.showMessageDialog(this.getWizardStagePanel(), errorMessage, MSGRES.getString(CLIENTDIALOG, "DeploySummaryPanel.printingResult"), 0);
        }
    }

    public void updateUIForPackageDeployment() {
        DeploySummaryPanel.setSepCommunicationSetting(false);
        TableColumnModel tblColModel = this.jTblComputers.getColumnModel();
        TableColumn updStatus = this.jTblComputers.getColumn(RemotePushComputerTableModel.UPD_STATUS);
        tblColModel.removeColumn(updStatus);
    }

    public void updateUIForCommunicationSettings() {
        DeploySummaryPanel.setSepCommunicationSetting(true);
        this.descFooter.setText(strFooterDescForCommunication);
        this.desc.setText(strDescCommunication);
    }

    private static void setSepCommunicationSetting(boolean setting) {
        isSepCommunicationSetting = setting;
    }

    static {
        Object[] objectArray;
        Object[] objectArray2;
        MSGRES = MessageResources.getInstance();
        strDesc = MSGRES.getString(CLIENTDIALOG, "DeploySummaryPanel.description");
        strDescCommunication = MSGRES.getString(CLIENTDIALOG, "DeploySummaryPanel.descriptionCommunication");
        String string = MSGRES.getString(CLIENTDIALOG, "DeploySummaryPanel.lblFooterNote");
        if (LicenseObject.getInstance().isSEPSBProduct()) {
            Object[] objectArray3 = new Object[1];
            objectArray2 = objectArray3;
            objectArray3[0] = MSGRES.getString(CLIENTDIALOG, "DeploySummaryPanel.ComputerTab");
        } else {
            Object[] objectArray4 = new Object[1];
            objectArray2 = objectArray4;
            objectArray4[0] = MSGRES.getString(CLIENTDIALOG, "DeploySummaryPanel.ClientTab");
        }
        strFooterDesc = MessageFormat.format(string, objectArray2);
        String string2 = MSGRES.getString(CLIENTDIALOG, "DeploySummaryPanel.lblFooterNoteCommunication");
        if (LicenseObject.getInstance().isSEPSBProduct()) {
            Object[] objectArray5 = new Object[1];
            objectArray = objectArray5;
            objectArray5[0] = MSGRES.getString(CLIENTDIALOG, "DeploySummaryPanel.ComputerTab");
        } else {
            Object[] objectArray6 = new Object[1];
            objectArray = objectArray6;
            objectArray6[0] = MSGRES.getString(CLIENTDIALOG, "DeploySummaryPanel.ClientTab");
        }
        strFooterDescForCommunication = MessageFormat.format(string2, objectArray);
        colSizes = new float[]{0.3f, 0.3f, 0.05f, 0.15f, 0.2f};
        isSepCommunicationSetting = false;
    }

    private static class DeploymentStatusRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int updStatus;
            TableColumnModel tblColModel = table.getColumnModel();
            JLabel renderer = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int idxStatus = tblColModel.getColumnIndex(RemotePushComputerTableModel.DEP_STATUS);
            if (column == idxStatus) {
                int status = (Integer)value;
                switch (status) {
                    case 1: {
                        renderer.setText(MSGRES.getString(DeploySummaryPanel.CLIENTDIALOG, "DeploySummaryPanel.success"));
                        break;
                    }
                    default: {
                        renderer.setText(MSGRES.getString(DeploySummaryPanel.CLIENTDIALOG, "DeploySummaryPanel.failed"));
                    }
                }
            }
            if (isSepCommunicationSetting && column == (updStatus = tblColModel.getColumnIndex(RemotePushComputerTableModel.UPD_STATUS))) {
                int status = (Integer)value;
                switch (status) {
                    case 0: {
                        renderer.setText(MSGRES.getString(DeploySummaryPanel.CLIENTDIALOG, "DeploySummaryPanel.success"));
                        break;
                    }
                    default: {
                        renderer.setText(MSGRES.getString(DeploySummaryPanel.CLIENTDIALOG, "DeploySummaryPanel.failed"));
                    }
                }
            }
            renderer.setHorizontalAlignment(2);
            return renderer;
        }
    }
}

