/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.client.dlg.ClientInstallationWizard;
import com.sygate.scm.console.ui.client.dlg.InstallClientWizardDialog;
import com.sygate.scm.console.ui.client.networkaudit.NetworkAuditObject;
import com.sygate.scm.console.ui.client.networkaudit.NetworkAuditSearchListener;
import com.sygate.scm.console.ui.client.networkaudit.RemotePushComputerObject;
import com.sygate.scm.console.ui.client.networkaudit.RemotePushComputerTableModel;
import com.sygate.scm.console.ui.client.networkaudit.RemotePushInstallClientThread;
import com.sygate.scm.console.ui.client.wizard.DeployStatusTableCellRenderer;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.SwingWorkerExecutor;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.KeepAlive;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Random;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DeployProgressPanel
extends ClientInstallationWizard
implements PropertyChangeListener {
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENTDIALOG = "com.sygate.scm.console.ui.client.dlg.clientdialog";
    private DescriptionTextArea desc;
    private RemotePushInstallClientThread installThread;
    private Vector<RemotePushComputerObject> vData;
    private static final String progressString = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployProgressPanel.progressLabel");
    private DescriptionTextArea descProgress;
    private JProgressBar totalProgress;
    private DeployMonitor task;
    private boolean deploymentDone;
    private int finishedNodes;
    private RemotePushComputerTableModel tblModel;
    private JTable jTblComputers;
    private JScrollPane jsp;
    private static final float[] colSizes = new float[]{0.4f, 0.3f, 0.3f};

    public DeployProgressPanel(InstallClientWizardDialog parent, boolean isSMB) {
        super(parent, isSMB);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.desc = new DescriptionTextArea(MSGRES.getString(CLIENTDIALOG, "DeployProgressPanel.description"));
        this.descProgress = new DescriptionTextArea(progressString);
        this.deploymentDone = false;
        this.finishedNodes = 0;
        this.tblModel = new RemotePushComputerTableModel(true);
        this.jTblComputers = new StripesTable(this.tblModel);
        this.jsp = new JScrollPane(this.jTblComputers);
    }

    @Override
    protected String getTitleDescription() {
        return MSGRES.getString(CLIENTDIALOG, "DeployProgressPanel.titleDesc");
    }

    @Override
    protected String getTitle() {
        return MSGRES.getString(CLIENTDIALOG, "DeployProgressPanel.title");
    }

    @Override
    protected JPanel getCenterPanel() {
        this.desc.setMargin(new Insets(0, 5, 0, 5));
        this.totalProgress = new JProgressBar(0, 100);
        this.totalProgress.setValue(0);
        this.totalProgress.setStringPainted(true);
        this.totalProgress.addPropertyChangeListener(this);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new GridBagLayout());
        this.jsp.setPreferredSize(new Dimension(200, 150));
        super.setUpTableView(this.jTblComputers, colSizes);
        TableColumnModel tblColModel = this.jTblComputers.getColumnModel();
        TableColumn colComputerHostName = this.jTblComputers.getColumn(RemotePushComputerTableModel.COMPUTER_HOST_NAME);
        TableColumn colIPAddr = this.jTblComputers.getColumn(RemotePushComputerTableModel.IP_ADDR);
        TableColumn colSWInfo = this.jTblComputers.getColumn(RemotePushComputerTableModel.PROTECTION);
        TableColumn instStatus = this.jTblComputers.getColumn(RemotePushComputerTableModel.DEP_STATUS);
        TableColumn updStatus = this.jTblComputers.getColumn(RemotePushComputerTableModel.UPD_STATUS);
        tblColModel.removeColumn(colComputerHostName);
        tblColModel.removeColumn(colIPAddr);
        tblColModel.removeColumn(colSWInfo);
        tblColModel.removeColumn(instStatus);
        tblColModel.removeColumn(updStatus);
        this.setRenderers();
        int y = 0;
        centerPanel.add((Component)this.getDescPanel(), new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 10, 2, insertToLogo, 0, 0));
        centerPanel.add((Component)this.descProgress, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 25, 10, 100), 0, 0));
        centerPanel.add((Component)this.totalProgress, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 25, 10, 50), 0, 0));
        centerPanel.add((Component)this.jsp, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 25, 10, 50), 0, 0));
        centerPanel.add(Box.createGlue(), new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return centerPanel;
    }

    private JPanel getDescPanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 20));
        panel.add((Component)this.desc, "Center");
        return panel;
    }

    public void cancel() {
        if (this.installThread != null) {
            this.installThread.cancel();
        }
    }

    public void sendRequest(String pkgId, Vector<RemotePushComputerObject> data, String strGroupId, String strClientFeatures, int option, String settingsName, int mode, boolean addCompUninstall, boolean addPreInstallCleanup, boolean keepPreviousSettingsMac, boolean isMac1015OrUp, String knownHostsFile, boolean reducedSize, boolean darkNetwork, boolean lowBandwidthEnabled) throws ConsoleException {
        this.installThread = new RemotePushInstallClientThread(pkgId, data, strGroupId, strClientFeatures, new PushInstallListener(), this.getWizard().getLatestPackages(), this.getWizard().getSelectedPackage(), option, null, null, settingsName, mode, keepPreviousSettingsMac, isMac1015OrUp, knownHostsFile, reducedSize, darkNetwork, lowBandwidthEnabled);
        this.installThread.start();
        this.monitorDeploymentProgress();
    }

    public Vector<RemotePushComputerObject> getData() {
        return this.vData;
    }

    public void sendRequest(String selectedPackageId, Vector<RemotePushComputerObject> data, String strGroupId, String strClientFeatures, int option, String savedFilePath, String savedFileName, int policyMode, boolean addCompUninstall, boolean addPreInstallCleanup, boolean keepPreviousSettingsMac, boolean isMac1015OrUp, String knownHostsFile, boolean reducedSize, boolean darkNetwork, boolean lowBandwidthEnabled) {
        this.installThread = new RemotePushInstallClientThread(selectedPackageId, data, strGroupId, strClientFeatures, new PushInstallListener(), this.getWizard().getLatestPackages(), this.getWizard().getSelectedPackage(), option, savedFilePath, savedFileName, null, policyMode, keepPreviousSettingsMac, isMac1015OrUp, knownHostsFile, reducedSize, darkNetwork, lowBandwidthEnabled);
        this.installThread.start();
        this.monitorDeploymentProgress();
    }

    public void sendRequestForSepCommunicationUpdater(Vector<RemotePushComputerObject> data, String groupId, int agentMode, boolean isMac, String knownHostsFile) {
        this.installThread = new RemotePushInstallClientThread(data, groupId, agentMode, new PushInstallListener(), isMac, knownHostsFile);
        this.installThread.start();
        this.monitorDeploymentProgress();
    }

    public void setData(Vector<RemotePushComputerObject> data) {
        if (this.vData == null) {
            this.vData = new Vector();
        }
        if (data == null || data.size() < 1) {
            return;
        }
        this.vData = data;
        this.tblModel.setData(this.vData);
        this.tblModel.fireTableDataChanged();
        this.updateDescProgress(0);
    }

    private void setRenderers() {
        TableColumn colStatus = this.jTblComputers.getColumn(RemotePushComputerTableModel.PROGRESS);
        colStatus.setCellRenderer(new DeployStatusTableCellRenderer());
    }

    public boolean monitorDeploymentProgress() {
        this.getWizard().enableNetxButton(false);
        this.totalProgress.setIndeterminate(true);
        this.task = new DeployMonitor();
        this.task.addPropertyChangeListener(this);
        SwingWorkerExecutor.getInstance().execute(this.task);
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            Integer value = (Integer)evt.getNewValue();
            this.totalProgress.setIndeterminate(false);
            this.totalProgress.setValue(value);
            this.updateDescProgress(value);
        }
    }

    public void setDeploymentDone(boolean deploymentDone) {
        this.deploymentDone = deploymentDone;
    }

    public boolean isDeploymentDone() {
        return this.deploymentDone;
    }

    public void updateFinishedNodesCount() {
        this.finishedNodes = this.getFinishedNodes();
    }

    public void updateNodesStatus() {
        this.tblModel.fireTableDataChanged();
    }

    public int getFinishedNodes() {
        int count = 0;
        for (RemotePushComputerObject entry : this.vData) {
            if (entry == null || entry.getInstallStatus() != 1) continue;
            ++count;
        }
        return count;
    }

    public int getTotalNodes() {
        if (this.vData == null) {
            return 0;
        }
        return this.vData.size();
    }

    public void updateDescProgress(int progress) {
        int total = this.getTotalNodes();
        String text = MessageFormat.format(progressString, progress, this.finishedNodes, total);
        this.descProgress.setText(text);
    }

    class DeployMonitor
    extends SwingWorker<Boolean, Void> {
        DeployMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean doInBackground() {
            KeepAlive.suspend();
            try {
                Random random = new Random();
                int progress = 0;
                this.setProgress(0);
                try {
                    Thread.sleep(random.nextInt(1000));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                while (progress < 100 && !DeployProgressPanel.this.isDeploymentDone()) {
                    progress = this.calcaulateProgress();
                    this.setProgress(Math.min(progress, 100));
                    DeployProgressPanel.this.updateNodesStatus();
                    try {
                        Thread.sleep(random.nextInt(1000));
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Boolean bl = true;
                return bl;
            }
            finally {
                KeepAlive.resume();
            }
        }

        private int calcaulateProgress() {
            float percent = 0.0f;
            int count = DeployProgressPanel.this.getTotalNodes();
            for (int i = 0; i < count; ++i) {
                int progress = DeployProgressPanel.this.vData.elementAt(i).getProgress();
                if (progress >= 100) {
                    progress = 100;
                }
                percent += (float)progress;
            }
            if (count > 0) {
                percent /= (float)count;
            }
            return (int)percent;
        }

        @Override
        public void done() {
            DeployProgressPanel.this.setDeploymentDone(true);
        }
    }

    private class PushInstallListener
    implements NetworkAuditSearchListener {
        private PushInstallListener() {
        }

        @Override
        public void entryFound(NetworkAuditObject obj) {
        }

        @Override
        public void stateChanged(int state) {
            if (state == 1) {
                DeployProgressPanel.this.getWizard().setCursor(Cursor.getPredefinedCursor(3));
            } else if (state == 4) {
                DeployProgressPanel.this.updateFinishedNodesCount();
            } else if (state == 5) {
                DeployProgressPanel.this.desc.setText(MSGRES.getString(DeployProgressPanel.CLIENTDIALOG, "DeployProgressPanel.descriptionDone"));
                DeployProgressPanel.this.getWizard().enableNetxButton(true);
                DeployProgressPanel.this.getWizard().setCursor(Cursor.getDefaultCursor());
                DeployProgressPanel.this.setDeploymentDone(true);
                DeployProgressPanel.this.getWizard().doNextClicked();
            } else if (state == 2) {
                DeployProgressPanel.this.desc.setText(MSGRES.getString(DeployProgressPanel.CLIENTDIALOG, "DeployProgressPanel.descriptionDone"));
                DeployProgressPanel.this.getWizard().enableNetxButton(true);
                DeployProgressPanel.this.getWizard().setCursor(Cursor.getDefaultCursor());
                DeployProgressPanel.this.setDeploymentDone(true);
                DeployProgressPanel.this.getWizard().doNextClicked();
            }
        }
    }
}

