/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.configobject.schema.AutoUpgradeContentOption;
import com.sygate.scm.common.configobject.schema.ClientInstallationFeatures;
import com.sygate.scm.common.configobject.schema.DeploymentNotification;
import com.sygate.scm.common.configobject.schema.DeploymentSchedule;
import com.sygate.scm.common.configobject.schema.DeploymentSnooze;
import com.sygate.scm.common.configobject.schema.SoftwareDeploymentEntity;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.SecurityFixContentInfoObject;
import com.sygate.scm.console.logicobject.SoftwareDeploymentEntityObject;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationSettingObject;
import com.sygate.scm.console.ui.client.dlg.DeployConfigGeneralPanel;
import com.sygate.scm.console.ui.client.dlg.DeployConfigNotificationPanel;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JTabbedPane;

public class DeployConfigurationDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final String AUTOMATION_BUTTON_OK = "ButtonOK";
    private DeployConfigGeneralPanel panelGeneral;
    private DeployConfigNotificationPanel panelNotification = new DeployConfigNotificationPanel();
    private JTabbedPane tabbedPane;
    private boolean newOptionOnly = false;
    private String platformType = null;
    private boolean usingSBEPackage = false;

    public DeployConfigurationDlg(int packageType, ClientInstallationFeatures cif, DeploymentSchedule deploymentSchedule, boolean forceDeployment, boolean autoUpgradeToEnglish, DeploymentNotification deploymentNotification, DeploymentSnooze deploymentSnooze, ClientInstallationSettingObject cisObj, boolean isSBEPackage, String packagePlatform, AutoUpgradeContentOption contentOption, SoftwarePackageObject spo) throws ConsoleException {
        super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigurationDlg.newUpdateConfigurationTitle"), true);
        this.newOptionOnly = true;
        this.platformType = packagePlatform;
        this.setUsingSBEPackage(isSBEPackage);
        this.initialize();
        this.initData(packageType, cif, deploymentSchedule, forceDeployment, autoUpgradeToEnglish, deploymentNotification, deploymentSnooze, cisObj, isSBEPackage, this.platformType, contentOption, spo);
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public DeployConfigurationDlg(ArrayList<CurrentPackageObject> listSoftwarePackages, GroupObject groupObj) throws ConsoleException {
        super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigurationDlg.newUpdateConfigurationTitle"), true);
        this.initialize();
        this.initData(listSoftwarePackages, groupObj);
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public DeployConfigurationDlg(SoftwareDeploymentEntityObject entityObj, GroupObject groupObj) throws ConsoleException {
        super(Manager.getFrame(), "", true);
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigurationDlg.deployingConfigForTitle");
        super.setTitle(str);
        this.initialize();
        this.initData(entityObj, groupObj);
        if (groupObj.getAccessConstraint() == 2 || !AdminPrivilegeObject.isCurrentAdminHasFullAccessPackagePrivilege()) {
            this.setReadOnly();
        }
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public SoftwareDeploymentEntity getDuplicatedEntity() {
        return this.panelGeneral.getDuplicatedEntity();
    }

    public void modifyExistingEntity(SoftwareDeploymentEntityObject entityObj) throws ConsoleException {
        this.panelGeneral.modifyExistingEntity(entityObj);
        this.panelNotification.modifyExistingEntity(entityObj);
    }

    public SoftwareDeploymentEntity generateNewEntity() throws ConsoleException {
        SoftwareDeploymentEntityObject entityObj = this.panelGeneral.generateNewEntity();
        this.panelNotification.modifyExistingEntity(entityObj);
        return entityObj.getSoftwareDeploymentEntity();
    }

    public SecurityFixContentInfoObject getSecurityFixContentInfoObject() {
        return this.panelGeneral.getSecurityFixContentInfoObject();
    }

    public DeploymentSchedule generateDeploymentSchedule() {
        return this.panelGeneral.generateDeploymentSchedule();
    }

    public AutoUpgradeContentOption generateAutoUpgradeContentOption() {
        return this.panelGeneral.generateAutoUpgradeContentOption();
    }

    public boolean isForceDeployment() {
        return this.panelGeneral.isForceDeployment();
    }

    public boolean isAutoUpgradeToEnglish() {
        return this.panelGeneral.isAutoUpgradeToEnglish();
    }

    public ClientInstallationFeatures getClientFeatureObject() {
        return this.panelGeneral.getClientInstallationFeatureObject();
    }

    public ClientInstallationSettingObject getClientInstallSettings() {
        return this.panelGeneral.getSelectedInstallSettings();
    }

    public DeploymentNotification generateDeploymentNotification() {
        return this.panelNotification.generateDeploymentNotification();
    }

    public DeploymentSnooze generateDeploymentSnooze() {
        return this.panelNotification.generateDeploymentSnooze();
    }

    @Override
    protected boolean isValidate() {
        if (!this.panelGeneral.isValidate()) {
            return false;
        }
        return this.panelNotification.isValidate();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return ((ContentSensitiveHelpPage)((Object)this.tabbedPane.getSelectedComponent())).getContentSensitiveHelpToken();
    }

    private void initialize() {
        UIUtilities.setName(this.jBOk, "clientPage", UIUtilities.ComponentType.BUTTON, AUTOMATION_BUTTON_OK);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getConfigPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
    }

    private JTabbedPane getConfigPanel() {
        this.tabbedPane = new JTabbedPane();
        this.panelGeneral = new DeployConfigGeneralPanel(this.newOptionOnly, this.platformType);
        this.tabbedPane.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigurationDlg.generalTab"), this.panelGeneral);
        this.tabbedPane.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigurationDlg.notificationTab"), this.panelNotification);
        return this.tabbedPane;
    }

    private void initData(int packageType, ClientInstallationFeatures cif, DeploymentSchedule deploymentSchedule, boolean forceDeployment, boolean autoUpgradeToEnglish, DeploymentNotification deploymentNotification, DeploymentSnooze deploymentSnooze, ClientInstallationSettingObject cisObj, boolean isSBEPackage, String packagePlatform, AutoUpgradeContentOption contentOption, SoftwarePackageObject spo) throws ConsoleException {
        this.panelGeneral.initData(packageType, cif, deploymentSchedule, forceDeployment, autoUpgradeToEnglish, cisObj, isSBEPackage, packagePlatform, contentOption, spo, null);
        this.panelNotification.initData(deploymentNotification, deploymentSnooze);
        this.pack();
    }

    private void initData(ArrayList<CurrentPackageObject> listSoftwarePackages, GroupObject groupObj) throws ConsoleException {
        this.panelGeneral.initData(listSoftwarePackages, groupObj);
        this.panelNotification.initData(listSoftwarePackages, groupObj);
        this.pack();
    }

    private void initData(SoftwareDeploymentEntityObject entityObj, GroupObject groupObj) throws ConsoleException {
        this.panelGeneral.initData(entityObj, groupObj);
        this.panelNotification.initData(entityObj, groupObj);
        this.pack();
    }

    private void setReadOnly() {
        this.panelGeneral.setReadOnly();
        this.panelNotification.setReadOnly();
        this.jBOk.setEnabled(false);
    }

    public void setUsingSBEPackage(boolean usingSBEPackage) {
        this.usingSBEPackage = usingSBEPackage;
    }

    public boolean isUsingSBEPackage() {
        return this.usingSBEPackage;
    }
}

