/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.configobject.schema.DeploymentNotification;
import com.sygate.scm.common.configobject.schema.DeploymentNotificationBeforeUpdate;
import com.sygate.scm.common.configobject.schema.DeploymentSnooze;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.SoftwareDeploymentEntityObject;
import com.sygate.scm.console.ui.util.CreateOSLabelUtil;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.JPanelWithIconBorder;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class DeployConfigNotificationPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static final String[] SNOOZE_TIME_STR = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.30minutes"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.1hour"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.2hours"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.4hours"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.8hours"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.1day"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.2days"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.4days"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.1week")};
    private static final int[] SNOOZE_TIME_IN_MINS = new int[]{30, 60, 120, 240, 480, 1440, 2880, 5760, 10080};
    private JTextArea jLInfo = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.youCanCustomizeSettingsCkbox"), 2, 20);
    private JPanel panelNotification = null;
    private JCheckBox jCbxNotification = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.notifyAgentUserCkbox"));
    private String defaultMessage = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.specifyNotificationMessageTxt");
    private String deployMessage = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.deployNotificationMessageTxt");
    private JLabel jLPopupMsg = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.notificationMessageLabel"));
    private JTextArea jTPopupMsg = new JTextArea(4, 20);
    private JPanel panelSnooze = null;
    private JCheckBox jCbxSnooze = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.allowAgentToPostponeUpgradeCkbox"));
    private JTextArea jLInfoSnooze = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.agentMayPostponeAutoupgradeProcessTxt"), 3, 20);
    private JLabel jLTimeMin = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.minimumTimeLabel"));
    private JComboBox<String> jCbTimeMin = new JComboBox<String>(SNOOZE_TIME_STR);
    private JLabel jLTimeMax = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.MaximumTimeLabel"));
    private JComboBox<String> jCbTimeMax = new JComboBox<String>(SNOOZE_TIME_STR);
    private JButton jBUseDefault = null;

    public DeployConfigNotificationPanel() {
        this.jbInit();
    }

    public DeploymentNotification generateDeploymentNotification() {
        boolean enabled = this.isNotificationEnabled();
        DeploymentNotification notification = new DeploymentNotification();
        if (!enabled) {
            notification.setOptEnable(Boolean.valueOf(false));
            return notification;
        }
        notification.setOptEnable(Boolean.valueOf(true));
        DeploymentNotificationBeforeUpdate update = new DeploymentNotificationBeforeUpdate();
        update.setOptEnable(Boolean.valueOf(true));
        String text = this.getNotificationText();
        if (text == null || text.length() < 1) {
            update.setOptAdditionalText("");
        } else {
            update.setOptAdditionalText(text);
        }
        notification.setOptDeploymentNotificationBeforeUpdate(update);
        return notification;
    }

    public DeploymentSnooze generateDeploymentSnooze() {
        boolean enabled = this.isSnoozeEnabled();
        int minTimeInSecs = this.getSnoozeMinTimeInSecs();
        int maxTimeInSecs = this.getSnoozeMaxTimeInSecs();
        DeploymentSnooze snooze = new DeploymentSnooze();
        snooze.setOptEnable(Boolean.valueOf(enabled));
        snooze.setMinimumTime(Integer.valueOf(minTimeInSecs));
        snooze.setOptMaximumTime(Integer.valueOf(maxTimeInSecs));
        return snooze;
    }

    public void modifyExistingEntity(SoftwareDeploymentEntityObject entityObj) {
        entityObj.setNotification(this.isNotificationEnabled(), this.getNotificationText());
        entityObj.setSnooze(this.isSnoozeEnabled(), this.getSnoozeMinTimeInSecs(), this.getSnoozeMaxTimeInSecs());
    }

    public boolean isNotificationEnabled() {
        return this.jCbxNotification.isSelected();
    }

    public String getNotificationText() {
        return this.jTPopupMsg.getText().trim();
    }

    public boolean isSnoozeEnabled() {
        return this.jCbxSnooze.isSelected();
    }

    public int getSnoozeMinTimeInSecs() {
        return SNOOZE_TIME_IN_MINS[this.jCbTimeMin.getSelectedIndex()] * 60;
    }

    public int getSnoozeMaxTimeInSecs() {
        return SNOOZE_TIME_IN_MINS[this.jCbTimeMax.getSelectedIndex()] * 60;
    }

    public String getSnoozeMaxTimeInString() {
        return this.jCbTimeMax.getSelectedItem().toString();
    }

    public String getSnoozeMinTimeInString() {
        return this.jCbTimeMin.getSelectedItem().toString();
    }

    public boolean isValidate() {
        try {
            if (this.isNotificationEnabled() && this.isSnoozeEnabled() && this.getSnoozeMinTimeInSecs() >= this.getSnoozeMaxTimeInSecs()) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.MaxTimeShouldBeLargerThanMinimumTimeMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.consoleError"), 0);
                return false;
            }
            String text = this.getNotificationText();
            int lines = 1;
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c != '\n') continue;
                ++lines;
            }
            Object[] obj = new Object[]{Integer.toString(2)};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.notificationMessageLimitedToMsg");
            String fm = MessageFormat.format(str, obj);
            if (lines > 2) {
                JOptionPane.showMessageDialog(this, fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.consoleError"), 0);
                return false;
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return true;
    }

    public void setReadOnly() {
        this.jCbxNotification.setEnabled(false);
        this.jCbxSnooze.setEnabled(false);
        this.jCbTimeMin.setEnabled(false);
        this.jCbTimeMax.setEnabled(false);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_install_packages_wizard_assign_package_advanced_settings_notification";
    }

    private void jbInit() {
        this.jCbxNotification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeployConfigNotificationPanel.this.enableNotificationPanel();
            }
        });
        ArrayList<JLabel> iconLabelList = new ArrayList<JLabel>();
        iconLabelList.add(CreateOSLabelUtil.createWinLabel());
        JPanelWithIconBorder panel = new JPanelWithIconBorder("", iconLabelList);
        panel.setLayout(new GridBagLayout());
        panel.add((Component)this.jLInfo, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 5), 0, 0));
        panel.add((Component)this.jCbxNotification, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 12, 0, 0), 0, 0));
        panel.add((Component)this.getNotificationPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 5, 5, 5), 0, 0));
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane(panel));
    }

    private JPanel getNotificationPanel() {
        RestrictedPlainDocument contactListDoc = new RestrictedPlainDocument(128);
        this.jTPopupMsg.setDocument(contactListDoc);
        JScrollPane jScrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)jScrollPane, (JTextArea)this.jTPopupMsg);
        this.jTPopupMsg.setLineWrap(true);
        this.jTPopupMsg.setWrapStyleWord(true);
        this.jBUseDefault = new JButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.useDefault"));
        this.jBUseDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DeployConfigNotificationPanel.this.deployMessage.length() > 128) {
                    JOptionPane.showMessageDialog(DeployConfigNotificationPanel.this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.defaultMessageExceedLength"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigNotificationPanel.informationMsg"), 1);
                    DeployConfigNotificationPanel.this.jTPopupMsg.setText(DeployConfigNotificationPanel.this.deployMessage.substring(0, 128));
                } else {
                    DeployConfigNotificationPanel.this.jTPopupMsg.setText(DeployConfigNotificationPanel.this.deployMessage);
                }
                AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
                    ClientAgent agent = ClientAgent.getCurrentInstance();
                    agent.getHTMLPage().setComponentDirty((Component)DeployConfigNotificationPanel.this.jTPopupMsg, true);
                });
            }
        });
        this.jTPopupMsg.setText(this.defaultMessage);
        this.panelNotification = new JPanel();
        this.panelNotification.setBorder(new TitledBorder(BorderFactory.createTitledBorder(" ")));
        this.panelNotification.setLayout(new GridBagLayout());
        this.panelNotification.add((Component)this.jLPopupMsg, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        this.panelNotification.add((Component)this.jBUseDefault, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.panelNotification.add((Component)jScrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.jCbxSnooze.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeployConfigNotificationPanel.this.snoozeChanged();
            }
        });
        this.panelNotification.add((Component)this.jCbxSnooze, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 12, 0, 0), 0, 0));
        this.panelNotification.add((Component)this.getSnoozePanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 5, 5, 5), 0, 0));
        return this.panelNotification;
    }

    private JPanel getSnoozePanel() {
        this.panelSnooze = new JPanel();
        this.panelSnooze.setBorder(new TitledBorder(BorderFactory.createTitledBorder(" ")));
        this.panelSnooze.setLayout(new GridBagLayout());
        this.panelSnooze.add((Component)this.jLInfoSnooze, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 2, new Insets(15, 5, 0, 5), 0, 0));
        this.panelSnooze.add(this.jCbTimeMin, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.panelSnooze.add(this.jCbTimeMax, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.panelSnooze.add((Component)this.jLTimeMin, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        this.panelSnooze.add((Component)this.jLTimeMax, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.jLTimeMin.setLabelFor(this.jCbTimeMin);
        this.jLTimeMax.setLabelFor(this.jCbTimeMax);
        this.panelSnooze.add((Component)new JPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return this.panelSnooze;
    }

    private void snoozeChanged() {
        boolean isEnabled = this.jCbxSnooze.isSelected() && this.jCbxSnooze.isEnabled();
        this.jCbTimeMin.setEnabled(isEnabled);
        this.jCbTimeMax.setEnabled(isEnabled);
    }

    private void enableNotificationPanel() {
        boolean isEnabled = this.jCbxNotification.isSelected();
        this.jBUseDefault.setEnabled(isEnabled);
        this.jTPopupMsg.setEnabled(isEnabled);
        this.jCbxSnooze.setEnabled(isEnabled);
        this.snoozeChanged();
    }

    public void initData(ArrayList<CurrentPackageObject> listSoftwarePackages, GroupObject groupObj) {
        this.jCbTimeMax.setSelectedIndex(5);
        this.enableNotificationPanel();
    }

    public void initData(DeploymentNotification deploymentNotification, DeploymentSnooze deploymentSnooze) {
        if (deploymentNotification != null) {
            this.jCbxNotification.setSelected(SoftwareDeploymentEntityObject.isNotificationEnabled(deploymentNotification));
            this.jTPopupMsg.setText(SoftwareDeploymentEntityObject.getNotificationText(deploymentNotification));
            String depNotText = SoftwareDeploymentEntityObject.getNotificationText(deploymentNotification);
            if (depNotText == null || depNotText.trim().length() == 0) {
                this.jTPopupMsg.setText(this.defaultMessage);
            } else {
                this.jTPopupMsg.setText(depNotText);
            }
        }
        if (deploymentSnooze == null) {
            this.jCbTimeMax.setSelectedIndex(5);
        } else {
            int i;
            this.jCbxSnooze.setSelected(SoftwareDeploymentEntityObject.isSnoozeEnabled(deploymentSnooze));
            int time = SoftwareDeploymentEntityObject.getSnoozeMinTimeInSecs(deploymentSnooze) / 60;
            for (i = 0; i < SNOOZE_TIME_IN_MINS.length; ++i) {
                if (time != SNOOZE_TIME_IN_MINS[i]) continue;
                this.jCbTimeMin.setSelectedIndex(i);
            }
            time = SoftwareDeploymentEntityObject.getSnoozeMaxTimeInSecs(deploymentSnooze) / 60;
            for (i = 0; i < SNOOZE_TIME_IN_MINS.length; ++i) {
                if (time != SNOOZE_TIME_IN_MINS[i]) continue;
                this.jCbTimeMax.setSelectedIndex(i);
            }
        }
        this.enableNotificationPanel();
    }

    public void initData(SoftwareDeploymentEntityObject entityObj, GroupObject groupObj) {
        int i;
        this.jCbxNotification.setSelected(entityObj.isNotificationEnabled());
        if (entityObj.getNotificationText() == null) {
            this.jTPopupMsg.setText(this.defaultMessage);
        } else {
            this.jTPopupMsg.setText(entityObj.getNotificationText());
        }
        this.jCbxSnooze.setSelected(entityObj.isSnoozeEnabled());
        int time = entityObj.getSnoozeMinTimeInSecs() / 60;
        for (i = 0; i < SNOOZE_TIME_IN_MINS.length; ++i) {
            if (time != SNOOZE_TIME_IN_MINS[i]) continue;
            this.jCbTimeMin.setSelectedIndex(i);
        }
        time = entityObj.getSnoozeMaxTimeInSecs() / 60;
        for (i = 0; i < SNOOZE_TIME_IN_MINS.length; ++i) {
            if (time != SNOOZE_TIME_IN_MINS[i]) continue;
            this.jCbTimeMax.setSelectedIndex(i);
        }
        this.enableNotificationPanel();
    }
}

