/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.AutoUpgradeContentOption;
import com.sygate.scm.common.configobject.schema.ClientFeature;
import com.sygate.scm.common.configobject.schema.ClientInstallationFeatures;
import com.sygate.scm.common.configobject.schema.ClientInstallationSettings;
import com.sygate.scm.common.configobject.schema.DeploymentSchedule;
import com.sygate.scm.common.configobject.schema.EnabledClientFeatures;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.PackageInfo;
import com.sygate.scm.common.configobject.schema.PackageSource;
import com.sygate.scm.common.configobject.schema.Schedule;
import com.sygate.scm.common.configobject.schema.SemGroupPolicy;
import com.sygate.scm.common.configobject.schema.SoftwareDeploymentEntity;
import com.sygate.scm.common.configobject.schema.SoftwareDeploymentPolicy;
import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.MultiLineLabel;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SemClientHandler;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.SecurityFixContentInfoObject;
import com.sygate.scm.console.logicobject.SoftwareDeploymentEntityObject;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallFeaturePoolObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallPoolObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationFeatureObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationSettingObject;
import com.sygate.scm.console.ui.policy.lu.LuUtility;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.MultiLineMsgBox;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.PackageListComboBox;
import com.sygate.scm.console.ui.util.TimeSpinner1;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.renderer.ToolTipComboBoxRenderer;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.AutoUpgradeUtils;
import com.sygate.scm.util.HTMLUtilities;
import com.sygate.scm.util.PackageUtil;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatter;

public class DeployConfigGeneralPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static final String AUTOMATION_PACKAGE_BUILD_SELECTION = "PackageBuildSelection";
    private static final String AUTOMATION_PACKAGE_NAME_SELECTION = "PackageNameSelection";
    private PackageListComboBox cbPackage = new PackageListComboBox();
    HashMap<String, Object> packageMap = new HashMap();
    private JTextArea taDesc = new DescriptionTextArea(" ");
    private JComboBox<ClientInstallationFeatureObject> cmbFeatures;
    private JRadioButton rbInternal = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.downloadAgentPackageFromPolicyManagerLabel"), true);
    private JRadioButton rbExternal = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.downloadPackageFromHTTPLabel"));
    private JTextField tfUrl = new JTextField();
    private JCheckBox cbxLocalTime = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.updateScheduleCkBox"));
    private String timePattern = MessageResources.getInstance().getString("com.sygate.scm.util.util", "timePattern");
    private String hourPattern;
    private TimeSpinner1 spStart;
    private TimeSpinner1 spTo;
    private int startTime = 0;
    private int endTime = 1;
    private boolean hasHour;
    private boolean hasMinute;
    private boolean hasSecond;
    private boolean hasAmpm;
    private JSpinner spDay = new JSpinner(new SpinnerNumberModel(0, 0, 9999, 1));
    private static final int DELETE = 127;
    private static final int BACKSPACE = 8;
    private JCheckBox cbxMaintainExistingFtre = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.forceUpdateCkBox"), true);
    private JCheckBox cbxAutoUpgradeToEnglish = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.autoUpgradeCkBox"), false);
    private Hashtable<String, ConfigObject> duplicatedPackageAndEntity;
    private boolean newDeploymentMode = true;
    private GroupObject groupObj;
    private JLabel pickFeatLbl = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.pickFeaturesLabel"));
    private DescriptionTextArea featuresWarning = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.FeaturesWarning"));
    private boolean newOptionOnly = false;
    private ArrayList<ClientInstallationFeatureObject> featureList = null;
    private JPanel forceDeployPanel;
    private JTextArea updateAgentsLabel = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.updateAllAgentsLabel"));
    private JTextArea updateAgentsLanguageLabel = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.updateAgentsLanguageLabel"));
    private JLabel lblInstallationStyle = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SelectGroupPackagePanel.lblInstallationOptions"));
    private ClientInstallationSettingObject installSettings = null;
    private JComboBox<ClientInstallationSettingObject> settingComboBox;
    private ClientInstallPoolObject settingsPool;
    private int packageType = 105;
    private String platformType = "WIN32BIT";
    private boolean usingSbePackage = false;
    private JCheckBox chkContentSelection = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SelectGroupPackagePanel.checkboxContentSelection"));
    private JTextArea contentSelectionDescriptionLabel = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SelectGroupPackagePanel.labelContentSelectionDiscription"), 50);
    private JPanel securityFixPanel;
    private JLabel securityFixBuildNumbertLbl = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.Pickup_securityFixBuildNumber"));
    private JComboBox<SecurityFixContentInfoObject> securityFixBuildNumberComboBox;

    public DeployConfigGeneralPanel(boolean newOptionOnly, String packagePlatform) {
        this.newOptionOnly = newOptionOnly;
        this.platformType = packagePlatform;
        this.initialize();
    }

    public SoftwareDeploymentEntity getDuplicatedEntity() {
        if (this.duplicatedPackageAndEntity == null) {
            return null;
        }
        return (SoftwareDeploymentEntity)this.duplicatedPackageAndEntity.get("ENTITY");
    }

    public void modifyExistingEntity(SoftwareDeploymentEntityObject entityObj) throws ConsoleException {
        int packageType = entityObj.getSoftwarePackage().getPackageInfo().getType();
        if (ClientInstallationFeatureObject.hasCustomizedFeatures(packageType)) {
            ObjReference objCIFRef = entityObj.getSoftwareDeploymentEntity().getObjReferenceByType("ClientInstallationFeatures");
            ClientInstallationFeatureObject sObj = (ClientInstallationFeatureObject)this.cmbFeatures.getSelectedItem();
            boolean needUpdate = false;
            DataobjectManager manager = DataobjectManager.getInstance();
            if (objCIFRef == null) {
                objCIFRef = new ObjReference();
                objCIFRef.setTargetType("ClientInstallationFeatures");
                objCIFRef.setName("TargetSoftwarePackageLink");
                objCIFRef.setTargetId(sObj.getId());
                entityObj.getSoftwareDeploymentEntity().addObjReference(objCIFRef);
                needUpdate = true;
            } else {
                if (!objCIFRef.getTargetId().equalsIgnoreCase(sObj.getId())) {
                    ClientInstallationFeatureObject sOldObject = new ClientInstallationFeatureObject(manager.getClientInstallationFeatures(objCIFRef.getTargetId()));
                    if (sOldObject != null && !sOldObject.isSystemObject()) {
                        sOldObject.decRefCount();
                        manager.updateClientInstallationFeatures("Merge", sOldObject.getClientInstallationFeatures());
                    }
                    needUpdate = true;
                }
                objCIFRef.setTargetId(sObj.getId());
            }
            if (!sObj.isSystemObject() && needUpdate) {
                sObj.incRefCount();
                manager.updateClientInstallationFeatures("Merge", sObj.getClientInstallationFeatures());
            }
            needUpdate = false;
            ClientInstallationSettingObject cisObj = this.getSelectedInstallSettings();
            ObjReference objCISRef = entityObj.getSoftwareDeploymentEntity().getObjReferenceByType("ClientInstallationSettings");
            if (objCISRef == null) {
                objCISRef = new ObjReference();
                objCISRef.setTargetType("ClientInstallationSettings");
                objCISRef.setName("TargetClientInstallationSettingsLink");
                objCISRef.setTargetId(cisObj.getId());
                entityObj.getSoftwareDeploymentEntity().addObjReference(objCISRef);
                needUpdate = true;
            } else if (!objCISRef.getTargetId().equalsIgnoreCase(cisObj.getId())) {
                ClientInstallationSettingObject iOldObject = new ClientInstallationSettingObject(manager.getClientInstallationSettings(objCISRef.getTargetId()));
                if (iOldObject != null && !iOldObject.isSystemObject()) {
                    iOldObject.decRefCount();
                    manager.updateClientInstallationSettings("Merge", iOldObject.getClientInstallationSettings());
                }
                objCISRef.setTargetId(cisObj.getId());
                needUpdate = true;
            }
            if (needUpdate && !cisObj.isSystemObject()) {
                cisObj.incRefCount();
                manager.updateClientInstallationSettings("Merge", cisObj.getClientInstallationSettings());
            }
        }
        entityObj.setDownloadSource(this.getDownloadSource(), this.tfUrl.getText().trim());
        entityObj.setForceDeployment(!this.cbxMaintainExistingFtre.isSelected());
        entityObj.setAutoUpgradeToEnglish(this.cbxAutoUpgradeToEnglish.isSelected());
        this.setFeaturesState();
        entityObj.setSchedule(this.cbxLocalTime.isSelected(), this.getHour(this.startTime), this.getMinute(this.startTime), this.getSecond(this.startTime), this.getHour(this.endTime), this.getMinute(this.endTime), this.getSecond(this.endTime), this.getRandomizedDays());
        this.updateSecurityFixContentInfo(new SoftwarePackageObject(entityObj.getSoftwarePackage()), entityObj);
        entityObj.setAutoUpgradeContentOption(this.chkContentSelection.isSelected());
    }

    public DeploymentSchedule generateDeploymentSchedule() {
        return SoftwareDeploymentEntityObject.newDeploymentSchedule(this.cbxLocalTime.isSelected(), this.getHour(this.startTime), this.getMinute(this.startTime), this.getSecond(this.startTime), this.getHour(this.endTime), this.getMinute(this.endTime), this.getSecond(this.endTime), this.getRandomizedDays());
    }

    public AutoUpgradeContentOption generateAutoUpgradeContentOption() {
        return SoftwareDeploymentEntityObject.newAutoUpgradeContentOption(this.chkContentSelection.isSelected());
    }

    public boolean isForceDeployment() {
        return !this.cbxMaintainExistingFtre.isSelected();
    }

    public boolean isAutoUpgradeToEnglish() {
        return this.cbxAutoUpgradeToEnglish.isSelected();
    }

    public SoftwareDeploymentEntityObject generateNewEntity() throws ConsoleException {
        TableRow sOldObject;
        DataobjectManager manager;
        SoftwarePackage sp = this.getSoftwarePackage();
        if (sp == null) {
            throw new ConsoleException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.errorPackageNotFound"));
        }
        String packageId = sp.getId();
        SoftwareDeploymentEntityObject entityObj = SoftwareDeploymentEntityObject.newInstanceObject(packageId);
        entityObj.setForceDeployment(!this.cbxMaintainExistingFtre.isSelected());
        entityObj.setAutoUpgradeToEnglish(this.cbxAutoUpgradeToEnglish.isSelected());
        entityObj.setDownloadSource(this.getDownloadSource(), this.tfUrl.getText().trim());
        int packageType = sp.getPackageInfo().getType();
        if (ClientInstallationFeatureObject.hasCustomizedFeatures(packageType)) {
            ObjReference objCIFRef = entityObj.getSoftwareDeploymentEntity().getObjReferenceByType("ClientInstallationFeatures");
            ClientInstallationFeatureObject sObj = (ClientInstallationFeatureObject)this.cmbFeatures.getSelectedItem();
            boolean needUpdate = false;
            manager = DataobjectManager.getInstance();
            if (objCIFRef == null) {
                objCIFRef = new ObjReference();
                objCIFRef.setTargetType("ClientInstallationFeatures");
                objCIFRef.setName("TargetSoftwarePackageLink");
                objCIFRef.setTargetId(sObj.getId());
                entityObj.getSoftwareDeploymentEntity().addObjReference(objCIFRef);
                needUpdate = true;
            } else {
                if (!objCIFRef.getTargetId().equalsIgnoreCase(sObj.getId())) {
                    sOldObject = new ClientInstallationFeatureObject(manager.getClientInstallationFeatures(objCIFRef.getTargetId()));
                    if (sOldObject != null && !((ClientInstallationFeatureObject)sOldObject).isSystemObject()) {
                        ((ClientInstallationFeatureObject)sOldObject).decRefCount();
                        manager.updateClientInstallationFeatures("Merge", ((ClientInstallationFeatureObject)sOldObject).getClientInstallationFeatures());
                    }
                    needUpdate = true;
                }
                objCIFRef.setTargetId(sObj.getId());
            }
            if (!sObj.isSystemObject() && needUpdate) {
                sObj.incRefCount();
                manager.updateClientInstallationFeatures("Merge", sObj.getClientInstallationFeatures());
            }
        }
        boolean needUpdate = false;
        ClientInstallationSettingObject cisObj = this.getSelectedInstallSettings();
        ObjReference objCISRef = entityObj.getSoftwareDeploymentEntity().getObjReferenceByType("ClientInstallationSettings");
        if (objCISRef == null) {
            objCISRef = new ObjReference();
            objCISRef.setTargetType("ClientInstallationSettings");
            objCISRef.setName("TargetClientInstallationSettingsLink");
            objCISRef.setTargetId(cisObj.getId());
            entityObj.getSoftwareDeploymentEntity().addObjReference(objCISRef);
            needUpdate = true;
        } else {
            if (!objCISRef.getTargetId().equalsIgnoreCase(cisObj.getId())) {
                manager = DataobjectManager.getInstance();
                sOldObject = new ClientInstallationSettingObject(manager.getClientInstallationSettings(objCISRef.getTargetId()));
                if (sOldObject != null && !((ClientInstallationSettingObject)sOldObject).isSystemObject()) {
                    ((ClientInstallationSettingObject)sOldObject).decRefCount();
                    manager.updateClientInstallationSettings("Merge", ((ClientInstallationSettingObject)sOldObject).getClientInstallationSettings());
                }
                needUpdate = true;
            }
            objCISRef.setTargetId(cisObj.getId());
        }
        if (needUpdate && !cisObj.isSystemObject()) {
            manager = DataobjectManager.getInstance();
            ClientInstallationSettingObject customInstallSettings = new ClientInstallationSettingObject(manager.getClientInstallationSettings(objCISRef.getTargetId()));
            customInstallSettings.incRefCount();
            manager.updateClientInstallationSettings("Merge", customInstallSettings.getClientInstallationSettings());
        }
        entityObj.setSchedule(this.cbxLocalTime.isSelected(), this.getHour(this.startTime), this.getMinute(this.startTime), this.getSecond(this.startTime), this.getHour(this.endTime), this.getMinute(this.endTime), this.getSecond(this.endTime), this.getRandomizedDays());
        entityObj.setAutoUpgradeContentOption(this.chkContentSelection.isSelected());
        this.updateSecurityFixContentInfo(new SoftwarePackageObject(sp), entityObj);
        return entityObj;
    }

    private void updateSecurityFixContentInfo(SoftwarePackageObject spObj, SoftwareDeploymentEntityObject entityObj) {
        if (spObj.isSecurityFixContent()) {
            SecurityFixContentInfoObject selectedBuild = (SecurityFixContentInfoObject)this.getSecurityFixBuildNumberComboBox().getSelectedItem();
            entityObj.getSoftwareDeploymentEntity().setOptSecurityFixContentInfo(selectedBuild.getSecurityFixContentInfo());
            ConsoleLogger.log("Security Fix Content package was deployed, build number: " + selectedBuild.getSecurityFixContentInfo().getProductBuildNum() + ", PackageChecksum: " + selectedBuild.getSecurityFixContentInfo().getPackageChecksum());
        }
    }

    private boolean validateRandomizedDays() throws ConsoleException {
        int result;
        if (LicenseObject.getInstance().isSBProduct()) {
            return true;
        }
        int count = SemClientHandler.getCountOfDistinctPhysicalComputers(null);
        System.out.println("DeployConfigurationDlg>> initRandomizedTime: physical computer count=" + count);
        if (count <= 10) {
            return true;
        }
        String message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.updateImmediatelyWarning");
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.warning");
        return this.getRandomizedDays() > 0 || (result = UIUtilities.confirmYesNoOptionDialog(message, title)) == 0;
    }

    public boolean isValidate() {
        if (this.rbExternal.isSelected()) {
            String requiredExtension = ".exe";
            if ("Mac".equalsIgnoreCase(this.getPlatformType())) {
                requiredExtension = ".zip";
            }
            if (!Utility.isValidUrl((String)this.tfUrl.getText().trim(), (String)requiredExtension)) {
                String notValidURLMsg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.notValidURLMsg"), requiredExtension);
                int columnnumber_max = 60;
                int columnnumber_min = 40;
                if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                    int columnsize = notValidURLMsg.length() > 120 ? columnnumber_max : columnnumber_min;
                    JOptionPane.showMessageDialog(this, new DescriptionTextArea(notValidURLMsg, columnsize), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.error"), 0);
                    return false;
                }
                JOptionPane.showMessageDialog(this, notValidURLMsg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.error"), 0);
                return false;
            }
        }
        try {
            boolean sameTypeExists;
            if (!this.validateRandomizedDays()) {
                return false;
            }
            if (this.newDeploymentMode && (sameTypeExists = this.isSameTypeLanguagePlatformExisting())) {
                SoftwarePackageObject spObj = this.getDuplicatedPackageObject();
                Object[] obj1 = new Object[]{spObj.getName(), this.getSoftwarePackage().getName()};
                String str1 = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.duplicateType");
                String fm1 = MessageFormat.format(str1, obj1);
                if (0 != JOptionPane.showConfirmDialog(this, fm1, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.duplicatePackageDeploymentTitle"), 0)) {
                    return false;
                }
            }
            if (this.groupObj != null) {
                ArrayList<GroupObject> selectedGroups = new ArrayList<GroupObject>();
                selectedGroups.add(this.groupObj);
                ArrayList<SoftwarePackage> selectedPackages = new ArrayList<SoftwarePackage>();
                selectedPackages.add(this.getSoftwarePackage());
                ArrayList<GroupObject> unAvaliableGroups = LuUtility.checkHIContentAvailable(selectedGroups, selectedPackages);
                if (null != unAvaliableGroups) {
                    MultiLineMsgBox optionPane = new MultiLineMsgBox(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "SoftwareUpdatePanel.warning"));
                    optionPane.init(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "SoftwareUpdatePanel.checkHIConetentFail"), 60, 0, -1);
                    optionPane.show();
                    return false;
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.consoleError"), 0);
            return false;
        }
        if (!this.cbxMaintainExistingFtre.isSelected()) {
            MultiLineLabel multiL;
            String msg;
            ClientInstallationFeatures clientInstallationFeatures;
            SoftwarePackage selectedPackage = this.getSoftwarePackage();
            if (selectedPackage.getPackageInfo() == null) {
                String errorMsg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.softwarePackageCorrupted");
                JOptionPane.showMessageDialog(Manager.getFrame(), errorMsg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.consoleError"), 0);
                return false;
            }
            String version = null;
            version = Boolean.TRUE.equals(selectedPackage.getPackageInfo().getOptSecurityFixPackage()) ? selectedPackage.getPackageInfo().getOptProductBuildNum() : selectedPackage.getPackageInfo().getVersion();
            if (!PackageUtil.isAtleastOneFeatureSelected((String)version, (ClientInstallationFeatures)(clientInstallationFeatures = this.getClientInstallationFeatureObject()))) {
                msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.NoFeatureEnabled");
                multiL = new MultiLineLabel(msg);
                JOptionPane.showMessageDialog(this, multiL, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.NoFeatureEnabledTitle"), 0);
                return false;
            }
            if (!this.isSaepAndTdadEnabled() && 0 != JOptionPane.showConfirmDialog(this, multiL = new MultiLineLabel(msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.saepAndTdadNotEnabled")), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.saepAndTdadNotEnabledTitle"), 0)) {
                return false;
            }
        }
        return true;
    }

    public void setReadOnly() {
        this.rbInternal.setEnabled(false);
        this.rbExternal.setEnabled(false);
        this.tfUrl.setEnabled(false);
        this.cbxLocalTime.setEnabled(false);
        this.spStart.setEnabled(false);
        this.spTo.setEnabled(false);
        this.spDay.setEnabled(false);
        this.cbxMaintainExistingFtre.setEnabled(false);
        this.chkContentSelection.setEnabled(false);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_install_packages_wizard_assign_package_advanced_settings_general";
    }

    private void initialize() {
        block11: {
            LicenseObject lo = LicenseObject.getInstance();
            try {
                this.spStart = new TimeSpinner1(this.timePattern);
                this.spTo = new TimeSpinner1(this.timePattern);
                if (this.timePattern.indexOf("h") != -1) {
                    this.hourPattern = "h";
                    this.hasHour = true;
                }
                if (this.timePattern.indexOf("H") != -1) {
                    this.hourPattern = "H";
                    this.hasHour = true;
                }
                if (this.timePattern.indexOf("k") != -1) {
                    this.hourPattern = "k";
                    this.hasHour = true;
                }
                if (this.timePattern.indexOf("K") != -1) {
                    this.hourPattern = "K";
                    this.hasHour = true;
                }
                if (this.timePattern.indexOf("m") != -1) {
                    this.hasMinute = true;
                }
                if (this.timePattern.indexOf("s") != -1) {
                    this.hasSecond = true;
                }
                if (this.timePattern.indexOf("a") != -1) {
                    this.hasAmpm = true;
                }
                this.cbxLocalTime.setFont(this.cbxLocalTime.getFont().deriveFont(1));
                this.cbxLocalTime.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e1) {
                        DeployConfigGeneralPanel.this.scheduleChanged();
                    }
                });
                JPanel panel = new JPanel();
                int row = 0;
                panel.setLayout(new GridBagLayout());
                if (!this.newOptionOnly) {
                    panel.add((Component)this.getPackagePanel(), new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
                }
                panel.add((Component)this.getSecurityFixBuildNumberPanel(), new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
                this.forceDeployPanel = this.getFeaturesPanel(this.getPackageType(), lo);
                panel.add((Component)this.forceDeployPanel, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
                if (!this.newOptionOnly) {
                    panel.add((Component)this.getSourcePanel(), new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
                }
                panel.add((Component)this.cbxLocalTime, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 12, 0, 5), 0, 0));
                panel.add((Component)this.getSchedulePanel(), new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 5, 0, 5), 0, 0));
                panel.add((Component)this.getRandomizedTimePanel(), new GridBagConstraints(0, row++, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 5, 0, 5), 0, 0));
                this.setLayout(new BorderLayout());
                this.add(new JScrollPane(panel));
                this.setFeaturesState();
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigFGeneralPanel.error"), 0);
                if (!ex.needRelogin()) break block11;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    private int getPackageType() {
        return this.packageType;
    }

    private String getPlatformType() {
        return this.platformType;
    }

    private JPanel getPackagePanel() throws ConsoleException {
        this.cbPackage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeployConfigGeneralPanel.this.packageChanged();
                DeployConfigGeneralPanel.this.updateSecurityFixBuildNumberPanel();
            }
        });
        UIUtilities.setName(this.cbPackage, "clientPage", UIUtilities.ComponentType.COMBOBOX, AUTOMATION_PACKAGE_NAME_SELECTION);
        this.cbPackage.setRenderer(new PackageListCellRenderer());
        this.taDesc.setBackground(this.getBackground());
        this.taDesc.setRows(3);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel comboLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.selectPackageForUpdateMsg"));
        comboLabel.setLabelFor(this.cbPackage);
        panel.add((Component)comboLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.cbPackage, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.descriptionLabel")), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        JScrollPane jSPane = new JScrollPane(this.taDesc);
        UiUtilities.setupScrollPane((JScrollPane)jSPane, (JTextArea)this.taDesc);
        JPanel container = new JPanel(new GridBagLayout());
        container.add((Component)jSPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)container, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getSourcePanel() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbInternal);
        buttonGroup.add(this.rbExternal);
        this.rbExternal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e1) {
                DeployConfigGeneralPanel.this.downloadTypeChanged();
            }
        });
        this.rbInternal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e1) {
                DeployConfigGeneralPanel.this.downloadTypeChanged();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.downloadSourceTitle")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        panel.add((Component)this.rbInternal, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.rbExternal, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        JLabel urlLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.urlLabel"));
        panel.add((Component)urlLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 25, 5, 0), 0, 0));
        panel.add((Component)this.tfUrl, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        urlLabel.setLabelFor(this.tfUrl);
        return panel;
    }

    public SoftwarePackage getCurrentSoftwarePackage() {
        return this.getSoftwarePackage();
    }

    private JPanel getSchedulePanel() {
        int hour = Utility.convertHourFrom_H_Pattern((int)0, (String)this.hourPattern);
        this.spStart.setHour(hour);
        hour = Utility.convertHourFrom_H_Pattern((int)23, (String)this.hourPattern);
        if (this.hasAmpm) {
            int ampm = Utility.getAmpmFrom_H_Pattern((int)23, (String)this.hourPattern);
            this.spTo.setAmpm(ampm);
        }
        this.spTo.setHour(hour);
        this.spTo.setMinute(59);
        this.spTo.setSecond(0);
        JPanel panel1 = new JPanel(new FlowLayout(0));
        panel1.setBorder(BorderFactory.createTitledBorder(" "));
        panel1.add(new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.fromLabel")));
        panel1.add(this.spStart);
        panel1.add(new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.toLabel")));
        panel1.add(this.spTo);
        return panel1;
    }

    private JPanel getRandomizedTimePanel() {
        JPanel panel2 = new JPanel(new FlowLayout(0));
        panel2.add(new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.distributeUpdatesLabel")));
        UIUtilities.enableOnlyValidEdits(this.spDay);
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)this.spDay.getEditor();
        final JFormattedTextField ftf = editor.getTextField();
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            ftf.setDocument(new NumberPlainDocument(9999L));
            ftf.setText("0");
        }
        ftf.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
                boolean isAllSelected;
                int keyCode = arg0.getKeyCode();
                boolean bl = isAllSelected = ftf.getSelectedText() != null && ftf.getSelectedText().length() == ftf.getText().length();
                if (!(keyCode != 127 && keyCode != 8 || !isAllSelected && ftf.getText().length() != 1)) {
                    JFormattedTextField.AbstractFormatter formatter = ftf.getFormatter();
                    DefaultFormatter df = (DefaultFormatter)formatter;
                    df.setAllowsInvalid(true);
                    DeployConfigGeneralPanel.this.spDay.setValue(0);
                    ftf.setText("");
                    UIUtilities.enableOnlyValidEdits(DeployConfigGeneralPanel.this.spDay);
                }
            }
        });
        panel2.add(this.spDay);
        panel2.add(new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.day(s)Label")));
        return panel2;
    }

    private JPanel getFeaturesPanel(int pkgType, LicenseObject lo) throws ConsoleException {
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.clientFeaturesTitle");
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.pickFeatLbl.setEnabled(false);
        this.cbxMaintainExistingFtre.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeployConfigGeneralPanel.this.setFeaturesState();
            }
        });
        int row = 0;
        if (pkgType != 151 && !lo.isSNACOnlyProduct() && !"Mac".equals(this.getPlatformType())) {
            panel.add((Component)this.cbxMaintainExistingFtre, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)this.updateAgentsLabel, new GridBagConstraints(0, row++, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 28, 5, 5), 0, 0));
            panel.add((Component)this.pickFeatLbl, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            panel.add(this.getFeatureCombo(), new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
            panel.add((Component)this.featuresWarning, new GridBagConstraints(0, row++, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 28, 5, 5), 0, 0));
            this.pickFeatLbl.setLabelFor(this.cmbFeatures);
        }
        panel.add((Component)this.lblInstallationStyle, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.lblInstallationStyle.setLabelFor(this.settingComboBox);
        panel.add(this.getSettingComboBox(), new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        if (!"Mac".equals(this.getPlatformType())) {
            panel.add((Component)this.chkContentSelection, new GridBagConstraints(0, row++, 2, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.contentSelectionDescriptionLabel, new GridBagConstraints(0, row++, 0, 0, 1.0, 1.0, 17, 2, new Insets(0, 28, 5, 0), 0, 0));
        }
        return panel;
    }

    protected JPanel getSecurityFixBuildNumberPanel() {
        int y = 0;
        if (this.securityFixPanel == null) {
            this.securityFixPanel = new JPanel(new GridBagLayout());
            this.securityFixBuildNumbertLbl.setLabelFor(this.getSecurityFixBuildNumberComboBox());
            this.securityFixPanel.add((Component)this.securityFixBuildNumbertLbl, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 2), 0, 0));
            this.securityFixPanel.add(this.getSecurityFixBuildNumberComboBox(), new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 10), 0, 0));
            this.securityFixPanel.add((Component)this.cbxAutoUpgradeToEnglish, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 5), 0, 0));
            this.securityFixPanel.add((Component)this.updateAgentsLanguageLabel, new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 28, 5, 5), 0, 0));
            String settingsTitle = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ExportPackageDlg.SecurityFixSetting");
            this.securityFixPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(settingsTitle), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        }
        return this.securityFixPanel;
    }

    protected JComboBox<SecurityFixContentInfoObject> getSecurityFixBuildNumberComboBox() {
        if (this.securityFixBuildNumberComboBox == null) {
            this.securityFixBuildNumberComboBox = new JComboBox();
            this.securityFixBuildNumberComboBox.setRenderer(new ToolTipComboBoxRenderer());
            this.securityFixBuildNumberComboBox.setPreferredSize(new Dimension(360, this.securityFixBuildNumberComboBox.getPreferredSize().height));
            UIUtilities.setName(this.securityFixBuildNumberComboBox, "clientPage", UIUtilities.ComponentType.COMBOBOX, AUTOMATION_PACKAGE_BUILD_SELECTION);
        }
        return this.securityFixBuildNumberComboBox;
    }

    protected void updateSecurityFixBuildNumberPanel() {
        SoftwarePackage sp = this.getSoftwarePackage();
        if (sp == null) {
            Object obj = this.packageMap.get(this.cbPackage.getSelectedItem());
            sp = this.cbPackage.getSoftwarePackage(obj);
        }
        if (sp != null) {
            this.updateSecurityFixBuildNumberPanel(sp, null);
        }
    }

    protected void updateSecurityFixBuildNumberPanel(SoftwarePackage softwarePackage, SecurityFixContentInfoObject selectedSecurityFix) {
        PackageInfo pkInfo = this.getSoftwarePackage().getPackageInfo();
        if (pkInfo != null && "en_us".equalsIgnoreCase(pkInfo.getOptLanuage())) {
            this.cbxAutoUpgradeToEnglish.setVisible(true);
            this.updateAgentsLanguageLabel.setVisible(true);
        } else {
            this.cbxAutoUpgradeToEnglish.setVisible(false);
            this.updateAgentsLanguageLabel.setVisible(false);
        }
        SoftwarePackageObject currentPackageObj = new SoftwarePackageObject(softwarePackage);
        if (currentPackageObj.isSecurityFixContent()) {
            this.getSecurityFixBuildNumberPanel().setVisible(true);
            this.getSecurityFixBuildNumberComboBox().removeAllItems();
            for (SecurityFixContentInfoObject securityFixContentInfoObject : currentPackageObj.getSecurityFixContentBuildNumbers()) {
                this.getSecurityFixBuildNumberComboBox().addItem(securityFixContentInfoObject);
            }
            for (ActionListener actionListener : this.getSecurityFixBuildNumberComboBox().getActionListeners()) {
                this.getSecurityFixBuildNumberComboBox().removeActionListener(actionListener);
            }
            this.getSecurityFixBuildNumberComboBox().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    DeployConfigGeneralPanel.this.securityFixBuildNumberComboBoxSelectionChange();
                }
            });
            if (selectedSecurityFix != null) {
                this.getSecurityFixBuildNumberComboBox().setSelectedItem(selectedSecurityFix);
            } else {
                this.getSecurityFixBuildNumberComboBox().setSelectedIndex(0);
            }
            this.securityFixBuildNumberComboBoxSelectionChange();
        } else {
            this.getSecurityFixBuildNumberPanel().setVisible(false);
        }
    }

    private void securityFixBuildNumberComboBoxSelectionChange() {
        SecurityFixContentInfoObject selectedBuild = (SecurityFixContentInfoObject)this.getSecurityFixBuildNumberComboBox().getSelectedItem();
        if (selectedBuild != null) {
            ConsoleLogger.log("The selected security fix build number is: " + selectedBuild.getSecurityFixContentInfo().getProductBuildNum() + ", PackageChecksum: " + selectedBuild.getSecurityFixContentInfo().getPackageChecksum());
        }
    }

    public void initData(ArrayList<CurrentPackageObject> listSoftwarePackages, GroupObject groupObj) throws ConsoleException {
        this.newDeploymentMode = true;
        this.groupObj = groupObj;
        this.packageMap.clear();
        this.cbPackage.init(listSoftwarePackages, this.packageMap);
        this.rbInternal.setSelected(true);
        this.tfUrl.setEnabled(!this.rbInternal.isSelected());
        this.cbxLocalTime.setSelected(false);
        this.initRandomizedTime();
        this.packageChanged();
        this.setFeaturesState();
        this.downloadTypeChanged();
        this.scheduleChanged();
        this.updateSecurityFixBuildNumberPanel();
        this.chkContentSelection.setSelected(true);
    }

    public void initData(SoftwareDeploymentEntityObject entityObj, GroupObject groupObj) throws ConsoleException {
        ObjReference objCISRef;
        this.newDeploymentMode = false;
        this.groupObj = groupObj;
        this.packageMap.clear();
        SoftwarePackage sp = entityObj.getSoftwarePackage();
        this.cbPackage.init(sp, this.packageMap);
        this.cbPackage.setEnabled(false);
        this.platformType = sp.getPackageInfo().getOptPlatformType();
        this.rbInternal.setSelected(entityObj.isDownloadSourceInternal());
        this.rbExternal.setSelected(entityObj.isDownloadSourceExternal());
        this.tfUrl.setText(entityObj.getDownloadSourceUrl());
        this.tfUrl.setEnabled(!this.rbInternal.isSelected());
        this.cbxLocalTime.setSelected(entityObj.isScheduleEnabled());
        this.setStartAndEndTime(entityObj.getDeploymentSchedule());
        int seconds = entityObj.getRandomizedTime();
        int days = seconds / 86400;
        this.spDay.setValue(days);
        this.cbxMaintainExistingFtre.setSelected(!entityObj.isForeceDeployment());
        this.cbxAutoUpgradeToEnglish.setSelected(entityObj.isAutoUpgradeToEnglish());
        ObjReference objCIFRef = entityObj.getSoftwareDeploymentEntity().getObjReferenceByType("ClientInstallationFeatures");
        DataobjectManager manager = DataobjectManager.getInstance();
        if (objCIFRef != null) {
            ClientInstallationFeatures installSettings = manager.getClientInstallationFeatures(objCIFRef.getTargetId());
            ClientInstallationFeatureObject sObj = new ClientInstallationFeatureObject(installSettings);
            this.cmbFeatures.getModel().setSelectedItem(sObj);
            this.setJComboBoxSelectedIndex(this.cmbFeatures);
        }
        if ((objCISRef = entityObj.getSoftwareDeploymentEntity().getObjReferenceByType("ClientInstallationSettings")) != null) {
            ClientInstallationSettings installSettings = manager.getClientInstallationSettings(objCISRef.getTargetId());
            ClientInstallationSettingObject cisObj = new ClientInstallationSettingObject(installSettings);
            this.settingComboBox.getModel().setSelectedItem(cisObj);
            this.setJComboBoxSelectedIndex(this.settingComboBox);
        }
        this.packageChanged();
        this.setFeaturesState();
        this.downloadTypeChanged();
        this.scheduleChanged();
        SecurityFixContentInfoObject securityFix = null;
        if (entityObj.getSoftwareDeploymentEntity().getOptSecurityFixContentInfo() != null) {
            securityFix = new SecurityFixContentInfoObject(entityObj.getSoftwareDeploymentEntity().getOptSecurityFixContentInfo());
        }
        this.updateSecurityFixBuildNumberPanel(sp, securityFix);
        this.chkContentSelection.setSelected(entityObj.isIncludeContentInAutoUpgradePackage());
        this.packageType = entityObj.getSoftwarePackage().getPackageInfo().getType();
        if (!ClientInstallationFeatureObject.hasCustomizedFeatures(this.packageType)) {
            UIUtilities.setContainerStatus(this.forceDeployPanel, false);
        }
    }

    private void setJComboBoxSelectedIndex(JComboBox<?> comboBox) {
        Object selectItem = comboBox.getSelectedItem();
        if (selectItem == null) {
            return;
        }
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            Object item = comboBox.getItemAt(i);
            if (!selectItem.equals(item)) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
    }

    public void initData(int packageType, ClientInstallationFeatures cif, DeploymentSchedule deploymentSchedule, boolean forceDeployment, boolean autoUpgradeToEnglish, ClientInstallationSettingObject cisObj, boolean isSBEPackage, String packagePlatform, AutoUpgradeContentOption contentOption, SoftwarePackageObject spo, SecurityFixContentInfoObject securityFix) throws ConsoleException {
        this.newDeploymentMode = true;
        this.groupObj = null;
        this.packageType = packageType;
        this.platformType = packagePlatform;
        this.setusingSbePackage(isSBEPackage);
        if (cif != null) {
            ClientInstallationFeatureObject sObj = new ClientInstallationFeatureObject(cif);
            this.cmbFeatures.getModel().setSelectedItem(sObj);
        }
        if (deploymentSchedule == null) {
            this.cbxLocalTime.setSelected(false);
        } else {
            this.cbxLocalTime.setSelected(SoftwareDeploymentEntityObject.isScheduleEnabled(deploymentSchedule));
        }
        this.setStartAndEndTime(deploymentSchedule);
        if (deploymentSchedule == null) {
            this.initRandomizedTime();
        } else {
            int seconds = SoftwareDeploymentEntityObject.getRandomizedTime(deploymentSchedule);
            int days = seconds / 86400;
            this.spDay.setValue(days);
        }
        if (cisObj != null && cisObj.getPlatform().equals(ClientInstallPoolObject.getClientInstallPlatfform(this.platformType))) {
            this.settingComboBox.getModel().setSelectedItem(cisObj);
        } else {
            this.reloadSettingComboBox();
        }
        if (spo == null) {
            ConsoleLogger.log("DeployConfigGeneralPanel> initData>> Error: Given SoftwarePackageObject is null.");
        } else {
            this.packageMap.clear();
            this.cbPackage.init(spo.getSoftwarePackage(), this.packageMap);
        }
        this.cbxMaintainExistingFtre.setSelected(!forceDeployment);
        this.cbxAutoUpgradeToEnglish.setSelected(autoUpgradeToEnglish);
        this.setMaintainExistingFeature(packageType);
        this.setFeaturesState();
        this.scheduleChanged();
        if (spo != null) {
            this.updateSecurityFixBuildNumberPanel(spo.getSoftwarePackage(), securityFix);
        }
        if (contentOption == null) {
            this.chkContentSelection.setSelected(true);
        } else {
            this.chkContentSelection.setSelected(SoftwareDeploymentEntityObject.isIncludeContentInAutoUpgradePackage(contentOption));
        }
    }

    private void initRandomizedTime() throws ConsoleException {
        int count = SemClientHandler.getCountOfDistinctPhysicalComputers(null);
        System.out.println("DeployConfigurationDlg>> initRandomizedTime: physical computer count=" + count);
        int hours = 0;
        hours = count <= 10 ? 0 : (count <= 5000 ? 24 : (count <= 10000 ? 48 : (count <= 20000 ? 72 : (count <= 30000 ? 96 : (count <= 40000 ? 120 : 120 + (count - 40000) / 360 + 1)))));
        this.spDay.setValue(hours / 24);
    }

    private SoftwarePackageObject getDuplicatedPackageObject() {
        SoftwarePackage sp = this.getDuplicatedPackage();
        if (sp == null) {
            return null;
        }
        return new SoftwarePackageObject(sp);
    }

    private SoftwarePackage getDuplicatedPackage() {
        if (this.duplicatedPackageAndEntity == null) {
            return null;
        }
        return (SoftwarePackage)this.duplicatedPackageAndEntity.get("PACKAGE");
    }

    private Integer getDownloadSource() {
        if (this.rbInternal.isSelected()) {
            return PackageSource.SEM_SERVER;
        }
        if (this.rbExternal.isSelected()) {
            return PackageSource.EXTERNAL_URL;
        }
        return PackageSource.SEM_SERVER;
    }

    public int getRandomizedDays() {
        int value = 0;
        Object o = this.spDay.getValue();
        if (o instanceof Integer) {
            value = (Integer)o;
        } else {
            try {
                value = Integer.parseInt(o.toString());
            }
            catch (Exception ex) {
                ConsoleLogger.log(ex);
            }
        }
        return value;
    }

    private void scheduleChanged() {
        boolean isEnabled = this.cbxLocalTime.isSelected();
        this.spStart.setEnabled(isEnabled);
        this.spTo.setEnabled(isEnabled);
    }

    private void packageChanged() {
        if (this.newOptionOnly) {
            return;
        }
        SoftwarePackage sp = this.getSoftwarePackage();
        if (sp == null) {
            Object obj = this.packageMap.get(this.cbPackage.getSelectedItem());
            sp = this.cbPackage.getSoftwarePackage(obj);
        }
        if (sp != null) {
            Object strDescription = sp.getOptDescription();
            Object object = strDescription = strDescription == null ? "" : strDescription;
            if (((String)strDescription).isEmpty()) {
                this.taDesc.setRows(0);
            }
            if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                strDescription = "<html>" + HTMLUtilities.filter((String)strDescription) + "</html>";
            }
            this.taDesc.setText((String)strDescription);
            this.taDesc.setCaretPosition(0);
            this.packageType = sp.getPackageInfo().getType();
            this.setMaintainExistingFeature(this.packageType);
            LicenseObject lo = LicenseObject.getInstance();
            String packageVersion = sp.getPackageInfo().getVersion();
            this.updateUIforSBEPackage(packageVersion, lo);
            if (!lo.isSBProduct()) {
                this.checkForSNACPackage(this.packageType);
            }
            this.updateUIForMacPackage(sp);
        }
    }

    private SoftwarePackage getSoftwarePackage() {
        Object obj = this.packageMap.get(this.cbPackage.getSelectedItem());
        if (obj == null) {
            return this.cbPackage.getSoftwarePackage(this.cbPackage.getSelectedItem());
        }
        if (obj instanceof String) {
            obj = this.packageMap.get(this.cbPackage.getSelectedItem());
        }
        return this.cbPackage.getSoftwarePackage(obj);
    }

    private void updateUIForMacPackage(SoftwarePackage sp) {
        try {
            Integer oldSettingPlatform = ClientInstallPoolObject.getClientInstallPlatfform(this.platformType);
            Integer newSettingPlatform = ClientInstallPoolObject.getClientInstallPlatfform(sp.getPackageInfo().getOptPlatformType());
            this.platformType = sp.getPackageInfo().getOptPlatformType();
            boolean isFeatureComponentVisible = !"Mac".equals(this.platformType);
            this.cbxMaintainExistingFtre.setVisible(isFeatureComponentVisible);
            this.updateAgentsLabel.setVisible(isFeatureComponentVisible);
            this.pickFeatLbl.setVisible(isFeatureComponentVisible);
            this.getFeatureCombo().setVisible(isFeatureComponentVisible);
            this.featuresWarning.setVisible(isFeatureComponentVisible);
            this.chkContentSelection.setVisible(isFeatureComponentVisible);
            this.contentSelectionDescriptionLabel.setVisible(isFeatureComponentVisible);
            if (oldSettingPlatform == null || !oldSettingPlatform.equals(newSettingPlatform)) {
                this.reloadSettingComboBox();
            }
        }
        catch (ConsoleException ce) {
            ConsoleLogger.log(ce);
        }
    }

    private void checkForSNACPackage(int packageType) {
        boolean snacpackage = packageType == 151;
        this.cbxMaintainExistingFtre.setVisible(!snacpackage);
        this.updateAgentsLabel.setVisible(!snacpackage);
        this.cmbFeatures.setVisible(!snacpackage);
        this.pickFeatLbl.setVisible(!snacpackage);
        this.featuresWarning.setVisible(!snacpackage);
    }

    private void updateUIforSBEPackage(String packageVersion, LicenseObject license) {
        boolean maintainFeature = true;
        if (license != null && !license.isSBProduct() && Utility.compareVersion((String)packageVersion, (String)"12.0.0.0") >= 0 && Utility.compareVersion((String)packageVersion, (String)"12.1.0.0") < 0) {
            maintainFeature = true;
            this.cbxMaintainExistingFtre.setEnabled(!maintainFeature);
        }
    }

    private void setMaintainExistingFeature(int packageType) {
        if (!ClientInstallationFeatureObject.hasCustomizedFeatures(packageType)) {
            this.cbxMaintainExistingFtre.setSelected(true);
            this.cbxMaintainExistingFtre.setEnabled(false);
            this.updateAgentsLabel.setEnabled(false);
        } else {
            this.cbxMaintainExistingFtre.setEnabled(true);
            this.updateAgentsLabel.setEnabled(true);
        }
        this.cbxMaintainExistingFtre.setEnabled(!this.isusingSbePackage());
    }

    private void downloadTypeChanged() {
        this.tfUrl.setEnabled(!this.rbInternal.isSelected());
    }

    private JComboBox<ClientInstallationFeatureObject> getFeatureCombo() throws ConsoleException {
        if (this.cmbFeatures == null) {
            ClientInstallFeaturePoolObject pool = new ClientInstallFeaturePoolObject();
            this.featureList = new ArrayList<ClientInstallationFeatureObject>(pool.getAllObjects());
            this.cmbFeatures = new JComboBox<ClientInstallationFeatureObject>(new Vector<ClientInstallationFeatureObject>(this.featureList));
            this.cmbFeatures.setEnabled(false);
        }
        return this.cmbFeatures;
    }

    public ClientInstallationFeatures getClientInstallationFeatureObject() {
        if (this.featureList == null) {
            return null;
        }
        ComboBoxModel<ClientInstallationFeatureObject> listModel = this.cmbFeatures.getModel();
        ClientInstallationFeatureObject cifo = (ClientInstallationFeatureObject)listModel.getSelectedItem();
        if (cifo != null) {
            return cifo.getClientInstallationFeatures();
        }
        return null;
    }

    private JComboBox<ClientInstallationSettingObject> getSettingComboBox() throws ConsoleException {
        this.reloadSettingComboBox();
        this.settingComboBox.setPreferredSize(new Dimension(360, this.settingComboBox.getPreferredSize().height));
        return this.settingComboBox;
    }

    private void reloadSettingComboBox() throws ConsoleException {
        if (this.settingsPool == null) {
            this.settingsPool = new ClientInstallPoolObject();
        }
        Vector<ClientInstallationSettingObject> allSettings = new Vector<ClientInstallationSettingObject>(this.settingsPool.getObjectsByPlatform(this.getPlatformType()));
        if (this.settingComboBox == null) {
            this.settingComboBox = new JComboBox<ClientInstallationSettingObject>(allSettings);
            this.settingComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ClientInstallationSettingObject obj = (ClientInstallationSettingObject)DeployConfigGeneralPanel.this.settingComboBox.getSelectedItem();
                    DeployConfigGeneralPanel.this.setSelectedInstallSettings(obj);
                }
            });
        } else {
            this.settingComboBox.removeAllItems();
            for (ClientInstallationSettingObject obj : allSettings) {
                this.settingComboBox.addItem(obj);
            }
        }
        if (allSettings != null && allSettings.size() > 0) {
            this.settingComboBox.setSelectedIndex(0);
            this.setSelectedInstallSettings((ClientInstallationSettingObject)this.settingComboBox.getSelectedItem());
        }
    }

    private void setSelectedInstallSettings(ClientInstallationSettingObject selectedItem) {
        if (selectedItem != null) {
            this.installSettings = selectedItem;
        }
    }

    public ClientInstallationSettingObject getSelectedInstallSettings() {
        return this.installSettings;
    }

    public String getSelectedInstallSettingsName() {
        return this.installSettings.getName();
    }

    public String getSelectedInstallSettingsId() {
        return this.installSettings.getId();
    }

    private boolean isSameTypeLanguagePlatformExisting() {
        if (this.groupObj == null) {
            return false;
        }
        String existLanguage = "";
        String existPlatform = "";
        try {
            Vector listDeploymentEntity;
            SemGroupPolicy groupPolicy = SoftwarePackageHandler.getGroupPolicy(this.groupObj);
            SoftwareDeploymentPolicy swDeploymentPolicy = SoftwarePackageHandler.getSoftwareDeploymentPolicy(groupPolicy);
            if (swDeploymentPolicy != null && (listDeploymentEntity = swDeploymentPolicy.getSoftwareDeploymentEntity()) != null && listDeploymentEntity.size() > 0) {
                for (SoftwareDeploymentEntity entity : listDeploymentEntity) {
                    SoftwarePackage spSelected = this.getSoftwarePackage();
                    SoftwarePackage softwarePackage = SoftwarePackageHandler.getSoftwarePackageFromDeploymentEntity(entity, true);
                    String selectedClientType = AutoUpgradeUtils.getPackageClientTypeValue((SoftwarePackage)spSelected);
                    String existClientType = AutoUpgradeUtils.getPackageClientTypeValue((SoftwarePackage)softwarePackage);
                    existLanguage = softwarePackage.getPackageInfo().getOptPackageLuInfo().getServerLanguage();
                    existPlatform = softwarePackage.getPackageInfo().getOptPlatformType();
                    System.out.println(spSelected.getPackageInfo().getOptPackageLuInfo().getServerLanguage() + ":::" + existLanguage);
                    System.out.println(spSelected.getPackageInfo().getOptPlatformType() + ":::" + existPlatform);
                    System.out.println(selectedClientType + ":::" + existClientType);
                    if (!spSelected.getPackageInfo().getOptPackageLuInfo().getServerLanguage().equals(existLanguage) || !spSelected.getPackageInfo().getOptPlatformType().equals(existPlatform) || !selectedClientType.equals(existClientType)) continue;
                    System.out.println("isSameTypeLanguagePlatformExisting >> Package with same language and platform is existing ");
                    if (this.duplicatedPackageAndEntity == null) {
                        this.duplicatedPackageAndEntity = new Hashtable();
                    }
                    this.duplicatedPackageAndEntity.put("PACKAGE", (ConfigObject)softwarePackage);
                    this.duplicatedPackageAndEntity.put("ENTITY", (ConfigObject)entity);
                    return true;
                }
            }
        }
        catch (Exception e1) {
            ConsoleLogger.log(e1);
        }
        return false;
    }

    private boolean isSaepAndTdadEnabled() {
        boolean saepEnabled = false;
        boolean tdadEnabled = false;
        boolean ntrEnabled = false;
        ClientInstallationFeatures clientInstallationFeatures = this.getClientInstallationFeatureObject();
        if (clientInstallationFeatures != null) {
            Vector enabledFeat = clientInstallationFeatures.getEnabledClientFeatures();
            for (int i = 0; i < enabledFeat.size(); ++i) {
                EnabledClientFeatures enabledClientFeature = (EnabledClientFeatures)enabledFeat.get(i);
                if (Utility.compareVersion((String)enabledClientFeature.getOptMinVersion(), (String)"14.3.5000.0") < 0) continue;
                Vector clientFeatureList = enabledClientFeature.getClientFeature();
                for (int j = 0; j < clientFeatureList.size(); ++j) {
                    ClientFeature clientFeature = (ClientFeature)clientFeatureList.get(j);
                    if (!clientFeature.getOptEnabled().booleanValue()) continue;
                    if (saepEnabled && tdadEnabled) {
                        return true;
                    }
                    if (!saepEnabled && clientFeature.getFeatureName().equalsIgnoreCase("Saep")) {
                        saepEnabled = true;
                        continue;
                    }
                    if (!tdadEnabled && clientFeature.getFeatureName().equalsIgnoreCase("ADDefense")) {
                        tdadEnabled = true;
                        continue;
                    }
                    if (ntrEnabled || !clientFeature.getFeatureName().equalsIgnoreCase("NTR")) continue;
                    ntrEnabled = true;
                }
                break;
            }
        }
        return saepEnabled && tdadEnabled && ntrEnabled;
    }

    private void setFeaturesState() {
        try {
            this.pickFeatLbl.setEnabled(!this.cbxMaintainExistingFtre.isSelected());
            this.getFeatureCombo().setEnabled(!this.cbxMaintainExistingFtre.isSelected());
        }
        catch (Exception e1) {
            ConsoleLogger.log(e1);
        }
    }

    public int getHour(int type) {
        int hour = 0;
        int ampm = -1;
        if (this.hasHour) {
            if (type == this.startTime) {
                hour = this.spStart.getHour();
            } else if (type == this.endTime) {
                hour = this.spTo.getHour();
            }
            if (this.hasAmpm) {
                if (type == this.startTime) {
                    ampm = this.spStart.getAmpm();
                } else if (type == this.endTime) {
                    ampm = this.spTo.getAmpm();
                }
            }
            hour = Utility.convertHourTo_H_Pattern((int)hour, (String)this.hourPattern, (int)ampm);
        }
        return hour;
    }

    public int getMinute(int type) {
        int minute = 0;
        if (this.hasMinute) {
            if (type == this.startTime) {
                minute = this.spStart.getMinute();
            } else if (type == this.endTime) {
                minute = this.spTo.getMinute();
            }
        }
        return minute;
    }

    private int getSecond(int type) {
        int second = 0;
        if (this.hasSecond) {
            if (type == this.startTime) {
                second = this.spStart.getSecond();
            } else if (type == this.endTime) {
                second = this.spTo.getSecond();
            }
        }
        return second;
    }

    private void setStartAndEndTime(DeploymentSchedule deploymentSchedule) {
        Schedule schedule;
        int startHour_H_Pattern = 0;
        int startHour = Utility.convertHourFrom_H_Pattern((int)0, (String)this.hourPattern);
        int startMinute = 0;
        int startSecond = 0;
        int startAmpm = 0;
        Schedule schedule2 = schedule = deploymentSchedule == null ? null : deploymentSchedule.getSchedule();
        if (schedule != null) {
            String startHour_H_PatternStr = schedule.getOptStartHour();
            if (startHour_H_PatternStr != null) {
                startHour_H_Pattern = Integer.parseInt(startHour_H_PatternStr);
            }
            if (this.hasAmpm) {
                startAmpm = Utility.getAmpmFrom_H_Pattern((int)startHour_H_Pattern, (String)this.hourPattern);
            }
            if (this.hasHour) {
                startHour = Utility.convertHourFrom_H_Pattern((int)startHour_H_Pattern, (String)this.hourPattern);
            }
            if (this.hasMinute && schedule.getOptStartMinute() != null) {
                startMinute = schedule.getOptStartMinute();
            }
            if (this.hasSecond && schedule.getOptStartSecond() != null) {
                startSecond = schedule.getOptStartSecond();
            }
        }
        this.spStart.setHour(startHour);
        this.spStart.setMinute(startMinute);
        this.spStart.setSecond(startSecond);
        if (this.hasAmpm) {
            this.spStart.setAmpm(startAmpm);
        }
        int endHour = Utility.convertHourFrom_H_Pattern((int)6, (String)this.hourPattern);
        int endMinute = 0;
        int endSecond = 0;
        int endAmpm = 1;
        int duration = 86340;
        if (deploymentSchedule != null) {
            duration = deploymentSchedule.getOptDuration() == null ? deploymentSchedule.getDefDuration().intValue() : deploymentSchedule.getOptDuration().intValue();
        }
        int diffHours = duration / 3600;
        int remaining = duration - diffHours * 3600;
        int diffMinutes = remaining / 60;
        int diffSeconds = remaining - diffMinutes * 60;
        if (this.hasSecond && (endSecond = startSecond + diffSeconds) >= 60) {
            ++diffMinutes;
            endSecond -= 60;
        }
        if (this.hasMinute && (endMinute = startMinute + diffMinutes) >= 60) {
            ++diffHours;
            endMinute -= 60;
        }
        if (this.hasHour) {
            int endHour_H_Pattern = startHour_H_Pattern + diffHours;
            if (endHour_H_Pattern >= 24) {
                endHour_H_Pattern -= 24;
            }
            endHour = Utility.convertHourFrom_H_Pattern((int)endHour_H_Pattern, (String)this.hourPattern);
            if (this.hasAmpm) {
                endAmpm = Utility.getAmpmFrom_H_Pattern((int)endHour_H_Pattern, (String)this.hourPattern);
            }
        }
        this.spTo.setHour(endHour);
        this.spTo.setMinute(endMinute);
        this.spTo.setSecond(endSecond);
        if (this.hasAmpm) {
            this.spTo.setAmpm(endAmpm);
        }
    }

    public void setusingSbePackage(boolean usingSbePackage) {
        this.usingSbePackage = usingSbePackage;
    }

    public boolean isusingSbePackage() {
        return this.usingSbePackage;
    }

    public SecurityFixContentInfoObject getSecurityFixContentInfoObject() {
        if (this.securityFixBuildNumberComboBox.getSelectedIndex() != -1) {
            return (SecurityFixContentInfoObject)this.securityFixBuildNumberComboBox.getSelectedItem();
        }
        return null;
    }

    private static class PackageListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -7416484721014103003L;

        private PackageListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            UIUtilities.setName((JComponent)component, "clientPage", UIUtilities.ComponentType.COMBOBOX, "PackageNameSelection_" + value.toString());
            return component;
        }
    }
}

