/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.ui.client.ExportPackageSettings;
import com.sygate.scm.console.ui.client.ExportPackageWorkerFacotry;
import com.sygate.scm.console.ui.client.PackageProgressListener;
import com.sygate.scm.console.ui.client.PackageWorker;
import com.sygate.scm.console.ui.client.PackageworkerErrorState;
import com.sygate.scm.console.ui.client.dlg.ClientInstallationWizard;
import com.sygate.scm.console.ui.client.dlg.InstallClientWizardDialog;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.MultiLineMsgBox;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.TimeCounter;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.ZipUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class CreatePackagePanel
extends ClientInstallationWizard
implements PackageProgressListener {
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENTDIALOG = "com.sygate.scm.console.ui.client.dlg.clientdialog";
    private static final int MAX_VALUE_FOR_PACKAGE = 10;
    private static final int MIN_VALUE = 0;
    private ArrayList<ExportPackageSettings> exportPackageSettingList;
    private int export_index = 0;
    private boolean isBothFinished;
    private boolean isCancelled;
    private PackageWorker worker;
    private DescriptionTextArea desc;
    private JProgressBar progressBar;

    public CreatePackagePanel(InstallClientWizardDialog parent, boolean isSMB) {
        super(parent, isSMB);
    }

    @Override
    protected void initialize() {
        this.isBothFinished = false;
        this.isCancelled = false;
        this.desc = new DescriptionTextArea(MSGRES.getString(CLIENTDIALOG, "CreatePackagePanel.description"));
        this.progressBar = new JProgressBar(this.getMinValue(), this.getProgessBarMaximumValue());
    }

    @Override
    protected JPanel getCenterPanel() {
        this.desc.setMargin(new Insets(0, 5, 0, 5));
        this.progressBar.setMinimum(0);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new GridBagLayout());
        centerPanel.add((Component)this.desc, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, insertToLogo, 0, 0));
        centerPanel.add((Component)this.progressBar, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 25, 10, 100), 0, 0));
        centerPanel.add(Box.createGlue(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return centerPanel;
    }

    @Override
    protected String getTitleDescription() {
        return MSGRES.getString(CLIENTDIALOG, "CreatePackagePanel.titleDesc");
    }

    @Override
    protected String getTitle() {
        return MSGRES.getString(CLIENTDIALOG, "CreatePackagePanel.title");
    }

    @Override
    public void setProgressMsg(String title, String msg, boolean bold, boolean enableStopButton, int value) {
        if (value > 0) {
            this.progressBar.setValue(value);
        }
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    @Override
    public void showFinished(boolean isAllDone, String strMessage) {
        if (this.exportPackageSettingList != null && this.export_index < this.exportPackageSettingList.size()) {
            this.exportPackage(this.exportPackageSettingList.get(this.export_index));
        } else {
            this.progressBar.setValue(this.getProgessBarMaximumValue());
            this.getWizard().setCursor(Cursor.getDefaultCursor());
            if (isAllDone) {
                this.desc.setText(strMessage);
                this.getWizard().enableNetxButton(true);
                AjaxSwingCommonUtil.executeOneBasedOnWebConsoleRunning(this::webConsoleUploadPackages, () -> this.getWizard().doNextClicked());
            } else {
                PackageworkerErrorState state = this.worker.getState();
                if (state != null && !state.isFinished()) {
                    MultiLineMsgBox box = new MultiLineMsgBox(Manager.getFrame(), state.getTitle());
                    box.init(state.getMsg(), 50, state.isErrorMsg() ? 0 : 1, -1);
                    AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true);
                    box.show();
                }
                this.desc.setText(MSGRES.getString(CLIENTDIALOG, "CreatePackagePanel.createPackageFailed"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void webConsoleUploadPackages() {
        String exportPath = Utility.getTempDir() + File.separator + Env.getWebConsoleIndex();
        String zipFileName = "setup_" + Env.getWebConsoleIndex() + ".zip";
        Env.setCurrentPackageZipName(zipFileName);
        String zipFilePath = Utility.getTempDir() + File.separator + zipFileName;
        try {
            TimeCounter counter = new TimeCounter();
            counter.start();
            ZipUtil.zipData((int)-1, (String)exportPath, (String)zipFilePath);
            counter.stop();
            System.out.println("Done Zip: " + zipFilePath + ", elapsed time=" + counter.getDuration() + " (" + counter.getDuration() / 1000L + "s)");
        }
        catch (Throwable ex) {
            System.out.println("PackageWorker>> createSingleZip: Error-> Failed to create single zip: " + zipFilePath);
            LoggerUtilities.logException((Throwable)ex);
        }
        finally {
            Utility.deleteDir((String)exportPath);
        }
    }

    @Override
    public int getMaxValue() {
        return 10;
    }

    @Override
    public int getMinValue() {
        return 0;
    }

    @Override
    public int getProgressValue() {
        if (this.progressBar != null) {
            return this.progressBar.getValue() % this.getProgessBarMaximumValue();
        }
        return 0;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void stopInMiddle() {
        if (!this.isBothFinished) {
            if (this.worker != null) {
                this.worker.interrupt();
            }
            this.isCancelled = true;
        }
        this.getWizard().setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void disposeUI() {
    }

    public void exportPackages(ArrayList<ExportPackageSettings> settingList, String exportDir) {
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
            File exportFolder = new File(exportDir + File.separator + Env.getWebConsoleIndex());
            if (exportFolder.exists()) {
                Utility.emptyDir((String)exportFolder.getAbsolutePath(), (boolean)false);
            }
        });
        this.exportPackageSettingList = settingList;
        if (!this.validExportPathAndSpace(exportDir)) {
            return;
        }
        if (this.exportPackageSettingList != null && this.exportPackageSettingList.size() > 0) {
            this.progressBar.setMaximum(this.getProgessBarMaximumValue());
            this.export_index = 0;
            this.exportPackage(this.exportPackageSettingList.get(0));
        }
    }

    private int getProgessBarMaximumValue() {
        if (this.exportPackageSettingList != null && this.exportPackageSettingList.size() > 0) {
            return 10 * this.exportPackageSettingList.size();
        }
        return 10;
    }

    public void exportSepCommunicationUpdaterPackage(ExportPackageSettings setting) {
        this.worker = ExportPackageWorkerFacotry.getInstance().getSepCommunicationExportPackageWorker(setting);
        this.worker.setProgressListener(this);
        ++this.export_index;
        this.worker.begin();
    }

    private void exportPackage(ExportPackageSettings setting) {
        this.worker = ExportPackageWorkerFacotry.getInstance().getExportPackageWorker(setting);
        this.worker.setProgressListener(this);
        ++this.export_index;
        this.worker.begin();
    }

    private boolean validExportPathAndSpace(String exportDir) {
        if (this.exportPackageSettingList != null) {
            long sizeRequired = 0L;
            for (ExportPackageSettings setting : this.exportPackageSettingList) {
                sizeRequired += setting.getExportedPackage().getSize() * 2L;
            }
            try {
                int result = SoftwarePackageObject.checkValidDirAndDiskSpace(exportDir, false, sizeRequired);
                if (result == -1) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(CLIENTDIALOG, "CreatePackagePanel.invalidExportDirectoryMsg"), MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.error"), 0);
                    return false;
                }
                if (result == -2) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(CLIENTDIALOG, "CreatePackagePanel.errorNoDiskSpace"), MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.error"), 0);
                    this.getWizard().dispose();
                    return false;
                }
                return true;
            }
            catch (IOException ex) {
                LoggerUtilities.logException((Throwable)ex);
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.error"), 0);
                this.getWizard().dispose();
                return false;
            }
        }
        return true;
    }
}

