/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.creamtec.ajaxswing.support.FileOpener;
import com.creamtec.sepm.ajaxswing.support.ComponentUtils;
import com.sygate.scm.common.configobject.schema.CommunicationOption;
import com.sygate.scm.common.configobject.schema.InstallationOption;
import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.ClientPackageUtils;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.ui.client.CreateNewPackageWorker;
import com.sygate.scm.console.ui.dlg.SimpleProgressDlg;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.NativeCommandUtilities;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.LinuxPackageFormatHelper;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.MacPackageFormatHelper;
import com.sygate.scm.util.PackageUtil;
import com.sygate.scm.util.SwingWorker;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.ZipUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class CreateNewSoftwareDlg
extends DialogBase
implements FileOpener {
    private static final long serialVersionUID = 1L;
    private JRadioButton jRBSygate = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.symantecAgentPackageLabel"), true);
    private JRadioButton jRBThirdParty = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.3rdPartySoftwarePackageLabel"));
    private JTextField jTFName = new JTextField(new RestrictedPlainDocument(128), "", 40);
    private File uploadedFile;
    private JTextField jTFLocation = new JTextField();
    private JButton jBBrowse = new JButton(UIText.get(257));
    private JTextArea jTADesc = new JTextArea(4, 40);
    private CurrentPackageObject currentPackageObject = new CurrentPackageObject("", "");
    private SimpleProgressDlg dlg = null;
    private boolean newPackageRowAdded = false;

    public CreateNewSoftwareDlg(String title, CurrentPackageObject cpo) {
        super(Manager.getFrame(), title, true);
        this.initialize();
        if (cpo != null) {
            this.initWithSameSetting(cpo);
        }
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public CurrentPackageObject generateCurrentPackageObject() {
        this.currentPackageObject.getSoftwarePackage().setName(this.jTFName.getText().trim());
        this.currentPackageObject.getSoftwarePackage().setOptDescription(this.jTADesc.getText().trim());
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            this.currentPackageObject.setSrcDirectory(this.uploadedFile == null ? "" : this.uploadedFile.getAbsolutePath());
        } else {
            this.currentPackageObject.setSrcDirectory(this.jTFLocation.getText().trim());
        }
        return this.currentPackageObject;
    }

    public void openFile(File file) {
        System.out.println("ajaxswing open file = " + file.getAbsolutePath());
        this.uploadedFile = file;
        this.jTFLocation.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.FileUploaded"));
    }

    private String checkDatandConvert(String sourceDir) {
        File pkgFile = null;
        Object newDir = null;
        System.out.println("CreateNewSoftwareDlg>> checkDatandConvert-> Source dir is..." + sourceDir);
        if (sourceDir != null && !(pkgFile = new File(sourceDir)).isDirectory() && sourceDir.endsWith(ConstantValue.getSupportedpackagefiletypesByIndex((int)2))) {
            File tempNewFile;
            String datext = ConstantValue.getSupportedpackagefiletypesByIndex((int)2);
            String zipext = ConstantValue.getSupportedpackagefiletypesByIndex((int)1);
            String fileName = sourceDir.substring(0, sourceDir.length() - datext.length());
            newDir = fileName + zipext;
            System.out.println("CreateNewSoftwareDlg>> checkDatandConvert-> new Source dir is..." + (String)newDir);
            if (!pkgFile.renameTo(new File((String)newDir)) && !(tempNewFile = new File((String)newDir)).exists()) {
                System.out.println("CreateNewSoftwareDlg>> checkDatandConvert->failed to rename .dat to .zip" + (String)newDir);
                newDir = null;
            }
            this.currentPackageObject.setSrcDirectory((String)newDir);
        }
        if (newDir == null || ((String)newDir).isEmpty()) {
            newDir = sourceDir;
        }
        return newDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isValidate() {
        String errMessage = null;
        System.out.println("OK clicked, validating user selected file or dir...");
        MacPackageFormatHelper macPkgFormatHelper = null;
        try {
            boolean isValid;
            String packageName = this.jTFName.getText().trim();
            if (packageName.length() == 0) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.noEmptyPackageNameMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.error"), 0);
                return false;
            }
            if (this.jTFName.isEnabled() && SoftwarePackageHandler.isPackageNameExisting(packageName)) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.nameExistEnterAnotherNameMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.error"), 0);
                return false;
            }
            String tmpName = "";
            tmpName = AjaxSwingCommonUtil.isAjaxSwingRunning() ? (this.uploadedFile != null ? this.uploadedFile.getAbsolutePath() : "") : this.jTFLocation.getText().trim();
            String newName = "";
            newName = AjaxSwingCommonUtil.isAjaxSwingRunning() ? this.checkDatandConvert(tmpName) : tmpName;
            final String dirName = newName;
            if (!SoftwarePackageObject.isValidDirectory(dirName, true)) {
                if (SoftwarePackageHandler.isPackageOfCorrectFileType(dirName) && new File(dirName).exists()) {
                    System.out.println("CreateNewSoftwareDlg>> isValidate()-> dirName " + dirName + "is validated");
                    if (dirName.endsWith(ConstantValue.getSupportedpackagefiletypesByIndex((int)1))) {
                        final MacPackageFormatHelper pkgFmtHelper = new MacPackageFormatHelper(dirName);
                        if (pkgFmtHelper.isMacZipPackage()) {
                            boolean isValid2 = false;
                            boolean isDisplayMsg = false;
                            final String tmpFileName = CreateNewPackageWorker.generateTempDirForZipPkg(dirName);
                            File tmpFile = new File(tmpFileName);
                            try {
                                SwingWorker worker = new SwingWorker(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public Object construct() {
                                        Integer result = 8;
                                        Object exePath = null;
                                        try {
                                            PackageUtil.cleanDirAndCreateIfReq((String)tmpFileName);
                                            exePath = NativeCommandUtilities.buildConsoleExe("SEPMPackageTool.exe") + File.separator + "SEPMPackageTool.exe";
                                            String pkgName = pkgFmtHelper.getPackageName();
                                            String pathPrefix = pkgName + "/" + pkgFmtHelper.getConfigDirPathWithSeperator() + "/";
                                            String configFile = pathPrefix + "sylink.xml";
                                            String setAidIni = pathPrefix + "setAid.ini";
                                            String setupIni = pathPrefix + "setup.ini";
                                            String[] extract_filter = new String[]{configFile, setAidIni, setupIni};
                                            boolean isUnzipped = PackageUtil.extractFilesFromZipFile((String)dirName, (String)tmpFileName, (String)tmpFileName, (String[])extract_filter, (String)exePath);
                                            System.out.println("result of unzipping the package: " + isUnzipped);
                                            if (isUnzipped) {
                                                result = 1;
                                            }
                                        }
                                        catch (Exception e) {
                                            System.out.println("Exception unzipping package file");
                                            LoggerUtilities.logException((Throwable)e);
                                        }
                                        finally {
                                            if (exePath != null && ((String)exePath).length() > 0) {
                                                Utility.deleteFile((String)exePath);
                                            }
                                        }
                                        return result;
                                    }

                                    public void finished() {
                                        if (CreateNewSoftwareDlg.this.dlg != null) {
                                            CreateNewSoftwareDlg.this.dlg.setCursor(Cursor.getDefaultCursor());
                                            CreateNewSoftwareDlg.this.dlg.dispose();
                                        }
                                    }
                                };
                                worker.start();
                                String heading = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.unzip.package.heading");
                                String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.unzip.package.pleaseWait");
                                this.dlg = new SimpleProgressDlg((Frame)Manager.getFrame(), heading, msg, true);
                                this.dlg.setCursor(Cursor.getPredefinedCursor(3));
                                this.dlg.setVisible(true);
                                Integer result = (Integer)worker.get();
                                if (!Integer.valueOf(1).equals(result)) {
                                    throw new RuntimeException("Error unzipping package");
                                }
                                File mpkgDir = null;
                                File[] files = tmpFile.listFiles();
                                if (files != null) {
                                    for (File file : files) {
                                        if (file == null || !file.isDirectory()) continue;
                                        mpkgDir = file;
                                    }
                                }
                                if (mpkgDir == null) {
                                    throw new ConsoleException(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "SoftwarePackageObject.generalerror.LongFolderPath"));
                                }
                                isValid2 = SoftwarePackageObject.isValidPackage(mpkgDir.getAbsolutePath(), this.currentPackageObject.getSoftwarePackageObject(), pkgFmtHelper, true);
                                if (isValid2 && !"Mac".equals(this.currentPackageObject.getPackagePlatformString())) {
                                    isValid2 = false;
                                    isDisplayMsg = true;
                                }
                            }
                            catch (ConsoleException cone) {
                                isValid2 = false;
                                isDisplayMsg = true;
                                errMessage = cone.getMessage();
                            }
                            catch (Exception e) {
                                isValid2 = false;
                                isDisplayMsg = true;
                                errMessage = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "SoftwarePackageObject.generalerror.ZipFileError");
                            }
                            finally {
                                if (!isValid2 && tmpFile.exists()) {
                                    Utility.deleteDir((String)tmpFileName);
                                }
                            }
                            if (isDisplayMsg) {
                                JOptionPane.showMessageDialog(this, errMessage, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.error"), 0);
                            }
                            return isValid2;
                        }
                        boolean isValid3 = true;
                        boolean isDisplayMsg = false;
                        LinuxPackageFormatHelper linuxPkgFmtHelper = new LinuxPackageFormatHelper(dirName);
                        if (linuxPkgFmtHelper.isLinuxPackage()) {
                            System.out.println("CreateNewSoftwareDlg>> isValidate()-> dirName " + dirName + " is linux zip.");
                        } else {
                            System.out.println("CreateNewSoftwareDlg>> isValidate()-> dirName " + dirName + " is windows zip.");
                        }
                        final String tmpFileName = CreateNewPackageWorker.generateTempDirForZipPkg(dirName);
                        File tmpFile = new File(tmpFileName);
                        System.out.println("CreateNewSoftwareDlg>> isValidate()-> CreateNewPackageWorker.generateTempDirForZipPkg(). tmpFileName is " + tmpFileName);
                        boolean isUnzipPackageFailed = false;
                        try {
                            SwingWorker worker = new SwingWorker(){

                                public Object construct() {
                                    Integer result = 8;
                                    try {
                                        PackageUtil.cleanDirAndCreateIfReq((String)tmpFileName);
                                        boolean isUnzipped = ZipUtil.unzipFile((String)dirName, (String)tmpFileName);
                                        System.out.println("result of unzipping the package: " + isUnzipped);
                                        if (isUnzipped) {
                                            result = 1;
                                        }
                                    }
                                    catch (Exception e) {
                                        System.out.println("Exception unzipping package file");
                                        LoggerUtilities.logException((Throwable)e);
                                    }
                                    return result;
                                }

                                public void finished() {
                                    if (CreateNewSoftwareDlg.this.dlg != null) {
                                        CreateNewSoftwareDlg.this.dlg.setCursor(Cursor.getDefaultCursor());
                                        CreateNewSoftwareDlg.this.dlg.dispose();
                                    }
                                }
                            };
                            worker.start();
                            String heading = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.unzip.package.heading");
                            String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.unzip.package.pleaseWait");
                            this.dlg = new SimpleProgressDlg((Frame)Manager.getFrame(), heading, msg, true);
                            this.dlg.setCursor(Cursor.getPredefinedCursor(3));
                            this.dlg.setVisible(true);
                            Integer result = (Integer)worker.get();
                            if (!Integer.valueOf(1).equals(result)) {
                                isUnzipPackageFailed = true;
                                throw new RuntimeException("Error unzipping package");
                            }
                            isValid3 = SoftwarePackageObject.isValidPackage(tmpFileName, this.currentPackageObject.getSoftwarePackageObject(), null, true);
                            if (linuxPkgFmtHelper.isLinuxPackage() && isValid3 && !ConstantValue.isLinuxPlatform((String)this.currentPackageObject.getPackagePlatformString())) {
                                isValid3 = false;
                                isDisplayMsg = true;
                            }
                        }
                        catch (Exception e) {
                            isValid3 = false;
                            isDisplayMsg = true;
                        }
                        finally {
                            if (!isValid3 && tmpFile.exists()) {
                                Utility.deleteDir((String)tmpFileName);
                            }
                        }
                        if (isDisplayMsg) {
                            String msg = null;
                            msg = isUnzipPackageFailed ? MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "SoftwarePackageObject.generalerror.InvalidZipFile") : (linuxPkgFmtHelper.isLinuxPackage() ? MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "SoftwarePackageObject.generalerror.LinuxZipFileError") : MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "SoftwarePackageObject.generalerror.ZipFileError"));
                            JOptionPane.showMessageDialog(this, msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.error"), 0);
                        }
                        return isValid3;
                    }
                    String packageZipFile = SoftwarePackageHandler.getZipFile(dirName);
                    if (packageZipFile != null) {
                        return true;
                    }
                    JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.packageNotExistEnterValidSourceMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.error"), 0);
                    return false;
                }
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.packageNotExistEnterValidSourceMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.error"), 0);
                return false;
            }
            SoftwarePackageObject spo = this.currentPackageObject.getSoftwarePackageObject();
            if (macPkgFormatHelper == null) {
                macPkgFormatHelper = new MacPackageFormatHelper(dirName);
            }
            if ((isValid = SoftwarePackageObject.isValidPackage(dirName, spo, macPkgFormatHelper)) && "Mac".equals(this.currentPackageObject.getPackagePlatformString()) && ConstantValue.isMacPackageOfZipFormatType((int)spo.getType())) {
                String msg = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "SoftwarePackageObject.generalerror.mpkgFileError");
                JOptionPane.showMessageDialog(this, msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.error"), 0);
                return false;
            }
            System.out.println("OK clicked, validating user selected file or dir...done.");
            return isValid;
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.error"), 0);
            if (ex.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            }
            return true;
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_install_packages_dialog_add_package";
    }

    private void initialize() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.getPackagePanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(20, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jTFName.setEnabled(false);
        this.pack();
    }

    private JPanel getPackagePanel() {
        RestrictedPlainDocument doc = new RestrictedPlainDocument(128);
        doc.setValidator("\"/\\*?<>|:", false);
        this.jTFName.setDocument(doc);
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            ComponentUtils.setFileOpener((JComponent)this.jBBrowse, (FileOpener)this);
        }
        this.jBBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateNewSoftwareDlg.this.btnBrowseActionPerformed();
            }
        });
        RestrictedPlainDocument descDoc = new RestrictedPlainDocument(1024);
        this.jTADesc.setDocument(descDoc);
        JScrollPane jScrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)jScrollPane, (JTextArea)this.jTADesc);
        this.jTADesc.setWrapStyleWord(true);
        this.jTADesc.setLineWrap(true);
        doc = new RestrictedPlainDocument(260);
        doc.setValidator("\"/*?<>|", false);
        this.jTFLocation.setDocument(doc);
        JPanel panel = new JPanel(new GridBagLayout());
        int row = 0;
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.specifySourceDirectoryLabel")), new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        panel.add((Component)this.jTFLocation, new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.jBBrowse, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.specifyNameLabel")), new GridBagConstraints(0, ++row, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.jTFName, new GridBagConstraints(0, ++row, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.descriptionLabel")), new GridBagConstraints(0, ++row, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        panel.add((Component)jScrollPane, new GridBagConstraints(0, ++row, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 10, 5), 0, 0));
        return panel;
    }

    private void btnBrowseActionPerformed() {
        JFileChooser fc = new JFileChooser();
        fc.putClientProperty("ajaxswing.browseClient", true);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                    return SoftwarePackageHandler.isPackageOfCorrectFileType(f.getName().toLowerCase()) || f.getName().equalsIgnoreCase("setup.exe");
                }
                return f.isDirectory() || SoftwarePackageHandler.isPackageOfCorrectFileType(f.getName().toLowerCase()) && !f.getName().toLowerCase().endsWith(".dat") || f.getName().equalsIgnoreCase("setup.exe");
            }

            @Override
            public String getDescription() {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.infoFileDesc");
            }
        });
        fc.setApproveButtonText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.browseDialogButtonText"));
        fc.setDialogTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.browseDialogTitle"));
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            fc.setFileSelectionMode(0);
        } else {
            fc.setFileSelectionMode(2);
            fc.setAcceptAllFileFilterUsed(false);
        }
        if (0 != fc.showOpenDialog(this)) {
            return;
        }
        File selectFile = fc.getSelectedFile();
        if (selectFile == null) {
            return;
        }
        String path = selectFile.getAbsolutePath();
        if (path.toLowerCase().endsWith("setup.exe") && selectFile.isFile()) {
            path = path.substring(0, path.length() - 10);
        }
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            this.uploadedFile = selectFile;
            this.jTFLocation.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.FileUploaded"));
        } else {
            this.jTFLocation.setText(path);
        }
        this.updatePackageNameStatus(path);
    }

    private void updatePackageNameStatus(String dirName) {
        this.jTFName.setEnabled(true);
        this.newPackageRowAdded = true;
        String packagePath = dirName;
        if (dirName.endsWith(ConstantValue.getSupportedpackagefiletypesByIndex((int)0))) {
            packagePath = SoftwarePackageHandler.getZipFile(dirName);
        }
        try {
            ClientPackageUtils.SetAidIni setAidIni = new ClientPackageUtils.SetAidIni(packagePath);
            SoftwarePackage existingSecurityFixPkg = SoftwarePackageHandler.getSecurityFixSoftwarePackageByPVL(setAidIni);
            if (existingSecurityFixPkg != null && !Boolean.TRUE.equals(existingSecurityFixPkg.getOptSuspended())) {
                String packageName = existingSecurityFixPkg.getName();
                ConsoleLogger.log("updatePackageNameStatus>> It's a SecurityFix Content Package, use existing package name: " + packageName);
                this.jTFName.setEnabled(false);
                this.jTFName.setText(packageName);
                this.newPackageRowAdded = false;
            }
        }
        catch (RuntimeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            ConsoleLogger.log("updatePackageNameStatus>> Exception: " + exc.getMessage());
        }
    }

    private void initWithSameSetting(CurrentPackageObject cpo) {
        CommunicationOption com;
        InstallationOption io = cpo.cloneInstallationOption();
        if (io != null) {
            this.currentPackageObject.setInstallationOption(io);
        }
        if ((com = cpo.cloneCommunicationOption()) != null) {
            this.currentPackageObject.setCommunicationOption(com);
        }
        this.jRBSygate.setSelected(true);
        this.jRBSygate.setEnabled(false);
        this.jRBThirdParty.setEnabled(false);
    }

    public boolean isNewPackageRowAdded() {
        return this.newPackageRowAdded;
    }
}

