/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.LanDeviceExcludedHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.ClientObject;
import com.sygate.scm.console.logicobject.LanDeviceExcludedObject;
import com.sygate.scm.console.ui.client.dlg.AddLanSensorDlg;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.UIText;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class ConfigLanSensorDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private LanSensorTableModel model;
    private JTable jTSensor;
    private JButton jBAdd;
    private JButton jBRemove;
    private String clientHash;
    private ArrayList<LanDeviceExcludedObject> lanDevices;

    public ConfigLanSensorDlg(ClientObject client) {
        block3: {
            super(Manager.getFrame(), "", true);
            this.model = new LanSensorTableModel();
            this.jTSensor = new StripesTable(this.model);
            this.jBAdd = new JButton(UIText.get(5));
            this.jBRemove = new JButton(UIText.get(4354));
            Object[] obj = new Object[]{client.getName()};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ConfigLanSensorDlg.exclusionSettingsForLanSensor0Title");
            String fm = MessageFormat.format(str, obj);
            super.setTitle(fm);
            this.initialize();
            this.clientHash = client.getHash();
            try {
                this.lanDevices = LanDeviceExcludedHandler.getListByHash(this.clientHash);
                this.model.reset(this.lanDevices);
            }
            catch (ConsoleException ex) {
                System.err.println("ConfigLanSensorDlg->Constructor: Can't get LanDeviceExcluded list.");
                if (this.lanDevices == null) break block3;
                this.lanDevices.clear();
            }
        }
        if (client.getGroupObject().getAccessConstraint(true) == 2) {
            this.setReadOnly();
        }
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    @Override
    protected boolean ok() {
        if (super.ok()) {
            this.dispose();
        }
        return true;
    }

    @Override
    protected void commit() {
        ArrayList<LanDeviceExcludedObject> modelData = this.model.getModelData();
        for (LanDeviceExcludedObject device : new ArrayList<LanDeviceExcludedObject>(modelData)) {
            if (!this.lanDevices.contains(device)) continue;
            this.lanDevices.remove(device);
            modelData.remove(device);
        }
        try {
            LanDeviceExcludedHandler.add(modelData);
            LanDeviceExcludedHandler.delete(this.lanDevices);
        }
        catch (ConsoleException ex) {
            System.err.println("ConfigLanSensorDlg->ok: can't update LanDeviceExcluded. " + ex.getMessage());
        }
    }

    @Override
    protected void cancel() {
        super.cancel();
        this.dispose();
    }

    private void initialize() {
        Dimension size = this.jTSensor.getPreferredScrollableViewportSize();
        this.jTSensor.setPreferredScrollableViewportSize(new Dimension(size.width * 2 / 3, (this.jTSensor.getRowHeight() + this.jTSensor.getRowMargin()) * 5 * 2));
        this.jTSensor.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ConfigLanSensorDlg.this.jBRemove.setEnabled(ConfigLanSensorDlg.this.jTSensor.isEnabled() && ConfigLanSensorDlg.this.jTSensor.getSelectedRowCount() > 0);
            }
        });
        this.jBAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddLanSensorDlg dlg = new AddLanSensorDlg();
                if (dlg.isOk()) {
                    if (dlg.isIpAddress()) {
                        ConfigLanSensorDlg.this.model.add(new LanDeviceExcludedObject(ConfigLanSensorDlg.this.clientHash, LanDeviceExcludedObject.IP_RANGE_MODE, dlg.getStartAddress(), dlg.getEndAddress()));
                    } else {
                        ConfigLanSensorDlg.this.model.add(new LanDeviceExcludedObject(ConfigLanSensorDlg.this.clientHash, LanDeviceExcludedObject.MAC_ADDRESS_MODE, dlg.getMacAddress()));
                    }
                }
                dlg.dispose();
            }
        });
        this.jBRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigLanSensorDlg.this.model.remove(ConfigLanSensorDlg.this.jTSensor.getSelectedRows());
            }
        });
        JPanel jOperationPanel = new JPanel();
        UIUtilities.layoutButtonPanel(jOperationPanel, new JButton[]{this.jBAdd, this.jBRemove}, 1, 3, true);
        JPanel jTablePanel = new JPanel(new GridBagLayout());
        jTablePanel.setBorder(BorderFactory.createEtchedBorder());
        jTablePanel.add((Component)new JScrollPane(this.jTSensor), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
        jTablePanel.add((Component)jOperationPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 1, 0), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ConfigLanSensorDlg.unknownDeviceDetectionExclusionLabel")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)jTablePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pack();
    }

    private void setReadOnly() {
        this.jTSensor.setEnabled(false);
        this.jBAdd.setEnabled(false);
        this.jBRemove.setEnabled(false);
        this.jBOk.setEnabled(false);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_client_dialog_computers_users_config_lansensor";
    }

    private static class LanSensorTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -3733886200227831653L;
        private ArrayList<LanDeviceExcludedObject> list = new ArrayList();

        private LanSensorTableModel() {
        }

        public void reset(ArrayList<LanDeviceExcludedObject> list) {
            this.list.clear();
            this.list.addAll(list);
        }

        public ArrayList<LanDeviceExcludedObject> getModelData() {
            return this.list;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        public void add(LanDeviceExcludedObject object) {
            this.list.add(object);
            this.fireTableDataChanged();
        }

        public void remove(int[] indices) {
            int i = indices.length;
            while (--i >= 0) {
                this.list.remove(indices[i]);
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ConfigLanSensorDlg.IPRange");
            }
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ConfigLanSensorDlg.MACAddress");
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            LanDeviceExcludedObject item = this.list.get(rowIndex);
            if (columnIndex == 0) {
                return item.getDisplayIpAddress();
            }
            return item.getMacAddress();
        }
    }
}

