/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.SemAgentHandler;
import com.sygate.scm.console.handler.SemHostHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.AgentObject;
import com.sygate.scm.console.logicobject.ClientObject;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.ui.util.renderer.JLabelCellRenderer;
import com.sygate.scm.console.util.ConsoleException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ClientPropsUserInfoPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static final String[] COL_NAMES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsUserInfoPanel.typeCName")};
    private JTextField jTFFullName = new InfoTextField();
    private JTextField jTFEmailAddress = new InfoTextField();
    private JTextField jTFJobTitle = new InfoTextField();
    private JTextField jTFDepartment = new InfoTextField();
    private JTextField jTFEmployeeNumber = new InfoTextField();
    private JTextField jTFEmployeeContractor = new InfoTextField();
    private JTextField jTFOfficePhone = new InfoTextField();
    private JTextField jTFMobilePhone = new InfoTextField();
    private JTextField jTFHomePhone = new InfoTextField();
    private SortableTableModel agentModel = new SortableTableModel();
    private JTable jTAgent = new StripesTable(this.agentModel, false, false);
    private ArrayList<AgentObject> agentList;

    public ClientPropsUserInfoPanel() {
        this.initialize();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_client_dialog_computers_users_client_properties_userinfo";
    }

    public void init(ClientObject client) throws ConsoleException {
        if (client == null) {
            return;
        }
        if (SemHostHandler.retrieveHostObject(client, false) == null) {
            return;
        }
        this.agentList = SemAgentHandler.getAgentsByClient(client, 0, Integer.MAX_VALUE);
        if (this.agentList != null && this.agentList.size() > 0) {
            for (int i = 0; i < this.agentList.size(); ++i) {
                AgentObject agent = this.agentList.get(i);
                agent.getSemAgent().setOptStatus(Integer.valueOf(client.getOnlineStatusEx() == 0 ? 0 : 1));
                this.agentModel.addRow(agent);
            }
            this.jTAgent.getSelectionModel().setSelectionInterval(0, 0);
        } else {
            this.tableSelectionChanged();
        }
    }

    private void initialize() {
        this.agentModel.setColumnNames(COL_NAMES);
        this.agentModel.setEditMode(false);
        Dimension size = this.jTAgent.getPreferredScrollableViewportSize();
        this.jTAgent.setPreferredScrollableViewportSize(new Dimension(size.width * 2 / 3, (this.jTAgent.getRowHeight() + this.jTAgent.getRowMargin()) * 5));
        this.jTAgent.getColumnModel().getColumn(0).setCellRenderer(new JLabelCellRenderer());
        ListSelectionModel listSelectionModel = this.jTAgent.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ClientPropsUserInfoPanel.this.tableSelectionChanged();
                }
            }
        });
        listSelectionModel.setSelectionMode(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsUserInfoPanel.infoEnteredByUserLabel")), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 20, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsUserInfoPanel.fullNameLabel")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFFullName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsUserInfoPanel.emailAddressLabel")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFEmailAddress, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsUserInfoPanel.jobTitleLabel")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFJobTitle, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsUserInfoPanel.departmentLabel")), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFDepartment, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsUserInfoPanel.employeeNumberLabel")), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFEmployeeNumber, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsUserInfoPanel.employmentStatusLabel")), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFEmployeeContractor, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsUserInfoPanel.officePhoneNumberLabel")), new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFOfficePhone, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsUserInfoPanel.mobilePhoneNumberLabel")), new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFMobilePhone, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsUserInfoPanel.homePhoneNumberLabel")), new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFHomePhone, new GridBagConstraints(1, 9, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsUserInfoPanel.agentLabel")), new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        JScrollPane spane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)spane, (JTable)this.jTAgent);
        spane.setMinimumSize(spane.getPreferredSize());
        panel.add((Component)spane, new GridBagConstraints(1, 10, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.setLayout(new VerticalFlowLayout());
        this.add(panel);
    }

    private void tableSelectionChanged() {
        int selIndex = this.jTAgent.getSelectedRow();
        if (selIndex == -1) {
            return;
        }
        AgentObject agent = this.agentList.get(selIndex);
        this.jTFFullName.setText(agent.getUserInfoFullName());
        this.jTFEmailAddress.setText(agent.getUserInfoEmail());
        this.jTFJobTitle.setText(agent.getUserInfoJobTitle());
        this.jTFDepartment.setText(agent.getUserInfoDepartment());
        this.jTFEmployeeNumber.setText(agent.getUserInfoEmployeeNumber());
        this.jTFEmployeeContractor.setText(agent.getUserInfoEmploymentStatus());
        this.jTFOfficePhone.setText(agent.getUserInfoOfficePhone());
        this.jTFMobilePhone.setText(agent.getUserInfoMobilePhone());
        this.jTFHomePhone.setText(agent.getUserInfoHomePhone());
    }

    private static class InfoTextField
    extends JTextField {
        private static final long serialVersionUID = 1L;

        public InfoTextField() {
            this.setEditable(false);
        }
    }
}

