/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.SemAgentHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.AgentObject;
import com.sygate.scm.console.logicobject.ClientObject;
import com.sygate.scm.console.logicobject.HostIpObject;
import com.sygate.scm.console.logicobject.HostObject;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.ui.util.renderer.IPv6CellRenderer;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;

public class ClientPropsNetworkPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static final String[] COL_NAMES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsNetworkPanel.IPAddressCName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsNetworkPanel.MacAddressCName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsNetworkPanel.defaultGatewayCName")};
    private SortableTableModel model = new SortableTableModel();
    private JTable jTIp = new StripesTable(this.model, false, false);
    private JTextField jTFLastConnectedIP = new JTextField();
    private JTextField jTFDhcp = new JTextField();
    private DefaultListModel<String> dnsModel = new DefaultListModel();
    private JList<String> jLDns = new JList<String>(this.dnsModel);
    private DefaultListModel<String> winsModel = new DefaultListModel();
    private JList<String> jLWins = new JList<String>(this.winsModel);

    public ClientPropsNetworkPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ConsoleLogger.log(ex);
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_client_dialog_computers_users_client_properties_network";
    }

    public void init(ClientObject client, HostObject host) throws ConsoleException {
        if (host == null) {
            return;
        }
        this.jTFLastConnectedIP.setText(Utilities.shortenIpv6Address(this.getLastConnectedIpAddr(client, host)));
        this.jTFDhcp.setText(Utilities.shortenIpv6Address(host.getDhcpServer()));
        if (host.getDnsServer1() != null && host.getDnsServer1().length() > 0) {
            this.dnsModel.addElement(Utilities.shortenIpv6Address(host.getDnsServer1()));
        }
        if (host.getDnsServer2() != null && host.getDnsServer2().length() > 0) {
            this.dnsModel.addElement(Utilities.shortenIpv6Address(host.getDnsServer2()));
        }
        if (host.getWinsServer1() != null && host.getWinsServer1().length() > 0) {
            this.winsModel.addElement(Utilities.shortenIpv6Address(host.getWinsServer1()));
        }
        if (host.getWinsServer2() != null && host.getWinsServer2().length() > 0) {
            this.winsModel.addElement(Utilities.shortenIpv6Address(host.getWinsServer2()));
        }
        this.setupIpTable(host);
    }

    private void jbInit() throws Exception {
        this.model.setColumnNames(COL_NAMES);
        this.model.setEditMode(false);
        this.model.addMouseListenerToHeaderInTable(this.jTIp);
        Dimension size = this.jTIp.getPreferredScrollableViewportSize();
        this.jTIp.setPreferredScrollableViewportSize(new Dimension(size.width * 2 / 3, (this.jTIp.getRowHeight() + this.jTIp.getRowMargin()) * 5 * 2));
        this.setCellRendererToTableColumns();
        this.jTFLastConnectedIP.setEditable(false);
        this.jTFDhcp.setEditable(false);
        this.jLDns.setVisibleRowCount(5);
        this.jLWins.setVisibleRowCount(5);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsNetworkPanel.lastConnectedIPLabel")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFLastConnectedIP, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsNetworkPanel.dhcpServerLabel")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFDhcp, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsNetworkPanel.dnsServerLabel")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        JScrollPane spane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)spane, this.jLDns);
        spane.setMinimumSize(spane.getPreferredSize());
        panel.add((Component)spane, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsNetworkPanel.winsServerLabel")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        spane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)spane, this.jLWins);
        spane.setMinimumSize(spane.getPreferredSize());
        panel.add((Component)spane, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsNetworkPanel.addressLabel")), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        spane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)spane, (JTable)this.jTIp);
        spane.setMinimumSize(spane.getPreferredSize());
        panel.add((Component)spane, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.setLayout(new VerticalFlowLayout());
        this.add(panel);
    }

    private void setCellRendererToTableColumns() {
        Enumeration<TableColumn> columns = this.jTIp.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            Object valueObj = column.getHeaderValue();
            if (!(valueObj instanceof String) || !COL_NAMES[0].equals((String)valueObj) && !COL_NAMES[2].equals((String)valueObj)) continue;
            column.setCellRenderer(new IPv6CellRenderer());
        }
    }

    private void setupIpTable(HostObject host) throws ConsoleException {
        int len = this.model.getRowCount();
        for (int i = len - 1; i >= 0; --i) {
            this.model.removeRow(i);
        }
        List<HostIpObject> list = host.getNicIpList();
        if (list != null) {
            len = list.size();
            for (int i = 0; i < len; ++i) {
                HostIpObject ip = list.get(i);
                this.model.addRow(ip);
            }
        }
    }

    private String getLastConnectedIpAddr(ClientObject client, HostObject host) {
        String lastConnectedIp = "";
        if (client == null || host == null) {
            return "";
        }
        try {
            ArrayList<AgentObject> listAgentObjs = SemAgentHandler.getAgentsByClient(client, 0, Integer.MAX_VALUE);
            for (int i = 0; listAgentObjs != null && i < listAgentObjs.size(); ++i) {
                AgentObject tempAgent = listAgentObjs.get(i);
                if (!tempAgent.getComputerId().equals(host.getSemComputer().getComputerId())) continue;
                byte[] ipAddress = tempAgent.getSemAgent().getOptLastConnectedIpAddr();
                if (ipAddress != null && (ipAddress.length == 4 || ipAddress.length == 16)) {
                    lastConnectedIp = Utility.getIpAddressLiteral((byte[])ipAddress);
                }
                break;
            }
        }
        catch (ConsoleException ex) {
            ConsoleLogger.log(ex);
        }
        return lastConnectedIp;
    }
}

