/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.SemComputerHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.ClientObject;
import com.sygate.scm.console.logicobject.HostObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ClientPropsGeneralPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static final int WRITE_FILTER_DISABLED = 0;
    private static final int WRITE_FILTER_ENABLED = 1;
    private static final int WRITE_FILTER_NOT_INSTALLED = 2;
    private static final int WRITE_FILTER_NOT_REPORTING = 127;
    private JLabel jLComputerUser = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.logonUserNameLabel"));
    private JLabel jLComputerComputer = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.computerNameLabel"));
    private JLabel jLUserUser = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.userNameLabel"));
    private JLabel jLUserComputer = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.logonComputerName"));
    private JTextArea jTADesc = new JTextArea(new RestrictedPlainDocument(256), "", 3, 30);
    private JTextField jTFComputerUserName = new InfoTextField();
    private JTextField jTFGroup = new InfoTextField();
    private JTextField jTFDomain = new InfoTextField();
    private JTextField jTFProcessor = new InfoTextField();
    private JTextField jTFMemory = new InfoTextField();
    private JTextField jTFBiosVersion = new InfoTextField();
    private JTextField jTFBiosSN = new InfoTextField();
    private JTextField jTFVirtualizationHost = new InfoTextField();
    private JTextField jTFOperatingSystem = new InfoTextField();
    private JTextField jTFKernel = new InfoTextField();
    private JTextField jTFUniqueId = new InfoTextField();
    private JTextField jTFHardwareKey = new InfoTextField();
    private JTextField jTFUUID = new InfoTextField();
    private JTextField jTFComputerComputerName = new InfoTextField();
    private JTextField jTFComputerDescription = new InfoTextField();
    private JTextField jTFUserUserName = new InfoTextField();
    private JTextField jTFUserComputerName = new InfoTextField();
    private JTextField jTFServicePack = new InfoTextField();
    private JTextField jTFTpmDevice = new InfoTextField();
    private JTextField osLangField = new InfoTextField();
    private JTextField diskSpaceField = new InfoTextField();
    private JTextField gupField = new InfoTextField();
    private JTextField jTFDeployStatus = new InfoTextField();
    private JTextField jTFDeployMsg = new InfoTextField();
    private JTextField jTFDeployTargetVersion = new InfoTextField();
    private JTextField jTFDeployRunningVersion = new InfoTextField();
    private JTextField jTFDeployTimestamp = new InfoTextField();
    private JTextField jTFInstallType = new InfoTextField();
    private JTextField jTFWriteFilters = new InfoTextField();

    public ClientPropsGeneralPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_client_dialog_computers_users_client_properties_general";
    }

    public String getDescription() {
        return this.jTADesc.getText().trim();
    }

    public void init(ClientObject client, HostObject host) throws ConsoleException {
        if (client.isComputerMode()) {
            this.initShowGuiForComputer(client);
        } else {
            this.initShowGuiForUser(client);
        }
        this.jTFGroup.setText(GroupHandler.getGroupFullPath(client.getGroupId()));
        this.jTFDomain.setText(client.getDomainName());
        this.jTFUniqueId.setText(client.getId());
        this.jTFHardwareKey.setText(client.getHardwareKey());
        this.jTADesc.setText(client.getDescription());
        if (host != null && host.getSemComputer() != null) {
            this.jTFUUID.setText(host.getSemComputer().getOptUUID());
        }
        this.initHostInfo(host);
        if (SemComputerHandler.retrieveGUPStatusByComputerId(client.getComputerId())) {
            this.gupField.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "TableCriteriaList.GupTypeTrue"));
        } else {
            this.gupField.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "TableCriteriaList.GupTypeFalse"));
        }
        System.out.println("ClientPropsGeneralPanel>> init: Creator=" + client.getCreator() + ", id=" + client.getId());
    }

    public void setReadOnly() {
        this.jTADesc.setEnabled(false);
    }

    private void jbInit() throws Exception {
        JPanel panel = new JPanel(new GridBagLayout());
        int row = 0;
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.descriptionLabel")), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        JScrollPane scrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scrollPane, (JTextArea)this.jTADesc);
        panel.add((Component)scrollPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jLComputerComputer, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFComputerComputerName, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jLComputerUser, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFComputerUserName, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jLUserUser, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFUserUserName, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jLUserComputer, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFUserComputerName, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.groupLabel")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFGroup, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.domainOrWorkgroupLabel")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFDomain, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.computerDescriptionLabel")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFComputerDescription, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.processorLabel")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 10), 0, 0));
        panel.add((Component)this.jTFProcessor, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.memoryLabel")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 10), 0, 0));
        panel.add((Component)this.jTFMemory, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.BIOSVersionLabel")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 10), 0, 0));
        panel.add((Component)this.jTFBiosVersion, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.operatingSystemLabel")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFOperatingSystem, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.kernelLabel")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFKernel, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.servicePackLabel")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFServicePack, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.TPMDeviceLabel")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFTpmDevice, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.uniqueIDLabel")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFUniqueId, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.hardwareKeyLabel")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFHardwareKey, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.UUID")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFUUID, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.osLangLabel")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.osLangField, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.diskSpaceLabel")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.diskSpaceField, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        if (!LicenseObject.getInstance().isSBProduct()) {
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.gupLabel")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.gupField, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        }
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.deployStatusLabel")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFDeployStatus, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.deployMessageLabel")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFDeployMsg, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.deployTargetVersionLabel")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFDeployTargetVersion, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.deployRunningVersionLabel")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFDeployRunningVersion, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.deployTimestampLabel")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFDeployTimestamp, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.virtualizationHostLabel")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFVirtualizationHost, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.snName")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFBiosSN, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.installTypeLabel")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFInstallType, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.writeFiltersLabel")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFWriteFilters, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.setLayout(new VerticalFlowLayout());
        this.add(panel);
    }

    private void initHostInfo(HostObject host) {
        if (host == null) {
            return;
        }
        this.jTFComputerDescription.setText(host.getComputerDescription());
        this.jTFProcessor.setText(host.getProcessorDisplayString());
        this.jTFMemory.setText(host.getMemoryDisplayString());
        this.jTFBiosVersion.setText(host.getBiosVersionDisplayString());
        this.jTFVirtualizationHost.setText(host.getVirtualizationHostDisplayString());
        this.jTFOperatingSystem.setText(host.getL10nOperatingSystem());
        this.jTFKernel.setText(host.getKernel());
        this.osLangField.setText(host.getOSLanguage());
        this.jTFServicePack.setText(host.getServicePack());
        this.jTFTpmDevice.setText(host.getTpmDeviceDisplayString());
        this.diskSpaceField.setText(host.getDiskTotalDisplayString());
        this.jTFBiosSN.setText(host.getBiosSerialNumberDisplayString());
        Object localizedWriteFiltersStatus = "";
        int ewf = host.getEWFStatus();
        int fbwf = host.getFBWFStatus();
        int uwf = host.getUWFStatus();
        if (ewf == 127 && fbwf == 127 && uwf == 127) {
            localizedWriteFiltersStatus = (String)localizedWriteFiltersStatus + MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.WRITE_FILTER_STATUS_127");
        } else if (ewf == 2 && fbwf == 2 && uwf == 2) {
            localizedWriteFiltersStatus = (String)localizedWriteFiltersStatus + MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.WRITE_FILTER_STATUS_2");
        } else {
            Object localizedEwfStatus = "";
            Object localizedFbwfStatus = "";
            Object localizedUwfStatus = "";
            boolean addDelimiter = false;
            if (ewf == 0 || ewf == 1) {
                localizedEwfStatus = (String)localizedEwfStatus + MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.EWF");
                localizedEwfStatus = (String)localizedEwfStatus + " ";
                localizedEwfStatus = (String)localizedEwfStatus + MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.WRITE_FILTER_STATUS_" + ewf);
                addDelimiter = true;
            }
            if (fbwf == 0 || fbwf == 1) {
                if (addDelimiter) {
                    localizedFbwfStatus = (String)localizedFbwfStatus + "; ";
                }
                localizedFbwfStatus = (String)localizedFbwfStatus + MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.FBWF");
                localizedFbwfStatus = (String)localizedFbwfStatus + " ";
                localizedFbwfStatus = (String)localizedFbwfStatus + MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.WRITE_FILTER_STATUS_" + fbwf);
                addDelimiter = true;
            }
            if (uwf == 0 || uwf == 1) {
                if (addDelimiter) {
                    localizedUwfStatus = (String)localizedUwfStatus + "; ";
                }
                localizedUwfStatus = (String)localizedUwfStatus + MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.UWF");
                localizedUwfStatus = (String)localizedUwfStatus + " ";
                localizedUwfStatus = (String)localizedUwfStatus + MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.WRITE_FILTER_STATUS_" + uwf);
            }
            localizedWriteFiltersStatus = (String)localizedEwfStatus + (String)localizedFbwfStatus + (String)localizedUwfStatus;
        }
        this.jTFWriteFilters.setText((String)localizedWriteFiltersStatus);
    }

    private void initShowGuiForComputer(ClientObject client) {
        this.jLUserUser.setVisible(false);
        this.jTFUserUserName.setVisible(false);
        this.jLUserComputer.setVisible(false);
        this.jTFUserComputerName.setVisible(false);
        this.jTFComputerComputerName.setText(client.getName());
        this.jTFComputerUserName.setText(client.getUserName());
        String localizedDeployStatus = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.DEPLOY_STATUS_" + client.getDeployStatus());
        this.jTFDeployStatus.setText(localizedDeployStatus);
        if (client.getDeployStatus() > 0) {
            this.jTFDeployMsg.setText(client.getDeployMessage());
            this.jTFDeployTargetVersion.setText(client.getDeployTargetVersion());
            this.jTFDeployRunningVersion.setText(client.getDeployRunningVersion());
            this.jTFDeployTimestamp.setText(Utility.getLongDateTimeString((long)client.getDeployTimestamp(), null));
            String localizedInstallType = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.INSTALL_TYPE_" + client.getInstallType());
            this.jTFInstallType.setText(localizedInstallType);
        }
    }

    private void initShowGuiForUser(ClientObject client) {
        this.jLComputerUser.setVisible(false);
        this.jTFComputerUserName.setVisible(false);
        this.jLComputerComputer.setVisible(false);
        this.jTFComputerComputerName.setVisible(false);
        this.jTFUserUserName.setText(client.getName());
        this.jTFUserComputerName.setText(client.getComputerName());
        String localizedDeployStatus = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.DEPLOY_STATUS_" + client.getDeployStatus());
        this.jTFDeployStatus.setText(localizedDeployStatus);
        if (client.getDeployStatus() > 0) {
            this.jTFDeployMsg.setText(client.getDeployMessage());
            this.jTFDeployTargetVersion.setText(client.getDeployTargetVersion());
            this.jTFDeployRunningVersion.setText(client.getDeployRunningVersion());
            this.jTFDeployTimestamp.setText(Utility.getLongDateTimeString((long)client.getDeployTimestamp(), null));
            String localizedInstallType = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsGeneralPanel.INSTALL_TYPE_" + client.getInstallType());
            this.jTFInstallType.setText(localizedInstallType);
        }
    }

    private static class InfoTextField
    extends JTextField {
        private static final long serialVersionUID = 1L;

        public InfoTextField() {
            this.setEditable(false);
        }
    }
}

