/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.LicenseHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SemAgentHandler;
import com.sygate.scm.console.handler.SemHostHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.AgentObject;
import com.sygate.scm.console.logicobject.ClientObject;
import com.sygate.scm.console.logicobject.RevisionObject;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.ui.util.renderer.JLabelCellRenderer;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ClientPropsAgentsPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = -4064938533325789444L;
    private static final int CLIENT_ROW_COUNT = 2;
    private static final String[] COL_NAMES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.typeCName")};
    private JLabel jLHeartbeat = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.heartBeatLabel"));
    private JLabel jLOnlineTime = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.lastOnlineTimeLabel"));
    private JLabel jLSavDef = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.savDefLabel"));
    private JLabel jLTruScanDef = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.truScanDefLabel"));
    private JLabel jLIpsDef = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.ipsDefLabel"));
    private JLabel jLDPDef = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.daDefLabel"));
    private JLabel jLEDRDef = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.edrDefLabel"));
    private JLabel jLSTICDef = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.sticDefLabel"));
    private JLabel jLAMLAVDef = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.AMLAVDefLabel"));
    private JLabel wtrDefLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.WTRDefLabel"));
    private JLabel jLHIStatus = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.hiStatusLabel"));
    private JLabel jLHIReasonDesc = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.hiReasonLabel"));
    private JLabel tdadDefLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.TDADDefLabel"));
    private JLabel webExtDefLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.WebExtDefLabel"));
    private JTextField jTFClientSoftwareVersion = new InfoTextField();
    private JTextField jTFClientSecurtyPatchVersion = new InfoTextField();
    private JTextField jTFProfile = new InfoTextField();
    private JTextField jTFHeartbeatValue = new InfoTextField();
    private JTextField jTFOnlineTime = new InfoTextField();
    private JTextField freeMemoryField = new InfoTextField();
    private JTextField freeHardDriveField = new InfoTextField();
    private JTextField timeZoneField = new InfoTextField();
    private SortableTableModel agentModel = new SortableTableModel();
    private JTable jTAgent = new StripesTable(this.agentModel, false, false);
    private JTextField jTFSavDef = new InfoTextField();
    private JTextField jTFTruScanDef = new InfoTextField();
    private JTextField jTFIpsDef = new InfoTextField();
    private JTextField jTFDPDef = new InfoTextField();
    private JTextField jTFEDRDef = new InfoTextField();
    private JTextField jTFSTICDef = new InfoTextField();
    private JTextField jTFAMLAVDef = new InfoTextField();
    private JTextField jTFPepStatus = new InfoTextField();
    private JTextField jTFHIStatus = new InfoTextField();
    private JTextField jTFHIReason = new InfoTextField();
    private JTextField jTFLBStatus = new InfoTextField();
    private JTextField jTFHidStatus = new InfoTextField();
    private JTextField wtrStatusField = new InfoTextField();
    private JTextField wtrMessageField = new InfoTextField();
    private JTextField oobStatusField = new InfoTextField();
    private JTextField wtrDefField = new InfoTextField();
    private JTextField tdadStatusField = new InfoTextField();
    private JTextField urlOnOffStatusField = new InfoTextField();
    private JTextField tdadDefField = new InfoTextField();
    private JTextField webExtDefField = new InfoTextField();
    private JTextField cidsBrowserIEStatusField = new InfoTextField();
    private JTextField cidsBrowserFFStatusField = new InfoTextField();
    private JTextField cidsBrowserChromeStatusField = new InfoTextField();
    private JTextField acStatusField = new InfoTextField();
    private JTextField dcStatusField = new InfoTextField();
    private JTextField lastScanStartedTime = new InfoTextField();
    private JTextField lastScanCompletedTime = new InfoTextField();
    private ArrayList<AgentObject> listAgentObjs = null;

    public ClientPropsAgentsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_client_dialog_computers_users_client_properties_agents";
    }

    public void init(ClientObject client) throws ConsoleException {
        if (client == null) {
            return;
        }
        if (SemHostHandler.retrieveHostObject(client, false) == null) {
            return;
        }
        this.listAgentObjs = SemAgentHandler.getAgentsByClient(client, 0, Integer.MAX_VALUE);
        if (this.listAgentObjs != null && this.listAgentObjs.size() > 0) {
            this.agentModel.removeAll();
            for (int i = 0; i < this.listAgentObjs.size(); ++i) {
                AgentObject agent = this.listAgentObjs.get(i);
                agent.getSemAgent().setOptStatus(Integer.valueOf(client.getOnlineStatusEx() == 0 ? 0 : 1));
                this.agentModel.addRow(agent);
            }
            if (this.jTAgent.getRowCount() > 0) {
                this.jTAgent.getSelectionModel().setSelectionInterval(0, 0);
            }
        } else {
            this.tableSelectionChanged();
        }
    }

    private void jbInit() throws Exception {
        this.agentModel.setColumnNames(COL_NAMES);
        this.agentModel.setEditMode(false);
        this.jTAgent.getColumnModel().getColumn(0).setCellRenderer(new JLabelCellRenderer());
        Dimension size = this.jTAgent.getPreferredScrollableViewportSize();
        this.jTAgent.setPreferredScrollableViewportSize(new Dimension(size.width * 2 / 3, (this.jTAgent.getRowHeight() + this.jTAgent.getRowMargin()) * 2));
        ListSelectionModel listSelectionModel = this.jTAgent.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ClientPropsAgentsPanel.this.tableSelectionChanged();
                }
            }
        });
        listSelectionModel.setSelectionMode(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.systemInformationLabel")), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 20, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.agentsLabel")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        JScrollPane spane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)spane, (JTable)this.jTAgent);
        spane.setMinimumSize(spane.getPreferredSize());
        panel.add((Component)spane, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.clientSoftwareVersionLabel")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFClientSoftwareVersion, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.clientSecuirtyPatchVersionLabel")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFClientSecurtyPatchVersion, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.profileSerialNumberLabel")), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFProfile, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jLSavDef, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFSavDef, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jLTruScanDef, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFTruScanDef, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jLIpsDef, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFIpsDef, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jLDPDef, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFDPDef, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jLEDRDef, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFEDRDef, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jLSTICDef, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFSTICDef, new GridBagConstraints(1, 11, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        int gridY = 12;
        if (CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId())) {
            panel.add((Component)this.jLAMLAVDef, new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.jTFAMLAVDef, new GridBagConstraints(1, gridY, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            ++gridY;
        }
        panel.add((Component)this.wtrDefLabel, new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.wtrDefField, new GridBagConstraints(1, gridY, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.tdadDefLabel, new GridBagConstraints(0, ++gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.tdadDefField, new GridBagConstraints(1, gridY, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.webExtDefLabel, new GridBagConstraints(0, ++gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.webExtDefField, new GridBagConstraints(1, gridY, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jLHIStatus, new GridBagConstraints(0, ++gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFHIStatus, new GridBagConstraints(1, gridY, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jLHIReasonDesc, new GridBagConstraints(0, ++gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFHIReason, new GridBagConstraints(1, gridY, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jLOnlineTime, new GridBagConstraints(0, ++gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFOnlineTime, new GridBagConstraints(1, gridY, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jLHeartbeat, new GridBagConstraints(0, ++gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFHeartbeatValue, new GridBagConstraints(1, gridY, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.timeZoneLabel")), new GridBagConstraints(0, ++gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.timeZoneField, new GridBagConstraints(1, gridY, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.freeMemoryLabel")), new GridBagConstraints(0, ++gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.freeMemoryField, new GridBagConstraints(1, gridY, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.freeHardDriveLabel")), new GridBagConstraints(0, ++gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.freeHardDriveField, new GridBagConstraints(1, gridY, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        ++gridY;
        if (LicenseHandler.isPEPActivated()) {
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.pepStatusLabel")), new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.jTFPepStatus, new GridBagConstraints(1, gridY, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            ++gridY;
        }
        if (CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId())) {
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.lowbandwidthLabel")), new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.jTFLBStatus, new GridBagConstraints(1, gridY, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            ++gridY;
        }
        if (CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId())) {
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.hidLabel")), new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.jTFHidStatus, new GridBagConstraints(1, gridY, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            ++gridY;
        }
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.wtrStatusLabel")), new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.wtrStatusField, new GridBagConstraints(1, gridY, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.wtrMessageLabel")), new GridBagConstraints(0, ++gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.wtrMessageField, new GridBagConstraints(1, gridY, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        ++gridY;
        if (ScmProperties.isIpsOobFeatureEnabled()) {
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.oobStatusLabel")), new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.oobStatusField, new GridBagConstraints(1, gridY, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            ++gridY;
        }
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.tdadStatusLabel")), new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.tdadStatusField, new GridBagConstraints(1, gridY, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        ++gridY;
        if (ScmProperties.isStarPulseFeatureEnabled()) {
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.urlOnOffLabel")), new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.urlOnOffStatusField, new GridBagConstraints(1, gridY, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            ++gridY;
        }
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.cidsBrowserIEOnOffLabel")), new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.cidsBrowserIEStatusField, new GridBagConstraints(1, gridY, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.cidsBrowserFFOnOffLabel")), new GridBagConstraints(0, ++gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.cidsBrowserFFStatusField, new GridBagConstraints(1, gridY, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.cidsBrowserChromeOnOffLabel")), new GridBagConstraints(0, ++gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.cidsBrowserChromeStatusField, new GridBagConstraints(1, gridY, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.acStatusLabel")), new GridBagConstraints(0, ++gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.acStatusField, new GridBagConstraints(1, gridY, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.dcStatusLabel")), new GridBagConstraints(0, ++gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.dcStatusField, new GridBagConstraints(1, gridY, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.lastScanStartedTimeLabel")), new GridBagConstraints(0, ++gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.lastScanStartedTime, new GridBagConstraints(1, gridY, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.lastScanCompletedTimeLabel")), new GridBagConstraints(0, ++gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.lastScanCompletedTime, new GridBagConstraints(1, gridY, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.setLayout(new VerticalFlowLayout());
        this.add(panel);
    }

    private void tableSelectionChanged() {
        int selIndex = this.jTAgent.getSelectedRow();
        if (selIndex == -1) {
            this.jLOnlineTime.setVisible(false);
            this.jTFOnlineTime.setVisible(false);
            this.jLHeartbeat.setVisible(false);
            this.jTFHeartbeatValue.setVisible(false);
            return;
        }
        if (this.listAgentObjs.size() == 0) {
            return;
        }
        AgentObject agent = this.listAgentObjs.get(selIndex);
        this.jTFClientSoftwareVersion.setText(agent.getSoftwareVersion());
        this.jTFProfile.setText(agent.getProfileDisplayString());
        this.jLOnlineTime.setVisible(true);
        this.jTFOnlineTime.setVisible(true);
        this.jTFOnlineTime.setText(agent.getLastUpdateTimeDisplayString());
        boolean isVisible = agent.getHeartbeat() > 0;
        this.jLHeartbeat.setVisible(isVisible);
        this.jTFHeartbeatValue.setVisible(isVisible);
        this.jTFHeartbeatValue.setText(String.valueOf(agent.getHeartbeat()));
        this.timeZoneField.setText(Utility.getTimeZoneByOffset((int)agent.getTimeZoneOffset()));
        this.freeMemoryField.setText(agent.getFreeMemoryDisplayString());
        this.freeHardDriveField.setText(agent.getFreeHardDriveDisplayString());
        this.jTFPepStatus.setText(agent.getPepStatus());
        this.jTFLBStatus.setText(agent.getLBStatus());
        this.jTFHidStatus.setText(agent.getHidStatus());
        this.wtrStatusField.setText(agent.getWtrStatus());
        this.wtrMessageField.setText(agent.getWtrMessage());
        this.oobStatusField.setText(agent.getIpsOobStatus());
        this.tdadStatusField.setText(agent.getTdadStatus());
        this.urlOnOffStatusField.setText(agent.getUrlOnOffStatus());
        this.cidsBrowserIEStatusField.setText(agent.getCidsBrowserIEOnOffStatus());
        this.cidsBrowserFFStatusField.setText(agent.getCidsBrowserFFOnOffStatus());
        this.cidsBrowserChromeStatusField.setText(agent.getCidsBrowserChromeOnOffStatus());
        try {
            this.jTFClientSecurtyPatchVersion.setText(RevisionObject.convertDbFormatStringToUIFormat(SemAgentHandler.getSecurityPatchDefByAgentId(agent.getAgentId())));
            this.jTFSavDef.setText(RevisionObject.convertDbFormatStringToUIFormat(SemAgentHandler.getSAVDefByAgentId(agent.getAgentId())));
            this.jTFTruScanDef.setText(RevisionObject.convertDbFormatStringToUIFormat(SemAgentHandler.getTruScanDefByAgentObject(agent)));
            String ipsDef = SemAgentHandler.getIPSDefByAgentId(agent.getAgentId());
            Object ipsDefSuffix = "";
            if (ipsDef != null && agent.isIpsServerSigOn()) {
                ipsDefSuffix = " " + MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropsAgentsPanel.IPS_SERVER_SIG_SUFFIX");
            }
            this.jTFIpsDef.setText(RevisionObject.convertDbFormatStringToUIFormat(ipsDef) + (String)ipsDefSuffix);
            this.jTFDPDef.setText(RevisionObject.convertDbFormatStringToUIFormat(SemAgentHandler.getDPDefByAgentId(agent.getAgentId())));
            this.jTFEDRDef.setText(RevisionObject.convertDbFormatStringToUIFormat(SemAgentHandler.getEDRDefByAgentId(agent.getAgentId())));
            this.jTFSTICDef.setText(RevisionObject.convertDbFormatStringToUIFormat(SemAgentHandler.getSTICDefByAgentId(agent.getAgentId())));
            this.jTFAMLAVDef.setText(RevisionObject.convertDbFormatStringToUIFormat(SemAgentHandler.getAMLAVDefByAgentId(agent.getAgentId())));
            this.wtrDefField.setText(RevisionObject.convertDbFormatStringToUIFormat(SemAgentHandler.getWtrDefByAgentId(agent.getAgentId())));
            this.tdadDefField.setText(RevisionObject.convertDbFormatStringToUIFormat(SemAgentHandler.getTdadDefByAgentId(agent.getAgentId())));
            this.webExtDefField.setText(RevisionObject.convertDbFormatStringToUIFormat(SemAgentHandler.getWebExtDefByAgentId(agent.getAgentId())));
            this.jTFHIStatus.setText(agent.getHIStatusString());
            this.jTFHIReason.setText(agent.getHIReasonCodeDescription());
            this.acStatusField.setText(agent.getAcStatus());
            this.dcStatusField.setText(agent.getDcStatus());
            this.lastScanStartedTime.setText(agent.getLastScanTimeDisplayString());
            this.lastScanCompletedTime.setText(agent.getLastScanCompletedTimeDisplayString());
        }
        catch (ConsoleException consoleException) {
            // empty catch block
        }
    }

    private static class InfoTextField
    extends JTextField {
        private static final long serialVersionUID = 1L;

        public InfoTextField() {
            this.setEditable(false);
        }
    }
}

