/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SemClientHandler;
import com.sygate.scm.console.handler.SemHostHandler;
import com.sygate.scm.console.logicobject.ClientObject;
import com.sygate.scm.console.logicobject.HostObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.client.dlg.ClientPropsAgentsPanel;
import com.sygate.scm.console.ui.client.dlg.ClientPropsGeneralPanel;
import com.sygate.scm.console.ui.client.dlg.ClientPropsNetworkPanel;
import com.sygate.scm.console.ui.client.dlg.ClientPropsUserInfoPanel;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;

public class ClientPropertiesDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private ClientPropsGeneralPanel generalPanel = new ClientPropsGeneralPanel();
    private ClientPropsNetworkPanel networkPanel = new ClientPropsNetworkPanel();
    private ClientPropsAgentsPanel agentsPanel = new ClientPropsAgentsPanel();
    private ClientPropsUserInfoPanel userInfoPanel = new ClientPropsUserInfoPanel();
    private ClientObject client = null;
    private JTabbedPane pane = new JTabbedPane();

    public ClientPropertiesDlg(ClientObject client) throws ConsoleException {
        super(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropertiesDlg.clientName"), client.getName()), true);
        this.initialize();
        this.initData(client);
        if (client.getGroupObject().getAccessConstraint(true) == 2) {
            this.setReadOnly();
        }
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    @Override
    protected void commit() {
        block3: {
            String desc = this.generalPanel.getDescription();
            String oldDesc = this.client.getDescription();
            if (!(oldDesc = oldDesc.trim()).equals(desc)) {
                this.client.setDescription(desc);
                try {
                    SemClientHandler.update(this.client);
                    ConsoleLogger.logAdminEvent(8209);
                }
                catch (ConsoleException ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropertiesDlg.error"), 0);
                    this.client.setDescription(oldDesc);
                    if (!ex.needRelogin()) break block3;
                    Manager.getFrame().showLoginPanel();
                }
            }
        }
    }

    private void initialize() {
        this.pane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pane.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.generalPanel), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropertiesDlg.generalTab"));
        this.pane.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.networkPanel), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropertiesDlg.networkTab"));
        this.pane.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.agentsPanel), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropertiesDlg.agentsTab"));
        if (!LicenseObject.getInstance().isSBProduct()) {
            this.pane.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.userInfoPanel), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientPropertiesDlg.userInfoTab"));
        }
        this.getContentPane().add((Component)this.pane, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
    }

    private void initData(ClientObject client) throws ConsoleException {
        this.client = client;
        HostObject host = SemHostHandler.retrieveHostObject(client, false);
        this.generalPanel.init(client, host);
        this.networkPanel.init(client, host);
        this.agentsPanel.init(client);
        this.userInfoPanel.init(client);
    }

    private void setReadOnly() {
        this.generalPanel.setReadOnly();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_compusers_pane_comp_properties";
    }
}

