/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.IPField;
import com.sygate.scm.console.ui.util.IPv6RangePane;
import com.sygate.scm.console.ui.util.IpRangePane;
import com.sygate.scm.console.ui.util.MacField;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class AddLanSensorDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final String NON_VALID_MAC_ADDRESS = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "AddLanSensorDlg.MACAddressNotValidMsg");
    private JRadioButton jRBIpAddress = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "AddLanSensorDlg.excludeDetectionIPMsg"), true);
    private JRadioButton jRBMacAddress = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "AddLanSensorDlg.excludeDetectionMACMsg"));
    private IPField start = new IPField();
    private IPField end = new IPField();
    private MacField mac = new MacField();
    private JPanel ipRangePanel;
    private CardLayout ipRangePanelLayout;
    private IpRangePane ipRangePane;
    private IPv6RangePane ipv6RangePane;
    private static final String IPV_FOUR = "IPV4";
    private static final String IPV_SIX = "IPV6";
    private JComboBox<String> ipVerCombo;
    private static int ID_IP_TYPE_V4 = 0;
    private static final String POLICYDIALOG = "com.sygate.scm.console.ui.policy.dialog.policydialog";
    private static final String[] IP_VERSIONS = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "IPv.four"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "IPv.six")};

    public AddLanSensorDlg() {
        super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "AddLanSensorDlg.addLanSensorDetectionExclusionMsg"), true);
        this.initialize();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public boolean isIpAddress() {
        return this.jRBIpAddress.isSelected();
    }

    public String getStartAddress() {
        if (this.ipVerCombo.getSelectedIndex() == ID_IP_TYPE_V4) {
            return this.ipRangePane.getFromIP();
        }
        return this.ipv6RangePane.getFromIP();
    }

    public String getEndAddress() {
        if (this.ipVerCombo.getSelectedIndex() == ID_IP_TYPE_V4) {
            return this.ipRangePane.getToIP();
        }
        return this.ipv6RangePane.getToIP();
    }

    public String getMacAddress() {
        return this.mac.getText();
    }

    @Override
    protected boolean isValidate() {
        if (this.isIpAddress()) {
            if (this.ipVerCombo.getSelectedIndex() == ID_IP_TYPE_V4) {
                if (!this.ipRangePane.isValidValue()) {
                    String message = this.ipRangePane.getErrorMessage();
                    JOptionPane.showMessageDialog(Manager.getFrame(), message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.title.InvalidIPRange"), 0);
                    this.ipRangePane.requestFocus();
                    return false;
                }
            } else if (!this.ipv6RangePane.isValidValue()) {
                JOptionPane.showMessageDialog(Manager.frame, this.ipv6RangePane.getErrorMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.title.InvalidIPv6Address"), 0);
                this.ipv6RangePane.requestFocus();
                return false;
            }
        } else if (!this.mac.isValid()) {
            JOptionPane.showMessageDialog(this, NON_VALID_MAC_ADDRESS, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "AddLanSensorDlg.error"), 0);
            this.mac.requestFocus();
            return false;
        }
        return true;
    }

    private void initialize() {
        this.start.setPreferredSize(new Dimension(150, 25));
        this.end.setPreferredSize(new Dimension(150, 25));
        this.mac.setPreferredSize(new Dimension(150, 25));
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRBIpAddress);
        group.add(this.jRBMacAddress);
        this.ipVerCombo = new JComboBox<String>(IP_VERSIONS);
        this.ipVerCombo.setSelectedIndex(ID_IP_TYPE_V4);
        this.ipVerCombo.setVisible(true);
        JPanel jMacPanel = new JPanel(new GridBagLayout());
        jMacPanel.setBorder(BorderFactory.createEtchedBorder());
        jMacPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "AddLanSensorDlg.MACAddressLabel")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 0, 0), 0, 0));
        jMacPanel.add((Component)this.mac, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 10, 10), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.jRBIpAddress, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 30, 0, 30), 0, 0));
        this.getContentPane().add(this.ipVerCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 30, 4, 30), 0, 0));
        this.getContentPane().add((Component)this.getIpRangePanel(), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 52, 0, 30), 0, 0));
        this.getContentPane().add((Component)this.jRBMacAddress, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(20, 30, 0, 30), 0, 0));
        this.getContentPane().add((Component)jMacPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 52, 10, 30), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jRBIpAddress.setSelected(true);
        this.updatePanelStatus();
        this.setListener();
        this.pack();
    }

    private JPanel getIpRangePanel() {
        if (this.ipRangePanel == null) {
            this.ipRangePanel = new JPanel();
            this.ipRangePanelLayout = new CardLayout();
            this.ipRangePanel.setLayout(this.ipRangePanelLayout);
            this.ipRangePanel.add((Component)this.getIpv4RangePanel(), IPV_FOUR);
            this.ipRangePanel.add((Component)this.getIPv6RangePane(), IPV_SIX);
        }
        return this.ipRangePanel;
    }

    private JPanel getIpv4RangePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel ipPanel = new JPanel(new BorderLayout());
        panel.add((Component)ipPanel, "North");
        this.ipRangePane = new IpRangePane();
        this.ipRangePane.setBorder(null);
        ipPanel.add((Component)this.ipRangePane, "Center");
        this.ipRangePane.getStartLabel().setPreferredSize(new JLabel(this.ipRangePane.getStartLabel().getText()).getPreferredSize());
        this.ipRangePane.getEndLabel().setPreferredSize(new JLabel(this.ipRangePane.getEndLabel().getText()).getPreferredSize());
        return panel;
    }

    private JPanel getIPv6RangePane() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel ipPanel = new JPanel(new BorderLayout());
        panel.add((Component)ipPanel, "North");
        this.ipv6RangePane = new IPv6RangePane();
        this.ipv6RangePane.setBorder(null);
        ipPanel.add((Component)this.ipv6RangePane, "Center");
        this.ipv6RangePane.getStartLabel().setPreferredSize(new JLabel(this.ipv6RangePane.getStartLabel().getText()).getPreferredSize());
        this.ipv6RangePane.getEndLabel().setPreferredSize(new JLabel(this.ipv6RangePane.getEndLabel().getText()).getPreferredSize());
        return panel;
    }

    private void updatePanelStatus() {
        if (this.jRBIpAddress.isSelected()) {
            this.ipVerCombo.setEnabled(true);
            this.start.setEnabled(true);
            this.end.setEnabled(true);
            this.mac.setEnabled(false);
        } else if (this.jRBMacAddress.isSelected()) {
            this.ipVerCombo.setEnabled(false);
            this.start.setEnabled(false);
            this.end.setEnabled(false);
            this.mac.setEnabled(true);
        }
        if (this.ipVerCombo.isEnabled()) {
            if (this.ipVerCombo.getSelectedIndex() == ID_IP_TYPE_V4) {
                this.ipRangePanelLayout.show(this.ipRangePanel, IPV_FOUR);
            } else {
                this.ipRangePanelLayout.show(this.ipRangePanel, IPV_SIX);
            }
        }
    }

    private void setListener() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AddLanSensorDlg.this.updatePanelStatus();
            }
        };
        this.jRBIpAddress.addActionListener(actionListener);
        this.jRBMacAddress.addActionListener(actionListener);
        this.ipVerCombo.addActionListener(actionListener);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_client_dialog_computers_users_add_lansensor";
    }
}

