/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class AddGroupDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private JTextField jTFName = new JTextField();
    private JTextArea jTADesc = new JTextArea(new RestrictedPlainDocument(1024), "", 5, 30);
    String groupFullPath = null;

    public AddGroupDlg(String groupFullPath) {
        super(Manager.getFrame(), "", true);
        Object[] obj = new Object[]{groupFullPath};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "AddGroupDlg.addGroupFor0Msg");
        String fm = MessageFormat.format(str, obj);
        super.setTitle(fm);
        this.groupFullPath = groupFullPath;
        this.initialize();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public String getDescription() {
        return this.jTADesc.getText().trim();
    }

    public String getGroupName() {
        return this.jTFName.getText().trim();
    }

    @Override
    protected boolean isValidate() {
        String groupName = this.getGroupName();
        if (groupName.length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "AddGroupDlg.specifyGroupNameMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "AddGroupDlg.warning"), 2);
            this.jTFName.requestFocus();
            return false;
        }
        if (groupName.length() > 990) {
            Object[] obj = new Object[]{Integer.toString(990)};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "AddGroupDlg.nameExceeds0charactersMsg");
            String fm = MessageFormat.format(str, obj);
            JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "AddGroupDlg.warning"), 2);
            this.jTFName.requestFocus();
            return false;
        }
        String fullPath = GroupHandler.generateGroupFullPath(this.groupFullPath, groupName);
        if (fullPath.length() > 1000) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "AddGroupDlg.groupPathTooLongMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "AddGroupDlg.error"), 0);
            return false;
        }
        return true;
    }

    private void initialize() {
        RestrictedPlainDocument groupNameDoc = new RestrictedPlainDocument(990);
        groupNameDoc.setValidator("\"/\\*?<>|:&", false);
        this.jTFName.setDocument(groupNameDoc);
        RestrictedPlainDocument descDoc = new RestrictedPlainDocument(1024);
        this.jTADesc.setDocument(descDoc);
        JScrollPane scrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scrollPane, (JTextArea)this.jTADesc);
        this.jTADesc.setFocusTraversalKeys(0, null);
        this.jTADesc.setFocusTraversalKeys(1, null);
        scrollPane.getVerticalScrollBar().setFocusable(false);
        scrollPane.getHorizontalScrollBar().setFocusable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "AddGroupDlg.groupNameLabel")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jTFName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "AddGroupDlg.descripttionLabel")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.getContentPane().add((Component)scrollPane, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.pack();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_client_tree_dialog_add_group";
    }
}

