/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.client.HtmlPanel;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.SimpleTemplateParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XSLTPanel
extends HtmlPanel {
    private static final long serialVersionUID = 1L;
    public static final String TABLE_INFO_ELEMENT = "TableInfo";

    public XSLTPanel(String xsltFile) {
        super(xsltFile);
    }

    protected Document createSourceDocument() throws ConsoleException {
        Document sourceDoc = XMLHelper.newDocument();
        Element root = sourceDoc.createElement("ClientGroupProperties");
        root.setAttribute("ProductName", LicenseObject.getInstance().getProductName());
        this.createTableInfo(sourceDoc, root);
        sourceDoc.appendChild(root);
        return sourceDoc;
    }

    protected void createTableInfo(Document doc, Element parent) throws ConsoleException {
        try {
            Element tabElem = doc.createElement(TABLE_INFO_ELEMENT);
            parent.appendChild(tabElem);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex);
        }
    }

    @Override
    protected void initParser() throws ConsoleException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            URL fu = ConsoleMain.class.getResource(this.templateFileName);
            StreamSource source = new StreamSource(fu.openStream());
            Templates template = factory.newTemplates(source);
            Transformer transformer = template.newTransformer();
            transformer.setParameter("fontName", UIFontUtilities.STANDARD_FONT_NAME);
            Document sourceDoc = this.createSourceDocument();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XMLHelper.serialize((Document)sourceDoc, (OutputStream)out);
            out.close();
            byte[] byteSource = out.toByteArray();
            StreamSource xmlSource = new StreamSource(new ByteArrayInputStream(byteSource));
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outStream);
            transformer.transform(xmlSource, result);
            this.templateParser = new SimpleTemplateParser();
            this.templateParser.setTemplateString(UIUtilities.takeOutMeta(outStream.toString("UTF-8")));
        }
        catch (TransformerConfigurationException e) {
            LoggerUtilities.logException((Throwable)e);
            throw new ConsoleException(e);
        }
        catch (IOException e) {
            LoggerUtilities.logException((Throwable)e);
            throw new ConsoleException(e);
        }
        catch (TransformerException e) {
            LoggerUtilities.logException((Throwable)e);
            throw new ConsoleException(e);
        }
    }
}

