/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.configobject.rpc.NameValuePair;
import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.schema.EnabledClientFeatures;
import com.sygate.scm.common.configobject.schema.InstallationOption;
import com.sygate.scm.common.configobject.schema.PackageInfo;
import com.sygate.scm.common.configobject.schema.PackageLuFile;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationFeatureObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationSettingObject;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.PackageContentsUtil;
import com.sygate.scm.util.SwingWorker;
import com.sygate.scm.util.Utility;
import java.util.Set;

public class WindowsPackageSizeCalculator {
    private static final long appRemoverZipSize = 9000000L;
    private Boolean isNoDefsWarningShouldBeShown = false;
    private boolean isUsingLowBandwidthContent = false;

    public long calculateOnePackageSize(CurrentPackageObject currentPackageObj, ClientInstallationSettingObject settings, ClientInstallationFeatureObject ciFeature, int packageContentOption, boolean isZipped, boolean lowBandwidth) {
        InstallationOption installationOptions;
        long defaultPkgSize;
        String version = currentPackageObj.getSoftwarePackageObject().getVersion(true);
        String platform = currentPackageObj.getPlatformType();
        boolean isSavPackage = currentPackageObj.getPackageType() == 105;
        long totalSize = defaultPkgSize = isZipped ? currentPackageObj.getSize() : currentPackageObj.getUnZippedSize();
        long extraSizeForOtherComponents = 0L;
        Boolean isReducedInstall = false;
        Boolean isDarkNetwork = false;
        Boolean optAppRemover = false;
        this.isNoDefsWarningShouldBeShown = false;
        if (settings != null && (installationOptions = settings.getInstallationOption()) != null) {
            isReducedInstall = installationOptions.getOptSpecifyReducedInstallSize();
            if (isReducedInstall == null) {
                isReducedInstall = installationOptions.getDefSpecifyReducedInstallSize();
            }
            if ((isDarkNetwork = installationOptions.getOptDarkNetwork()) == null) {
                isDarkNetwork = installationOptions.getDefDarkNetwork();
            }
            if ((optAppRemover = installationOptions.getOptEnableCompetitiveUninstall()) != null && optAppRemover.booleanValue()) {
                extraSizeForOtherComponents += 9000000L;
            }
        }
        if (Utility.compareVersion((String)version, (String)"12.1.0.0") >= 0 && Utility.compareVersion((String)version, (String)"12.1.5394.6000") < 0) {
            isReducedInstall = false;
        } else if (Utility.compareVersion((String)version, (String)"14.0.0.0") >= 0) {
            isReducedInstall = isDarkNetwork == false;
        }
        if (Utility.compareVersion((String)version, (String)"14.0.0.1000") >= 0 && !isDarkNetwork.booleanValue() && lowBandwidth) {
            this.isUsingLowBandwidthContent = true;
        }
        if (Utility.compareVersion((String)version, (String)"14.0.0.0") >= 0 && !"Mac".equals(platform) && isSavPackage) {
            totalSize = this.getPackageSizeWithoutLUFiles(currentPackageObj, totalSize, isZipped);
            EnabledClientFeatures enabledFeatures = ciFeature.getEnabledFeaturesByPackageVersion(version);
            Set reqLuFilenames = PackageContentsUtil.getPackageLuContentFileNames((EnabledClientFeatures)enabledFeatures, (boolean)isReducedInstall, (String)version, (boolean)this.isUsingLowBandwidthContent);
            GetContentFileSizesSwingWorker worker = new GetContentFileSizesSwingWorker(version, platform, isReducedInstall, isDarkNetwork, this.isUsingLowBandwidthContent);
            RpcData rpc = (RpcData)worker.construct();
            for (String luFileName : reqLuFilenames) {
                ConsoleLogger.log("ExportPackageDlg>>calculateOnePackageSize: LU filename: " + luFileName);
                if (packageContentOption != 0 && PackageContentsUtil.isAVDefsFile((String)luFileName)) continue;
                long defsSize = this.getLuFileSize(currentPackageObj, luFileName, isZipped, rpc);
                if (PackageContentsUtil.isAVDefsFile((String)luFileName) && defsSize == 0L) {
                    this.isNoDefsWarningShouldBeShown = true;
                }
                totalSize += defsSize;
            }
            if (totalSize < defaultPkgSize) {
                totalSize = defaultPkgSize;
            }
        }
        return totalSize += extraSizeForOtherComponents;
    }

    private long getPackageSizeWithoutLUFiles(CurrentPackageObject currentPackageObj, long totalSize, boolean isZipped) {
        PackageInfo pInfo = currentPackageObj.getSoftwarePackage().getPackageInfo();
        for (PackageLuFile luFile : pInfo.getPackageLuFile()) {
            totalSize -= (isZipped ? luFile.getzippedSize() : luFile.getUnZippedSize()).longValue();
        }
        return totalSize;
    }

    protected long getLuFileSize(CurrentPackageObject currentPackageObj, String filename, boolean isZipped, RpcData rpc) {
        for (NameValuePair pair : rpc.getNameValuePair()) {
            if (!pair.getName().equalsIgnoreCase(filename)) continue;
            return Long.parseLong(pair.getOptValue());
        }
        PackageLuFile luFile = currentPackageObj.getPackageLuFile(filename);
        if (luFile != null) {
            return isZipped ? luFile.getzippedSize() : luFile.getUnZippedSize();
        }
        return 0L;
    }

    public Boolean getIsNoDefsWarningShouldBeShown() {
        return this.isNoDefsWarningShouldBeShown;
    }

    public boolean getIsUsingLowBandwidthContent() {
        return this.isUsingLowBandwidthContent;
    }

    private static class GetContentFileSizesSwingWorker
    extends SwingWorker {
        private String version = "";
        private String platform = "";
        private Boolean isReducedInstall = false;
        private Boolean isDarkNetwork = false;
        private Boolean isLowBandwidth = false;

        GetContentFileSizesSwingWorker(String version, String platform, Boolean isReducedInstall, Boolean isDarkNetwork, Boolean isLowBandwidth) {
            this.version = version;
            this.platform = platform;
            this.isReducedInstall = isReducedInstall;
            this.isDarkNetwork = isDarkNetwork;
            this.isLowBandwidth = isLowBandwidth;
        }

        public Object construct() {
            try {
                RpcData rpc = GUIManager.getLatestContentFileSizes(this.version, this.platform, this.isReducedInstall, this.isDarkNetwork, this.isLowBandwidth);
                return rpc;
            }
            catch (Exception e) {
                ConsoleLogger.log(e);
                return null;
            }
        }

        public void finished() {
            AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true);
        }
    }
}

